/*************************************************************************
 *
 *  $RCSfile: test.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:15:01 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <tools/debug.hxx>
#include <svtools/libcall.hxx>
#include <vcl/window.hxx>
#include <usr/uno.hxx>
#include <usr/refl.hxx>
#include <usr/conver.hxx>
#ifndef __UNO_REPOS_SERINFO_HXX__
#include <stardiv/uno/repos/serinfo.hxx>
#endif
#ifndef __STARDIV_ONE_FRAME_XDESKTOP_HXX__ //autogen
#include <stardiv/one/frame/xdesktop.hxx>
#endif
//#include <stardiv/one/frame/xcollect.hxx>
#include <stardiv/one/form/form.hxx>
#include <stardiv/one/text/txttype.hxx>
#include <stardiv/one/text/txtmod.hxx>
#include <stardiv/uno/util/comp.hxx>
#ifndef __STARDIV_ONE_TEXT_TXTCOLL_HXX__
#include <stardiv/one/text/txtcoll.hxx>
#endif
#ifndef __STARDIV_ONE_TEXT_TXTMISC_HXX__
#include <stardiv/one/text/txtmisc.hxx>
#endif
#ifndef __STARDIV_ONE_TEXT_TXTTBL_HXX__
#include <stardiv/one/text/txttbl.hxx>
#endif
#include <stardiv/one/text/txtdoc.hxx>
#include <stardiv/one/table/offtable.hxx>
#include <stardiv/one/offmisc.hxx>
#include <stardiv/one/offview.hxx>
#include <stardiv/one/text/offsrch.hxx>
#include <stardiv/one/drawing/shape.hxx>
#include <stardiv/one/drawing/drawpage.hxx>
#include <stardiv/one/text/txtcont.hxx>
#ifndef __STARDIV_ONE_CHART_XCINTRFC_HXX__ //autogen
#include <stardiv/one/chart/xcintrfc.hxx>
#endif
#ifndef __STARDIV_ONE_FRAME_XMODEL_HXX__ //autogen
#include <stardiv/one/frame/xmodel.hxx>
#endif

#ifndef __STARDIV_ONE_FRAME_XCTRLLER_HXX__ //autogen
#include <stardiv/one/frame/xctrller.hxx>
#endif

#ifndef _SV_SOUND_HXX //autogen
#include <vcl/sound.hxx>
#endif
#include <stardiv/uno/lang/reflect/reflect.hxx>
#include <vcl/msgbox.hxx>

#include <wrkdlg.hxx>

/*-----------------25.02.98 11:42-------------------

--------------------------------------------------*/
AnyAndBox::AnyAndBox(BoxType eSet, Window* pParent, UsrAny& rSet) :
	aVal(rSet),
	eBox(eSet),
	pTxt(0),
	pWin(0),
	pField2(0)
{
	switch ( eBox )
	{
		case BOXTYPE_CHECKBOX :
			pBox = new CheckBox(pParent);
			pBox->SetClickHdl(LINK(this, AnyAndBox, ClickHdl ));
			pBox->SaveValue();
		break;
		case BOXTYPE_DBL_NUMERIC:
			pField2 = new NumericField(pParent, WB_BORDER);
			pField2->SetMin(-9999999);
			pField2->SetMax(+0xffffff);
			pField2->Show();
			pField2->SetModifyHdl(LINK(this, AnyAndBox, EditHdl ));
		// kein break
		case BOXTYPE_ENUM:
		case BOXTYPE_NUMERIC:
			pField = new NumericField(pParent, WB_BORDER);
			pField->SetMin(-9999999);
			pField->SetMax(+0xffffff);
			pField->SetModifyHdl(LINK(this, AnyAndBox, EditHdl ));
		break;
		case BOXTYPE_FLOAT:
			pField = new NumericField(pParent, WB_BORDER);
			pField->SetMin(-9999999);
			pField->SetMax(+0xffffff);
			pField->SetDecimalDigits( 4 );
		break;
		case BOXTYPE_SECT_LINK:
		case BOXTYPE_STRING:
			pValueTxt = new Edit(pParent);
			pValueTxt->SetModifyHdl(LINK(this, AnyAndBox, EditHdl ));
			pValueTxt->SaveValue();
		break;
		case BOXTYPE_DD_LISTBOX:
			pListBox = new ListBox(pParent, WB_DROPDOWN);
			pListBox->SetSizePixel(Size(100, 100));
		break;
		case BOXTYPE_BUTTON:
			pButton = new PushButton(pParent);
			pButton->SetSizePixel(Size(100, 100));
			pButton->SetText("Numbering");
		break;
	}
	if(eBox != BOXTYPE_CHECKBOX)
	{
		pTxt = new FixedText(pParent);
		pTxt->SetSizePixel(Size(100, 20));
		pTxt->Show();
	}
	if(pWin)
	{
		if(eBox != BOXTYPE_DD_LISTBOX)
			pWin->SetSizePixel(Size(100, 20));
		pWin->Show();
	}
}
AnyAndBox::~AnyAndBox()
{
	delete pTxt;
	delete pField2;
	switch ( eBox )
	{
		case BOXTYPE_CHECKBOX :
			delete pBox;
		break;
		case BOXTYPE_NUMERIC:
			delete pField;
		break;
		case BOXTYPE_DD_LISTBOX:
			delete pListBox;
		break;
		case BOXTYPE_SECT_LINK:
		case BOXTYPE_STRING:
			delete pValueTxt;
		break;
		case BOXTYPE_BUTTON:
			delete pButton;
		break;
	}
}

void AnyAndBox::SetPosSizePixel(Point aPt, Size aSz)
{
	if(pTxt)
	{
		pTxt->SetPosPixel(aPt);
		Size aFSz(aSz);
		aFSz.Width() /= 3;
		aFSz.Width() *= 2;
		pTxt->SetSizePixel(aFSz);
		aPt.X() += aFSz.Width() + 3;
		aSz.Width() -= (aFSz.Width() + 3);
	}
	if(pField2)
	{
		Size aFSz(aSz);
		aFSz.Width() /= 2;
		aFSz.Width() -= 4;
		pField->SetSizePixel(aFSz);
		pField2->SetSizePixel(aFSz);
		pField->SetPosPixel(aPt);
		aPt.X() += aFSz.Width() + 3;
		pField2->SetPosPixel(aPt);
	}
	else if(pWin)
	{
		pWin->SetPosPixel(aPt);
		if(eBox == BOXTYPE_DD_LISTBOX)
			aSz.Height() += 100;
		pWin->SetSizePixel(aSz);
	}

}

BOOL AnyAndBox::HasValueChanged() const
{
	BOOL bRet = FALSE;
	switch ( eBox )
	{
		case BOXTYPE_CHECKBOX :
			bRet = pBox->GetSavedValue() != pBox->IsChecked();
		break;
		case BOXTYPE_DBL_NUMERIC:
			bRet|= pField2->GetSavedValue() != pField2->GetText();
		case BOXTYPE_ENUM:
		case BOXTYPE_NUMERIC:
			bRet|= pField->GetSavedValue() != pField->GetText();
		break;
		case BOXTYPE_FLOAT:
		break;
		case BOXTYPE_SECT_LINK:
		case BOXTYPE_STRING:
			bRet = pValueTxt->GetSavedValue() != pValueTxt->GetText();
		break;
		case BOXTYPE_BUTTON:
			bRet = TRUE;
		break;
	}
	return bRet;
}

IMPL_LINK(AnyAndBox, ClickHdl, CheckBox*, pBox)
{
	aVal.setBOOL(pBox->IsChecked());
	return 0;
}
IMPL_LINK(AnyAndBox, EditHdl, Edit*, pEdt)
{
	if(eBox == BOXTYPE_STRING)
	{
		aVal.setString(S2U(pValueTxt->GetText()));
	}
	else if(eBox == BOXTYPE_SECT_LINK)
	{
		SectionFileLink* pLink = (SectionFileLink*)	aVal.get();
		pLink->FileURL = S2U(pValueTxt->GetText());
	}
	else if(pEdt == pField)
	{
		if(eBox == BOXTYPE_NUMERIC)
		{
			if(aVal.getReflection()->getName() ==
								UINT32_getReflection()->getName())
				aVal.setUINT32(pField->GetValue());
			else if(aVal.getReflection()->getName() ==
				INT32_getReflection()->getName())
				aVal.setINT32(pField->GetValue());
			else if(aVal.getReflection()->getName() ==
				UINT16_getReflection()->getName())
				aVal.setUINT16((UINT16)pField->GetValue());
			else if(aVal.getReflection()->getName() ==
				INT16_getReflection()->getName())
				aVal.setINT16((INT16)pField->GetValue());
			else if(aVal.getReflection()->getName() ==
				BYTE_getReflection()->getName())
				aVal.setBYTE((BYTE)pField->GetValue());
			else if(aVal.getReflection()->getTypeClass() == TYPECLASS_ENUM)
			{
				enum DummyEnum{Dummy1} eTmp;
					eTmp = (DummyEnum)(INT32)pField->GetValue();
				Reflection* pRefl = aVal.getReflection();
				aVal.set(&eTmp, pRefl);
			}
			else if(aVal.getReflection()->getName() ==
						ShadowFormat_getReflection()->getName())
			{
				ShadowFormat* pShadow = (ShadowFormat*)aVal.get();
				pShadow->Location = (ShadowLocation)pField->GetValue();
			}


		}
		else if(aVal.getReflection()->getName() == LeftRightMargin_getReflection()->getName())
		{
			LeftRightMargin* pLR = (LeftRightMargin*)aVal.get();
			pLR->Left = pField->GetValue();
		}
		else if(aVal.getReflection()->getName() ==
				TopBottomMargin_getReflection()->getName())
		{
			TopBottomMargin* pLR = (TopBottomMargin*)aVal.get();
			pLR->Top = pField->GetValue();
		}
	}
	else if(pEdt == pField2)
	{
		if(aVal.getReflection()->getName() == LeftRightMargin_getReflection()->getName())
		{
			LeftRightMargin* pLR = (LeftRightMargin*)aVal.get();
			pLR->Right = pField2->GetValue();
		}
		else if(aVal.getReflection()->getName() ==
				TopBottomMargin_getReflection()->getName())
		{
			TopBottomMargin* pLR = (TopBottomMargin*)aVal.get();
			pLR->Bottom = pField2->GetValue();
		}
	}
	return 0;
}
/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
class MyWindow : public Window
{
	USHORT 		nIndex;
	PushButton 	aModelButton;
	ListBox		aChapterLB;
	ListBox		aBookmarkLB;
	ListBox		aFrameLB;
	ListBox		aGraphicLB;
	ListBox		aOLELB;
	ListBox		aTableLB;
	ListBox		aSectionLB;
	PushButton 	aSelTblPB;
	Edit 		aAutoFormatED;
	PushButton 	aAutoFmtPB;
	PushButton 	aSelFrmPB;
	PushButton 	aSelBkmPB;

	PushButton	aFieldPB;
	PushButton 	aShapePB;
	PushButton 	aTextPB;
	PushButton 	aSettingsPB;
	PushButton 	aViewSettingsPB;
	PushButton	aSearchPB;
//	Edit		aZoomValueED;
//	PushButton  aZoomPB;

	Edit		aWriteED;

	PushButton	aLeftPB;
	PushButton	aRightPB;
	PushButton	aNextWordPB;
	PushButton	aPrevWordPB;
	CheckBox	aSelectCB;

	PushButton	aTablePB;
	PushButton	aTableInsertPB;

	Edit 		aSearchED;
	Edit		aReplaceED;
	PushButton	aReplacePB;

	PushButton 	aStylePB;

	PushButton 	aInsertFramePB;
	PushButton	aIndexPropPB;

	XTextCursorRef 			xCursorRef;
	XTextRef 				xTextRef;
	XDesktopRef 			xDesktopRef;
//	XModelCollectionRef 	xModelCollRef;
	XTextDocumentRef 		xTextDocumentRef;
	XTextFrameRef 			xFrm;
//	XSelectionObjectRef 	xSelObj ;
//	XTextViewRef 			xViewRef ;

		DECL_LINK(ModelHdl, PushButton*);
		DECL_LINK(ZoomHdl, PushButton*);
		DECL_LINK(TextHdl, Edit*);
		DECL_LINK(CursorHdl, PushButton*);
		DECL_LINK(TableHdl, PushButton*);
		DECL_LINK(TableInsertHdl, PushButton*);
		DECL_LINK(SearchHdl, PushButton*);
		DECL_LINK(ReplaceHdl, PushButton*);
		DECL_LINK(PropertyHdl, ListBox*);
		DECL_LINK(CellHdl, ListBox*);
		DECL_LINK(FieldHdl, PushButton*);
		DECL_LINK(ShapesHdl, PushButton*);
		DECL_LINK(StartTextHdl, PushButton*);
		DECL_LINK(BookmarkHdl, ListBox*);
		DECL_LINK(SettingsHdl, PushButton*);
		DECL_LINK(ViewSelectHdl, PushButton*);
		DECL_LINK(AutoFmtHdl, PushButton*);
		DECL_LINK(StyleHdl, PushButton*);
		DECL_LINK(InsertFrameHdl, PushButton*);
		DECL_LINK(IndexHdl, PushButton*);

		void 				GetCursor();
		BOOL				GetModel(XTextDocumentRef& xDoc);
//		XSelectionObjectRef getSelection();
public:
			MyWindow( Window *pParent );
};

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
MyWindow::MyWindow( Window *pParent )
				: Window( pParent ),
				aModelButton(this),
				aChapterLB(this),
				aFrameLB(this),
				aGraphicLB(this),
				aOLELB(this),
				aTableLB(this),
				aSelTblPB(this),
				aAutoFormatED(this),
				aAutoFmtPB(this),
				aSelFrmPB(this),
				aSelBkmPB(this),
				aFieldPB(this),
				aSectionLB(this),
				aBookmarkLB(this),
				aShapePB(this),
				aSettingsPB(this),
				aViewSettingsPB(this),
				aTextPB(this),
//				aZoomValueED(this),
//				aZoomPB(this),
				aWriteED(this),
				aLeftPB(this),
				aRightPB(this),
				aNextWordPB(this),
				aPrevWordPB(this),
				aSelectCB(this),
				aTablePB(this),
				aTableInsertPB(this),
				aSearchED(this),
				aSearchPB(this),
				aReplaceED(this),
				aReplacePB(this),
				aStylePB(this),
				aInsertFramePB(this),
				aIndexPropPB(this),
				nIndex(0)
{
	aModelButton.SetText("Test");
	aModelButton.SetPosSizePixel(10,10, 100,30);
	aModelButton.SetClickHdl(LINK(this, MyWindow, ModelHdl));
	aModelButton.Show();

	aFieldPB.SetText("Felddialog");
	aFieldPB.SetPosSizePixel(10,45, 100,30);
	aFieldPB.SetClickHdl(LINK(this, MyWindow, FieldHdl));
	aFieldPB.Show();

	aShapePB.SetText("Shapes");
	aShapePB.SetPosSizePixel(10,80, 100,30);
	aShapePB.SetClickHdl(LINK(this, MyWindow, ShapesHdl));
	aShapePB.Show();

	aTextPB.SetText("Text");
	aTextPB.SetPosSizePixel(10,115, 100,30);
	aTextPB.SetClickHdl(LINK(this, MyWindow, StartTextHdl));
	aTextPB.Show();

	aSettingsPB.SetText("Settings");
	aSettingsPB.SetPosSizePixel(10,150, 100,30);
	aSettingsPB.SetClickHdl(LINK(this, MyWindow, SettingsHdl));
	aSettingsPB.Show();

	aViewSettingsPB.SetText("ViewSettings");
	aViewSettingsPB.SetPosSizePixel(10,185, 100,30);
	aViewSettingsPB.SetClickHdl(LINK(this, MyWindow, SettingsHdl));
	aViewSettingsPB.Show();

	aTablePB.SetText("Tabelle ");
	aTablePB.SetClickHdl(LINK(this, MyWindow, TableHdl));
	aTablePB.SetPosSizePixel(10,220, 50,30);
	aTablePB.Show();

	aSearchPB.SetText("Search");
	aSearchPB.SetClickHdl(LINK(this, MyWindow, SearchHdl));
//	aSearchED.SetPosSizePixel(10,230, 100,20);
	aSearchPB.SetPosSizePixel(10,255, 100,30);
	aSearchPB.Show();

	aNextWordPB	.SetPosSizePixel(10,290, 45,30);
	aPrevWordPB	.SetPosSizePixel(60,290,45,30);
	aNextWordPB.SetClickHdl(LINK(this, MyWindow, CursorHdl));
	aPrevWordPB.SetClickHdl(LINK(this, MyWindow, CursorHdl));
	aNextWordPB	.SetText("NxtWrd");
	aPrevWordPB	.SetText("PrvWrd");
	aNextWordPB	.Show();
	aPrevWordPB	.Show();

	aStylePB.SetText("Styles");
	aStylePB.SetPosSizePixel(10,325,100,30);
	aStylePB.SetClickHdl(LINK(this, MyWindow, StyleHdl));
	aStylePB.Show(),

	aInsertFramePB.SetText("InsertFrame");
	aInsertFramePB.SetPosSizePixel(10,360,100,30);
	aInsertFramePB.SetClickHdl(LINK(this, MyWindow, InsertFrameHdl));
	aInsertFramePB.Show(),

	aIndexPropPB.SetText("IndexProp");
	aIndexPropPB.SetPosSizePixel(10,395,100,30);
	aIndexPropPB.SetClickHdl(LINK(this, MyWindow, IndexHdl));
	aIndexPropPB.Show(),



	aChapterLB.SetPosSizePixel(120,10, 100,50);
	aChapterLB.Show();

	aFrameLB.SetPosSizePixel(120,65, 150,50);
	aFrameLB.SetDoubleClickHdl(LINK(this, MyWindow, PropertyHdl));
	aFrameLB.Show();
	aSelFrmPB.SetClickHdl(LINK(this, MyWindow, ViewSelectHdl));
	aSelFrmPB.SetPosSizePixel(275,65, 100,30);
	aSelFrmPB.SetText("Select");
	aSelFrmPB.Show();


	aGraphicLB.SetPosSizePixel(120,120, 150,50);
	aGraphicLB.SetDoubleClickHdl(LINK(this, MyWindow, PropertyHdl));
	aGraphicLB.Show();
	aOLELB.SetPosSizePixel(120,175, 150,50);
	aOLELB.Show();

	aTableLB.SetPosSizePixel(120,230, 150,50);
	aTableLB.SetDoubleClickHdl(LINK(this, MyWindow, PropertyHdl));
	//aTableLB.SetSelectHdl(LINK(this, MyWindow, CellHdl));
	aTableLB.Show();
	aSelTblPB.SetText("Select");
	aSelTblPB.SetPosSizePixel(275,230, 100,30);
	aSelTblPB.SetClickHdl(LINK(this, MyWindow, ViewSelectHdl));
	aSelTblPB.Show();

	aAutoFormatED.SetPosSizePixel(275,265, 50,18);
	aAutoFormatED.Show();
	aAutoFmtPB.SetText("AutoFormat");
	aAutoFmtPB.SetPosSizePixel(330,265, 100,20);
	aAutoFmtPB.SetClickHdl(LINK(this, MyWindow, AutoFmtHdl));
	aAutoFmtPB.Show();


	aBookmarkLB.SetPosSizePixel(120,285, 150,50);
	aBookmarkLB.SetDoubleClickHdl(LINK(this, MyWindow, BookmarkHdl));
	aBookmarkLB.Show();
	aSelBkmPB.SetClickHdl(LINK(this, MyWindow, ViewSelectHdl));
	aSelBkmPB.SetText("Select");
	aSelBkmPB.SetPosSizePixel(275,285, 100,30);
	aSelBkmPB.Show();

	aSectionLB.SetPosSizePixel(120,340, 150,50);
	aSectionLB.SetDoubleClickHdl(LINK(this, MyWindow, PropertyHdl));
	aSectionLB.Show();

//	aZoomPB.SetText("setZoom");
//	aZoomPB.SetPosSizePixel(10,90, 150,30);
//	aZoomPB.SetClickHdl(LINK(this, MyWindow, ZoomHdl));
//	aZoomPB.Show();
//	aZoomValueED.SetPosSizePixel(10,50, 150,30);
//	aZoomValueED.Show();

	aWriteED.SetPosSizePixel(10,130, 150,20);
	aWriteED.SetModifyHdl(LINK(this, MyWindow, TextHdl));
//	aWriteED.Show();

	aLeftPB.SetClickHdl(LINK(this, MyWindow, CursorHdl));
	aRightPB.SetClickHdl(LINK(this, MyWindow, CursorHdl));
	aLeftPB		.SetPosSizePixel(10,160, 45,30);
	aRightPB	.SetPosSizePixel(55,160, 45,30);
	aSelectCB	.SetPosSizePixel(190,160, 45,30);
	aLeftPB		.SetText("Left");
	aRightPB	.SetText("Right");
	aSelectCB	.SetText("Select");
//	aLeftPB		.Show();
//	aRightPB	.Show();
//	aSelectCB	.Show();


	aTableInsertPB.SetText("Insert Table");
	aTableInsertPB.SetClickHdl(LINK(this, MyWindow, TableInsertHdl));
	aTableInsertPB.SetPosSizePixel(100,195, 100,30);
//	aTableInsertPB.Show();

	aReplacePB.SetText("Replace");
	aReplacePB.SetClickHdl(LINK(this, MyWindow, ReplaceHdl));
	aReplaceED.SetPosSizePixel(120,230, 100,20);
//	aReplaceED.Show();
	aReplacePB.SetPosSizePixel(120,260, 100,30);
//	aReplacePB.Show();

}

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, ModelHdl, PushButton*, pButton)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}

	//USHORT nCount = xModelCollRef->getCount();
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XTextRef xBodyTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
//				String sBTxt = U2S(xBodyTxt->getText());
				//Paragraph + P.Enumerator
/*				XParagraphEnumerationAccessRef xEnumerationAcc = (XParagraphEnumerationAccess*)
												xBodyTxt->queryInterface(XParagraphEnumerationAccess::getSmartUik());
				XParagraphEnumerationRef xEnumeration = xEnumerationAcc->getParagraphEnumeration();
				XTextDocumentRef xDoc2 = (XTextDocument*)xEnumerationAcc->queryInterface(XTextDocument::getSmartUik());
				if(xEnumeration.is())
				{
					XEnumerationRef xEnum = (XEnumeration*)xEnumeration->queryInterface(
															XEnumeration::getSmartUik());
					while( xEnum->hasMoreElements() )
					{
						XInterfaceRef xPara = xEnum->nextElement();
						if(xPara.is())
						{
							//Tabstops ermitteln und wieder setzen
							XPropertySetRef xPrSet = (XPropertySet*)xPara->queryInterface(XPropertySet::getSmartUik());
							if(xPrSet.is())
							{
								UsrAny aVal = xPrSet->getPropertyValue(L"TabStops");
								if(aVal.getReflection()->getName() == Sequence<TabStop>::getReflection()->getName())
								{
									Sequence<TabStop>* pTabStops = (Sequence<TabStop>*)aVal.get();
									int nLen = pTabStops->getLen();
									if(nLen)
									{
										const TabStop* pTabStop = pTabStops->getConstArray();
										TabStop aTStop = pTabStop[0];
									}
									Sequence<TabStop> aNewTabStop(1);
									TabStop* pArr = aNewTabStop.getArray();
									pArr[0].Alignment = (TabAlign)2;
									pArr[0].Position = 2000;
									pArr[0].DecimalChar = ',';
									pArr[0].FillChar = '.';
									UsrAny aSet;
									aSet.set(&aNewTabStop, Sequence<TabStop>::getReflection());
									xPrSet->setPropertyValue(L"TabStops", aSet);


								}
							}


							XTextPortionEnumerationAccessRef xIter = (XTextPortionEnumerationAccess*)xPara->queryInterface(
																					XTextPortionEnumerationAccess::getSmartUik());
							XTextPortionEnumerationRef xTPEn = xIter->getTextPortionEnumeration();
							while(xTPEn->hasMoreElements())
							{
								XInterfaceRef xInt = xTPEn->nextElement();
								XTextFieldRef xFld = (XTextField*)xTPEn->queryInterface(XTextField::getSmartUik());
								if(xFld.is())
								{
									xFld->getTextFieldType();
								}
								XTextPositionRef xPos = (XTextPosition*)xInt->queryInterface(XTextPosition::getSmartUik());
								String sText = U2S(xPos->getText());
								XPropertySetRef xPrSet = (XPropertySet*)xInt->queryInterface( XPropertySet::getSmartUik());
								PropertyDialog aDlg(pButton, xPrSet);
								aDlg.SetText(sText);
								aDlg.Execute();
							}

						}
					}
				}

*/
/*				XChapterSettingsRef xChpSett = (XChapterSettings*)xDoc->queryInterface(XChapterSettings::getSmartUik());
				XChapterNumberingRef xChp = xChpSett->getChapterNumberingProperties();
				if(xChp)
				{
					Sequence<UString> aSeq = xChp->getHeadingStyleNames();
					UString * pArr = aSeq.getArray();
					String sMsg;
					aChapterLB.Clear();
					for(USHORT i = 0; i < aSeq.getLen(); i++)
						aChapterLB.InsertEntry(U2S(pArr[i]));

					INT32 nRules = xChp->getNoOfRules();
					for(INT32 j = 0; j < nRules; j++)
					{
						NumberingRule aRule = xChp->getLevelByIndex(j);
						INT32 nTmp = j;
					}

				}
 */

/*				XFootAndEndnoteSettingsRef xFtnEndRef = (XFootAndEndnoteSettings*)xDoc->queryInterface(XFootAndEndnoteSettings::getSmartUik());
				XFootnotePropertiesRef xFtnRef = xFtnEndRef->getFootnoteProperties();
				PropertyDialog aDlg(this, xFtnRef);
				aDlg.SetText("Footnote properties");
				aDlg.Execute();

				XEndnotePropertiesRef xEndRef = xFtnEndRef->getEndnoteProperties();
				PropertyDialog aDlg1(this, xEndRef);
				aDlg1.SetText("Endnote properties");
				aDlg1.Execute();

				XLineNumberingSettingsRef xLineRef = (XLineNumberingSettings*)xDoc->queryInterface(XLineNumberingSettings::getSmartUik());
				XLineNumberingPropertiesRef xLinePropRef = xLineRef->getLineNumberingProperties();
				PropertyDialog aDlg2(this, xLinePropRef);
				aDlg2.SetText("LineNumbering properties");
				aDlg2.Execute();
*/

				XTextTablesRef xTbls = xDoc->getTextTables();
				XIndexAccessRef xIdx = (XIndexAccess*)xTbls->queryInterface(XIndexAccess::getSmartUik());
				XNameAccessRef xNIdx = (XNameAccess*)xTbls->queryInterface(XNameAccess::getSmartUik());
				INT32 nCount = xIdx->getCount();
				aTableLB.Clear();
				while( nCount-- )
				{
					XTextTableRef xTbl = xTbls->getTextTableByIndex((USHORT)nCount);
					aTableLB.InsertEntry(U2S(xTbl->getName()), 0);
					if(nCount == 0)
						xTbl->setName(S2U("Neuer Tabellenname"));

				}
/*				if(xTbl)
				{
					InfoBox(&aModelButton, xTbl->getName()).Execute();
					XPropertySetRef aProp = (XPropertySet*)xTbl->queryInterface(XPropertySet::getSmartUik());
					UsrAny aAny = aProp->getPropertyValue("Size");
				}*/
				XTextFramesRef xFrms = xDoc->getTextFrames();
				XIndexAccessRef xFIdx = (XIndexAccess*)xFrms->queryInterface(XIndexAccess::getSmartUik());
				nCount = xFIdx->getCount();
				aFrameLB.Clear();
				while( nCount-- )
				{
					XTextFrameRef xFrm = xFrms->getTextFrameByIndex(nCount);
					aFrameLB.InsertEntry(U2S(xFrm->getName()), 0);
				}
				if(!xFrm)
					xFrm = xFrms->getTextFrameByIndex(0);
				if(xFrm)
				{
//					InfoBox(&aModelButton, xFrm->getName()).Execute();
					XPropertySetRef aProp = (XPropertySet*)xFrm->queryInterface(XPropertySet::getSmartUik());
					UsrAny aAny = aProp->getPropertyValue(S2U("Anchor"));
					aAny.setUINT16(2);
					aProp->setPropertyValue(S2U("Anchor"), aAny);

					//LeftRightMargin veraeedern
					aAny = aProp->getPropertyValue(S2U("LeftRightMargin"));
					LeftRightMargin* pMargin = (LeftRightMargin*)aAny.get();
					if(pMargin)
					{
						pMargin->Left *= 2;
						pMargin->Left  += 20;
						pMargin->Right *= 2;
						pMargin->Right += 20;
//						aAny.set(pMargin, aAny.getReflection());
						aProp->setPropertyValue(S2U("LeftRightMargin"), aAny);
					}
					aAny = aProp->getPropertyValue(S2U("TopBottomMargin"));
					TopBottomMargin* pTBMargin = (TopBottomMargin*)aAny.get();
					if(pTBMargin)
					{
						pTBMargin->Top *= 2;
						pTBMargin->Bottom *= 2;
//						aAny.set(pTBMargin, aAny.getReflection());
						aProp->setPropertyValue(S2U("TopBottomMargin"), aAny);
					}
				}
				XNameAccessRef xNA = (XNameAccess*)xFrms->queryInterface(XNameAccess::getSmartUik());
				XInterfaceRef xInt = xNA->getElementByName(S2U("Rahmen1"));
				XInterface * pInt = xInt;
				if(pInt)
				{
					XTextFrameRef xTF = (XTextFrame*)pInt->queryInterface(XTextFrame::getSmartUik());
					xTF->getName();
				}
				BOOL bHas = xNA->hasElementByName(S2U("Rahmen1"));
				bHas = xNA->hasElementByName(S2U("xxx"));
				Sequence<UString> aSeq = xNA->getElementNames();

				XTextGraphicObjectsRef xGrs = xDoc->getGraphicObjects();
				XIndexAccessRef xGIdx = (XIndexAccess*)xGrs->queryInterface(XIndexAccess::getSmartUik());
				nCount = xGIdx->getCount();
				aGraphicLB.Clear();
				while( nCount-- )
				{
					XTextGraphicObjectRef xGr = xGrs->getGraphicByIndex(nCount);
					aGraphicLB.InsertEntry(U2S(xGr->getName()), 0);
				}
				XTextEmbeddedObjectsRef xOLEs = xDoc->getEmbeddedObjects();
				XIndexAccessRef xOIdx = (XIndexAccess*)xOLEs->queryInterface(XIndexAccess::getSmartUik());
				nCount = xOIdx->getCount();
				aOLELB.Clear();
				while( nCount-- )
				{
					XTextEmbeddedObjectRef xOLE = xOLEs->getEmbeddedObjectByIndex(nCount);
					aOLELB.InsertEntry(U2S(xOLE->getName()), 0);
				}
//				XTextRef xBodyTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
				String sContent = U2S(xBodyTxt->getText());
				//xBodyTxt->setText(L"alles geloescht!");
				XTextCursorRef 	xTxtCrsr = xBodyTxt->createTextCursor();
				{
					XLineCursorRef xLnCrsr= (XLineCursor*)xTxtCrsr->queryInterface(XLineCursor::getSmartUik());

					xTxtCrsr->goRight(1,FALSE);
					xLnCrsr->goDown(2,TRUE);
					XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());

					//xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					String sText(U2S(xTxtPos->getText()));
//					InfoBox(this, sText).Execute();



				}
				//Paragraph + P.Enumerator
/*				xEnumeration = (XParagraphEnumeration*)
									xBodyTxt->queryInterface(XParagraphEnumeration::getSmartUik());
				if(xEnumeration.is())
				{
					XEnumerationRef xEnum = (XEnumeration*)xEnumeration->queryInterface(
															XEnumeration::getSmartUik());
					BOOL bNext = xEnum->hasMoreElements();
					XInterfaceRef xPara = xEnum->nextElement();
					if(xPara.is())
					{
						XPropertySetRef xPSet = (XPropertySet*)
										xPara->queryInterface(XPropertySet::getSmartUik());
						PropertyDialog aDlg(this, xPSet);
						aDlg.SetText("Paragraph properties");
						aDlg.Execute();
						XParagraphRef xParagr = (XParagraph*)xPara->queryInterface(XParagraph::getSmartUik());
						XTextPositionRef xRef = xParagr->getTextPosition();
//						InfoBox(this, U2S(xRef->getText())).Execute();
					}

				}
*/

				//xTxtCrsr->gotoStart(FALSE);
				xTxtCrsr->goRight(1,0);
				XPropertySetRef aProp = (XPropertySet*)xTxtCrsr->queryInterface(XPropertySet::getSmartUik());
				UsrAny aAny = aProp->getPropertyValue(S2U("Color"));
				XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
				XPropertySetRef xPrSet;
				//xFrms->addFrame(xPrSet, xTxtPos);
				//if(xTxtPos)
				//	xTbls->addTextTable(2,2,xPrSet,xTxtPos);

				XBookmarksRef xBkms = xDoc->getBookmarks();
				aBookmarkLB.Clear();
				XIndexAccessRef xBIdx = (XIndexAccess*)xBkms->queryInterface(XIndexAccess::getSmartUik());

				xBkms->addBookmark(S2U("TestMarke"),xTxtPos);

				INT32 nBkCount = xBIdx->getCount();
				for(INT32 i = 0; i< nBkCount; i++)
				{
					XBookmarkRef xBkm = xBkms->getBookmarkByIndex(i);
					aBookmarkLB.InsertEntry(U2S(xBkm->getName()), 0);
				}

				XTextSectionsRef xScts = xDoc->getTextSections();
				aSectionLB.Clear();
				XIndexAccessRef xSIdx = (XIndexAccess*)xScts->queryInterface(XIndexAccess::getSmartUik());

//				xBkms->addTextSection("TestBereich", xPrSet, xTxtPos);

				INT32 nScCount = xSIdx->getCount();
				for(i = 0; i< nScCount; i++)
				{
					XTextSectionRef xSec = xScts->getTextSectionByIndex(i);
					aSectionLB.InsertEntry(U2S(xSec->getName()), 0);
				}

				if(xFrm)
				{
					XTextRef xFrmTxt = (XText*)xFrm->queryInterface(XText::getSmartUik());
					XParagraphEnumerationAccessRef xEnumerationAccess = (XParagraphEnumerationAccess*)
												xFrmTxt->queryInterface(XParagraphEnumerationAccess::getSmartUik());
					XParagraphEnumerationRef xEnumeration = xEnumerationAccess->getParagraphEnumeration();
//					XParagraphEnumeratorRef xEnumerator = (XParagraphEnumerator*)
//										xFrmTxt->queryInterface(XParagraphEnumerator::getSmartUik());
					if(xEnumeration.is())
					{
						XEnumerationRef xEnum = (XEnumeration*)xEnumeration->queryInterface(
																XEnumeration::getSmartUik());
						BOOL bNext = xEnum->hasMoreElements();
						XInterfaceRef xPara = xEnum->nextElement();
						if(xPara.is())
						{
//							XPropertySetRef xPSet = (XPropertySet*)
//											xPara->queryInterface(XPropertySet::getSmartUik());
//							PropertyDialog aDlg(this, xPSet);
//                            aDlg.SetText("Paragraph properties");
//							aDlg.Execute();
						}

					}

					XTextCursorRef 	xTxtCrsr = xFrmTxt->createTextCursor();
//					XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					XLineCursorRef xLnCrsr= (XLineCursor*)xTxtCrsr->queryInterface(XLineCursor::getSmartUik());

					xTxtCrsr->goRight(1,FALSE);
					xLnCrsr->goDown(2,TRUE);

					//xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					String sText(U2S(xTxtPos->getText()));
					XLineCursorRef xCrsr = (XLineCursor*)xTxtCrsr->queryInterface(XLineCursor::getSmartUik());
//					xCrsr->gotoEndOfLine(TRUE);
					//xTxtPos = (XTextPosition*)xCrsr->queryInterface(XTextPosition::getSmartUik());
					sText = U2S(xTxtPos->getText());
					xTxtCrsr->goRight(1,FALSE);
					//xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					sText = U2S(xTxtPos->getText());
					xTxtCrsr->goRight(1,TRUE);
					sText = U2S(xTxtPos->getText());
					xTxtCrsr->goRight(1,FALSE);
					sText = U2S(xTxtPos->getText());
//					xCrsr->gotoStartOfLine(TRUE);
					//xTxtPos = (XTextPosition*)xCrsr->queryInterface(XTextPosition::getSmartUik());
					sText = U2S(xTxtPos->getText());
					sText += "TEST";
					xTxtPos->setText(S2U(sText));
					XPropertySetRef aProp = (XPropertySet*)xTxtCrsr->queryInterface(XPropertySet::getSmartUik());
					UsrAny aAny = aProp->getPropertyValue(S2U("Color"));
					XPropertySetRef xPrSet;
					//xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					if(xTxtPos)
					{
						try
						{
							XTextTableDescriptorRef xDesc = xTbls->createTextTable(2,0);
							xTbls->addTextTable(xDesc, xTxtPos);
						}
						catch(UsrException& rExc)
						{
							InfoBox(pButton, "Exception ist aufgetreten!").Execute();
						}
					}
				}


//	sequence<unsigned short> getFieldTypeIds();
//	sequence<string> getFieldTypeNames([in] unsigned short FieldType);
//	XNamedFieldType	getNamedFieldType([in] unsigned short FieldType,[in] string Name);
//	XTextFieldType	getFieldType([in] unsigned short FieldType);


/*			Sortierung
			{
//				xTextDocument->createGlobalDoc("d:\\temp\\unoglbl.sgl");
				// Syntaxtest fuer XTextSortable
				XTextSortableRef xSortable = (XTextSortable*)xTextDocument->queryInterface(1);
				XTextSortDescriptorRef xDesc = xSortable->createSortDescriptor();

				TextSortKeySequence aSeq(3);
				TextSortKey* pKeys =  aSeq.getArray();
				pKeys[0].SortByRow = TRUE;
				pKeys[0].SortNumeric = TRUE;
				pKeys[0].RowColumnIndex = 1;

				pKeys[1].SortByRow = TRUE;
				pKeys[1].SortNumeric = TRUE;
				pKeys[1].RowColumnIndex = 1;

				pKeys[2].SortByRow = TRUE;
				pKeys[2].SortNumeric = TRUE;
				pKeys[2].RowColumnIndex = 1;


				xDesc->setSortKeys(aSeq);
				xDesc->setSortAscending(TRUE);
				xDesc->setColumnSeparator('\t');

				xSortable->sort(xDesc);
			}*/
/*			{
	Beispiel fuer Frame einfuegen
				XTextRef xText = (XText*)xDoc->queryInterface(XText::getSmartUik());
				XTextCursorRef xCrsr = xText->createTextCursor();
				xCrsr->goRight(2, TRUE);
				XTextPositionRef xPos = (XTextPosition*)xCrsr->queryInterface(XTextPosition::getSmartUik());
				if(xPos)
				{
					XTextFramesRef xFrms = xDoc->getTextFrames();
					XPropertySetRef xPrSet = 0;// ???
						Size* pSize = new Size(200,500);
						xPrSet->setPropertyValue("Size", UsrAny(pSize, Size_getReflection()));
						xPrSet->setPropertyValue("FrameAnchor",
							UsrAny(USHORT(FRAME_ANCHOR_PARAGRAPH)));
					xFrms->addFrame(xPrSet, xPos);
					delete pSize;
				}
			}
*/
			}
		}
	}
	nIndex++;
	return 0;
}

/*-----------------12.12.97 15:19-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, ZoomHdl, PushButton*, EMPTYARG)
{
/*	if(!xModelCollRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );

		XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = USR_XMODELCOLLECTION_ID;
		XServiceProviderRef xSSI = xProv->getServiceProvider( "stardiv.desktop.ModelCollection", aIfaces, Sequence<UsrUik>() );
		xModelCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( USR_XMODELCOLLECTION_ID );
	}
	USHORT nCount = xModelCollRef->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		XModelRef aRef = xModelCollRef->getItemByIndex( i );
		if ( aRef )
		{
			UString aName = aRef->getClassName();
			XTextDocument* pTextDocument = (XTextDocument*)aRef->queryInterface(USR_SW_TEXT_DOCUMENT);
			if(pTextDocument)
			{
				XTextViewsRef xViewsRef = pTextDocument->getViewsCollection();
				if(xViewsRef)
				{
					XTextViewRef xViewRef = xViewsRef->getViewByIndex(0);
					if(xViewRef)
					{
						short nZoom = aZoomValueED.GetText();
						if(nZoom >= - 3)
							xViewRef->setZoom(nZoom);
						else
							for(USHORT i = 20; i < 200; i++)
								xViewRef->setZoom(i);
					}
				}
			}
		}
	}*/
	return 0;
};
/*-----------------15.12.97 10:43-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, TextHdl, Edit*, pEdit)
{
/*	if(!xModelCollRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );

		XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = USR_XMODELCOLLECTION_ID;
		XServiceProviderRef xSSI = xProv->getServiceProvider( "stardiv.desktop.ModelCollection", aIfaces, Sequence<UsrUik>() );
		xModelCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( USR_XMODELCOLLECTION_ID );
	}
	USHORT nCount = xModelCollRef->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		XModelRef aRef = xModelCollRef->getItemByIndex( i );
		if ( aRef )
		{
			UString aName = aRef->getClassName();
			XTextDocument* pTextDocument = (XTextDocument*)aRef->queryInterface(USR_SW_TEXT_DOCUMENT);
			if(pTextDocument)
			{
				XTextViewsRef xViewsRef = pTextDocument->getViewsCollection();
				if(xViewsRef)
				{
					XTextViewRef xViewRef = xViewsRef->getViewByIndex(0);
					if(xViewRef)
					{
						XSelectionObjectRef xSelObj = xViewRef->getSelection();
						if(xSelObj)
						{
							XTextRef xText = (XText*)xSelObj->queryInterface(USR_OFF_TEXT);
							if(xText)
							{
								String sText(pEdit->GetText());
								if(sText.Len())
								{
									XTextCursorRef xCursorRef = xText->getTextCursor();
									XTextPositionRef xPosRef1 = xCursorRef->getPosition();
									xCursorRef->goLeft(2, FALSE);
									XTextPositionRef xPosRef2 = xCursorRef->getPosition();

									XTextWriteableRef xWriteRef = (XTextWriteable*)xText->queryInterface(USR_OFF_TEXT_WRITEABLE);
									if(xWriteRef)
									{
										xWriteRef->setTextByPosition(sText[(USHORT)(sText.Len() -1)], xPosRef1);
										//xWriteRef->setTextByPosition("Rechts", xPosRef1);
										//xWriteRef->setTextByPosition("Links", xPosRef2);
									}
								}
							}
						}
					}
				}
			}
		}
	}*/
	return 0;
};

/*-----------------05.01.98 10:02-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, SearchHdl, PushButton*, EMPTYARG)
{
	XServiceManagerRef xManager = getGlobalServiceManager();
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}



	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XTextSearchableRef xSrchbl = (XTextSearchable*)xDoc->queryInterface(XTextSearchable::getSmartUik());
				XTextSearchRef xTSrch = xSrchbl->createTextSearch();
				XPropertySetRef xPrSet = (XPropertySet*)xTSrch->queryInterface(XPropertySet::getSmartUik());
				PropertyDialog aDlg(this, xPrSet);
				aDlg.Execute();
				xTSrch->setSearchText(L"Suche");
				XTextReplaceRef xRepl = (XTextReplace*)xTSrch->queryInterface(XTextReplace::getSmartUik());
				xRepl->setReplaceText(L"Ersetzung");
//				ULONG nRepl = xSrchbl->replace(xRepl);
				XContainerRef xCont = xRepl->search();
/*				if(xCont->getHasElements())
				{
					XTextPositionsRef xPos = (XTextPositions*)xCont->queryInterface(XTextPositions::getSmartUik());
					XDocumentViewRef xView = (XDocumentView*)xDoc->queryInterface(
													XDocumentView::getSmartUik());
					if(xView.is())
						xView->select(xPos);

					if(xPos.is())
					{
						INT32 nCount = xPos->getCount();
						if(nCount)
						{
							XTextPositionRef xP = xPos->getTextPositionByIndex(0);
							if(nCount > 1)
								xPos->removeTextPositionByIndex(1);
							nCount = xPos->getCount();
							for(INT32 i = 0; i < nCount; i++)
							{
								XTextPositionRef xP = xPos->getTextPositionByIndex(i);
								if(xP.is())
									xP->setText(L"neuer Text");
							}
							if(nCount > 2)
							{
								XTextPositionRef xP = xPos->getTextPositionByIndex(2);
								if(xP.is())
									xP->setText(L"wieder gendert");
							}
						}
					}
				}*/
			}
		}
	}
	return 0;
}
/*-----------------05.01.98 10:27-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, ReplaceHdl, PushButton*, EMPTYARG)
{
/*	if(!xModelCollRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );

		XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = USR_XMODELCOLLECTION_ID;
		XServiceProviderRef xSSI = xProv->getServiceProvider( "stardiv.desktop.ModelCollection", aIfaces, Sequence<UsrUik>() );
		xModelCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( USR_XMODELCOLLECTION_ID );
	}
	USHORT nCount = xModelCollRef->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		XModelRef aRef = xModelCollRef->getItemByIndex( i );
		if ( aRef )
		{
			UString aName = aRef->getClassName();
			XTextDocument* pTextDocument = (XTextDocument*)aRef->queryInterface(USR_SW_TEXT_DOCUMENT);
			if(pTextDocument)
			{
				XTextViewsRef xViewsRef = pTextDocument->getViewsCollection();
				if(xViewsRef)
				{
					XTextViewRef xViewRef = xViewsRef->getViewByIndex(0);
					if(xViewRef)
					{
						XSearchableRef xSearchable = (XSearchable*)xViewRef->queryInterface(USR_OFF_SEARCHABLE);
						if(xSearchable)
						{
							XSearchRef xSrch = (XSearch*)xSearchable->createSearch();
							xSrch->setSearchText(aSearchED.GetText());

							XReplaceRef xRepl = (XReplace*)xSrch->queryInterface(USR_OFF_REPLACE);
							BOOL bRet = FALSE;
							if(xRepl)
							{
								xRepl->setReplaceText(aReplaceED.GetText());
								bRet = xRepl->replace();
							}
							if(!bRet)
								Sound::Beep();
						}
					}
				}
			}
		}
	}*/
	return 0;
}

/*-----------------17.12.97 08:20-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, CursorHdl, PushButton*, pButton)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}

	static XWordCursorRef xWrdCrsr;
	static XDocumentViewRef xView;

	if(!xWrdCrsr.is())
	{
		XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
		XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
		USHORT nCount = xIdx->getCount();
		for (  USHORT i = 0; i < nCount; i++ )
		{
			//XModelRef aRef = xModelCollRef->getItemByIndex( i );
			XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
			if ( aRef )
			{
	//            UString aName = aRef->getClassName();
				XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
				if(xDoc.is())
				{
					XTextRef xBodyTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
					XTextCursorRef xTxtCrsr = xBodyTxt->createTextCursor();
					xWrdCrsr = (XWordCursor*)xTxtCrsr->queryInterface(XWordCursor::getSmartUik());
					xView = (XDocumentView*)xDoc->queryInterface(
													XDocumentView::getSmartUik());
				}
			}
		}
	}
	if(pButton == &aNextWordPB)
	{
		if(xWrdCrsr->gotoNextWord(TRUE, FALSE))
			Sound::Beep();
	}
	else if(pButton == &aPrevWordPB)
	{
		if(xWrdCrsr->gotoPreviousWord(TRUE, FALSE))
			Sound::Beep();
	}
	if(xView.is())
		xView->select(xWrdCrsr);
/*	BOOL bSelect = aSelectCB.IsChecked();
	if(!xCursorRef)
		GetCursor();
	if(!xCursorRef)
		return 0;

	if(pButton == &aLeftPB)
	{
		xCursorRef->goLeft(1, bSelect);
	}
	else if(pButton == &aRightPB)
	{
		xCursorRef->goRight(1, bSelect);
	}
	else if(pButton == &aNextWordPB)
	{
		XWordCursorRef xWrdCrsr = (XWordCursor*)xCursorRef->queryInterface(USR_OFF_WORD_CURSOR);
		if(xWrdCrsr)
			xWrdCrsr->gotoNextWord(TRUE, bSelect);
	}
	else if(pButton == &aPrevWordPB)
	{
		XWordCursorRef xWrdCrsr = (XWordCursor*)xCursorRef->queryInterface(USR_OFF_WORD_CURSOR);
		if(xWrdCrsr)
			xWrdCrsr->gotoPreviousWord(TRUE, bSelect);
	}
	XTextPositionRef xPosRef = xCursorRef->getPosition();
	String sText( xTextRef->getTextByPosition(xPosRef));
	aWriteED.SetText(sText);*/
	return 0;
}
/*-----------------17.12.97 08:20-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, TableHdl, PushButton*, pButton)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );
//		aIfaces.getArray()[0] = XModelCollection::getSmartUik();
//        XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.desktop.ModelCollection"), aIfaces, Sequence<UsrUik>() );
//		xModelCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( XModelCollection::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}

	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XPropertySetRef xProp;

					XTextTablesRef xTbls = xDoc->getTextTables();
					XIndexAccessRef xFIdx = (XIndexAccess*)xTbls->queryInterface(XIndexAccess::getSmartUik());
					XTextTableRef xTbl = xTbls->getTextTableByIndex(0);
					if(xTbl)
					{
						XCellRangeRef xTblRg = (XCellRange*)xTbl->queryInterface(XCellRange::getSmartUik());
						USHORT nRows = xTblRg->getRowCount();
						USHORT nCols = xTblRg->getColumnCount();
						XCellRangeRef xSubRg = xTblRg->getSubRange(0,0, nCols - 1, nRows - 1);
						XPropertySetRef xRgPrSet = (XPropertySet*)xSubRg->queryInterface(XPropertySet::getSmartUik());
						UsrAny aVal;
						aVal.setBOOL(TRUE);
						xRgPrSet->setPropertyValue(L"ChartRowAsLabel", aVal);
						xRgPrSet->setPropertyValue(L"ChartColumnAsLabel", aVal);

						XChartDataRef xData = (XChartData*)xSubRg->queryInterface(XChartData::getSmartUik());
						Sequence< Sequence< double > > aDataArr = xData->getData();

						const Sequence<double>* pDataArr = aDataArr.getConstArray();

						for(USHORT j = 0; j < aDataArr.getLen(); j++)
						{
							const Sequence<double> aRow = pDataArr[j];
							const double * pConstArray = aRow.getConstArray();
							for(USHORT i = 0; i < aRow.getLen(); i++)
								double fVal = pConstArray[0];
						}


						//hier mal ein kleiner Performance-Test
						USHORT nMax = 10000;
						for(USHORT k = 0; k < nMax; k++)
						{
							XCellRef xCell = xTblRg->getCell(0,0);
							XPropertySetRef xPrSet = (XPropertySet*)xTbl->queryInterface(XPropertySet::getSmartUik());
							UsrAny aRet = xPrSet->getPropertyValue(L"TransparentBackground");
							BOOL bTrans = TypeConversion::toBOOL(aRet);
						}

/*						xTbl->insertRows(3,4);
						xTbl->insertColumns(2,2);
						XCellRangeRef xRg = (XCellRange*)xTbl->queryInterface(XCellRange::getSmartUik());
						UINT16 nCount = xRg->getColumnCount();
						XCellRangeRef xTblRange = (XCellRange*)xTbl->queryInterface(XCellRange::getSmartUik());
						XCellRangeRef xRange = xTblRange->getSubRange(1,2,3,5);
						if(xRange.is())
						{
							xProp = (XPropertySet*)xRange->queryInterface(XPropertySet::getSmartUik());
//		 				xProp = (XPropertySet*)xTbl->queryInterface(XPropertySet::getSmartUik());

							if(xProp.is())
							{
								PropertyDialog aDlg(this, xProp);
								if(RET_OK == aDlg.Execute())
								{
								}
							}
							XCellRangeRef xSubRange = xRange->getSubRange(0,1,1,2);
							if(xSubRange.is())
							{
								xProp = (XPropertySet*)xSubRange->queryInterface(XPropertySet::getSmartUik());
								if(xProp.is())
								{
									PropertyDialog aDlg(this, xProp);
									if(RET_OK == aDlg.Execute())
									{
									}
								}
							}
							XCellRef xCell = xRange->getCell(1,2);
							if(xCell)
							{
								xProp = (XPropertySet*)xCell->queryInterface(XPropertySet::getSmartUik());
								PropertyDialog aDlg(this, xProp);
								if(RET_OK == aDlg.Execute())
								{
								}
							}


						}
 */
					}
			}
		}
	}
	return 0;

};
/*-----------------18.12.97 13:34-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, TableInsertHdl, PushButton*, pButton)
{
/*	XSelectionObjectRef xSelObj = getSelection();
	if(xSelObj)
	{
		XTableInsertableRef xTInsRef = (XTableInsertable*)xSelObj->
									queryInterface(USR_SW_TABLE_INSERTABLE);
		if(xTInsRef)
		{
			XTextRef xTextRef = (XText*)xSelObj->queryInterface(USR_OFF_TEXT);
			XTextCursorRef xCursorRef = xTextRef->getTextCursor();
			XTextPositionRef xPosRef = xCursorRef->getPosition();
			if(xPosRef)
			{
				//PropertySet organisieren
				XServiceManagerRef xProv = getGlobalServiceManager();
				Sequence<UsrUik> aIfaces( 1 );
				XServiceProviderRef  xSSI2 = xProv->getServiceProvider( "stardiv.desktop.XPropertySet", aIfaces, Sequence<UsrUik>() );
				XPropertySetRef aPropSet = (XPropertySet*) xSSI2->newInstance()->queryInterface(USR_PROPERTYSET_ID);

				FmtVertOrient* pVertOrient = new FmtVertOrient();
				UsrAny aVertOrient(pVertOrient, FmtVertOrient_getReflection());
				aPropSet->setPropertyValue("FmtVertOrient", aVertOrient);

				xTInsRef->insertTable(5,5, xPosRef, aPropSet);

			}
		}
	}*/
	return 0;

};
/*-----------------23.02.98 15:38-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, PropertyHdl, ListBox*, pBox)
{
	XPropertySetClonerRef xClone;
	String sContent = pBox->GetSelectEntry();
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XPropertySetRef xProp;
				if(pBox == &aGraphicLB)
				{
					XTextGraphicObjectsRef xFrms = xDoc->getGraphicObjects();
					XNameAccessRef xFIdx = (XNameAccess*)xFrms->queryInterface(XNameAccess::getSmartUik());
					XTextGraphicObjectRef xFrm = xFrms->getGraphicByName(S2U(sContent));
					if(xFrm)
					{
//		 				xProp = (XPropertySet*)xFrm->queryInterface(XPropertySet::getSmartUik());
						xClone = (XPropertySetCloner*)xFrm->queryInterface(
																XPropertySetCloner::getSmartUik());
						if(xClone)
						{
							xProp = xClone->cloneProperties();
						}
					}
				}
				if(pBox == &aFrameLB)
				{
					XTextFramesRef xFrms = xDoc->getTextFrames();
					XNameAccessRef xFIdx = (XNameAccess*)xFrms->queryInterface(XNameAccess::getSmartUik());
					XTextFrameRef xFrm = xFrms->getTextFrameByName(S2U(sContent));
					if(xFrm)
					{
//		 				xProp = (XPropertySet*)xFrm->queryInterface(XPropertySet::getSmartUik());
						xClone = (XPropertySetCloner*)xFrm->queryInterface(
																XPropertySetCloner::getSmartUik());
						if(xClone)
						{
							xProp = xClone->cloneProperties();
						}
					}
				}
				else if(pBox == &aTableLB)
				{
					XTextTablesRef xTbls = xDoc->getTextTables();
					XNameAccessRef xFIdx = (XNameAccess*)xTbls->queryInterface(XNameAccess::getSmartUik());
					XTextTableRef xTbl = xTbls->getTextTableByName(S2U(sContent));
					if(xTbl)
					{
//		 				xProp = (XPropertySet*)xTbl->queryInterface(XPropertySet::getSmartUik());
						xClone = (XPropertySetCloner*)xTbl->queryInterface(
																XPropertySetCloner::getSmartUik());
						if(xClone)
						{
							xProp = xClone->cloneProperties();
						}
					}
				}
				else if(pBox == &aSectionLB)
				{
					XTextSectionsRef xScts = xDoc->getTextSections();
					XTextSectionRef xSec = xScts->getTextSectionByName(S2U(sContent));
					xProp = (XPropertySet*)xSec->queryInterface(XPropertySet::getSmartUik());
				}

				if(xProp)
				{
					PropertyDialog aDlg(this, xProp);
					if(RET_OK == aDlg.Execute())
					{
						if(xClone)
						{
							xClone->applyProperties(xProp);
						}
					}
				}
			}
		}
	}
	return 0;

};
/*-----------------23.02.98 15:38-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, AutoFmtHdl, PushButton*, EMPTYARG)
{
	if(!aTableLB.GetSelectEntryCount())
		return 0;
	XPropertySetClonerRef xClone;
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{

					XTextTablesRef xTbls = xDoc->getTextTables();
					XNameAccessRef xFIdx = (XNameAccess*)xTbls->queryInterface(XNameAccess::getSmartUik());
					XTextTableRef xTbl = xTbls->getTextTableByName(S2U(aTableLB.GetSelectEntry()));
					if(xTbl)
					{
						XAutoFormattableRef xAF = (XAutoFormattable*)xTbl->queryInterface(XAutoFormattable::getSmartUik());
						xAF->applyAutoFormat(S2U(aAutoFormatED.GetText()));
					}
			}
		}
	}


	return 0;

};
/*-----------------14.03.98 13:27-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, StartTextHdl, PushButton*, pBtn)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}


	//Felder
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XTextRef xBodyTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
				XTextCursorRef 	xTxtCrsr = xBodyTxt->createTextCursor();
				xTxtCrsr->goRight(1,FALSE);
				xTxtCrsr->goRight(5,TRUE);
				XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
//				String sText = xTxtPos->getText();
//				sText = "Test";
//				xTxtPos->setText(sText);
				XPropertySetRef xPrSet = (XPropertySet*)xTxtCrsr->queryInterface(XPropertySet::getSmartUik());
//				XPropertySetClonerRef xClone = (XPropertySetCloner*)xTxtCrsr->queryInterface(
//														XPropertySetCloner::getSmartUik());
//				if(xClone)
//				{
//					xPrSet = xClone->cloneProperties();
//				}
				PropertyDialog aDlg(pBtn, xPrSet);
				if(RET_OK == aDlg.Execute())// &&
//					xClone.is())
//				{
//					xClone->applyProperties(xPrSet);
//				}
				//Fussnoten:
				xTxtCrsr->goRight(5, 0);
				XFootnotesRef xFtns = xDoc->getFootnotes();
				xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
				long nCount = xFtns->getCount();
				XFootnoteRef xFtn = xFtns->addFootnote(xTxtPos, S2U("***"));
				xFtn->setMark(S2U(""));
				xFtn->setMark(S2U("ABC"));
				XTextRef xFtnText = (XText*)xFtn->queryInterface(XText::getSmartUik());
				if(xFtnText.is())
				{
					XTextCursorRef xCrsr = xFtnText->createTextCursor();
					XTextPositionRef xFtnTxtPos = (XTextPosition*)xCrsr->queryInterface(XTextPosition::getSmartUik());
					xFtnTxtPos->setText(S2U("Funoteninhalt"));
				}

				xTxtCrsr->goLeft(2, 0);
				xTxtCrsr->goLeft(1, 1);
				xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
				XDocumentIndexesRef xIndexes = xDoc->getIndexes();
				unsigned long nCnt = xIndexes->getIndexTypeCount();

				XDocumentIndexTypeRef xType = xIndexes->getIndexTypeByIndex(0);
				nCnt = xType->getDocumentIndexCount();

				XDocumentIndexTypeRef xNewType = xIndexes->addIndexType(S2U("xxxx"));
				if(xNewType.is())
				{
					XDocumentIndexMarkRef xMark = xNewType->addIndexMark(xTxtPos);
					if(xMark.is())
					{
						XPropertySetRef xProp = (XPropertySet*)xMark->queryInterface(XPropertySet::getSmartUik());

						PropertyDialog aDlg(this, xProp);
						aDlg.Execute();
					}
					xTxtCrsr->goRight(5, 0);
					xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
					XPropertySetRef xIdxDescriptor = xNewType->createDocumentIndex();
					XDocumentIndexRef xIdx = xNewType->insertDocumentIndex(xIdxDescriptor, xTxtPos);
					if(xIdx.is())
					{
						XPropertySetRef xProp = (XPropertySet*)xIdx->queryInterface(XPropertySet::getSmartUik());

						PropertyDialog aDlg(this, xProp);
						aDlg.Execute();
					}
				}

				xIndexes->removeIndexType(xType);

//				xFtns->removeFootnote(xFtn);


				// Feld einfuegen
				XFieldTypesRef xTypes = xDoc->getFieldTypes();
				Sequence<UINT16> aSeq = xTypes->getFieldTypeIds();
				USHORT* pArray = aSeq.getArray();
/*				for( UINT32 i = 0; i < aSeq.getLen(); i++)
				{
					XTextFieldRef xFld;
					XTextFieldTypeRef xFieldType = xTypes->getFieldType(pArray[i]);
					if(!xFieldType.is())
					{
						xFld = 0;
						Sequence<UString> aNames = xTypes->getFieldTypeNames(pArray[i]);
						if(aNames.getLen())
						{
							String* pStrArr = aNames.getArray();
							XNamedFieldTypeRef xFieldType = xTypes->getNamedFieldType(pArray[i], pStrArr[0]);
							if(xFieldType.is())
							{
								XNamedFieldType* pTp = xFieldType;
								XTextFieldTypeRef xFldTp = (XTextFieldType*)pTp;
								xFld = xTypes->insertTextField(xFldTp, xTxtPos);
							}
							xTypes->removeFieldType(xFieldType);
						}
					}
					if(xFieldType.is())
					{
						xFld = xTypes->insertTextField(xFieldType, xTxtPos);
					}
					if(!xFld)
					{
						String sMessage(pArray[i]);
						sMessage.Insert("Das Feld konnte nicht eingefgt werden: ", 0);
						InfoBox(pBtn, sMessage).Execute();
					}
					else
					{
						XPropertySetRef xProp = (XPropertySet*)xFld->queryInterface(XPropertySet::getSmartUik());
						PropertyDialog* pDlg = new PropertyDialog(pBtn, xProp);
						pDlg->SetText("Neues Feld");
						pDlg->Execute();
						delete pDlg;
						xTypes->removeTextField(xFld);
					}
				}*/


			}
		}
	}
	return 0;
}
/*-----------------15.03.98 12:49-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, SettingsHdl, PushButton*, pBtn)
{
	XServiceManagerRef xProv = getGlobalServiceManager();
	DBG_ASSERT( xProv, "Kein ServiceProvider!" );
	XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
	if ( !xReg )
		return 0;
	Sequence<UsrUik> aIfaces( 1 );

	if(pBtn == &aSettingsPB)
	{
		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		XModuleRef xModule = xSSI2.is() ? (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() ) : 0;
		XPrintSettingsRef xPrtSet = (XPrintSettings*)xModule->queryInterface(

			XPrintSettings::getSmartUik());
		XPrintSettings* pSet = xPrtSet;
		XPropertySetRef xPrSet =  pSet;


	//	PropertySetRef xPrSet = (XPropertySet*)xPrtSet->queryInterface(
	//												XPropertySet::getSmartUik());
		PropertyDialog aDlg(pBtn, xPrSet);
		aDlg.Execute();
		XViewSettingsRef xViewSet = (XViewSettings*)xModule->queryInterface(
													XViewSettings::getSmartUik());
	//	xPrSet = (XPropertySet*)xViewSet->queryInterface(
	//												XPropertySet::getSmartUik());
		XViewSettings* pView = xViewSet;
		xPrSet = pView;
		PropertyDialog aDlg2(pBtn, xPrSet);
		aDlg2.Execute();
	}
	else
	{
		if(!xDesktopRef)
		{
			XServiceManagerRef xProv = getGlobalServiceManager();
			DBG_ASSERT( xProv, "Kein ServiceProvider!" );
			XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
			//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
			if ( !xReg )
				return 0;
			Sequence<UsrUik> aIfaces( 1 );
			aIfaces.getArray()[0] = XDesktop::getSmartUik();
			XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
			xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

			aIfaces.getArray()[0] = XModule::getSmartUik();
			XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
			if(xSSI2.is())
				XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

		}

		XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
		XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
		USHORT nCount = xIdx->getCount();
		for (  USHORT i = 0; i < nCount; i++ )
		{
			//XModelRef aRef = xModelCollRef->getItemByIndex( i );
			XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
			if ( aRef )
			{
	//            UString aName = aRef->getClassName();
				XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
				if(xDoc.is())
				{
					XModelRef xMdl = (XModel*)xDoc->queryInterface(XModel::getSmartUik());
					XControllerRef 	xCtrl = xMdl->getCurrentController();
					XDocumentViewRef xView = (XDocumentView*)xCtrl->queryInterface(
													XDocumentView::getSmartUik());
					XInterfaceRef xSel = xView->getSelection();
					if(xSel.is() && xSel->queryInterface(XTextPositions::getSmartUik()))
					{
						XTextPositionsRef xPos = (XTextPositions*)xSel->queryInterface(
															XTextPositions::getSmartUik());
						INT32 nCount = xPos->getCount();
						for(INT32 i = 0; i < nCount; i++)
						{
							XTextPositionRef xP = xPos->getTextPositionByIndex(i);
							String sTxt = U2S(xP->getText());
							XTextRef xTxt = xP->getParentText();
							static XTextFrameRef xParentFrame;
							static XTextPositionRef xSavePos;
							if(!xParentFrame.is())
							{
								xParentFrame = (XTextFrame*)xTxt->queryInterface(XTextFrame::getSmartUik());
								xSavePos = xP;
							}
						}
					}
					if(!xView.is())
						return 0;
					XViewSettingsRef xViewSet = (XViewSettings*)xView->queryInterface(
													XViewSettings::getSmartUik());

					XViewSettings* pVs = xViewSet;
					XPropertySetRef xPrSet = pVs;
					PropertyDialog aDlg2(pBtn, xPrSet);
					aDlg2.SetText("ViewSettings der View");
					aDlg2.Execute();
				}
			}
		}
	}
	return 0;
}
/*-----------------02.04.98 11:45-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, ViewSelectHdl, PushButton*, pBtn)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}

	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XDocumentViewRef xView = (XDocumentView*)xDoc->queryInterface(
												XDocumentView::getSmartUik());
				if(!xView.is())
					return 0;
				if(pBtn == &aSelTblPB)
				{
					String sContent = aTableLB.GetSelectEntry();
					XTextTablesRef xTbls = xDoc->getTextTables();
					if(sContent.Len())
					{
						XNameAccessRef xFIdx = (XNameAccess*)xTbls->queryInterface(XNameAccess::getSmartUik());
						XTextTableRef xTbl = xTbls->getTextTableByName(S2U(sContent));
						if(xTbl)
						{
							xView->select(xTbl);
							xTbls->removeTextTableByName(xTbl->getName());
						}
					}
				}
				else if(pBtn == &aSelFrmPB)
				{
					String sContent = aFrameLB.GetSelectEntry();
					XTextFramesRef xFrms = xDoc->getTextFrames();
					if(sContent.Len())
					{
						XNameAccessRef xFIdx = (XNameAccess*)xFrms->queryInterface(XNameAccess::getSmartUik());
						XTextFrameRef xFrm = xFrms->getTextFrameByName(S2U(sContent));
					}
					if(xFrm)
					{
						xView->select(xFrm);
						xFrms->removeTextFrameByName(xFrm->getName());
					}


				}
				else if(pBtn == &aSelBkmPB)
				{
					String sContent = aBookmarkLB.GetSelectEntry();
					if(sContent.Len())
					{
						XBookmarksRef xBkms = xDoc->getBookmarks();
						XBookmarkRef xBkm = xBkms->getBookmarkByName(S2U(sContent));
						if(xBkm)
							xView->select(xBkm);
					}
				}
			}
		}
	}
	return 0;
}


/*-----------------10.03.98 14:28-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, CellHdl, ListBox*, pBox)
{
	String sContent = aTableLB.GetSelectEntry();
	if(sContent.Len())
	{
		XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
		XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
		USHORT nCount = xIdx->getCount();
		for (  USHORT i = 0; i < nCount; i++ )
		{
			//XModelRef aRef = xModelCollRef->getItemByIndex( i );
			XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
			if ( aRef )
			{
	//            UString aName = aRef->getClassName();
				XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
				if(xDoc.is())
				{
					XTextTablesRef xTbls = xDoc->getTextTables();
					XTextTableRef xTbl = xTbls->getTextTableByName(S2U(sContent));
					if(xTbl)
					{
						XCellRangeRef xCellRange = (XCellRange*)xTbl->queryInterface(XCellRange::getSmartUik());
						XCellRef xCell = xCellRange->getCell(1,1);
						XTextRef xTxt = (XText*)xCell->queryInterface(XText::getSmartUik());
						String sCellText = U2S(xTxt->getText());
						XParagraphEnumerationAccessRef xEnumerationAccess = (XParagraphEnumerationAccess*)
												xTxt->queryInterface(XParagraphEnumerationAccess::getSmartUik());
						XParagraphEnumerationRef xEnumeration = xEnumerationAccess->getParagraphEnumeration();
						if(xEnumeration.is())
						{
							XEnumerationRef xEnum = (XEnumeration*)xEnumeration->queryInterface(
																	XEnumeration::getSmartUik());
							BOOL bNext = xEnum->hasMoreElements();
							XInterfaceRef xPara = xEnum->nextElement();
							while(xPara.is())
							{
								XPropertySetRef xPSet = (XPropertySet*)
												xPara->queryInterface(XPropertySet::getSmartUik());
								PropertyDialog aDlg(this, xPSet);
								aDlg.SetText("Paragraph properties");
								if(RET_OK == aDlg.Execute())
									xPara = xEnum->nextElement();
								else
									xPara = 0;
							}

						}
						XTextCursorRef xTxtCrsr = xTxt->createTextCursor();
						xTxtCrsr->goRight(1,0);
						xTxtCrsr->goRight(1,1);
						XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());
						String sText = U2S(xTxtPos->getText());
						sText = "Test";
						xTxtPos->setText(S2U(sText));

					}
				}
			}
		}
	}
	return 0;
}
/*-----------------09.03.98 17:37-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, BookmarkHdl, ListBox*, pBox)
{
	String sContent = pBox->GetSelectEntry();
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XPropertySetRef xProp;
				XBookmarksRef xBkms = xDoc->getBookmarks();
				XNameAccessRef xBIdx = (XNameAccess*)xBkms->queryInterface(XNameAccess::getSmartUik());
				XBookmarkRef xBkm = xBkms->getBookmarkByName(S2U(sContent));
				if(xBkm)
				{
					xProp = (XPropertySet*)xBkm->queryInterface(XPropertySet::getSmartUik());
				}
				xBkms->removeBookmarkByName(xBkm->getName());

			}
		}
	}
	return 0;
}
/* -----------------26.05.98 15:19-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(MyWindow, StyleHdl, PushButton*, pButton)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}


	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XStyleFamiliesRef xFams = xDoc->getStyleFamilies();
				StyleDialog aDlg(pButton, xFams);
				aDlg.Execute();
/*				XStyleFamilyRef xFam = xFams->getStyleFamilyByType(STYLE_FAMILY_PARAGRAPH);
				if(xFam.is())
				{
					INT32 nCount = xFam->getCount();
					XStyleRef xStyle = xFam->getStyleByIndex(0);
					XStyleRef xStyleN = xFam->getStyleByName(L"Standard");
					if(xStyleN.is)
					{
						xStyleN->getName();
						XPropertySetRef xPrSet = (XPropertySet*)xStyleN->queryInterface(XPropertySet::getSmartUik());
						PropertyDialog aDlg(pButton, xPrSet);
						aDlg.Execute();
					}
				}
*/			}
		}
	}
	return 0;
}
/*-----------------17.12.97 08:24-------------------

--------------------------------------------------*/
void 	MyWindow::GetCursor()
{
/*	if(!xModelCollRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );

		XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = USR_XMODELCOLLECTION_ID;
		XServiceProviderRef xSSI = xProv->getServiceProvider( "stardiv.desktop.ModelCollection", aIfaces, Sequence<UsrUik>() );
		xModelCollRef = (XModelCollection*) xSSI->newInstance()->queryInterface( USR_XMODELCOLLECTION_ID );
	}
	USHORT nCount = xModelCollRef->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		XModelRef aRef = xModelCollRef->getItemByIndex( i );
		if ( aRef )
		{
			xTextDocumentRef = (XTextDocument*)aRef->queryInterface(USR_SW_TEXT_DOCUMENT);
			if(xTextDocumentRef)
			{
				XTextViewsRef xViewsRef = xTextDocumentRef->getViewsCollection();
				if(xViewsRef)
				{
					xViewRef = xViewsRef->getViewByIndex(0);
					if(xViewRef)
					{
						xSelObj = xViewRef->getSelection();
						if(xSelObj)
						{
							xTextRef = (XText*)xSelObj->queryInterface(USR_OFF_TEXT);
							if(xTextRef)
							{
								xCursorRef = xTextRef->getTextCursor();
								break;
							}
						}
					}
				}
			}
		}
	}*/
}
/*-----------------02.03.98 17:13-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, FieldHdl, PushButton*, EMPTYARG)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}

	//Felder
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				FieldViewDlg* pFldView = new FieldViewDlg(this, xDoc->getFieldTypes());
				pFldView->Execute();
				delete pFldView;
				break;
			}
		}
	}
	return 0;
}

/*-----------------11.03.98 15:03-------------------

--------------------------------------------------*/
IMPL_LINK(MyWindow, ShapesHdl, PushButton*, pBtn)
{
	XServiceManagerRef xManager = getGlobalServiceManager();
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}


	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
				XDrawPageRef xPage = xDoc->getDrawPage();
				XFormPageRef xFormPage = (XFormPage*)xPage->queryInterface(XFormPage::getSmartUik());
				if(xFormPage.is())
				{
					XFormsRef xForms = xFormPage->getForms();
					XFormComponentFactoryRef xFac = (XFormComponentFactory*)xFormPage->queryInterface(XFormComponentFactory::getSmartUik());
					Sequence< UString > aTypes = xFac->getFormComponentTypes();
					UString* pTypes = aTypes.getArray();
					XFormComponentRef xComp = xFac->createFormComponent(pTypes[0]);
//					XFormComponentRef xComp = (XFormComponent*)xDesc->queryInterface(XFormComponent::getSmartUik());

					XServiceProviderRef xProv =
							xManager->getServiceProvider( L"stardiv.desktop.forms.component.Form",
								  Sequence<Uik>(),
								  Sequence<Uik>() );
					XFormRef xForm = (XForm *)xProv->newInstance()->queryInterface( XForm::getSmartUik() );

					XFormComponentsRef xComps = (XFormComponents*)xForm->queryInterface(XFormComponents::getSmartUik());


					xComps->appendFormComponent(xComp);
					XShapesRef xShapes = (XShapes*)xPage->queryInterface(XShapes::getSmartUik());
				XTextShapesRef xTextShapes = (XTextShapes*)xPage->queryInterface(XTextShapes::getSmartUik());
				XTextRef xBodyTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
				XTextCursorRef 	xTxtCrsr = xBodyTxt->createTextCursor();
				xTxtCrsr->goRight(1,0);
				XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());

				XShapeFactoryRef xShFac = (XShapeFactory*)xPage->queryInterface(XShapeFactory::getSmartUik());
				Sequence<UString> aShapeTypes = xShFac->getShapeTypes(  );
				UString* pShTypes = aShapeTypes.getArray();
				XShapeDescriptorRef xDesc = xShFac->createShape( pShTypes[0], Size(200,400));

					XShapeRef xShape = xTextShapes->insertShapeAtTextPosition( xDesc, xTxtPos );

//    				xForms->insertFormByName(xForm, L"Form1");

//					XShapes* xShapes = (XShapes*)xForm->queryInterface(XShapes::getSmartUik());
//					XShapeRef xShape = xShapes->insertShape( xDesc, Point(100,100) );
				}

//				XShapesRef xShapes= xDoc->getShapes();
				XFormComponentFactoryRef xFmFac = (XFormComponentFactory*)xPage->queryInterface(XFormComponentFactory::getSmartUik());
				Sequence<UString> aFmTypes = xFmFac->getFormComponentTypes();
				UString* pFmTypes = aFmTypes.getArray();
				long nFmCount = aFmTypes.getLen();
//				XShapeDescriptorRef xFmDsc = xFmFac->createFormComponent( pFmTypes[0], Size(200,400));

				XShapeFactoryRef xFac = (XShapeFactory*)xPage->queryInterface(XShapeFactory::getSmartUik());
				Sequence<UString> aTypes = xFac->getShapeTypes(  );
				UString* pTypes = aTypes.getArray();
				XShapeDescriptorRef aDsc = xFac->createShape( pTypes[0], Size(200,400));
//				Point aPt(2000,2000);
				XTextShapesRef xTextShapes = (XTextShapes*)xPage->queryInterface(XTextShapes::getSmartUik());

				XTextRef xBodyTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
				XTextCursorRef 	xTxtCrsr = xBodyTxt->createTextCursor();
				xTxtCrsr->goRight(1,0);
				XTextPositionRef xTxtPos = (XTextPosition*)xTxtCrsr->queryInterface(XTextPosition::getSmartUik());


				XPropertySetRef xPrSet = (XPropertySet*)aDsc->queryInterface(XPropertySet::getSmartUik());
				if(xPrSet.is())
				{
					PropertyDialog aDlg(pBtn, xPrSet);
					aDlg.SetText("Shape descriptor properties");
					aDlg.Execute();
//					aDlg.Execute();
				}
				xTextShapes->insertShapeAtTextPosition(aDsc, xTxtPos);
				XShapesRef xShapes = (XShapes*)xPage->queryInterface(XShapes::getSmartUik());
				XShapeDescriptorRef xDsc2 = xFac->createShape( pTypes[1], Size(800,400));
//				XShapeRef xShape2 = xShapes->insertShape(xDsc2, Point(4000,3000));

//				XShapeRef xFmShape = xShapes->insertShape(xFmDsc, Point(4000,3000));
//				XPropertySetRef xPrSet2 = (XPropertySet*)xShape2->queryInterface(XPropertySet::getSmartUik());
//				if(xPrSet2.is())
//				{
//					PropertyDialog aDlg(pBtn, xPrSet2);
//					aDlg.SetText("Shape properties");
//					aDlg.Execute();
//				}
				XIndexAccessRef xIdx = (XIndexAccess*)xPage->queryInterface(XIndexAccess::getSmartUik());
				INT32 nCnt = xIdx->getCount();

				for( INT32 i = 0; i < nCnt; i++ )
				{
					XInterfaceRef xInt = xIdx->getElementByIndex(i);
					XShapeRef xShape0 = (XShape*)xInt->queryInterface(XShape::getSmartUik());
					if(xShape0)
					{
						XPropertySetRef xPrSet0 = (XPropertySet*)xShape0->queryInterface(XPropertySet::getSmartUik());
						if(xPrSet0.is())
						{
							PropertyDialog aDlg(pBtn, xPrSet0);
							String sText("Shape properties object ");
							sText += i;
							aDlg.SetText(sText);
							aDlg.Execute();
						}
					}
				}
				break;
			}
		}
	}
	return 0;
}

/*-----------------11.12.97 10:25-------------------

--------------------------------------------------*/
extern "C" Window* __LOADONCALLAPI CreateWindow( Window *pParent, const String& rParam )
{
	MyWindow *pWin = new MyWindow( pParent );


	return pWin;
}

/*-----------------24.02.98 09:45-------------------

--------------------------------------------------*/
PropertyDialog::PropertyDialog(Window* pParent, XPropertySetRef xProp) :
			ModalDialog(pParent, WB_STDMODAL),
			xPropSet(xProp),
			aOk(this),
			aCancel(this),
			nYPos(6),
			nXPos(0),
			nNumberingPosition(0xffff)
{
	SetOutputSizePixel(Size(600, 600));
	aCancel.SetPosSizePixel(Point(535, 35), Size(60, 20));
	aCancel.Show();
	aOk.SetPosSizePixel(Point(535, 10), Size(60, 20));
	aOk.SetClickHdl(LINK(this, PropertyDialog, OkHdl));
	aOk.Show();
	USHORT n = 0;
	while(n < MAX_BOXES)
	{
		aBoxes[n] = 0;
		n++;
	}


	XPropertySetInfoRef xInfo = xPropSet->getPropertySetInfo();
	Sequence<Property> aSeq = xInfo->getProperties();
	Property* pProp = aSeq.getArray();

	for(USHORT i = 0; i < aSeq.getLen(); i++ )
	{
		UsrAny aAny = xProp->getPropertyValue(pProp->Name);
		AddProperty(U2S(pProp->Name), aAny, pProp);
		pProp++;
	}

}
/*-----------------24.02.98 10:02-------------------

--------------------------------------------------*/
PropertyDialog::~PropertyDialog()
{
	USHORT n = 0;
	while(n < MAX_BOXES)
	{
		delete aBoxes[n];
		n++;
	}
}
/*-----------------24.02.98 09:48-------------------

--------------------------------------------------*/
INT32 lcl_getInt32(UsrAny aVal)
{
	INT32 nRet = 0;
	if( aVal.getReflection() == BYTE_getReflection())
		nRet = (INT32)aVal.getBYTE();
	if( aVal.getReflection() == UINT16_getReflection())
		nRet = (INT32)aVal.getUINT16();
	if( aVal.getReflection() == INT16_getReflection())
		nRet = (INT32)aVal.getINT16();
	if( aVal.getReflection() == UINT32_getReflection())
		nRet = (INT32)aVal.getUINT32();
	if( aVal.getReflection() == INT32_getReflection())
		nRet = aVal.getINT32();
	return nRet;
}


void PropertyDialog::AddProperty(const String& rName, UsrAny aVal, Property* pProp)
{
	USHORT n = 0;

	while(n <= MAX_BOXES && aBoxes[n])
		n++;
	if(n<MAX_BOXES)
	{

		UsrAny aTempAny;
		if(aVal.getReflection()->getName() == aTempAny.getReflection()->getName())
		{
			pProp->Type->createObject(aTempAny);
			aVal = aTempAny;
		}

		const String& rReflName = U2S(aVal.getReflection()->getName());
		if(aVal.getReflection() == BOOL_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_CHECKBOX, this, aVal);
			((CheckBox*)aBoxes[n]->GetWin())->Check(aVal.getBOOL());
			((CheckBox*)aBoxes[n]->GetWin())->SaveValue();
		}
		else if( aVal.getReflection() == BYTE_getReflection()||
				 aVal.getReflection() == UINT16_getReflection()||
				 aVal.getReflection() == INT16_getReflection()||
				 aVal.getReflection() == UINT32_getReflection()||
				 aVal.getReflection() == INT32_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_NUMERIC, this, aVal);
			aBoxes[n]->SetValue(lcl_getInt32(aVal));
		}
		else if(rReflName ==
						U2S(ShadowFormat_getReflection()->getName()))
		{
			ShadowFormat* pShadow = (ShadowFormat*)aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_NUMERIC, this, aVal);
			aBoxes[n]->SetValue((long)pShadow->Location);
		}
		else if(rReflName == U2S(LeftRightMargin_getReflection()->getName()) ||
					rReflName == U2S(TopBottomMargin_getReflection()->getName()))
		{
			TopBottomMargin* pTB = (TopBottomMargin*)aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_DBL_NUMERIC, this, aVal);
			aBoxes[n]->SetValue(pTB->Top, pTB->Bottom);
		}
		else if(aVal.getReflection()->getName() ==
			LineSpacingFormat_getReflection()->getName())
		{
			LineSpacingFormat* pFormat = (LineSpacingFormat*)aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_DBL_NUMERIC, this, aVal);
			aBoxes[n]->SetValue(pFormat->LineSpacingType, pFormat->LineHeight);

		}
		else if(aVal.getReflection()->getName() ==
				Sequence<TabStop>::getReflection()->getName())
		{
			Sequence<TabStop>* pSeq = (Sequence<TabStop>*) aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_DD_LISTBOX, this, aVal);
			TabStop* pArray = pSeq->getArray();
			for( USHORT i = 0; i < pSeq->getLen(); i++  )
			{
				String sEntry(pArray[i].Position);
				sEntry += ' ';
				sEntry += String((USHORT)pArray[i].Alignment);
				sEntry += ' ';
				sEntry += pArray[i].DecimalChar;
				sEntry += ' ';
				sEntry += pArray[i].FillChar;
				aBoxes[n]->AppendValue(sEntry);
			}

		}
		else if(aVal.getReflection()->getName() ==
				XTextColumns_getReflection()->getName())
		{
			XTextColumnsRef xCols = *(XTextColumnsRef*)aVal.get();
			if(xCols.is())
			{
				Sequence<TextColumn> aSeq = xCols->getColumns();

				aBoxes[n] = new AnyAndBox(BOXTYPE_DD_LISTBOX, this, aVal);
				const TextColumn* pArray = aSeq.getConstArray();
				for( USHORT i = 0; i < aSeq.getLen(); i++  )
				{
					String sEntry(pArray[i].Width);
					sEntry += ' ';
					sEntry += pArray[i].LeftMargin;
					sEntry += ' ';
					sEntry += pArray[i].RightMargin;
					aBoxes[n]->AppendValue(sEntry);
				}
			}
			else
				aBoxes[n] = new AnyAndBox(BOXTYPE_FIXEDTEXT, this, aVal);
		}
		else if(aVal.getReflection() == Float_getReflection()||
			aVal.getReflection() == Double_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_FLOAT, this, aVal);
			aBoxes[n]->SetValue(TypeConversion::toDouble(aVal));

		}
		else if(aVal.getReflection() == OUString_getReflection())
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_STRING, this, aVal);
			String sVal(U2S(aVal.getString()));
			aBoxes[n]->SetText(rName, &sVal);
		}
		else if(rReflName == U2S(SectionFileLink_getReflection()->getName()))
		{
			SectionFileLink* pLink = (SectionFileLink*)aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_SECT_LINK, this, aVal);
			String sUrl = U2S(pLink->FileURL);
			aBoxes[n]->SetText(rName, &sUrl);

		}
		else if(aVal.getReflection()->getTypeClass() == TYPECLASS_ENUM)
		{
			enum AnyEnum
			{
				VALUE_1,
				VALUE_2
			};
			AnyEnum* pAnyEnum = (AnyEnum*)aVal.get();
			aBoxes[n] = new AnyAndBox(BOXTYPE_NUMERIC, this, aVal);
			aBoxes[n]->SetValue((INT32)*pAnyEnum);

		}
		else if(aVal.getReflection()->getName() == XNumberingRules_getReflection()->getName())
		{
			nNumberingPosition = n;
			aBoxes[n] = new AnyAndBox(BOXTYPE_BUTTON, this, aVal);
			aBoxes[n]->SetLink(LINK(this, PropertyDialog, NumberingHdl));
		}
		else
		{
			aBoxes[n] = new AnyAndBox(BOXTYPE_FIXEDTEXT, this, aVal);
		}
		aBoxes[n]->SetPosSizePixel(Point(nXPos + 5,nYPos), Size(200, 20));
		aBoxes[n]->SetText(rName);
		nYPos += 20;
		long nHeight = GetSizePixel().Height();
		if(nYPos + 100 > nHeight)
		{
			nYPos = 5;
			nXPos += 200;
		}

	}
}

/*-----------------07.03.98 15:22-------------------

--------------------------------------------------*/
IMPL_LINK(PropertyDialog, OkHdl, PushButton*, EMPTYARG)
{
	USHORT n = 0;
	while(aBoxes[n])
	{
		if(aBoxes[n]->HasValueChanged())
		{

			xPropSet->setPropertyValue(S2U(aBoxes[n]->GetPropName()),
			aBoxes[n]->GetAny());

		}
		n++;
	}
	EndDialog(RET_OK);
	return TRUE;
}
/* -----------------25.05.98 11:49-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(PropertyDialog, NumberingHdl, PushButton*, pBtn)
{

	NumberingDialog aNumDlg(pBtn, aBoxes[nNumberingPosition]->GetAny());
	aNumDlg.Execute();
	return 0;
}

/*-----------------26.02.98 12:17-------------------

--------------------------------------------------*/

FieldViewDlg::FieldViewDlg(Window* pParent, XFieldTypes* pFieldTypes) :
	ModalDialog(pParent, WB_STDMODAL),
	aOk(this),
	aFieldTypeIdsLB(this, WB_BORDER),
	aFieldTypesLB(this, WB_BORDER),
	aFieldsLB(this, WB_BORDER),
	xTypes(pFieldTypes)
{
	SetSizePixel(Size(400,300));
	aOk.SetPosSizePixel(Point(345, 5), Size(50, 20));
	aOk.Show();
	aFieldTypeIdsLB.SetPosSizePixel(Point(5, 5), Size(100, 150));
	aFieldTypeIdsLB.SetSelectHdl(LINK(this, FieldViewDlg, FieldIdHdl));
	aFieldTypeIdsLB.Show();
	aFieldTypesLB.SetPosSizePixel(Point(110, 5), Size(190, 150));
	aFieldTypesLB.SetSelectHdl(LINK(this, FieldViewDlg, FieldTypeHdl ));
	aFieldTypesLB.Show();
	aFieldsLB.SetPosSizePixel(Point(5, 160), Size(295, 135));
	aFieldsLB.SetDoubleClickHdl(LINK(this, FieldViewDlg, FieldHdl));
	aFieldsLB.Show();

	//aFieldsLB.Clear();
	//XFieldTypesRef xFldT = xDoc->getFieldTypes();
	Sequence<UINT16> aSeq = xTypes->getFieldTypeIds();
	USHORT* pArray = aSeq.getArray();
	for( UINT32 i = 0; i < aSeq.getLen(); i++)
	{
		aFieldTypeIdsLB.InsertEntry(pArray[i]);
	}
/*
	Sequence<UString> aSSeq = xTypes->getFieldTypeNames(FIELDTYPE_USER);
	XTextFieldTypeRef xField = xTypes->getFieldType(FIELDTYPE_DATE);
	UString* pArray = aSSeq.getArray();
	for( INT32 i = 0; i < aSSeq.getLen(); i++)
	{
		String aRep(pArray[i]);
		aRep += " : ";
		XNamedFieldTypeRef xNField = xTypes->getNamedFieldType(
											FIELDTYPE_USER, pArray[i]);
		String sTName = xNField->getTypeName();
		XTextFieldsRef xFields = (XTextFields*)
					xNField->queryInterface(XTextFields::getSmartUik());
		INT32 nCount = xFields->getCount();
		for(INT32 j  = 0; j < nCount; j++)
		{
			XInterfaceRef xInt = xFields->getElementByIndex(j);
			XInterface* pInt = xInt;
			if(pInt)
			{
				aRep += ((XTextField*)pInt)->getPresentation(TRUE);
				aRep += " - ";
			}
		}
		aFieldsLB.InsertEntry(aRep);
	}
 */
};

/*-----------------26.02.98 13:48-------------------

--------------------------------------------------*/
IMPL_LINK(FieldViewDlg, FieldIdHdl, ListBox*, pBox)
{
	USHORT nId = pBox->GetSelectEntry();
	aFieldTypesLB.Clear();
	if(nId == FIELDTYPE_DATABASE||
			nId== FIELDTYPE_USER||
			nId== FIELDTYPE_DDE||
			nId== FIELDTYPE_SET_REFERENCE||
				nId == FIELDTYPE_SET_EXP||
				FIELDTYPE_DATABASE_NAME == nId)
	{
		// NamedFieldType
		Sequence<UString> aSSeq = xTypes->getFieldTypeNames(nId);
		UString* pArray = aSSeq.getArray();

		for( UINT32 i = 0; i < aSSeq.getLen(); i++)
		{
			String aRep(U2S(pArray[i]));
			aFieldTypesLB.InsertEntry(U2S(pArray[i]));
		}
	}
	else
	{
		XTextFieldTypeRef xField = xTypes->getFieldType(nId);
		aFieldTypesLB.InsertEntry("NoName");
	}
	return 0;
}
/*-----------------26.02.98 13:48-------------------

--------------------------------------------------*/
IMPL_LINK(FieldViewDlg, FieldTypeHdl, ListBox*, pBox)
{
	USHORT nId = aFieldTypeIdsLB.GetSelectEntry();
	//aFieldsLB.Clear();
	XTextFieldsRef xFields;
	if(nId == FIELDTYPE_DATABASE||
			nId== FIELDTYPE_USER||
			nId== FIELDTYPE_DDE||
			nId== FIELDTYPE_SET_REFERENCE||
				nId == FIELDTYPE_SET_EXP||
				FIELDTYPE_DATABASE_NAME == nId)
	{
		// NamedFieldType
		XNamedFieldTypeRef xNField = xTypes->getNamedFieldType(
											nId, S2U(pBox->GetSelectEntry()));
		XPropertySetRef xPrSet = (XPropertySet*)xNField->queryInterface(XPropertySet::getSmartUik());
		if(xPrSet.is())
		{
			PropertyDialog aDlg(pBox, xPrSet);
			aDlg.Execute();
		}

		xFields = (XTextFields*)
					xNField->queryInterface(XTextFields::getSmartUik());

	}
	else
	{
		XTextFieldTypeRef xField = xTypes->getFieldType(nId);
		xFields = (XTextFields*)
					xField->queryInterface(XTextFields::getSmartUik());
	}

	USHORT nFieldCount = aFieldsLB.GetEntryCount();
	for(UINT32 j  = 0; j < nFieldCount; j++)
	{
		XInterfaceRef* pInt = (XInterfaceRef*)aFieldsLB.GetEntryData((UINT16)j);
		delete pInt;
	}
	aFieldsLB.Clear();
	UINT32 nCount = xFields->getCount();
	for(j = 0; j < nCount; j++)
	{
		XInterfaceRef xInt = xFields->getElementByIndex(j);
		XInterface* pInt = xInt;
		if(pInt)
		{
			aFieldsLB.InsertEntry(U2S(((XTextField*)pInt)->getPresentation(TRUE)));
			XInterfaceRef* pInt = new XInterfaceRef(xInt);
			aFieldsLB.SetEntryData((USHORT)j, pInt);
		}
	}
	return 0;
}
/*-----------------04.03.98 13:03-------------------

--------------------------------------------------*/
IMPL_LINK(FieldViewDlg, FieldHdl, ListBox*, pBox)
{
	USHORT nId = pBox->GetSelectEntryPos();
	if(nId != 0xffff)
	{
		XInterfaceRef* pInt = (XInterfaceRef*)aFieldsLB.GetEntryData(nId);
		XPropertySetRef xProp = (XPropertySet*)(*pInt)->queryInterface(XPropertySet::getSmartUik());
		PropertyDialog* pDlg = new PropertyDialog(pBox, xProp);
/*		XPropertySetInfoRef xInfo = xProp->getPropertySetInfo();
		PropertySequence aSeq = xInfo->getProperties();
		const Property* pProp = aSeq.getConstArray();

		for(USHORT i = 0; i < aSeq.getLen(); i++ )
		{
			UsrAny aAny = xProp->getPropertyValue(pProp->Name);
			pDlg->AddProperty(pProp->Name, aAny);
			pProp++;
			//xProp->setPropertyValue(pProp->Name, aAny);
		}*/

		pDlg->Execute();
		delete pDlg;
	}
	return 0;
}
/*
 *
 * */
NumberingDialog::NumberingDialog(Window* pParent, UsrAny& rAny)	:
	ModalDialog(pParent, WB_STDMODAL),
	rVal(rAny),
	aOk(this),
	aNumTypeFT(this),
	aNumTypeED(this),
	aPrefixFT(this) ,
	aPrefixED(this) ,
	aSuffixFT(this) ,
	aSuffixED(this)
{
	SetSizePixel(Size(500, 500));
	SetText("Numbering Dialog");
	aOk.		SetPosSizePixel(Point(400,20), Size(40,20));
	aOk.SetClickHdl(LINK(this, NumberingDialog, OkHdl));
	aNumTypeFT.	SetPosSizePixel(Point(20, 10), Size(60,20));
	aNumTypeED.	SetPosSizePixel(Point(100, 10), Size(40,20));
	aPrefixFT.	SetPosSizePixel(Point(20, 40), Size(60,20));
	aPrefixED.	SetPosSizePixel(Point(100, 40), Size(40,20));
	aSuffixFT.	SetPosSizePixel(Point(20,70), Size(60,20));
	aSuffixED.	SetPosSizePixel(Point(100, 70), Size(40,20));

	aNumTypeFT.	SetText("NumType");
	aPrefixFT.	SetText("Prefix");
	aSuffixFT.  SetText("Suffix");
	aOk.Show();

	aNumTypeFT.	Show();
	aNumTypeED.	Show();
	aPrefixFT.	Show();
	aPrefixED.	Show();
	aSuffixFT.	Show();
	aSuffixED.	Show();

	aNumTypeED.	SaveValue();
	aPrefixED.	SaveValue();
	aSuffixED.	SaveValue();


	XNumberingRulesRef xRule = *(XNumberingRulesRef*)rAny.get();
	if(xRule.is())
	{
		XNumberingRules* pRules = xRule;
		NumberingRule aRule = pRules->getLevelByIndex(0);
		aNumTypeED.SetText(		aRule.Level.NumberingType);
		aPrefixED.	 SetText(U2S(aRule.Level.Prefix));
		aSuffixED.	 SetText(U2S(aRule.Level.Suffix));
	}
	else
		SetText("Die Numerierung ist nicht gesetzt");



}
IMPL_LINK(NumberingDialog, OkHdl, PushButton*, pBtn)
{
	XNumberingRulesRef xRule = *(XNumberingRulesRef*)rVal.get();
	if(xRule.is())
	{
		XNumberingRules* pRules = xRule;
		NumberingRule aRule = pRules->getLevelByIndex(0);
		if(aNumTypeED.GetText() != aNumTypeED.GetSavedValue())
		{
			aRule.Level.NumberingType = aNumTypeED.GetText();
		}
		if(aPrefixED. GetText() != aPrefixED. GetSavedValue())
		{
			aRule.Level.Prefix = S2U(aPrefixED.GetText());
		}
		if(aSuffixED.GetText() != aSuffixED.GetSavedValue())
		{
			aRule.Level.Suffix = S2U(aSuffixED.GetText());
		}

		pRules->setLevelByIndex(0, aRule);
	}
	EndDialog(RET_OK);
	return TRUE;
}

/* -----------------26.05.98 15:19-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(MyWindow, InsertFrameHdl, PushButton*, pButton)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return 0;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}


	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			XTextDocumentRef xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
			{
/* -----------------25.06.98 10:39-------------------
 * 	kleiner Einschub fuer Feld-Absturz-Test
 * --------------------------------------------------*/
				XFieldTypesRef xFields = xDoc->getFieldTypes();
				XNamedFieldTypeRef xNFld =  xFields->getNamedFieldType(0,L"Test");
				if(xNFld.is())
				{
					XPropertySetRef xPrSet = (XPropertySet*)xNFld->queryInterface(XPropertySet::getSmartUik());
					UsrAny aVal;
					aVal.setString(L"Testinhalt");
					xPrSet->setPropertyValue(L"Content", aVal);
					xFields->update();
				}



				XTextFramesRef xFrms = xDoc->getTextFrames();
				XTextFrameDescriptorRef xFrDesc = xFrms->createTextFrame(Size(200,300));
				UsrAny aVal;
					UINT16 nAnchType = 1;
					aVal.setUINT16(nAnchType);
					xFrDesc->setPropertyValue(L"AnchorType", aVal);
					XTextRef xTxt = (XText*)xDoc->queryInterface(XText::getSmartUik());
					XTextCursorRef xCrsr = xTxt->createTextCursor();
					XTextPositionRef xTxtPos = (XTextPosition*)xCrsr->queryInterface(XTextPosition::getSmartUik());
					aVal.set(&xTxtPos, XTextPosition_getReflection());
				xFrms->addFrame(xFrDesc);


			}
		}
	}
	return 0;
}

/* -----------------17.09.98 08:59-------------------
 *
 * --------------------------------------------------*/
IMPL_LINK(MyWindow, IndexHdl, PushButton*, pButton)
{
	XTextDocumentRef xDoc;
	if(!GetModel(xDoc) || !xDoc.is())
		return 0;
	XDocumentIndexesRef xIdxs = xDoc->getIndexes();
	int nCount = xIdxs->getIndexTypeCount();
	for(int i = 0; i < nCount; i++)
	{
		XDocumentIndexTypeRef xIType = xIdxs->getIndexTypeByIndex(i);
		if(xIType->getDocumentIndexCount())
		{
			XDocumentIndexRef xIdx = xIType->getDocumentIndexByIndex(0);
			XPropertySetRef xPrSet = (XPropertySet*)xIdx->queryInterface(XPropertySet::getSmartUik());
			PropertyDialog aDlg(pButton, xPrSet);
			aDlg.Execute();
		}
	}


	return 0;
}
/*
sub index_properties
doc = activedocument.uno
'msgbox doc.dbg_properties
docindexes = doc.indexes
'msgbox indexes.dbg_properties
for i = 0 to docindexes.indextypecount -1
	indextype = docindexes(i)
'	msgbox indextype.dbg_properties
'	print indextype.indexkind
	index = indextype.getdocumentindexbyindex(0)
'	print index.title
	msgbox index.dbg_properties
	if indextype.indexkind = 0 then
		'Stichwort
		FormatLevel1 = index.FormatLevel1
		FormatLevel2 = index.FormatLevel2
		FormatLevel3 = index.FormatLevel3
		FormatSeparator = index.FormatSeparator
		ParaStyleSeparator = index.ParaStyleSeparator
		ParaStyleLevel1 = index.ParaStyleLevel1
		ParaStyleLevel2 = index.ParaStyleLevel2
		ParaStyleLevel3 = index.ParaStyleLevel3

	elseif indextype.indexkind = 1 then
		'Inhalt
		FormatLevel1 = index.FormatLevel1
		FormatLevel2 = index.FormatLevel2
		FormatLevel3 = index.FormatLevel3
		FormatLevel10 = index.FormatLevel10
		ParaStyleLevel1 = index.ParaStyleLevel1
		ParaStyleLevel2 = index.ParaStyleLevel2
		ParaStyleLevel3 = index.ParaStyleLevel3
		ParaStyleLevel10 = index.ParaStyleLevel10
	else
		'Benutzerverzeichnis
		FormatLevel1 = index.FormatLevel1
		FormatLevel2 = index.FormatLevel2
		FormatLevel5 = index.FormatLevel5
		ParaStyleLevel1 = index.ParaStyleLevel1
		ParaStyleLevel2 = index.ParaStyleLevel2
		ParaStyleLevel5 = index.ParaStyleLevel5
	endif
next i

end sub
*/
/* -----------------17.09.98 08:59-------------------
 *
 * --------------------------------------------------*/
BOOL MyWindow::GetModel(XTextDocumentRef& xDoc)
{
	if(!xDesktopRef)
	{
		XServiceManagerRef xProv = getGlobalServiceManager();
		DBG_ASSERT( xProv, "Kein ServiceProvider!" );
		XServiceRegistryRef xReg = (XServiceRegistry*)xProv->queryInterface(XServiceRegistry::getSmartUik());
		//XServiceRegistryRef xReg = XServiceRegistryRef::queryInterface( xProv );
		if ( !xReg )
			return FALSE;
		Sequence<UsrUik> aIfaces( 1 );
		aIfaces.getArray()[0] = XDesktop::getSmartUik();
		XServiceProviderRef xSSI = xProv->getServiceProvider( S2U("stardiv.one.frame.Desktop"), aIfaces, Sequence<UsrUik>() );
		xDesktopRef = (XDesktop*) xSSI->newInstance()->queryInterface( XDesktop::getSmartUik() );

		aIfaces.getArray()[0] = XModule::getSmartUik();
		XServiceProviderRef xSSI2 = xProv->getServiceProvider( S2U("stardiv.one.text.StarWriter"), aIfaces, Sequence<UsrUik>() );
		if(xSSI2.is())
			XModuleRef xModule = (XModule*) xSSI2->newInstance()->queryInterface( XModule::getSmartUik() );

	}
	XComponentEnumerationAccessRef xComponents = xDesktopRef->getComponents();
	XIndexAccessRef xIdx = (XIndexAccess*)xComponents->queryInterface(XIndexAccess::getSmartUik());
	USHORT nCount = xIdx->getCount();
	for (  USHORT i = 0; i < nCount; i++ )
	{
		//XModelRef aRef = xModelCollRef->getItemByIndex( i );
		XComponentRef aRef = (XComponent*)xIdx->getElementByIndex(i)->queryInterface(XComponent::getSmartUik());
		if ( aRef )
		{
//            UString aName = aRef->getClassName();
			xDoc = (XTextDocument*)aRef->queryInterface(XTextDocument::getSmartUik());
			if(xDoc.is())
				break;
		}
	}


	return TRUE;
}
