/*************************************************************************
 *
 *  $RCSfile: folder.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FOLDER_HXX
#define _FOLDER_HXX

#ifndef _VOS_THREAD_HXX_
#include <vos/thread.hxx>
#endif

#ifndef _FASTFSYS_HXX
#include <fastfsys.hxx>
#endif

#ifndef _ITEMPATH_HXX
#include <itempath.hxx>
#endif

#include <wpclient.hxx>


/***************************************************************************************
 *
 * IfcContextMenuImpl - declaration of non virtual interface
 *
 ***************************************************************************************
 */

class IfcContextMenuImpl : public IfcContextMenu
{
	HOBJECT m_hObject;

public:
	IfcContextMenuImpl(String& rObject);

	virtual UINT32 GetItemCount() { return 2; };

	virtual BOOL GetMenuItem(UINT32 nIndex, MenuItem& rItem);
	virtual IfcContextMenu *GetSubMenu(UINT32 nIndex) { return NULL; };

	virtual BOOL ExecuteCommand(String aCommand);
};

/***************************************************************************************
 *
 * IfcShortcut - Implementation
 *
 ***************************************************************************************
 */

class IfcShortcutImpl : public IfcShortcut
{
    UINT32 m_nCurrentGroup;
    PVOID  m_pData;

    ItemIDPath m_aParent;
    ItemIDPath m_aIDPath;

public:
    IfcShortcutImpl(const String& crLanguage, const ItemIDPath& crFolder);
    ~IfcShortcutImpl();

	virtual UINT32 GetValueNameCount() const;
	virtual const String& GetValueName(UINT32 nIndex) const;

	virtual const String& GetValueContent(const String& crValueName) const;
	virtual void SetValueContent(const String& crValueName, const String& crValueContent);

	virtual FSysError Load(const ItemIDPath& crIDPath);
	virtual FSysError Store(const String& crTitle, ItemIDPath& crNewIDPath,
                             ShortcutFormat ePreferred = SHORTCUT_FORMAT_BESTFIT);
};

/***************************************************************************************
 *
 * FolderImpl - base class declaration
 *
 ***************************************************************************************
 */

class FolderImpl : public NAMESPACE_VOS(OThread)
{
	ItemIDPath m_aPath;

protected:
	Link m_aLink;
	BOOL m_bValidLink;

	FolderImpl(const ItemIDPath& rPath) : m_aPath(rPath) { m_bValidLink = FALSE; };

	inline String Location();

public:
	inline ItemIDPath GetItemIDPath() const { return m_aPath; };

	inline void setLink(const Link& rLink)	{ m_aLink = rLink; m_bValidLink = TRUE; };
	inline Link getLink() { return m_aLink; };

	inline static String extractPath(const ItemIDPath&);
//	  static String GetItemPath(const ItemIDPath rPath);

	virtual BOOL isValid() const = NULL;
	virtual BOOL isThreadable() const	{ return TRUE; };
	virtual BOOL isCaseSensitiv() const { return FALSE; };

	virtual BOOL   GetNextItem(ItemIDPathData&) = NULL;
	virtual BOOL   RestartEnum(const FindFlags) = NULL;
	virtual UINT32 BuildCRC	  (const FindFlags, BOOL) = NULL;

	virtual BOOL RenameItem(const ItemIDPath&, ItemIDPath&, const String&) { return FALSE; };
	virtual BOOL DeleteItem(const ItemIDPath&) { return FALSE; };

	virtual BOOL GetItemIDInfo	 (const ItemIDPath&, FastItemInfo&) = NULL;
	virtual BOOL GetFileInfo	 (const ItemIDPath&, FastFileInfo&)	 { return FALSE; };
	virtual BOOL GetNameSpaceInfo(const ItemIDPath&, NameSpaceInfo&) { return FALSE; };
	virtual BOOL GetLinkFileInfo (const ItemIDPath&, LinkFileInfo& ) { return FALSE; };

	virtual IfcContextMenu* GetContextMenu(const ItemIDPath&) { return NULL; };
};

inline String FolderImpl::Location()
{
    String aLocation = m_aPath.GetHostNotationPath();

    USHORT nLen = aLocation.Len();

    if(nLen && aLocation.GetChar(nLen - 1) != '\\')
        aLocation += '\\';

	return aLocation;
}

inline String FolderImpl::extractPath(const ItemIDPath& rPath)
{
	ItemIDPathData *pIDData = (ItemIDPathData *) rPath.GetDataPtr();

	if(pIDData)
		return pIDData->sPath;

	return String();
}

/***************************************************************************************
 *
 * InValidFolderImpl - this class for invalid items
 *
 ***************************************************************************************
 */

class InvalidFolderImpl : public FolderImpl
{
public:
	InvalidFolderImpl(const ItemIDPath& rPath) : FolderImpl(rPath) {};

	virtual void run() {};

	virtual BOOL isValid() const { return FALSE; };

	virtual BOOL GetNextItem(ItemIDPathData&) { return FALSE; };
	virtual BOOL RestartEnum(const FindFlags) { return FALSE; };
	virtual UINT32 BuildCRC	  (const FindFlags, BOOL) { return 0; };

	virtual BOOL GetItemIDInfo(const ItemIDPath&, FastItemInfo&) { return FALSE; };
};

/***************************************************************************************
 *
 * DrivesFolderImpl - class to enumerate drives
 *
 ***************************************************************************************
 */


class DrivesCacheImpl;

class DrivesFolderImpl : public FolderImpl
{
	static DrivesCacheImpl *m_pCache;
	static void EnsureCache();
	static void DestroyCache();

	BYTE   m_nCurrentDrive;

public:
	DrivesFolderImpl(const ItemIDPath&);

	virtual void run();

	virtual BOOL isValid() const { return TRUE; };

	virtual BOOL   GetNextItem(ItemIDPathData&);
	virtual BOOL   RestartEnum(const FindFlags);
	virtual UINT32 BuildCRC	  (const FindFlags, BOOL);

	virtual BOOL GetItemIDInfo(const ItemIDPath&, FastItemInfo&);

	static BOOL GetVolumeInfo(const String&, VolumeInfo&);
	static BOOL GetVolumeKind(const String&, VolumeKind&);
	static BOOL GetFileSystemName(const String&, String&);
};


/***************************************************************************************
 *
 * DosFolderImpl - filesystem folder class
 *
 ***************************************************************************************
 */

class DosFolderImpl : public FolderImpl
{
	HDIR	m_hDir;
	ULONG	m_nFlags;
	String	m_aSearchMask;

	BOOL	m_bIsRemovable;
	BOOL	m_bIsRemote;
	BOOL	m_bIsLongNameFS;
	BOOL	m_bIsCaseSensitiv;

	ULONG	OS2FindFlags(const FindFlags);

public:
	DosFolderImpl(const ItemIDPath&, const FindFlags);

	static void getFileInfo(const FILESTATUS3 *, FastFileInfo&);

	virtual BOOL isValid() const;
	virtual BOOL isThreadable() const;
	virtual BOOL isCaseSensitiv() const;

	virtual void run();

	virtual BOOL   GetNextItem(ItemIDPathData&);
	virtual BOOL   RestartEnum(const FindFlags);
	virtual UINT32 BuildCRC	  (const FindFlags, BOOL);

	virtual BOOL RenameItem(const ItemIDPath&, ItemIDPath&, const String&);
	virtual BOOL DeleteItem(const ItemIDPath&);

	virtual BOOL GetItemIDInfo(const ItemIDPath&, FastItemInfo&);
	virtual BOOL GetFileInfo  (const ItemIDPath&, FastFileInfo&);
};

/***************************************************************************************
 *
 * WinFolderImpl - retrieves data from wps client
 *
 ***************************************************************************************
 */

class aTmpClass;

class WinFolderImpl : public FolderImpl
{
	static const ULONG	nValidFlags;
	static WPSBaseImpl *m_pBase;

	aTmpClass *m_aThread;

	ULONG  m_nFlags;

	String m_aLocation;
	String m_aActual;

	static void EnsureBase();
	static void DestroyBase();

	String extractObject  (const ItemIDPath&);
	String extractLocation(const ItemIDPath&);

public:
	WinFolderImpl(const ItemIDPath&, const FindFlags);
	~WinFolderImpl();

	static Boolean isAvailable();
	static Boolean queryHandle(PSZ, HOBJECT *);

    static String queryLocation(PSZ);
    static String HandleToString(LHANDLE);

	static String queryTitle(PSZ);
	static BOOL	  queryLinkInfo(PSZ pszObject, PVOID pBuffer, ULONG ulSize);
	static BOOL	  queryObjectInfo(PSZ pszObject, PVOID pBuffer, ULONG ulSize);

    static String GetValidObject(const String&);
    static BOOL   isVirtual(const String&);

	virtual BOOL isValid() const;

	virtual void run();

	virtual BOOL   GetNextItem(ItemIDPathData&);
	virtual BOOL   RestartEnum(const FindFlags);
	virtual UINT32 BuildCRC	  (const FindFlags, BOOL);

	virtual BOOL GetItemIDInfo	  (const ItemIDPath&, FastItemInfo&);
	virtual BOOL GetNameSpaceInfo (const ItemIDPath&, NameSpaceInfo&);
	virtual BOOL GetLinkFileInfo  (const ItemIDPath&, LinkFileInfo&);
	virtual BOOL GetFileInfo	  (const ItemIDPath&, FastFileInfo&);

	virtual BOOL RenameItem(const ItemIDPath&, ItemIDPath&, const String&);
	virtual BOOL DeleteItem(const ItemIDPath&);

	virtual IfcContextMenu* GetContextMenu(const ItemIDPath&);
};


/***************************************************************************************
 *
 * ProgFolderImpl - folder with all pragrams on wps desktop
 *
 ***************************************************************************************
 */

class ProgFolderImpl : public WinFolderImpl
{
public:
	ProgFolderImpl(const ItemIDPath& rPath, const FindFlags aFlags) : WinFolderImpl(rPath, aFlags) {};

	virtual BOOL GetNextItem(ItemIDPathData&);
};

/***************************************************************************************
 *
 * WorkplaceImpl - wps replacement of DrivesFolderImpl
 *
 ***************************************************************************************
 */

class WorkplaceImpl : public DrivesFolderImpl
{
	BYTE m_nCurrent;

public:
	WorkplaceImpl(const ItemIDPath&, const FindFlags);

	virtual BOOL   GetNextItem(ItemIDPathData&);
	virtual BOOL   RestartEnum(const FindFlags);

	virtual BOOL   GetItemIDInfo(const ItemIDPath&, FastItemInfo&);
	virtual BOOL GetNameSpaceInfo (const ItemIDPath&, NameSpaceInfo&);
};

#endif /* _FOLDER_HXX */





