/*************************************************************************
 *
 *  $RCSfile: ffmenu.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:03:11 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <prewin.h>
#include "shutil.h"
#include <postwin.h>

#include "ctxmenu.hxx"

//**************************************************************************
//	ImplSendToMenu
//**************************************************************************

ImplSendToMenu::ImplSendToMenu( LPSHELLFOLDER pShellFolder, LPDATAOBJECT pDataObject ) :
m_pDataObject( pDataObject ),
m_pSendToFolder( pShellFolder ),
m_nItems( 0 )
{
	if ( m_pDataObject )
		m_pDataObject->AddRef();

	LPENUMIDLIST	pEnumIDList = NULL;

	if ( m_pSendToFolder )
		m_pSendToFolder->AddRef();

	if ( m_pSendToFolder && SUCCEEDED(m_pSendToFolder->EnumObjects( NULL, SHCONTF_NONFOLDERS | SHCONTF_FOLDERS | SHCONTF_INCLUDEHIDDEN, &pEnumIDList)) )
	{
		DWORD	dwFetched = 0;

		while ( S_OK == pEnumIDList->Next( 1, &m_pItems[m_nItems], &dwFetched ) )
		{
			m_nItems++;
		}

		pEnumIDList->Release();
	}
}

ImplSendToMenu::~ImplSendToMenu()
{
	for ( USHORT n = 0; n < m_nItems; WIN_SHFree( m_pItems[n++] ) );

	if ( m_pDataObject )
		m_pDataObject->Release();

	if ( m_pSendToFolder )
		m_pSendToFolder->Release();
}

UINT32 ImplSendToMenu::GetItemCount()
{
	return m_nItems;
}

BOOL ImplSendToMenu::GetMenuItem( UINT32 nIndex, MenuItem & rItem )
{
	BOOL	bSuccess = FALSE;

	if ( nIndex < m_nItems && m_pItems && m_pSendToFolder )
	{
		DWORD	dwAttributes = SFGAO_FOLDER;

		if ( SUCCEEDED(m_pSendToFolder->GetAttributesOf( 1, (LPCITEMIDLIST *)&m_pItems[nIndex], &dwAttributes )) )
		{
			STRRET	strret;

			if ( SUCCEEDED(m_pSendToFolder->GetDisplayNameOf( m_pItems[nIndex], SHGDN_NORMAL, &strret)) )
			{
				CHAR	szDisplayName[MAX_PATH];

				WIN_SHStrRetToMultiByte( m_pItems[nIndex], &strret, szDisplayName, MAX_PATH );

				rItem.aDisplayText = szDisplayName;
				rItem.aVerb = "";
				rItem.aHelpText = "";

				if ( dwAttributes & SFGAO_FOLDER )
				{
					rItem.aItemFlags = 0;
					rItem.aCommand = "";
					rItem.aItemKind = MENU_ITEM_KIND_SUBMENU;
				}
				else
				{
					LPDROPTARGET	pDropTarget = NULL;

					if ( SUCCEEDED(m_pSendToFolder->GetUIObjectOf( NULL, 1, (LPCITEMIDLIST *)&m_pItems[nIndex], IID_IDropTarget, NULL, (LPVOID *)&pDropTarget )) )
					{
						rItem.aItemFlags = 0;
						pDropTarget->Release();
					}
					else
						rItem.aItemFlags = MENU_ITEM_FLAG_DISABLED;
					rItem.aCommand = "sendto:";
					rItem.aCommand += nIndex;
					rItem.aItemKind = MENU_ITEM_KIND_COMMAND;
				}
			}

			bSuccess = TRUE;
		}
	}

	return bSuccess;
}


IfcContextMenu *ImplSendToMenu::GetSubMenu( UINT32 nIndex )
{
	if ( nIndex < m_nItems && m_pItems && m_pSendToFolder )
	{
		DWORD	dwAttributes = SFGAO_DROPTARGET | SFGAO_FOLDER;

		if ( SUCCEEDED(m_pSendToFolder->GetAttributesOf( 1, (LPCITEMIDLIST *)&m_pItems[nIndex], &dwAttributes )) )
		{
			LPSHELLFOLDER	pFolder = NULL;

			if ( (dwAttributes & SFGAO_FOLDER) && SUCCEEDED( m_pSendToFolder->BindToObject(m_pItems[nIndex], NULL, IID_IShellFolder, (LPVOID *)&pFolder)) )
			{
				IfcContextMenu	*pCtxMenu = new ImplSendToMenu( pFolder, m_pDataObject );
				pFolder->Release();
				return pCtxMenu;
			}
		}
	}

	return NULL;
}

BOOL ImplSendToMenu::ExecuteCommand( String aCommand )
{
	BOOL			bSuccess = FALSE;
	IDropTarget		*pDropTarget = NULL;

	if ( COMPARE_EQUAL == aCommand.Compare( "sendto:", 7 ) )
	{
		UINT32	nIndex = aCommand.Erase( 0, 7 );

		if ( nIndex < m_nItems && m_pSendToFolder && m_pDataObject )
		{
			if ( SUCCEEDED(m_pSendToFolder->GetUIObjectOf( NULL, 1, (LPCITEMIDLIST *)&m_pItems[nIndex], IID_IDropTarget, NULL, (LPVOID *)&pDropTarget )) )
			{
				DWORD	dwEffect = DROPEFFECT_LINK | DROPEFFECT_MOVE | DROPEFFECT_COPY;
				DWORD	dwKeyState = 0;
				POINTL	pt = {0, 0};

				bSuccess = SUCCEEDED(pDropTarget->DragEnter( m_pDataObject, MK_LBUTTON | dwKeyState, pt, &dwEffect ));
				bSuccess = SUCCEEDED(pDropTarget->Drop( m_pDataObject, dwKeyState, pt, &dwEffect ));
				pDropTarget->Release();
			}
		}
	}

	return bSuccess;
}


//**************************************************************************
//	ImplContextMenu
//**************************************************************************

//--------------------------------------------------------------------------
// ImplContextMenu::ctor
//--------------------------------------------------------------------------

ImplContextMenu::ImplContextMenu( LPCONTEXTMENU pMenu, LPDATAOBJECT pDataObject, HMENU hMenu ) :
	m_pUIContextMenu(pMenu),
	m_pDataObject(pDataObject),
	m_hMenu(NULL),
	m_fValid(FALSE)
{
	if ( m_pUIContextMenu )
	{
		m_pUIContextMenu->AddRef();

		if ( hMenu == NULL )
		{
			m_hMenu = CreatePopupMenu();

			if ( m_hMenu )
			{
				HRESULT	hResult = m_pUIContextMenu->QueryContextMenu( m_hMenu, 0, 0, 0x1000, CMF_CANRENAME | CMF_NORMAL | CMF_INCLUDESTATIC );
				m_fValid = SUCCEEDED(hResult);
			}
		}
		else
		{
			m_hMenu = hMenu;
			m_fValid = TRUE;
		}
	}

	if ( m_pDataObject )
		m_pDataObject->AddRef();
}

//--------------------------------------------------------------------------
// ImplContextMenu::dtor
//--------------------------------------------------------------------------

ImplContextMenu::~ImplContextMenu()
{
	if ( m_hMenu )
		DestroyMenu( m_hMenu );

	if ( m_pUIContextMenu )
		m_pUIContextMenu->Release();

	if ( m_pDataObject )
		m_pDataObject->Release();
}

//--------------------------------------------------------------------------
// ImplContextMenu::GetItemCount
//--------------------------------------------------------------------------

UINT32 ImplContextMenu::GetItemCount()
{
	int	iCount = 0;

	if ( m_hMenu && m_fValid )
		iCount = GetMenuItemCount( m_hMenu );

	return iCount > 0 ? (UINT32)iCount : 0;
}

//--------------------------------------------------------------------------
// ImplContextMenu::GetMenuItem
//--------------------------------------------------------------------------


BOOL ImplContextMenu::GetMenuItem( UINT32 nIndex, MenuItem & rItem )
{
	BOOL	fSuccess = FALSE;

	if ( m_fValid && m_hMenu && m_pUIContextMenu )
	{
		UINT32	nCount = GetItemCount();

		if ( nIndex < nCount )
		{
			MENUITEMINFO	info;
			TCHAR			szBuffer[256] = "";

			info.cbSize = sizeof(info);
			info.fMask = MIIM_ID | MIIM_STATE | MIIM_TYPE | MIIM_SUBMENU;
			info.dwTypeData = szBuffer;
			info.wID = 0;
			info.fType = 0;
			info.fState = 0;
			info.hSubMenu = NULL;
			info.cch = sizeof(szBuffer) / sizeof(TCHAR);

			if ( GetMenuItemInfo( m_hMenu, nIndex, TRUE, &info ) )
			{
				fSuccess = TRUE;
				
				// Anzuzeigenden Text und Typ bestimmen

				// Ownerdraw knnen wir mit VCL nicht anzeigen
				if ( info.fType & MFT_OWNERDRAW )
					return FALSE;

				// Bitmaps ebenfalls nicht
				if ( info.fType & MFT_BITMAP )
					return FALSE;

				if ( info.fType & MFT_SEPARATOR )
				{
					rItem.aItemKind = MENU_ITEM_KIND_SEPARATOR;
					rItem.aVerb = "";
					rItem.aCommand = "";
					rItem.aHelpText = "";
				}
				else
				{
					// Kommandostring-ID setzen
					rItem.aCommand = info.wID;

					// Shortcuts abschneiden
					char *pTab = strchr( szBuffer, '\x09' );
					if ( pTab )
						*pTab = '\0';

					// Titel setzen
					rItem.aDisplayText = szBuffer;

					// Hilfetext und Verb bestimmen

					if ( info.hSubMenu == NULL )
					{
						if ( NOERROR == m_pUIContextMenu->GetCommandString( info.wID, GCS_HELPTEXT, NULL, szBuffer, sizeof(szBuffer) ) )
							rItem.aHelpText = szBuffer;
						else
							rItem.aHelpText = "";
						if ( NOERROR == m_pUIContextMenu->GetCommandString( info.wID, GCS_VERB, NULL, szBuffer, sizeof(szBuffer) ) )
							rItem.aVerb = szBuffer;
						else switch ( info.wID & 0xFF )
						{
						case 0x10:	// link
							rItem.aVerb = "link";
							break;
						case 0x11:	// delete
							rItem.aVerb = "delete";
							break;
						case 0x12:	// rename
							rItem.aVerb = "rename";
							break;
						case 0x13:	// properties
							rItem.aVerb = "properties";
							break;
						case 0x18:	// cut
							rItem.aVerb = "cut";
							break;
						case 0x19:	// copy
							rItem.aVerb = "copy";
							break;
						case 0x1a:	// paste
							rItem.aVerb = "paste";
							break;
						}

						// Filtern 

						/*
						if ( rItem.aVerb == "open" )
							fSuccess = FALSE;
						*/

						if ( rItem.aVerb == "find" )
							fSuccess = FALSE;
						if ( rItem.aVerb == "explore" )
							fSuccess = FALSE;
						if ( rItem.aVerb == "link" )
							fSuccess = FALSE;

						// Copy, Paste & Co uebernimmt jetzt der SFX

						if ( rItem.aVerb == "cut" )
							fSuccess = FALSE;
						if ( rItem.aVerb == "copy" )
							fSuccess = FALSE;
						if ( rItem.aVerb == "paste" )
							fSuccess = FALSE;

						// Rename und Delete werden vom Chaos gesetzt

						if ( rItem.aVerb == "rename" )
							fSuccess = FALSE;
						if ( rItem.aVerb == "delete" )
							fSuccess = FALSE;

						// Workaround, da wir mit einem per DDE gestarteten Drucken nicht klarkommen

						if ( rItem.aVerb == "print" )
							fSuccess = FALSE;

					}
					else
					{
						rItem.aHelpText = "";
						rItem.aVerb = "";
					}

					// Flags des Menueintrages setzen

					rItem.aItemFlags = 0;

					if ( info.fState & MFS_DEFAULT )
						rItem.aItemFlags |= MENU_ITEM_FLAG_DEFAULT;
					if ( info.fType &  MFT_RADIOCHECK )
						rItem.aItemFlags |= MENU_ITEM_FLAG_RADIOCHECKED;
					if ( info.fState & MFS_CHECKED )
						rItem.aItemFlags |= MENU_ITEM_FLAG_CHECKED;

					if ( (info.fState & MFS_DISABLED) || (info.fState & MFS_GRAYED) )
						rItem.aItemFlags |= MENU_ITEM_FLAG_DISABLED;


					// Submenu

					if ( info.hSubMenu )
						rItem.aItemKind = MENU_ITEM_KIND_SUBMENU;
					else
						rItem.aItemKind = MENU_ITEM_KIND_COMMAND;

				}


			}

		}
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
// ImplContextMenu::GetSubMenu
//--------------------------------------------------------------------------

IfcContextMenu *ImplContextMenu::GetSubMenu( UINT32 nIndex )
{
	if ( m_fValid && m_hMenu && m_pUIContextMenu )
	{
		MENUITEMINFO	mii;
		TCHAR			szBuffer[256];

		mii.cbSize = sizeof(mii);
		mii.fMask = MIIM_SUBMENU | MIIM_ID | MIIM_TYPE;
		mii.dwTypeData = szBuffer;
		mii.fType = 0;
		mii.wID = 0;
		mii.hSubMenu = NULL;
		mii.cch = sizeof(szBuffer) / sizeof(TCHAR);

		if ( GetMenuItemInfo( m_hMenu, nIndex, TRUE, &mii ) && mii.hSubMenu )
		{
			if ( (mii.wID & 0x3F) == 0x1B ) // sendto
			{
				LPSHELLFOLDER	pSendToFolder = NULL;

				WIN_SHGetSpecialFolder( CSIDL_SENDTO, &pSendToFolder );


				if ( pSendToFolder )
				{
					IfcContextMenu *pCtxMenu = new ImplSendToMenu( pSendToFolder, m_pDataObject );
					pSendToFolder->Release();
					return pCtxMenu;
				}
			}
			else
				return new ImplContextMenu( m_pUIContextMenu, m_pDataObject, mii.hSubMenu );
		}
	}

	return NULL;
}

//--------------------------------------------------------------------------
// ImplContextMenu::ExecuteCommand
//--------------------------------------------------------------------------

BOOL ImplContextMenu::ExecuteCommand( String aCommand )
{
	BOOL	fSuccess = FALSE;

	if ( m_fValid && m_pUIContextMenu )
	{

		CMINVOKECOMMANDINFO	ici;

		UINT	nCommand = aCommand;

		ici.lpVerb = MAKEINTRESOURCE(nCommand);

		ici.cbSize = sizeof(ici);
		ici.fMask = CMIC_MASK_FLAG_NO_UI;
		ici.hwnd = GetFocus();
		ici.lpParameters = NULL;
		ici.lpDirectory = NULL;
		ici.nShow = SW_SHOWNORMAL;
		ici.dwHotKey = 0;
		ici.hIcon = NULL;

		fSuccess = SUCCEEDED( m_pUIContextMenu->InvokeCommand( &ici ) );

		// Auf den Rueckgabewert kann man sich nicht verlassen !!!

		fSuccess = TRUE;
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
// ImplInternetExplorer4Menu::ExecuteCommand
//--------------------------------------------------------------------------

BOOL ImplInternetExplorer4Menu::ExecuteCommand( String aCommand )
{
	BOOL	fSuccess = FALSE;

	if ( m_fValid && m_pUIContextMenu )
	{
		UINT	nCommand = aCommand;

		if ( nCommand == 0x1B /* Open_Default */ )
		{
			String	aURL;
			HKEY	hKey = NULL;

			if ( ERROR_SUCCESS == RegOpenKeyEx( HKEY_CURRENT_USER, "Software\\Microsoft\\Internet Explorer\\Main", 0, KEY_QUERY_VALUE, &hKey ) )
			{
				BYTE	aData[256] = { 0 };
				DWORD	dwDataSize = 256;

				if ( ERROR_SUCCESS == RegQueryValueEx( hKey, "Start Page", NULL, NULL, aData, &dwDataSize ) )
					aURL = (LPCSTR)aData;

				RegCloseKey( hKey );
			}

			if ( aURL.Len() )
				fSuccess = InvokeInternal( aURL );
		}

		if ( !fSuccess )
		{
			CMINVOKECOMMANDINFO	ici;

			ici.lpVerb = MAKEINTRESOURCE(nCommand);

			ici.cbSize = sizeof(ici);
			ici.fMask = CMIC_MASK_FLAG_NO_UI;
			ici.hwnd = GetFocus();
			ici.lpParameters = NULL;
			ici.lpDirectory = NULL;
			ici.nShow = SW_SHOWNORMAL;
			ici.dwHotKey = 0;
			ici.hIcon = NULL;

			fSuccess = SUCCEEDED( m_pUIContextMenu->InvokeCommand( &ici ) );
		}
		// Auf den Rueckgabewert kann man sich nicht verlassen !!!

		fSuccess = TRUE;
	}

	return fSuccess;
}

//--------------------------------------------------------------------------
// ImplInternetExplorer4Menu::InvokeInternal
//--------------------------------------------------------------------------

BOOL ImplInternetExplorer4Menu::InvokeInternal( const String & crURL )
{
	TCHAR	szAppPath[MAX_PATH];
	String	aParams = "private:iexplorer?";

	aParams += crURL;

	GetModuleFileName( NULL, szAppPath, MAX_PATH );

	return (BOOL)(32 < (UINT)ShellExecute( NULL, NULL, szAppPath, aParams.GetStr(), NULL, SW_SHOW ));
}

