/*************************************************************************
 *
 *  $RCSfile: ucbdistributor.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: sb $ $Date: 2001/07/16 09:48:38 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCB_MAIN_UCBDISTRIBUTOR_HXX_
#include "ucbdistributor.hxx"
#endif

#ifndef _COM_SUN_STAR_BRIDGE_BRIDGEEXISTSEXCEPTION_HPP_
#include <com/sun/star/bridge/BridgeExistsException.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGE_HPP_
#include <com/sun/star/bridge/XBridge.hpp>
#endif
#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGEFACTORY_HPP_
#include <com/sun/star/bridge/XBridgeFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_CONNECTIONSETUPEXCEPTION_HPP_
#include <com/sun/star/connection/ConnectionSetupException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_NOCONNECTEXCEPTION_HPP_
#include <com/sun/star/connection/NoConnectException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTOR_HPP_
#include <com/sun/star/connection/XConnector.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_ILLEGALARGUMENTEXCEPTION_HPP_
#include <com/sun/star/lang/IllegalArgumentException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XEVENTLISTENER_HPP_
#include <com/sun/star/lang/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERACCEPTOR_HPP_
#include <com/sun/star/ucb/XRemoteContentProviderAcceptor.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include <com/sun/star/uno/Exception.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include <com/sun/star/uno/RuntimeException.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XINTERFACE_HPP_
#include <com/sun/star/uno/XInterface.hpp>
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _CPPUHELPER_TYPEPROVIDER_HXX_ 
#include <cppuhelper/typeprovider.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_ 
#include <cppuhelper/weak.hxx>
#endif
#ifndef _OSL_CONDITN_HXX_
#include <osl/conditn.hxx>
#endif
#ifndef _THREAD_HXX_
#include <osl/thread.hxx>
#endif
#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _VOS_DIAGNOSE_H_ 
#include <vos/diagnose.hxx>
#endif

#ifndef INCLUDED_ALGORITHM
#include <algorithm>
#define INCLUDED_ALGORITHM
#endif
#ifndef INCLUDED_CSTDDEF
#include <cstddef>
#define INCLUDED_CSTDDEF
#endif
#ifndef INCLUDED_NEW
#include <new>
#define INCLUDED_NEW
#endif

namespace unnamed_ucb_main_ucbdistributor {}
using namespace unnamed_ucb_main_ucbdistributor;
	// unnamed namespaces don't work well yet...

using namespace com::sun::star;
using namespace ucb_main;

//============================================================================
//
//  Implementation Helpers
//
//============================================================================

namespace unnamed_ucb_main_ucbdistributor {

inline rtl::OUString getDistributorImplementationName()
{
	return rtl::OUString::createFromAscii("ucb_main::UcbDistributor");
}

inline uno::Sequence< rtl::OUString > getDistributorSupportedServiceNames()
{
	uno::Sequence< rtl::OUString > aNames(1);
	aNames[0] = rtl::OUString::createFromAscii(
		            "com.sun.star.ucb.RemoteContentProviderDistributor");
	return aNames;
}

uno::Reference< uno::XInterface > xDistributorInstance;

uno::Reference< uno::XInterface > SAL_CALL
getDistributorInstance(uno::Reference< lang::XMultiServiceFactory > const &)
{
	return xDistributorInstance;
}

}

//============================================================================
//
//  FlagGuard
//
//============================================================================

namespace unnamed_ucb_main_ucbdistributor {

class FlagGuard
{
public:
	inline FlagGuard(bool * pTheFlag);

	inline ~FlagGuard() throw () { *m_pFlag = false; }

private:
	bool * m_pFlag;
};

inline FlagGuard::FlagGuard(bool * pTheFlag):
	m_pFlag(pTheFlag)
{
	VOS_ENSURE(m_pFlag && !*m_pFlag,
			   "ucb/main/ucbdistributor:FlagGuard::FlagGuard():"
			       " Bad argument");
	*m_pFlag = true;
}

}

//============================================================================
//
//  InstanceProvider
//
//============================================================================

namespace unnamed_ucb_main_ucbdistributor {

class InstanceProvider:
    public cppu::WeakImplHelper1< bridge::XInstanceProvider >
{
public:
    virtual uno::Reference< uno::XInterface > SAL_CALL
    getInstance(rtl::OUString const & rInstanceName)
        throw (container::NoSuchElementException, uno::RuntimeException);
};

}

uno::Reference< uno::XInterface > SAL_CALL
InstanceProvider::getInstance(rtl::OUString const & rInstanceName)
	throw (container::NoSuchElementException, uno::RuntimeException)
{
    // The com.sun.star.ucb.RemoteContentProviderDistributionBridgeIdentifier
    // interface is used by the other end of a bridge connection to find out
    // whether the connection will only be used to distribute remote content
    // providers; the interface actually returned is not important, only the
    // fact that an interface *is* returned is important:
	if (rInstanceName.
            equalsAsciiL(
                RTL_CONSTASCII_STRINGPARAM(
       "com.sun.star.ucb.RemoteContentProviderDistributionBridgeIdentifier")))
		return new cppu::OWeakObject;
	else
		return 0; //TODO! NoSuchElementException?
}

//============================================================================
//
//  resolve
//
//============================================================================

namespace unnamed_ucb_main_ucbdistributor {

// This function is like the com::sun::star::bridge::XUnoUrlResolver
// implementation in unourl_resolver::ResolverImpl::resolve, except that it
// accepts an additional com::sun::star::lang::XEventListener:
uno::Reference< uno::XInterface >
resolve(uno::Reference< lang::XMultiServiceFactory > const & rServiceFactory,
		rtl::OUString const & rUrl,
		uno::Reference< lang::XEventListener > const & rListener,
		uno::Reference< bridge::XBridge > * pBridge)
	throw (connection::NoConnectException,
		   connection::ConnectionSetupException,
		   uno::RuntimeException)
{
	VOS_ENSURE(rServiceFactory.is() && pBridge,
			   "ucb/main/ucbdistributor:resolve(): Bad arguments");

	sal_Int32 nDelim1;
	sal_Int32 nDelim2;
	if (rUrl.getLength() < RTL_CONSTASCII_LENGTH("uno:")
		|| rUrl[0] != 'U' && rUrl[0] != 'u'
		|| rUrl[1] != 'N' && rUrl[1] != 'n'
		|| rUrl[2] != 'O' && rUrl[2] != 'o'
		|| rUrl[3] != ':'
			//@@@ efficient, case less prefix compare to ASCII missing...
		|| (nDelim1 = rUrl.indexOf(';', RTL_CONSTASCII_LENGTH("uno:"))) == -1
		|| (nDelim2 = rUrl.indexOf(';', nDelim1 + 1)) == -1)
		throw connection::ConnectionSetupException(
			      rtl::OUString::createFromAscii(
					  "ucb/main/ucbdistributor:resolve(): Bad URL"),
				  0);
	rtl::OUString
		aUrlConnection(rUrl.copy(RTL_CONSTASCII_LENGTH("uno:"),
								 nDelim1 - RTL_CONSTASCII_LENGTH("uno:")));
	rtl::OUString
		aUrlProtocol(rUrl.copy(nDelim1 + 1, nDelim2 - (nDelim1 + 1)));
	rtl::OUString aUrlInstance(rUrl.copy(nDelim2 + 1));

	uno::Reference< connection::XConnector > xConnector;
	uno::Reference< bridge::XBridgeFactory > xBridgeFactory;
	try
	{
		xConnector
			= uno::Reference< connection::XConnector >(
				  rServiceFactory->
				      createInstance(
						  rtl::OUString::createFromAscii(
							  "com.sun.star.connection.Connector")),
				  uno::UNO_QUERY);
		xBridgeFactory
			= uno::Reference< bridge::XBridgeFactory >(
				  rServiceFactory->
				      createInstance(
						  rtl::OUString::createFromAscii(
							  "com.sun.star.bridge.BridgeFactory")),
				  uno::UNO_QUERY);
	}
	catch (uno::RuntimeException const &) { throw; }
	catch (uno::Exception const &) {}
	if (!xConnector.is() || !xBridgeFactory.is())
		throw uno::RuntimeException(
			      rtl::OUString::createFromAscii(
					  "ucb/main/ucbdistributor:resolve(): Missing service"),
				  0);

	try
	{
		*pBridge = xBridgeFactory->createBridge(rtl::OUString(),
												aUrlProtocol,
												xConnector->
												    connect(aUrlConnection),
												new InstanceProvider);
	}
	catch (bridge::BridgeExistsException const &) {}
	catch (lang::IllegalArgumentException const &) {}
	if (!pBridge->is())
		return 0;

	uno::Reference< lang::XComponent > xComponent(*pBridge, uno::UNO_QUERY);
	if (xComponent.is())
		xComponent->addEventListener(rListener);

	return (*pBridge)->getInstance(aUrlInstance);
}

}

//============================================================================
//
//  UcbDistributor
//
//============================================================================

// Bad HACK to keep the connection to the remote content provider acceptor
// alive, even if there is some proxy along the line that closes connections
// that are idle for some amount of time, by producing UNO traffic every
// 30 seconds.
// Since all manipulations of KeepAliveThread ref count are done when
// m_aMapMutex is locked, acquire() and release() do not need to take care of
// thread safety issues.
class UcbDistributor::KeepAliveThread: private osl::Thread
{
public:
    inline
    KeepAliveThread(
        uno::Reference< ucb::XRemoteContentProviderAcceptor > const &
            rAcceptor):
    m_xAcceptor(rAcceptor), m_nRefCount(0) { create(); }

    ~KeepAliveThread() SAL_THROW(());

    inline void acquire() SAL_THROW(()) { ++m_nRefCount; }

    inline void release() SAL_THROW(());

    static inline void * operator new(std::size_t nSize)
        SAL_THROW((std::bad_alloc))
    { return ::operator new(nSize); }
        // osl::Thread declares class-local operator new()

    static inline void operator delete(void * pPtr) SAL_THROW(())
    { ::operator delete(pPtr); }
        // osl::Thread declares class-local operator delete()

private:
    osl::Condition m_aTerminate;
    uno::Reference< ucb::XRemoteContentProviderAcceptor > m_xAcceptor;
    sal_uInt32 m_nRefCount;

    virtual void SAL_CALL run();
};

inline void UcbDistributor::KeepAliveThread::release() SAL_THROW(())
{
    if (--m_nRefCount == 0)
        delete this;
}

void SAL_CALL UcbDistributor::KeepAliveThread::run()
{
    static TimeValue const aWait = { 30, 0 };
    while (m_aTerminate.wait(&aWait) == osl::Condition::result_timeout)
               //TODO! report result_error conditions?
        try
        {
            uno::Reference< connection::XConnector >(m_xAcceptor,
                                                     uno::UNO_QUERY);
                // Bad HACK:  Each call to queryInterface() on an interface
                // not implemented by m_xAcceptor causes traffic on the UNO
                // bridge...
        }
        catch (uno::RuntimeException const &)
        {}
}

UcbDistributor::KeepAliveThread::~KeepAliveThread() SAL_THROW(())
{
    m_aTerminate.set();
    join(); //TODO! ok to create/join from potentially different threads?
}

//============================================================================
UcbDistributor::Data::Data(
	uno::Reference< bridge::XBridge > const & rTheBridge,
	uno::Reference< ucb::XRemoteContentProviderAcceptor > const &
	    rTheAcceptor,
	rtl::OUString const & rTheIdentifier):
	m_xBridge(rTheBridge),
	m_xAcceptor(rTheAcceptor),
	m_aIdentifier(rTheIdentifier),
    m_xThread(new KeepAliveThread(rTheAcceptor))
{}

//============================================================================
UcbDistributor::Data::~Data()
{}

//============================================================================
bool UcbDistributor::doConnect(rtl::OUString const & rUrl,
							   rtl::OUString const & rIdentifier)
	throw (connection::NoConnectException,
		   connection::ConnectionSetupException,
		   lang::IllegalArgumentException,
		   uno::RuntimeException)
{
	FlagGuard aFlagGuard(&m_bConnecting);
	vos::OGuard aMutexGuard(m_aMapMutex);

	HashMap::iterator aIt(m_aMap.find(rUrl));
	if (aIt != m_aMap.end())
		return false;

	// The soffice program resolves a url
	// "uno:<connection>;<protocol>;com.sun.star.ucb.RemoteContentProvider-
	// Acceptor" to the requested XRemoteContentProviderAcceptor, but the ucb
	// program resolves a url "uno:<connection>;<protocol>;UCB.Factory" to an
	// XMultiServiceFactory, at which to query for a second
	// XMultiServiceFactory, at which to query for the requested
	// XRemoteContentProviderAcceptor.
	uno::Reference< uno::XInterface > xInterface;
	uno::Reference< bridge::XBridge > xBridge;
	if (m_xFactory.is())
		xInterface = resolve(m_xFactory, rUrl, this, &xBridge);

	uno::Reference< ucb::XRemoteContentProviderAcceptor > xAcceptor;
	if (xInterface.is())
		if (rUrl.getLength()
			    >= RTL_CONSTASCII_LENGTH(
					   ";com.sun.star.ucb.RemoteContentProviderAcceptor")
			&& rUrl.
			       copy(rUrl.getLength()
						    - RTL_CONSTASCII_LENGTH(
						  ";com.sun.star.ucb.RemoteContentProviderAcceptor")).
			           equalsAsciiL(
						   RTL_CONSTASCII_STRINGPARAM(
						  ";com.sun.star.ucb.RemoteContentProviderAcceptor")))
			xAcceptor = uno::Reference< ucb::XRemoteContentProviderAcceptor >(
				            xInterface, uno::UNO_QUERY);
		else if (rUrl.getLength() >= RTL_CONSTASCII_LENGTH(";UCB.Factory")
				 && rUrl.copy(rUrl.getLength()
							      - RTL_CONSTASCII_LENGTH(";UCB.Factory")).
				             equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(
								              ";UCB.Factory")))
		{
			uno::Reference< lang::XMultiServiceFactory >
				xRemoteFactory(xInterface, uno::UNO_QUERY);
			if (xRemoteFactory.is())
				try
				{
					xRemoteFactory
						= uno::Reference< lang::XMultiServiceFactory >(
							  xRemoteFactory->
							      createInstance(
									  rtl::OUString(
										  RTL_CONSTASCII_USTRINGPARAM(
										"com.sun.star.lang.ServiceManager"))),
							  uno::UNO_QUERY);
				}
				catch (uno::Exception const &)
				{
					xRemoteFactory = 0;
				}
			if (xRemoteFactory.is())
				try
				{
					xAcceptor
						= uno::Reference<
						          ucb::XRemoteContentProviderAcceptor >(
							  xRemoteFactory->
							      createInstance(
									  rtl::OUString(
										  RTL_CONSTASCII_USTRINGPARAM(
						  "com.sun.star.ucb.RemoteContentProviderAcceptor"))),
							  uno::UNO_QUERY);
				}
				catch (uno::Exception const &) {}
		}
		else
			VOS_ENSURE(false, "Cannot process uno URL");

	if (!(xAcceptor.is()
		  && xAcceptor->
		         addRemoteContentProvider(rIdentifier,
										  m_xFactory,
										  uno::Sequence< rtl::OUString >(),
										  this)))
		return false;

	m_aMap.insert(HashMap::value_type(rUrl,
									  Data(xBridge, xAcceptor, rIdentifier)));
	return true;
}

//============================================================================
void UcbDistributor::finishDelayed() throw ()
{
	BridgeList aTheDisposed;
    ControlList aTheControls;
	{
		vos::OGuard aGuard(m_aDelayedMutex);
		aTheDisposed = m_aDisposed;
		m_aDisposed.clear();
        aTheControls = m_aControls;
        m_aControls.clear();
	}

	bool bEmpty;
	{
		vos::OGuard aGuard(m_aMapMutex);

        BridgeList::const_iterator aListBegin(aTheDisposed.begin());
        BridgeList::const_iterator aListEnd(aTheDisposed.end());
        HashMap::iterator aMapEnd(m_aMap.end());
        HashMap Pruned;
        for (HashMap::const_iterator aIt(m_aMap.begin()); aIt != aMapEnd;
             ++aIt)
        {
            Data const & rData = aIt->second;
            if (std::find(aListBegin, aListEnd, rData.m_xBridge) == aListEnd)
                Pruned.insert(*aIt);
        }
        m_aMap = Pruned;
        bEmpty = m_aMap.empty();

        for (ControlList::iterator aListIt(aTheControls.begin());
             aListIt != aTheControls.end(); ++aListIt)
            for (HashMap::iterator aIt(m_aMap.begin()); aIt != m_aMap.end();
                 ++aIt)
            {
                Data & rData = aIt->second;
                if (rData.m_xAcceptor == aListIt->m_xAcceptor)
                {
                    OSL_ENSURE(!rData.m_xConnectionControlToken.is(),
                               "connection control token already set");
                    rData.m_xConnectionControlToken = aListIt->m_xToken;
                    break;
                }
            }
	}

	if (bEmpty)
	{
		eventOccured();
		idle(true);
	}
}

//============================================================================
bool UcbDistributor::checkTryStop(State eNewState) throw ()
{
	for (;;)
	{
		vos::OClearableGuard aGuard(m_aStateMutex);
		if (m_eState == STATE_TRY_STOP)
		{
			aGuard.clear();
			m_aDoStop.wait();
			m_aDoStop.reset();
			if (m_eState == STATE_STOPPED)
				return false;
		}
		else
		{
			m_eState = eNewState;
			return true;
		}
	}
}

//============================================================================
UcbDistributor::UcbDistributor(
	uno::Reference< lang::XMultiServiceFactory > const & rTheFactory,
	MachineControl * pControl):
	Machine(pControl),
	m_xFactory(rTheFactory),
	m_eState(STATE_IDLE),
	m_bConnecting(false)
{
	VOS_ASSERT(m_xFactory.is());
	idle(true);
}

//============================================================================
// virtual
UcbDistributor::~UcbDistributor()
{}

//============================================================================
// virtual
uno::Any SAL_CALL UcbDistributor::queryInterface(uno::Type const & rType)
	throw (uno::RuntimeException)
{
	uno::Any
		aRet(cppu::queryInterface(
			     rType,
				 static_cast< lang::XServiceInfo * >(this),
				 static_cast< lang::XTypeProvider * >(this),
				 static_cast< ucb::XRemoteContentProviderDistributor * >(
					 this),
				 static_cast< ucb::XRemoteContentProviderDoneListener * >(
					 this),
				 static_cast<
                         ucb::XRemoteContentProviderConnectionControl * >(
					 this),
				 static_cast< lang::XEventListener * >(this)));
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface(rType);
}

//============================================================================
// virtual
void SAL_CALL UcbDistributor::acquire() throw ()
{
	OWeakObject::acquire();
}

//============================================================================
// virtual
void SAL_CALL UcbDistributor::release() throw ()
{
	OWeakObject::release();
}

//============================================================================
// virtual
rtl::OUString SAL_CALL UcbDistributor::getImplementationName()
	throw (uno::RuntimeException)
{
	return getDistributorImplementationName();
}

//============================================================================
// virtual
sal_Bool SAL_CALL
UcbDistributor::supportsService(rtl::OUString const & rServiceName)
	throw (uno::RuntimeException)
{
	uno::Sequence< rtl::OUString >
		aNames(getDistributorSupportedServiceNames());
	for (sal_Int32 i = 0; i < aNames.getLength(); ++i)
		if (aNames[i] == rServiceName)
			return true;
	return false;
}

//============================================================================
// virtual
uno::Sequence< rtl::OUString > SAL_CALL
UcbDistributor::getSupportedServiceNames()
	throw (uno::RuntimeException)
{
	return getDistributorSupportedServiceNames();
}

//============================================================================
// virtual
uno::Sequence< uno::Type > SAL_CALL UcbDistributor::getTypes()
	throw (uno::RuntimeException)
{
	static cppu::OTypeCollection * pCollection = 0;
	if (!pCollection)
	{
		osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
		if (!pCollection)
		{
			static cppu::OTypeCollection
				aTheCollection(
					getCppuType(
						static_cast< uno::Reference< lang::XServiceInfo >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference< lang::XTypeProvider >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						              ucb::XRemoteContentProviderDistributor >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						             ucb::XRemoteContentProviderDoneListener >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference<
						        ucb::XRemoteContentProviderConnectionControl >
						                 const * >(
							0)),
					getCppuType(
						static_cast< uno::Reference< lang::XEventListener >
						                 const * >(
							0)));
			pCollection = &aTheCollection;
		}
	}
	return pCollection->getTypes();
}

//============================================================================
// virtual
uno::Sequence< sal_Int8 > SAL_CALL UcbDistributor::getImplementationId()
	throw (uno::RuntimeException)
{
	static cppu::OImplementationId * pID = 0;
	if (!pID)
	{
		osl::MutexGuard aGuard(osl::Mutex::getGlobalMutex());
		if (!pID)
		{
			static cppu::OImplementationId aTheID(false);
			pID = &aTheID;
		}
	}
	return pID->getImplementationId();
}

//============================================================================
// virtual
sal_Bool SAL_CALL
UcbDistributor::connectToRemoteAcceptor(rtl::OUString const & rUrl,
										rtl::OUString const & rIdentifier)
	throw (connection::NoConnectException,
		   connection::ConnectionSetupException,
		   lang::IllegalArgumentException,
		   uno::RuntimeException)
{
	if (!checkTryStop(STATE_CONNECTING))
		return false;
	bool bSuccess = false;
	try
	{
		bSuccess = doConnect(rUrl, rIdentifier);
	}
	catch (connection::NoConnectException const &)
	{
		checkTryStop(STATE_IDLE);
		finishDelayed();
		throw;
	}
	catch (connection::ConnectionSetupException const &)
	{
		checkTryStop(STATE_IDLE);
		finishDelayed();
		throw;
	}
	catch (lang::IllegalArgumentException const &)
	{
		checkTryStop(STATE_IDLE);
		finishDelayed();
		throw;
	}
	catch (uno::RuntimeException const &)
	{
		checkTryStop(STATE_IDLE);
		finishDelayed();
		throw;
	}
	if (bSuccess)
		busy();
	checkTryStop(STATE_IDLE);
	finishDelayed();
	return bSuccess;
}

//============================================================================
// virtual
sal_Bool SAL_CALL
UcbDistributor::disconnectFromRemoteAcceptor(rtl::OUString const & rUrl)
	throw (uno::RuntimeException)
{
	vos::OGuard aGuard(m_aMapMutex);

	HashMap::iterator aIt(m_aMap.find(rUrl));
	if (aIt == m_aMap.end())
		return false;

	bool bSuccess = true;
	Data & rData = aIt->second;
    rData.m_xConnectionControlToken = 0;
        // release the token before calling removeRemoteContentProvider()
	if (rData.m_xAcceptor.is())
		try
		{
			bSuccess
				= rData.m_xAcceptor->
				          removeRemoteContentProvider(rData.m_aIdentifier)
				      != false;
		}
		catch (uno::RuntimeException const &) {}

	m_aMap.erase(aIt);

	if (m_aMap.empty())
	{
		eventOccured();
		idle(true);
	}

	return bSuccess;
}

//============================================================================
// virtual
void SAL_CALL UcbDistributor::disconnectFromAll()
	throw (uno::RuntimeException)
{
	vos::OGuard aGuard(m_aMapMutex);

	HashMap::iterator aEnd(m_aMap.end());
	for (HashMap::iterator aIt(m_aMap.begin()); aIt != aEnd; ++aIt)
	{
		Data & rData = aIt->second;
        rData.m_xConnectionControlToken = 0;
            // release the token before calling removeRemoteContentProvider()
		if (rData.m_xAcceptor.is())
			try
			{
				rData.m_xAcceptor->
					removeRemoteContentProvider(rData.m_aIdentifier);
			}
			catch (uno::RuntimeException const &) {}

	}
	m_aMap.clear();

	eventOccured();
	idle(true);
}

//============================================================================
// virtual
void SAL_CALL
UcbDistributor::doneWithRemoteContentProviders(
	uno::Reference< ucb::XRemoteContentProviderAcceptor > const & rAcceptor)
	throw (uno::RuntimeException)
{
	vos::OGuard aGuard(m_aMapMutex);

	HashMap::iterator aEnd(m_aMap.end());
	HashMap Pruned;
	for (HashMap::const_iterator aIt(m_aMap.begin()); aIt != aEnd; ++aIt)
	{
		Data const & rData = aIt->second;
		if (!rAcceptor.is() || rData.m_xAcceptor == rAcceptor)
		{
			if (rData.m_xAcceptor.is())
				try
				{
					rData.m_xAcceptor->
						removeRemoteContentProvider(rData.m_aIdentifier);
				}
				catch (uno::RuntimeException const &) {}
		}
		else
			Pruned.insert(*aIt);
	}
	m_aMap = Pruned;

	if (m_aMap.empty())
	{
		eventOccured();
		idle(true);
	}
}

//============================================================================
// virtual
void SAL_CALL
UcbDistributor::enableConnectionControl(
    uno::Reference< ucb::XRemoteContentProviderAcceptor > const & rAcceptor,
    uno::Reference< uno::XInterface > const & rToken)
    throw (uno::RuntimeException)
{
    {
        vos::OGuard aGuard(m_aDelayedMutex);
        m_aControls.push_back(Control(rAcceptor, rToken));
    }
    if (!m_bConnecting)
        finishDelayed();
}

//============================================================================
// virtual
void SAL_CALL UcbDistributor::disposing(lang::EventObject const & rSource)
	throw (uno::RuntimeException)
{
	uno::Reference< bridge::XBridge > xBridge(rSource.Source, uno::UNO_QUERY);
	if (xBridge.is())
	{
		{
			vos::OGuard aGuard(m_aDelayedMutex);
			m_aDisposed.push_back(xBridge);
		}
		if (!m_bConnecting)
			finishDelayed();
	}
}

//============================================================================
// virtual
void UcbDistributor::tryStop()
{
	vos::OGuard aGuard(m_aStateMutex);
	switch (m_eState)
	{
		case STATE_IDLE:
			m_eState = STATE_TRY_STOP;
			canStop(true);
			break;

		case STATE_CONNECTING:
			m_eState = STATE_TRY_STOP;
			break;

		default:
			VOS_ENSURE(false,
					   "ucb_main::UcbDistributor::tryStop(): Bad state");
			break;
	}
}

//============================================================================
// virtual
void UcbDistributor::doStop(bool bStop)
{
	vos::OGuard aGuard(m_aStateMutex);
	if (m_eState == STATE_TRY_STOP)
	{
		m_eState = bStop ? STATE_STOPPED : STATE_IDLE;
		m_aDoStop.set();
	}
	else
		VOS_ENSURE(false, "ucb_main::UcbDistributor::doStop(): Bad state");
}

//============================================================================
// static
bool
UcbDistributor::registerAtServiceFactory(
	uno::Reference< lang::XMultiServiceFactory > const & rServiceFactory,
	MachineControl * pControl)
{
	uno::Reference< container::XSet > xSet(rServiceFactory, uno::UNO_QUERY);
	if (!xSet.is())
		return false;

	// Create the single instance very early to have it registered at the
	// machine control before that goes active:
	xDistributorInstance
		= static_cast< uno::XWeak * >(static_cast< cppu::OWeakObject * >(
			                              new UcbDistributor(rServiceFactory,
															 pControl)));

	uno::Reference< lang::XSingleServiceFactory >
		xFactory(cppu::createOneInstanceFactory(
			         rServiceFactory,
					 getDistributorImplementationName(),
					 getDistributorInstance,
					 getDistributorSupportedServiceNames()));
	if (!xFactory.is())
		return false;

	xSet->insert(uno::makeAny(xFactory));
	return true;
}
