/*************************************************************************
 *
 *  $RCSfile: rapofflinestoragenode.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/12 11:13:59 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
#define INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX

#ifndef INCLUDED_UCB_RAPOFFLINESTORAGEERROR_HXX
#include "rapofflinestorageerror.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include "com/sun/star/uno/Sequence.hxx"
#endif
#ifndef _COM_SUN_STAR_UTIL_DATETIME_HPP_
#include "com/sun/star/util/DateTime.hpp"
#endif
#ifndef _OSL_INTERLOCK_H_
#include "osl/interlck.h"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif
#ifndef _SAL_TYPES_H_
#include "sal/types.h"
#endif
#ifndef _SALHELPER_SIMPLEREFERENCEOBJECT_HXX_
#include "salhelper/simplereferenceobject.hxx"
#endif
#ifndef _STORE_STORE_HXX_
#include "store/store.hxx"
#endif

#ifndef INCLUDED_MAP
#include <map>
#define INCLUDED_MAP
#endif
#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

namespace com { namespace sun { namespace star { namespace io {
    class XStream;
} } } }
namespace ucprmt { namespace offline {
    class StorageImpl;
    class StorageNode;
    class StorageNodeContainerIterator;
} }

namespace ucprmt { namespace offline {

class StorageNodeContainer: public salhelper::SimpleReferenceObject
{
public:
    StorageNodeContainer(rtl::Reference< StorageImpl > const & rImpl);

    rtl::Reference< StorageNode > find(rtl::OUString const & rId);

    rtl::Reference< StorageNode >
    create(
        com::sun::star::uno::Sequence< rtl::OUString > const & rChildren,
        rtl::OUString const & rParent,
        rtl::OUString const & rContentType,
        rtl::OUString const & rTitle,
        com::sun::star::util::DateTime const & rDateCreated,
        bool bFolder,
        bool bDocument,
        bool bReadOnly);

    bool insert(rtl::Reference< StorageNode > const & rElement,
                rtl::OUString const & rId,
                bool bLog);

    bool remove(rtl::OUString const & rId, bool bLog);

private:
    typedef std::map< rtl::OUString, StorageNode * > Map;

    Map m_aMap;
    osl::Mutex m_aMutex;
    rtl::Reference< StorageImpl > m_xImpl;

    virtual ~StorageNodeContainer() SAL_THROW(());

    void releaseElement(StorageNode * pElement) SAL_THROW(());

    friend class StorageNode; // to access Map, m_xImpl, releaseElement()
    friend class StorageNodeContainerIterator;
        // to access Map, m_aMap, m_aMutex
};

class StorageNodeContainerIterator
{
public:
    typedef StorageNodeContainer::Map::value_type value_type;

    StorageNodeContainerIterator(
        rtl::Reference< StorageNodeContainer > const & rContainer);

    ~StorageNodeContainerIterator() SAL_THROW(());

    bool empty() const;

    value_type * operator ->();

    StorageNodeContainerIterator & operator ++();

private:
    rtl::Reference< StorageNodeContainer > m_xContainer;
    osl::MutexGuard m_aGuard;
    StorageNodeContainer::Map::iterator m_aIt;

    StorageNodeContainerIterator(StorageNodeContainerIterator &);
        // not implemented
    void operator =(StorageNodeContainerIterator); // not implemented
};

class StorageNode
{
public:
    inline void acquire() SAL_THROW(())
    { osl_incrementInterlockedCount(&m_nRefCount); }

    void release() SAL_THROW(());

    com::sun::star::uno::Sequence< rtl::OUString > getCurrentChildren()
        SAL_THROW((StorageError));

    com::sun::star::uno::Sequence< rtl::OUString > getOriginalChildren()
        SAL_THROW((StorageError));

    rtl::OUString getOriginalUrl() SAL_THROW((StorageError));

    rtl::OUString getCurrentParent() SAL_THROW((StorageError));

    rtl::OUString getOriginalParent() SAL_THROW((StorageError));

    rtl::OUString getContentType() SAL_THROW((StorageError));

    rtl::OUString getCurrentTitle() SAL_THROW((StorageError));

    com::sun::star::util::DateTime getDateCreated() SAL_THROW((StorageError));

    com::sun::star::util::DateTime getDateModified()
        SAL_THROW((StorageError));

    bool getFolder() SAL_THROW((StorageError));

    bool getDocument() SAL_THROW((StorageError));

    bool getReadOnly() SAL_THROW((StorageError));

    com::sun::star::uno::Reference< com::sun::star::io::XStream > getStream()
        SAL_THROW((StorageError));

    inline bool isUninserted() const SAL_THROW(())
    { return m_eMode == MODE_UNINSERTED; } //TODO! thread safe?

    bool isInserted() SAL_THROW((StorageError));

    bool isModified() SAL_THROW((StorageError));

    bool isStreamModified() SAL_THROW((StorageError));

    bool isDeleted() SAL_THROW((StorageError));

    void addChild(rtl::OUString const & rChild) SAL_THROW((StorageError));

    void removeChild(rtl::OUString const & rChild) SAL_THROW((StorageError));

    void setTitle(rtl::OUString const & rTitle);

private:
    class StreamModificationListener;

    enum Mode
    {
        MODE_UNINSERTED,
        MODE_INITIAL,
        MODE_READ,
        MODE_REMOVED
    };

    enum State
    {
        STATE_UNCHANGED = 0,
        STATE_INSERTED = 1,
        STATE_CHILDREN_MODIFIED = 2,
        STATE_PARENT_MODIFIED = 4,
        STATE_TITLE_MODIFIED = 8,
        STATE_STREAM_MODIFIED = 16,
        STATE_DELETED = 32
    };

    rtl::Reference< StorageNodeContainer > m_xContainer;
    StorageNodeContainer::Map::iterator m_aContainerIt;
    oslInterlockedCount m_nRefCount;
    store::OStoreStream m_aStream;
    Mode m_eMode;
    osl::Mutex m_aMutex;
    com::sun::star::uno::Sequence< rtl::OUString > m_aCurrentChildren;
    com::sun::star::uno::Sequence< rtl::OUString > m_aOriginalChildren;
    rtl::OUString m_aOriginalUrl;
    rtl::OUString m_aCurrentParent;
    rtl::OUString m_aOriginalParent;
    rtl::OUString m_aContentType;
    rtl::OUString m_aCurrentTitle;
    rtl::OUString m_aOriginalTitle;
    com::sun::star::util::DateTime m_aDateCreated;
    com::sun::star::util::DateTime m_aDateModified;
    State m_eState;
    bool m_bFolder;
    bool m_bDocument;
    bool m_bReadOnly;

    inline
    StorageNode(rtl::Reference< StorageNodeContainer > const & rContainer,
                bool bUninserted);

    inline ~StorageNode() SAL_THROW(());

    void read() SAL_THROW((StorageError)); // not thread safe

    void write() SAL_THROW((StorageError)); // not thread safe

    void
    fill(com::sun::star::uno::Sequence< rtl::OUString > const & rChildren,
         rtl::OUString const & rParent,
         rtl::OUString const & rContentType,
         rtl::OUString const & rTitle,
         com::sun::star::util::DateTime const & rDateCreated,
         bool bFolder,
         bool bDocument,
         bool bReadOnly)
        SAL_THROW((StorageError));

    void setInserted(bool bLog) SAL_THROW((StorageError));

    void setDeleted(bool bLog) SAL_THROW((StorageError));

    void setStreamModified() SAL_THROW((StorageError));

    StorageNode(StorageNode &); // not implemented
    void operator =(StorageNode); // not implemented

    friend class StreamModificationListener; // to access setStreamModified()
#if defined WNT
    friend struct std::auto_ptr< StorageNode >; // to access ~StorageNode()
        // work around compiler bug...
#else // WNT
    friend class std::auto_ptr< StorageNode >; // to access ~StorageNode()
#endif // WNT
    friend class StorageNodeContainer;
        // to access m_aContainerIt, m_nRefCount, StorageNode(),
        // ~StorageNode(), fill(), setInserted(), setDeleted()
};

} }

#endif // INCLUDED_UCB_RAPOFFLINESTORAGENODE_HXX
