/*************************************************************************
 *
 *  $RCSfile: rmtcont.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/07 12:57:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCPRMT_RMTCONT_HXX_
#define _UCPRMT_RMTCONT_HXX_

#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGENOTIFIER_HPP_
#include <com/sun/star/beans/XPropertiesChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFOCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertySetInfoChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFOCHANGENOTIFIER_HPP_
#include <com/sun/star/beans/XPropertySetInfoChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCHILD_HPP_
#include <com/sun/star/container/XChild.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XUNOTUNNEL_HPP_
#include <com/sun/star/lang/XUnoTunnel.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFOCHANGELISTENER_HPP_
#include <com/sun/star/ucb/XCommandInfoChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDINFOCHANGENOTIFIER_HPP_
#include <com/sun/star/ucb/XCommandInfoChangeNotifier.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCOMMANDPROCESSOR_HPP_
#include <com/sun/star/ucb/XCommandProcessor.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENT_HPP_
#include <com/sun/star/ucb/XContent.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTCREATOR_HPP_
#include <com/sun/star/ucb/XContentCreator.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XCONTENTEVENTLISTENER_HPP_
#include <com/sun/star/ucb/XContentEventListener.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_ 
#include <cppuhelper/weak.hxx>
#endif
#ifndef _RTL_REF_HXX_ 
#include <rtl/ref.hxx>
#endif

#include <memory>
#include <queue>

namespace com { namespace sun { namespace star {
	namespace lang { class XMultiServiceFactory; }
	namespace reflection { class XProxyFactory; }
	namespace uno { class XAggregation; }
} } }
namespace cppu { class OInterfaceContainerHelper; }

namespace ucprmt {

class Connection;
class PropertiesChangeListeners;

//============================================================================
class Content: public cppu::OWeakObject,
		// proxied Content interfaces:
			   public com::sun::star::ucb::XContent,
			   public com::sun::star::lang::XComponent,
			   public com::sun::star::ucb::XCommandProcessor,
			   public com::sun::star::beans::XPropertiesChangeNotifier,
			// public com::sun::star::beans::XPropertyContainer,
			   public com::sun::star::beans::XPropertySetInfoChangeNotifier,
			   public com::sun::star::ucb::XCommandInfoChangeNotifier,
			   public com::sun::star::ucb::XContentCreator,
			   public com::sun::star::container::XChild,
		// other proxied interfaces:
			   public com::sun::star::lang::XUnoTunnel,
		// helper interfaces:
			   public com::sun::star::ucb::XContentEventListener,
			   public com::sun::star::beans::XPropertiesChangeListener,
			   public com::sun::star::beans::XPropertySetInfoChangeListener,
			   public com::sun::star::ucb::XCommandInfoChangeListener
{
public:
    class ListenerAction;
        // this is public because there are classes derived from this in
        // rmtcont.cxx

	static com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
	create(com::sun::star::uno::Reference<
		           com::sun::star::lang::XMultiServiceFactory > const &
		       rFactory,
		   rtl::Reference< Connection > const & rTheConnection,
		   com::sun::star::uno::Reference<
		           com::sun::star::ucb::XContentIdentifier > const &
		       rTheLocalIdentifier,
		   com::sun::star::uno::Reference<
		           com::sun::star::ucb::XContent > const &
		       rTheRemoteContent)
		throw (com::sun::star::uno::RuntimeException);

	virtual ~Content();

	//========================================================================
	// com::sun::star::uno::XInterface:

	virtual com::sun::star::uno::Any SAL_CALL
	queryInterface(com::sun::star::uno::Type const & rType)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw ();

    virtual void SAL_CALL release() throw ();

	//========================================================================
	// com::sun::star::ucb::XContent:

    virtual
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
	SAL_CALL
	getIdentifier() throw (com::sun::star::uno::RuntimeException);

    virtual rtl::OUString SAL_CALL getContentType()
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	addContentEventListener(
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XContentEventListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	removeContentEventListener(
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XContentEventListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XComponent:

    virtual void SAL_CALL dispose()
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	addEventListener(com::sun::star::uno::Reference<
					         com::sun::star::lang::XEventListener > const &
					     rListener)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	removeEventListener(com::sun::star::uno::Reference<
						        com::sun::star::lang::XEventListener > const &
						    rListener)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XCommandProcessor:

    virtual sal_Int32 SAL_CALL createCommandIdentifier()
		throw (com::sun::star::uno::RuntimeException);

    virtual com::sun::star::uno::Any SAL_CALL
	execute(com::sun::star::ucb::Command const & rCommand,
			sal_Int32 nCommandId,
			com::sun::star::uno::Reference<
			        com::sun::star::ucb::XCommandEnvironment > const &
			    rEnvironment)
		throw (com::sun::star::uno::Exception,
			   com::sun::star::ucb::CommandAbortedException,
			   com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL abort(sal_Int32 nCommandId)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::beans::XPropertiesChangeNotifier:

    virtual void SAL_CALL
	addPropertiesChangeListener(
		com::sun::star::uno::Sequence< rtl::OUString > const & rPropertyNames,
		com::sun::star::uno::Reference<
		        com::sun::star::beans::XPropertiesChangeListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	removePropertiesChangeListener(
		com::sun::star::uno::Sequence< rtl::OUString > const & rPropertyNames,
		com::sun::star::uno::Reference<
		        com::sun::star::beans::XPropertiesChangeListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::beans::XPropertySetInfoChangeNotifier:

    virtual void SAL_CALL
	addPropertySetInfoChangeListener(
		com::sun::star::uno::Reference<
		       com::sun::star::beans::XPropertySetInfoChangeListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	removePropertySetInfoChangeListener(
		com::sun::star::uno::Reference<
		       com::sun::star::beans::XPropertySetInfoChangeListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XCommandInfoChangeNotifier:

	virtual void SAL_CALL
	addCommandInfoChangeListener(
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XCommandInfoChangeListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL
	removeCommandInfoChangeListener(
		com::sun::star::uno::Reference<
		        com::sun::star::ucb::XCommandInfoChangeListener > const &
		    rListener)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XContentCreator:

    virtual
	com::sun::star::uno::Sequence< com::sun::star::ucb::ContentInfo > SAL_CALL
	queryCreatableContentsInfo()
		throw (com::sun::star::uno::RuntimeException);

    virtual
	com::sun::star::uno::Reference< com::sun::star::ucb::XContent > SAL_CALL
	createNewContent(com::sun::star::ucb::ContentInfo const & rInfo)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::container::XChild:

    virtual
	com::sun::star::uno::Reference< com::sun::star::uno::XInterface > SAL_CALL
	getParent() throw (com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL
	setParent(com::sun::star::uno::Reference<
			          com::sun::star::uno::XInterface > const &
			      rParent)
		throw (com::sun::star::lang::NoSupportException,
			   com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XUnoTunnel:

    virtual sal_Int64 SAL_CALL
	getSomething(com::sun::star::uno::Sequence< sal_Int8 > const &
				     rIdentifier)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::lang::XEventListener:

	virtual void SAL_CALL disposing(com::sun::star::lang::EventObject const &
									    rSource)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XContentEventListener:

	virtual void SAL_CALL
	contentEvent(com::sun::star::ucb::ContentEvent const & rEvt)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::beans::XPropertiesChangeListener:

	virtual void SAL_CALL
	propertiesChange(
		com::sun::star::uno::Sequence<
		        com::sun::star::beans::PropertyChangeEvent > const &
		    rEvt)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::beans::XPropertySetInfoChangeListener:

    virtual void SAL_CALL
	propertySetInfoChange(
		com::sun::star::beans::PropertySetInfoChangeEvent const & rEvt)
		throw (com::sun::star::uno::RuntimeException);

	//========================================================================
	// com::sun::star::ucb::XCommandInfoChangeListener:

	virtual void SAL_CALL
	commandInfoChange(com::sun::star::ucb::CommandInfoChangeEvent const &
					      rEvt)
		throw (com::sun::star::uno::RuntimeException);

private:
	enum Available { AVAIL_UNKNOWN, AVAIL_NO, AVAIL_YES };

    typedef std::queue< ListenerAction * > ListenerQueue;

    ListenerQueue m_aListenerQueue;
	rtl::Reference< Connection > m_xConnection;
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentIdentifier >
	    m_xLocalIdentifier;
	com::sun::star::uno::Reference< com::sun::star::ucb::XContent >
		m_xRemoteContent;
	com::sun::star::uno::Reference< com::sun::star::lang::XComponent >
		m_xRemoteComponent;
	com::sun::star::uno::Reference< com::sun::star::ucb::XCommandProcessor >
		m_xRemoteCommandProcessor;
	com::sun::star::uno::Reference<
	        com::sun::star::beans::XPropertiesChangeNotifier >
	    m_xRemotePropertiesChangeNotifier;
	com::sun::star::uno::Reference<
			com::sun::star::beans::XPropertySetInfoChangeNotifier >
		m_xRemotePropertySetInfoChangeNotifier;
	com::sun::star::uno::Reference<
			com::sun::star::ucb::XCommandInfoChangeNotifier >
		m_xRemoteCommandInfoChangeNotifier;
	com::sun::star::uno::Reference< com::sun::star::ucb::XContentCreator >
		m_xRemoteContentCreator;
	com::sun::star::uno::Reference< com::sun::star::container::XChild >
		m_xRemoteChild;
	com::sun::star::uno::Reference< com::sun::star::lang::XUnoTunnel >
		m_xRemoteUnoTunnel;
	com::sun::star::uno::Reference< com::sun::star::uno::XAggregation >
		m_xProxy;
	osl::Mutex m_aMutex;
    osl::Mutex m_aQueueMutex;
	cppu::OInterfaceContainerHelper * m_pEventListeners;
	cppu::OInterfaceContainerHelper * m_pContentEventListeners;
	PropertiesChangeListeners * m_pPropertiesChangeListeners;
	cppu::OInterfaceContainerHelper * m_pPropertySetInfoChangeListeners;
	cppu::OInterfaceContainerHelper * m_pCommandInfoChangeListeners;
	Available m_eAvailableComponent;
	Available m_eAvailableCommandProcessor;
	Available m_eAvailablePropertiesChangeNotifier;
	Available m_eAvailablePropertySetInfoChangeNotifier;
	Available m_eAvailableCommandInfoChangeNotifier;
	Available m_eAvailableContentCreator;
	Available m_eAvailableChild;
	Available m_eAvailableUnoTunnel;
    bool m_bQueueInOperation;

	inline bool isDisposed() const;

	inline void checkDisposed() const;

	Content(com::sun::star::uno::Reference<
			        com::sun::star::reflection::XProxyFactory > const &
			    rProxyFactory,
			rtl::Reference< Connection > const & rTheConnection,
			com::sun::star::uno::Reference<
			        com::sun::star::ucb::XContentIdentifier > const &
			    rTheLocalIdentifier,
			com::sun::star::uno::Reference<
			        com::sun::star::ucb::XContent > const &
			    rTheRemoteContent)
		throw (com::sun::star::uno::RuntimeException);

	void disposeAndClear();

	bool detectComponent();

	bool detectCommandProcessor();

	bool detectPropertiesChangeNotifier();

	bool detectPropertySetInfoChangeNotifier();

	bool detectCommandInfoChangeNotifier();

	bool detectContentCreator();

	bool detectChild();

	bool detectUnoTunnel();

    void addToListenerQueue(std::auto_ptr< ListenerAction > & rAction);

    void processListenerQueue();
};

}

#endif // _UCPRMT_RMTCONT_HXX_
