/*************************************************************************
 *
 *  $RCSfile: remotecontentproviderscontrol.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: sb $ $Date: 2001/06/20 07:52:00 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UCBHELPER_REMOTECONTENTPROVIDERSCONTROL_HXX_
#include "ucbhelper/remotecontentproviderscontrol.hxx"
#endif

#ifndef _COM_SUN_STAR_BRIDGE_XBRIDGE_HPP_
#include "com/sun/star/bridge/XBridge.hpp"
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTION_HPP_
#include "com/sun/star/connection/XConnection.hpp"
#endif
#ifndef _COM_SUN_STAR_CONNECTION_XCONNECTIONBROADCASTER_HPP_
#include "com/sun/star/connection/XConnectionBroadcaster.hpp"
#endif
#ifndef _COM_SUN_STAR_IO_XSTREAMLISTENER_HPP_
#include "com/sun/star/io/XStreamListener.hpp"
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include "com/sun/star/lang/XMultiServiceFactory.hpp"
#endif
#ifndef _COM_SUN_STAR_UCB_XREMOTECONTENTPROVIDERDONELISTENER_HPP_
#include "com/sun/star/ucb/XRemoteContentProviderDoneListener.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_EXCEPTION_HPP_
#include "com/sun/star/uno/Exception.hpp"
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include "com/sun/star/uno/Reference.hxx"
#endif
#ifndef _COM_SUN_STAR_UNO_RUNTIMEEXCEPTION_HPP_
#include "com/sun/star/uno/RuntimeException.hpp"
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include "cppuhelper/implbase1.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include "osl/diagnose.h"
#endif
#ifndef _OSL_MUTEX_HXX_
#include "osl/mutex.hxx"
#endif
#ifndef _RTL_REF_HXX_
#include "rtl/ref.hxx"
#endif
#ifndef _RTL_USTRING_HXX_
#include "rtl/ustring.hxx"
#endif

using namespace com::sun;
using ucb::RemoteContentProvidersControl;

class RemoteContentProvidersControl::Listener:
    public cppu::WeakImplHelper1< star::io::XStreamListener >
{
public:
    Listener(star::uno::Reference< star::connection::XConnection > const &
                 rConnection);

    void
    setControl(rtl::Reference< RemoteContentProvidersControl > const &
                   rControl,
               RemoteContentProvidersControl::Listeners::iterator const &
                   rIt);

    bool setDistribution(bool bDistribution);

	virtual void SAL_CALL disposing(star::lang::EventObject const & rSource)
		throw (star::uno::RuntimeException);

	virtual void SAL_CALL started() throw (star::uno::RuntimeException);

	virtual void SAL_CALL closed() throw (star::uno::RuntimeException);

	virtual void SAL_CALL terminated() throw (star::uno::RuntimeException);

	virtual void SAL_CALL error(star::uno::Any const &)
		throw (star::uno::RuntimeException);

private:
    osl::Mutex m_aMutex;
    RemoteContentProvidersControl::Listeners::iterator m_aIt;
    rtl::Reference< RemoteContentProvidersControl > m_xControl;
    star::uno::Reference< star::connection::XConnectionBroadcaster >
        m_xBroadcaster;
    bool m_bDistribution;
    bool m_bClosed;

    void closed(bool bRemove);
};

void RemoteContentProvidersControl::Listener::closed(bool bRemove)
{
    star::uno::Reference< star::connection::XConnectionBroadcaster >
        xBroadcaster;
    rtl::Reference< RemoteContentProvidersControl > xControl;
    bool bDistribution;
    {
        osl::MutexGuard aGuard(m_aMutex);
        if (!m_bClosed)
        {
            m_bClosed = true;
            if (bRemove)
                xBroadcaster = m_xBroadcaster;
            m_xBroadcaster = 0;
            xControl = m_xControl;
            bDistribution = m_bDistribution;
        }
    }
    if (xBroadcaster.is())
		try
		{
			xBroadcaster->removeStreamListener(this);
		}
        catch (star::uno::RuntimeException &)
        {
            OSL_ENSURE(false, "com::sun::star::uno::RuntimeException caught");
        }
    if (xControl.is())
        xControl->closed(m_aIt, bDistribution);
}

inline
RemoteContentProvidersControl::Listener::Listener(
    star::uno::Reference< star::connection::XConnection > const &
        rConnection):
    m_xBroadcaster(rConnection, star::uno::UNO_QUERY),
    m_bDistribution(false),
    m_bClosed(false)
{
    OSL_ENSURE(m_xBroadcaster.is(), "Bad rConnection");
	if (m_xBroadcaster.is())
		try
		{
			m_xBroadcaster->addStreamListener(this);
		}
        catch (star::uno::RuntimeException &)
        {
            OSL_ENSURE(false, "com::sun::star::uno::RuntimeException caught");
        }
}

void
RemoteContentProvidersControl::Listener::setControl(
    rtl::Reference< RemoteContentProvidersControl > const & rControl,
    RemoteContentProvidersControl::Listeners::iterator const & rIt)
{
    OSL_ENSURE(rControl.is(), "Null rControl");
    bool bDistribution;
    bool bClosed;
    {
        osl::MutexGuard aGuard(m_aMutex);
        m_xControl = rControl;
        m_aIt = rIt;
        bDistribution = m_bDistribution;
        bClosed = m_bClosed;
    }
    if (bClosed)
        m_xControl->closed(m_aIt, bDistribution);
}

bool
RemoteContentProvidersControl::Listener::setDistribution(bool bDistribution)
{
    osl::MutexGuard aGuard(m_aMutex);
    if (m_bClosed)
        return false;
    m_bDistribution = bDistribution;
    return m_bDistribution;
}

void SAL_CALL
RemoteContentProvidersControl::Listener::disposing(
    star::lang::EventObject const & rSource)
	throw (star::uno::RuntimeException)
{
    if (rSource.Source.is() && rSource.Source == m_xBroadcaster)
        closed(false);
}

void SAL_CALL RemoteContentProvidersControl::Listener::started()
	throw (star::uno::RuntimeException)
{}

void SAL_CALL RemoteContentProvidersControl::Listener::closed()
	throw (star::uno::RuntimeException)
{
    closed(true);
}

void SAL_CALL RemoteContentProvidersControl::Listener::terminated()
	throw (star::uno::RuntimeException)
{}

void SAL_CALL
RemoteContentProvidersControl::Listener::error(star::uno::Any const &)
	throw (star::uno::RuntimeException)
{}

void RemoteContentProvidersControl::closed(Listeners::iterator aIt,
                                           bool bDistribution)
{
    bool bDone;
    {
        osl::MutexGuard aGuard(m_aMutex);
        m_aListeners.erase(aIt);
        OSL_ENSURE((bDistribution ? m_nDistributions : m_nNonDistributions)
                       > 0,
                   "Bad counts");
        --(bDistribution ? m_nDistributions : m_nNonDistributions);
        bDone = !bDistribution
                && m_nDistributions > 0
                && m_nNonDistributions == 0;
    }

    if (bDone)
	{
		star::uno::Reference< star::ucb::XRemoteContentProviderDoneListener >
			xDoneListener;
        if (m_xServiceFactory.is())
            try
            {
                xDoneListener
                    = star::uno::Reference<
                              star::ucb::XRemoteContentProviderDoneListener >(
                          m_xServiceFactory->
					          createInstance(
                                  rtl::OUString(
                                      RTL_CONSTASCII_USTRINGPARAM(
                          "com.sun.star.ucb.RemoteContentProviderAcceptor"))),
                          star::uno::UNO_QUERY);
            }
		    catch (star::uno::Exception &)
            {
                OSL_ENSURE(false, "com::sun::star::uno::Exception caught");
            }
		OSL_ENSURE(xDoneListener.is(),
                   "No com.sun.star.ucb.RemoteContentProviderAcceptor");
		if (xDoneListener.is())
			xDoneListener->doneWithRemoteContentProviders(0);
	}
}

RemoteContentProvidersControl::RemoteContentProvidersControl(
	star::uno::Reference< star::lang::XMultiServiceFactory > const &
        rServiceFactory):
	m_xServiceFactory(rServiceFactory),
    m_nNonDistributions(0),
    m_nDistributions(0)
{
	OSL_ENSURE(m_xServiceFactory.is(), "Null m_xServiceFactory");
}

RemoteContentProvidersControl::~RemoteContentProvidersControl() SAL_THROW(())
{}

void
RemoteContentProvidersControl::addConnection(
	star::uno::Reference< star::connection::XConnection > const & rConnection)
{
    rtl::Reference< Listener > xListener(new Listener(rConnection));
    Listeners::iterator aIt;
    {
        osl::MutexGuard aGuard(m_aMutex);
        aIt = m_aListeners.
                  insert(Listeners::value_type(rConnection, xListener)).first;
        OSL_ENSURE(m_nNonDistributions < 0x7FFFFFFF, "Bad counts");
        ++m_nNonDistributions;
    }
    xListener->setControl(this, aIt);
}

void
RemoteContentProvidersControl::detectDistributionConnection(
    star::uno::Reference< star::connection::XConnection > const & rConnection,
    star::uno::Reference< star::bridge::XBridge > const & rBridge)
{
    rtl::Reference< Listener > xListener;
    {
        osl::MutexGuard aGuard(m_aMutex);
        Listeners::iterator aIt(m_aListeners.find(rConnection));
        if (aIt == m_aListeners.end())
            return;
        xListener = aIt->second;
    }

    // If the process at the other end of the bridge connection supports the
    // com.sun.star.ucb.RemoteContentProviderDistributionBridgeIdentifier
    // interface, assume that the connection will only be used to distribute
    // remote content providers:
    bool bDistribution = false;
    if (rBridge.is())
        try
        {
            bDistribution
                = rBridge->getInstance(rtl::OUString(
                                           RTL_CONSTASCII_USTRINGPARAM(
      "com.sun.star.ucb.RemoteContentProviderDistributionBridgeIdentifier"))).
                              is()
                      != false;
        }
        catch (star::uno::RuntimeException &)
        {
            // Instead of returning null, some bridges throw a
            // RuntimeException if they cannot supply the requested instance,
            // so silently ignore any RuntimeException here...
        }

    {
        osl::MutexGuard aGuard(m_aMutex);
        if (xListener->setDistribution(bDistribution))
        {
            OSL_ENSURE(m_nNonDistributions > 0
                       && m_nDistributions < 0x7FFFFFFF,
                       "Bad counts");
            --m_nNonDistributions;
            ++m_nDistributions;
        }
    }
}
