/*************************************************************************
 *
 *  $RCSfile: VCLWindow.m,v $
 *
 *  $Revision: 1.46 $
 *
 *  last change: $Author: hr $ $Date: 2002/08/27 11:58:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *		 - GNU Lesser General Public License Version 2.1
 *		 - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#import <VCLWindow.h>

#define _SV_VCLWINDOW_M

// -------------
// - VCLWindow -
// -------------

@implementation VCLWindow

- (void)setContentSize: (NSSize)aSize
{
	NSRect aFrameRect = [self frame];
	NSRect aContentRect;
	struct SalPaintEvent aPaintEvt;

	// Get the current size of the content view
	aContentRect = [VCLWindow contentRectForFrameRect: aFrameRect
		styleMask: [self styleMask]];

	if ( aSize.width != aContentRect.size.width ||
		aSize.height != aContentRect.size.height )
	{
		// Cache the new size
		mpSalFrameData->mnWidth = aSize.width;
		mpSalFrameData->mnHeight = aSize.height;
	
		// Pass the event to this window's callback function. We need to force
		// a resize before we post a paint event, otherwise only the old content
		// view area will only be painted.
		mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
			SALEVENT_RESIZE, NULL);
	
		// Initialize SalKeyEvent structure
		aPaintEvt.mnBoundX = 0;
		aPaintEvt.mnBoundY = 0;
		aPaintEvt.mnBoundWidth = aSize.width;
		aPaintEvt.mnBoundHeight = aSize.height;
	
		// Pass the event to this window's callback function
		mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
			SALEVENT_PAINT, &aPaintEvt );
	}

	// Invoke the superclass to set the size of the window
	[super setContentSize: aSize];
}

- (void)windowDidBecomeKey: (NSNotification *)aNotification
{
	mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
		SALEVENT_GETFOCUS, NULL );
}

- (void)windowDidResignKey: (NSNotification *)aNotification
{
	mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
		SALEVENT_LOSEFOCUS, NULL );
}

- (MacOSBOOL)windowShouldClose: (id)sender
{
	// Pass the event to this window's callback function.
	mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
		SALEVENT_CLOSE, NULL );

	// Always return FALSE as the event handler above should have taken
	// care of closing the window
	return FALSE;
}

- (NSSize)windowWillResize: (NSWindow *)sender toSize: (NSSize)proposedFrameSize
{
	NSRect aFrameRect;
	NSRect aContentRect;
	NSEvent *pEvent;
	struct SalPaintEvent aPaintEvt;

	// Get the size of the window's content area
	aFrameRect = NSMakeRect( 0, 0, proposedFrameSize.width,
		proposedFrameSize.height );
	aContentRect = [VCLWindow contentRectForFrameRect: aFrameRect
		styleMask: [self styleMask]];

	if ( aContentRect.size.width != mpSalFrameData->mnWidth ||
		aContentRect.size.height != mpSalFrameData->mnHeight )
	{
		// Cache the new size
		mpSalFrameData->mnWidth = aContentRect.size.width;
		mpSalFrameData->mnHeight = aContentRect.size.height;

		// Pass the event to this window's callback function.
		mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
			SALEVENT_RESIZE, NULL);

		// Initialize SalKeyEvent structure
		aPaintEvt.mnBoundX = 0;
		aPaintEvt.mnBoundY = 0;
		aPaintEvt.mnBoundWidth = aContentRect.size.width;
		aPaintEvt.mnBoundHeight = aContentRect.size.height;

		// Pass the event to this window's callback function
		mpSalFrameData->mpProc( mpSalFrameData->mpInst, mpSalFrame,
			SALEVENT_PAINT, &aPaintEvt );

		// We need to poll for the next NSPeriodic event that is posted
		// by the paint event that we posted, otherwise no repainting will
		// happen until after the last windowWillResize notification has
		// been issued. If the NSPeriodic event has not been posted yet,
		// don't worry about it as we will catch it the next time through.
		if ( [self isVisible] )
		{
			pEvent = [NSApp nextEventMatchingMask: NSPeriodicMask
				untilDate: nil inMode: NSDefaultRunLoopMode dequeue: YES];
			if ( pEvent )
				[NSApp sendEvent: pEvent];
		}
	}

	return proposedFrameSize;
}

@end

// -----------------------
// - C wrapper functions -
// -----------------------

VCLWINDOW VCLWindow_New( ULONG nSalFrameStyle, VCLWINDOW hParentWindow,
	SalFrame *pFrame, struct SalFrameData *pFrameData )
{
	VCLWindow *hWindow = nil;
	unsigned int nMask = 0;
	NSRect aContentRect;
	NSNotificationCenter *pNotifyCenter = [NSNotificationCenter defaultCenter];
	
	if (nSalFrameStyle & SAL_FRAME_STYLE_SIZEABLE) {
		nMask |= NSResizableWindowMask;
	}
	if (nSalFrameStyle & SAL_FRAME_STYLE_CLOSEABLE) {
		nMask |= NSClosableWindowMask;
	}
	if (nSalFrameStyle & SAL_FRAME_STYLE_MINABLE) {
		nMask |= NSMiniaturizableWindowMask;
	}
	if (nSalFrameStyle & SAL_FRAME_STYLE_BORDER) {
		nMask |= NSTitledWindowMask;
	}
	
	// Special settings for a generic window (i.e. one with a title bar)
	if( nSalFrameStyle & SAL_FRAME_STYLE_DEFAULT ) {
		// Make sure there is a title bar
		nMask |= NSTitledWindowMask;
		aContentRect = [[NSScreen mainScreen] visibleFrame];
	}
	// Generate a window without a title bar
	else if( nSalFrameStyle & SAL_FRAME_STYLE_FLOAT )
	{
		// Make sure that we turn off all title bar related items
		nMask &= ~NSClosableWindowMask;
		nMask &= ~NSMiniaturizableWindowMask;
		nMask &= ~NSTitledWindowMask;

		// Need to determine the correct default size for this case
		aContentRect = NSMakeRect(0, 0, 200, 300);
	}
	// All other windows
	else
	{
		// Make sure there is a title bar
		nMask |= NSTitledWindowMask;
		aContentRect = NSMakeRect(0, 0, 500, 400);
	}

	// Create a native window
	hWindow = [[VCLWindow new] initWithContentRect: aContentRect
		styleMask: nMask backing: NSBackingStoreBuffered defer: YES];

	// We need to attach the required SalFrameData struct pointer
	hWindow->mpSalFrame = pFrame;
	hWindow->mpSalFrameData = pFrameData;

	// Cache the size of the content area of the window
	hWindow->mpSalFrameData->mnHeight = aContentRect.size.height;
	hWindow->mpSalFrameData->mnWidth = aContentRect.size.width;

	// We need to set the window as its own Delegate to capture
	// resizing events
	[hWindow setDelegate: hWindow];

	// We need to replace the window's contentView with an VCLView so
	// that we can paint using QuickDraw
	[hWindow setContentView: [[[VCLView new] init] initWithFrame: [hWindow frame]]];
	
	// Turn on optimized drawing since we have no overlapping views
	[hWindow useOptimizedDrawing: YES];

	// Turn on mouse entered and exited events
	[[hWindow contentView] addTrackingRect: aContentRect owner: hWindow
		userData: nil assumeInside: NO];

	return hWindow;
}

VCLVIEW VCLWindow_ContentView( VCLWINDOW hWindow )
{
	if ( (VCLWindow *)hWindow == nil )
		return NULL;

	return [(VCLWindow *)hWindow contentView];
}

void VCLWindow_Show( VCLWINDOW hWindow )
{
	if ( (VCLWindow *)hWindow == nil )
		return;

	// If being shown for the first time, center it
	if ( ! [(VCLWindow *)hWindow isVisible] )
		[(VCLWindow *)hWindow center];

	// Bring the window to the front
	[(VCLWindow *)hWindow makeKeyAndOrderFront: NSApp];

	// Turn on tracking of mouse move events. Note that we can't do this until
	// after [VCLWindow makeKeyAndOrderFront:] is invoked. Otherwise, this call
	// does nothing.
	[(VCLWindow *)hWindow setAcceptsMouseMovedEvents: YES];
}

void VCLWindow_Close( VCLWINDOW hWindow )
{
	if ( (VCLWindow *)hWindow == nil )
		return;

	// Hide the window
	[(VCLWindow *)hWindow orderOut: (VCLWindow *)hWindow];
}

void VCLWindow_Release( VCLWINDOW hWindow )
{
	if ( (VCLWindow *)hWindow == nil )
		return;

	// Closing releases the window
	[(VCLWindow *)hWindow close];
}

void VCLWindow_SetTitle( VCLWINDOW hWindow, const char *pTitle )
{
	NSString *pString = nil;

	if ( (VCLWindow *)hWindow == nil )
		return;

	pString = [NSString stringWithCString: pTitle];
	[(VCLWindow *)hWindow setTitle: pString];
}

void VCLWindow_SetSize( VCLWINDOW hWindow, long nWidth, long nHeight )
{
	if ( (VCLWindow *)hWindow == nil )
		return;

	// Set the native window size
	[(VCLWindow *)hWindow setContentSize: NSMakeSize(nWidth, nHeight)];
}

BOOL VCLWindow_PostEvent( VCLWINDOW hWindow, void *pData )
{
	NSEvent *pEvent = nil;
	NSDate *pDate = nil;

	if ( (VCLWindow *)hWindow == nil )
		return FALSE;

	// Construct an event
	pDate = [NSDate date];
	pEvent = [NSEvent otherEventWithType: NSApplicationDefined
		location: NSMakePoint(0, 0) modifierFlags: 0
		timestamp: [pDate timeIntervalSince1970]
		windowNumber: [(VCLWindow *)hWindow windowNumber]
		context: nil subtype: 0 data1: (int)pData data2: 0];

	// Post the event
	[(VCLWindow *)hWindow postEvent: pEvent atStart: NO];

	return TRUE;
}

void VCLWindow_Beep( VCLWINDOW hWindow )
{
	NSBeep();
}
