/*************************************************************************
 *
 *  $RCSfile: gdiobj.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/19 10:23:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef NOOLDSV
#ifndef _SV_GDIOBJ_HXX
#define _SV_GDIOBJ_HXX

#ifndef _SV_COLOR_HXX
#include <color.hxx>
#endif

enum PenStyle { PEN_NULL, PEN_SOLID, PEN_DOT, PEN_DASH, PEN_DASHDOT };

class Pen
{
	Color			aColor;
	PenStyle		eStyle;
	ULONG			nWidth;

public:
					Pen() { eStyle = PEN_SOLID; nWidth = 0; }
					Pen( PenStyle _eStyle ) { eStyle = _eStyle; nWidth = 0; }
					Pen( const Color& rColor, ULONG _nWidth = 0,
						PenStyle _eStyle = PEN_SOLID ) :
						aColor( rColor )
						{ eStyle = _eStyle; nWidth = _nWidth; }

	void			SetColor( const Color& rColor ) { aColor = rColor; }
	const Color&	GetColor() const { return aColor; }

	void			SetWidth( ULONG _nWidth ) { nWidth = _nWidth; }
	ULONG			GetWidth() const { return nWidth; }

	void			SetStyle( PenStyle _eStyle ) { eStyle = _eStyle; }
	PenStyle		GetStyle() const { return eStyle; }

	BOOL			operator==( const Pen& rPen ) const
						{ return ((eStyle == rPen.eStyle) && (nWidth == rPen.nWidth) && (aColor == rPen.aColor)); }
	BOOL			operator!=( const Pen& rPen ) const
						{ return !(Pen::operator==( rPen )); }
	BOOL			IsSameInstance( const Pen& rPen ) const
						{ return (this == &rPen); }
};

// ---------------
// - Brush-Types -
// ---------------

#define BRUSH_SIZE		8

enum BrushStyle { BRUSH_NULL, BRUSH_SOLID, BRUSH_HORZ, BRUSH_VERT,
				  BRUSH_CROSS, BRUSH_DIAGCROSS, BRUSH_UPDIAG, BRUSH_DOWNDIAG,
				  BRUSH_25, BRUSH_50, BRUSH_75,
				  BRUSH_BITMAP };

// ---------
// - Brush -
// ---------

class Brush
{
private:
	Color			aColor;
	Color			aFillColor;
	BrushStyle		eStyle;
	BOOL			bTransparent;

public:
					Brush() : aColor( COL_WHITE )
						{  eStyle = BRUSH_SOLID; bTransparent = FALSE; }
					Brush( BrushStyle _eStyle ) : aColor( COL_WHITE )
						{  eStyle = _eStyle; bTransparent = FALSE; }
					Brush( const Color& rColor,
						BrushStyle _eStyle = BRUSH_SOLID ) :
						aColor( rColor )
						{  eStyle = _eStyle; bTransparent = TRUE; }
					Brush( const Color& rColor, const Color& rFillColor,
						BrushStyle _eStyle ) :
						aColor( rColor ),
						aFillColor( rFillColor )
						{  eStyle = _eStyle; bTransparent = FALSE; }

	void			SetColor( const Color& rColor ) { aColor = rColor; }
	const Color&	GetColor() const { return aColor; }
	void			SetFillColor( const Color& rColor ) { aFillColor = rColor; }
	const Color&	GetFillColor() const { return aFillColor; }

	void			SetStyle( BrushStyle _eStyle ) { eStyle = _eStyle; }
	BrushStyle		GetStyle() const { return eStyle; }

	void			SetTransparent( BOOL _bTransparent ) { bTransparent = _bTransparent; }
	BOOL			GetTransparent() const { return bTransparent; }
	BOOL			IsTransparent() const;
	BOOL			IsHatched() const;

	Color			GetVCLFillColor() const;

	BOOL			operator==( const Brush& rBrush ) const
						{ return ((eStyle == rBrush.eStyle) && (aColor == rBrush.aColor)); }
	BOOL			operator!=( const Brush& rBrush ) const
						{ return !(Brush::operator==( rBrush )); }
	BOOL			IsSameInstance( const Brush& rBrush ) const
						{ return (this == &rBrush); }
};

inline BOOL Brush::IsTransparent() const
{
	if ( eStyle == BRUSH_SOLID )
		return FALSE;
	else
	{
		if ( eStyle == BRUSH_NULL )
			return TRUE;
		else
			return bTransparent;
	}
}

inline BOOL Brush::IsHatched() const
{
	if ( (eStyle != BRUSH_SOLID)  &&
		 (eStyle != BRUSH_BITMAP) &&
		 (eStyle != BRUSH_NULL) )
		return TRUE;
	else
		return FALSE;
}

#endif // _SV_GDIOBJ_HXX
#endif
