/*************************************************************************
 *
 *  $RCSfile: salsys.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: tra $ $Date: 2002/11/20 15:45:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _SV_SALSYS_HXX
#define _SV_SALSYS_HXX

#ifndef _STRING_HXX
#include <tools/string.hxx>
#endif
#ifndef _LIST_HXX
#include <tools/list.hxx>
#endif

#ifndef _SV_SV_H
#include <sv.h>
#endif

#ifndef _SV_SYSTEM_HXX
#include <system.hxx>
#endif

#include <list>

// -------------------
// - SalSystem-Types -
// -------------------

// Must be the same values like in VCLSystemInfo
#define SALSYSTEM_GETSYSTEMINFO_STACK           ((ULONG)0x00000001)
#define SALSYSTEM_GETSYSTEMINFO_MODULES         ((ULONG)0x00000002)
#define SALSYSTEM_GETSYSTEMINFO_SYSTEMVERSION   ((ULONG)0x00000004)
#define SALSYSTEM_GETSYSTEMINFO_CPUTYPE         ((ULONG)0x00000008)
#define SALSYSTEM_GETSYSTEMINFO_MEMORYINFO      ((ULONG)0x00000010)
#define SALSYSTEM_GETSYSTEMINFO_LOCALVOLUMES    ((ULONG)0x00000020)
#define SALSYSTEM_GETSYSTEMINFO_SYSTEMDIRS      ((ULONG)0x00000040)
#define SALSYSTEM_GETSYSTEMINFO_MOUSEINFO       ((ULONG)0x00000080)
#define SALSYSTEM_GETSYSTEMINFO_GRAPHICSSYSTEM  ((ULONG)0x00000100)

// -------------
// - SalSystem -
// -------------

String GetSalSummarySystemInfos( ULONG nFlags );

bool GetSalSystemDisplayInfo( System::DisplayInfo& rInfo );

/* Button combinations for ImplShowNativeMessageBox
*/
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTNCOMBI_OK                 = 0;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTNCOMBI_OK_CANCEL          = 1;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTNCOMBI_ABORT_RETRY_IGNORE = 2;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTNCOMBI_YES_NO_CANCEL      = 3;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTNCOMBI_YES_NO             = 4;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTNCOMBI_RETRY_CANCEL       = 5;

/* Button identifier for ImplShowNativeMessageBox
*/
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_OK     = 1;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_CANCEL = 2;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_ABORT  = 3;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_RETRY  = 4;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_IGNORE = 5;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_YES    = 6;
const int SALSYSTEM_SHOWNATIVEMSGBOX_BTN_NO     = 7;

/*  Shows a native message box with the specified title, message and button
    combination. 
                
    @param  rTitle
            The title to be shown by the dialog box.
            
    @param  rMessage
            The message to be shown by the dialog box.
            
    @param  nButtonCombination
            Specify which button combination the message box should display.
            See button combinations above.
                        
    @param  nDefaultButton
            Specifies which button has the focus initially. 
            See button identifiers above. 
            The effect of specifying a button that doesn't belong
            to the specified button combination is undefined.
                                             
    @returns the identifier of the button that was pressed by the user.            
             See button identifier above. If the function fails the
             return value is 0.
*/
int ImplShowNativeMessageBox(const String& rTitle, const String& rMessage, int nButtonCombination, int nDefaultButton);

#endif // _SV_SALSYS_HXX
