/*************************************************************************
 *
 *  $RCSfile: salinst.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/



#include <string.h>



#if __profile__

#include "mac_start.h"

#include <profiler.h>

#include "mac_end.h"

#endif

#include <svmac.h>

#include <setjmp.h>



#define _SV_SALINST_CXX



#ifndef _TOOLS_H

#include <tools/tools.h>

#endif

#ifndef _DEBUG_HXX

#include <tools/debug.hxx>

#endif

#ifndef _TIME_HXX

#include <tools/time.hxx>

#endif



#ifndef _OSL_THREAD_H_

#include <osl/thread.h>

#endif



#ifndef _SV_SALIDS_HRC

#include <salids.hrc>

#endif

#ifndef _SV_SALATYPE_HXX

#include <salatype.hxx>

#endif

#ifndef _SV_SALDATA_HXX

#include <saldata.hxx>

#endif

#ifndef _SV_SALINST_HXX

#include <salinst.hxx>

#endif

#ifndef _SV_SALFRAME_HXX

#include <salframe.hxx>

#endif

#ifndef _SV_SVAPP_HXX

#include <svapp.hxx>

#endif


#include <vos/mutex.hxx>

#include <main.h>



// =======================================================================



MAC_Point gLastMousePos;



// =======================================================================



long GetMilliSecsFromTicks( ULONG nTicksSinceStartUp )

{

	// TickCount liefert die Zeit in 60zigstel Sekunden zurueck. 

	// Daraus muessen Millisekunden gemacht werden

	// (1/60)sec = 16.67 ms



	ULONG millisec = nTicksSinceStartUp;

	if ( millisec & 0xFFC00000 )

	{	millisec = ( millisec + 2 ) / 3;

		millisec *= 50;

	}

	else 

	{	millisec *= 50;

		millisec = ( millisec + 2 ) / 3;

	}

	return millisec;

}



// -----------------------------------------------------------------------

// last changed:	dv	13.11.97



BOOL QuickAnyInput()

{

	EventRecord	aEvent;

    SalData		*pSalData = GetSalData();



	if ( pSalData->mnTimerId &&

		 ( pSalData->mnTimerId < Time::GetSystemTicks() ) )

		return TRUE;



	if ( OSEventAvail( everyEvent, &aEvent ) )

		return TRUE;

	else

		if ( ( aEvent.where.h != gLastMousePos.h ) ||

			 ( aEvent.where.v != gLastMousePos.v ) )

			return TRUE;

		else

			return FALSE;

}



// =======================================================================



BOOL SalData::ImplSendMessage( UserEventData* pUEvntDat )

{

	if ( pUEvntDat )

	{	pUEvntDat->mpNextEvent = 0L;

		// insert

		if ( mpUserEvent )

		{	UserEventData*	pLastEvent;

			

			pLastEvent = mpUserEvent;

			while ( pLastEvent->mpNextEvent != 0 )

			{	pLastEvent = pLastEvent->mpNextEvent;

			}

			pLastEvent->mpNextEvent = pUEvntDat;

		}

		else 

		{	mpUserEvent = pUEvntDat;

		}

	}

	osl_yieldThread();

	return (pUEvntDat != 0L);

}



// -----------------------------------------------------------------------



BOOL SalData::ImplSendMessage( SalFrame* pSalFrame, void *pEventData, ULONG nEvent, 

											MAC_Point aWhere, long nWhen )

{

	UserEventData*	pUED = new UserEventData;



	pUED->mpSalFrame	= pSalFrame;

	pUED->mpEventData	= pEventData;

	pUED->mnEvent		= nEvent;

	pUED->maWhere		= aWhere;

	pUED->mnWhen		= nWhen;

	if ( nWhen == 0L )

	{	pUED->mnWhen	= Time::GetSystemTicks();

	}

	ImplSendMessage( pUED );

	return (pEventData != 0L);

}



// -----------------------------------------------------------------------



BOOL SalData::ImplSendMessage( SalFrame* pSalFrame, void *pEventData, ULONG nEvent )

{

	MAC_Point	aPoint;



	GetMouse( &aPoint ); LocalToGlobal( &aPoint );

	ImplSendMessage( pSalFrame, pEventData, nEvent, aPoint, Time::GetSystemTicks() );

	return (pEventData != 0L);

}



// -----------------------------------------------------------------------



BOOL SalData::ImplDispatchUserEvent( UserEventData* pUEvntDat )

{

	if ( TRUE )

	{	

		switch ( pUEvntDat->mnEvent )

		{

			case SALEVENT_USEREVENT:

				ImplHandleUserEvent( pUEvntDat->mpSalFrame, pUEvntDat->mpEventData );

			break;

			case SAL_MSG_MOUSELEAVE:

				EventRecord aEvent;

				memset (&aEvent, 0, sizeof( EventRecord ) );

				aEvent.what = pUEvntDat->mnEvent;

				aEvent.when = pUEvntDat->mnWhen;

				aEvent.where = pUEvntDat->maWhere;

				ImplHandleMouseMsg( &aEvent, pUEvntDat->mpSalFrame );

			break;

			default:

				DBG_ERROR("SalData::ImplDispatchUserEvent: nEvent NYI !!!");

				return FALSE;

			break;

		}

	}

	return TRUE;

}



// -----------------------------------------------------------------------



BOOL SalData::ImplDispatchUserEvents( long nWhenInMilliSecs )

{

	if ( mpUserEvent )

	{	if ( mbEnde || nWhenInMilliSecs >= mpUserEvent->mnWhen )

		{

			UserEventData *pTemp = mpUserEvent;

			UserEventData **hNext = &mpUserEvent;

			for ( ; pTemp; pTemp = *hNext )

			{

				if ( pTemp->mnWhen <= nWhenInMilliSecs || mbEnde )

				{

					*hNext = pTemp->mpNextEvent;

					ImplDispatchUserEvent( pTemp );

					delete pTemp;

				}

				else

				{	hNext = &pTemp->mpNextEvent;

				}

			}

		}

	}

	return ( mpUserEvent == 0 );

}



// =======================================================================



static OSStatus LastTryExceptionHandler (ExceptionInformation *theException);



static ExceptionHandler	prevHandler;



// -----------------------------------------------------------------------



static void SalExceptionHdl()

{

    SalData* pSalData = GetSalData();



    if ( pSalData->mpExceptionProc )

    {

        ULONG nCode = pSalData->mpExceptionProc( SAL_EXCEPTION_ACCESS_VIOLATION );

    }

	ImplFreeSalGDI();

	DeInitTools();

	ExitToShell();

}



// -----------------------------------------------------------------------



void SalSetExceptionHandler( SALEXCEPTIONPROC pProc )

{

    SalData*        pSalData = GetSalData();



    if ( pProc )

    {

		InstallExceptionHandler( (ExceptionHandler)LastTryExceptionHandler );

    }

    else

    {

		InstallExceptionHandler( (ExceptionHandler)prevHandler );

    }

	pSalData->mpExceptionProc = pProc;

}



// -----------------------------------------------------------------------



void SalAbort( const XubString& rErrorText )

{

    // Fehlermeldung anzeigen und Programm abbrechen

    if ( !rErrorText )

    {

		AlertUser( "\pApplication Error" );

	}

    else

        AlertUser(rErrorText.GetPascalStr());



    ImplFreeSalGDI();

	DeInitTools();

	ExitToShell();

}



// =======================================================================



void InitSalData()

{

    SalData* pSalData = new SalData;

    memset( pSalData, 0, sizeof( SalData ) );

    SetSalData( pSalData );

}



// -----------------------------------------------------------------------



void DeInitSalData()

{

    SalData* pSalData = GetSalData();

    delete pSalData;

    SetSalData( NULL );

}



// -----------------------------------------------------------------------



void SetFilterCallback( void* pCallback, void* pInst )

{

    SalData* pSalData = GetSalData();



	pSalData->mpFirstInstance->maInstData.mpFilterCallback = pCallback;

	pSalData->mpFirstInstance->maInstData.mpFilterInst = pInst;

}



// -----------------------------------------------------------------------



SalInstance* CreateSalInstance()

{

#if __profile__

	ProfilerInit( collectDetailed, microsecondsTimeBase, 10000, 50 );

#endif



    SalData*        pSalData = GetSalData();

    SalInstance*    pInst = new SalInstance;



    // init instance (only one instance in this version !!!)

    pSalData->mpFirstInstance   = pInst;



    // init static GDI Data

    ImplInitSalGDI();



    return pInst;

}



// -----------------------------------------------------------------------



void DestroySalInstance( SalInstance* pInst )

{

    SalData* pSalData = GetSalData();



    // reset instance (only one instance in this version !!!)

    if ( pSalData->mpFirstInstance == pInst )

        pSalData->mpFirstInstance = NULL;



    ImplFreeSalGDI();



#if __profile__

	ProfilerDump("\pStarView.prof");

	ProfilerTerm();

#endif



    delete pInst;

}



// =======================================================================



SalInstanceData::SalInstanceData()

{

    memset( this, 0, sizeof( SalInstanceData ) );

	mnMBarHeight = GetMBarHeight();



    SalData*        pSalData = GetSalData();

	pSalData->ImplSetInSuspendResume(FALSE);



	// Pruefen, ob wir der Front Prozess sind.

	ProcessSerialNumber	aMe, aFront;

	MAC_Boolean			aRet;



	GetCurrentProcess( &aMe );

	GetFrontProcess( &aFront );

	SameProcess( &aMe, &aFront, &aRet );



	pSalData->mbInForeground = aRet;

}



SalInstanceData::~SalInstanceData()

{

    delete mpAppFileName;

}


// ============ SalYieldMutex ==========================

class SalYieldMutex : public NAMESPACE_VOS(OMutex)
{
public:
#ifdef _VOS_NO_NAMESPACE
	SalYieldMutex() : OMutex() {}
#else
	SalYieldMutex() : vos::OMutex() {}
#endif
};


// =======================================================================

// =======================================================================



SalInstance::SalInstance()

{

	maInstData.mpFilterCallback = NULL; 

	maInstData.mpFilterInst = NULL; 

/* Patched HRO */
	maInstData.mpSalWaitMutex			= new NAMESPACE_VOS(OMutex);
	maInstData.mpSalYieldMutex			= new SalYieldMutex();
/* End Patch */

	GetFileName();

}



// -----------------------------------------------------------------------



SalInstance::~SalInstance()

{

/* Patched HRO */
	delete maInstData.mpSalYieldMutex;
	delete maInstData.mpSalWaitMutex;
/* End Patch */

}


// -----------------------------------------------------------------------

#ifdef _VOS_NO_NAMESPACE
IMutex* SalInstance::GetYieldMutex()
#else
vos::IMutex* SalInstance::GetYieldMutex()
#endif
{
	return maInstData.mpSalYieldMutex;
}


// -----------------------------------------------------------------------



void SalInstance::Yield( BOOL bWait )

{

	static ULONG nNextTime = 0L;



	SalData *pSalData = GetSalData();



	if ( pSalData->mpAppEventList )

	{

		AppEventList* pData = pSalData->mpAppEventList;

		while ( pData )

		{

			pSalData->mpAppEventList = pData->mpNext;

			GetpApp()->AppEvent( *(pData->mpAppEvent) );

			delete pData->mpAppEvent;

			delete pData;

			pData = pSalData->mpAppEventList;

		}

	}



	// In SuspendResume duerfen wir keinesfalls WaitNextEvent aufrufen

	// sonst werden wir im Suspend schon in den Hintergrund geschickt

	// obwohl die Applikation noch das Clipboard fuellt !



	if ( ! pSalData->ImplIsInSuspendResume() )

	{

		if ( ! bWait && ! AnyInput( INPUT_ANY ) )

		{

			osl_yieldThread();

			return;

		}

		

		BOOL	bGotEvent = FALSE;



		while ( ! bGotEvent )

		{

			if ( pSalData->mpUserEvent )

			{

				pSalData->ImplDispatchUserEvents( Time::GetSystemTicks() );

				bGotEvent = TRUE;

			}



			if ( ( ! bGotEvent && QuickAnyInput() ) ||

				 ( nNextTime < TickCount() ) )

//			if ( ! bGotEvent && ( nNextTime < TickCount() ) )

			{

				nNextTime = TickCount() + 4;

				bGotEvent |= SV_EventLoop();

			}



			osl_yieldThread();



			#ifdef DBG_UTIL

				if ( !bWait && !bGotEvent )

					DBG_ERROR( "Yield: Warum hat AnyInput TRUE geliefert, wenn nichts da ist?" );

			#endif

		}

	}

}



// -----------------------------------------------------------------------



XubString SalInstance::GetFileName()

{

    if ( !maInstData.mpAppFileName )

    {

		FSSpec	aAppFile;

		ProcessSerialNumber	process;

		ProcessInfoRec		procInfo;

		process.highLongOfPSN = 0;

		process.lowLongOfPSN  = kCurrentProcess;

		procInfo.processInfoLength	= sizeof(ProcessInfoRec);

		procInfo.processName		= nil;

		procInfo.processAppSpec		= &aAppFile;

	

		if ( noErr == GetProcessInformation(&process,&procInfo) ) 

		{

			maInstData.mpAppFileName = 

					new XubString( ((char*) aAppFile.name)+1,aAppFile.name[0] );

		} else 

		{	maInstData.mpAppFileName = new XubString( "StarView" );

		}

    }

    return *maInstData.mpAppFileName;

}



// -----------------------------------------------------------------------



USHORT SalInstance::GetCommandLineParamCount()

{

    return (USHORT)0;

}



// -----------------------------------------------------------------------



XubString SalInstance::GetCommandLineParam( USHORT nParam )

{

    return ImplGetSVEmptyStr();

}



// -----------------------------------------------------------------------

// last changed:	dv	13.11.97



BOOL SalInstance::AnyInput( USHORT nType )

{

	// In SuspendResume drfen wir keinesfalls EventAvail aufrufen

	// sonst werden wir im Suspend schon in den Hintergrunbd geschickt

	// obwohl die Applikation noch das Clipboard fuellt !

	if ( GetSalData()->ImplIsInSuspendResume() )

		return FALSE;



    SalData* pSalData = GetSalData();



	if ( ( nType & INPUT_OTHER ) && pSalData->mpUserEvent )

		return TRUE;



	if ( ( nType & INPUT_TIMER ) && pSalData->mnTimerId &&

		 ( pSalData->mnTimerId < Time::GetSystemTicks() ) )

		return TRUE;



	// ACHTUNG ! Wir bekommen keine MouseMove events!



	EventRecord	aEvent;

	short		nMask;



	switch ( nType ) {

		case INPUT_MOUSE:	nMask = mDownMask + mUpMask;

							break;

		case INPUT_KEYBOARD: nMask = keyDownMask + keyUpMask + autoKeyMask;

							break;

		case INPUT_PAINT:	nMask = updateMask;

							break;

		case INPUT_OTHER:	nMask = everyEvent;

							break;

		case INPUT_MOUSEANDKEYBOARD: nMask = mDownMask + mUpMask +

							keyDownMask + keyUpMask + autoKeyMask;

							break;

		case INPUT_ANY:		nMask = everyEvent;

							break;

		default:			nMask = everyEvent;

							break;

	}



	if ( OSEventAvail( nMask, &aEvent ) )

		return TRUE;

	else if ( ( nMask & ( mDownMask + mUpMask ) ) &&

			 ( ( aEvent.where.h != gLastMousePos.h ) ||

			   ( aEvent.where.v != gLastMousePos.v ) ) )

		return TRUE;

	else

		return EventAvail( nMask, &aEvent );

}



// =======================================================================



// Let main() and our exception handler both have access to global env 



static volatile jmp_buf aPPCExceptionEnv;



#if __profile__

#pragma profile off

#endif





void DoMemoryException ( )

{

	prevHandler = InstallExceptionHandler( (ExceptionHandler)LastTryExceptionHandler );

	if ( setjmp( aPPCExceptionEnv ) != noErr ) 

	{	

		InstallExceptionHandler( (ExceptionHandler)prevHandler );

		SalExceptionHdl();// finally ExitToShell is called

	}

	return;

}



// -----------------------------------------------------------------------



static OSStatus LastTryExceptionHandler ( ExceptionInformation *theException )

{

	switch ( theException->theKind )

	{

		case kTraceException:

		case kInstructionBreakpointException:

		case kDataBreakpointException:

		return noErr;

		default:

		;

	}

	if ((theException->theKind != kStackOverflowException) 

					&& (theException ->theKind != unresolvablePageFaultException))

		longjmp( aPPCExceptionEnv, memAdrErr );

	else

		return (-1);

		

	return noErr;

}




