/*************************************************************************
 *
 *  $RCSfile: salfont.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 17:05:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <string.h>
#include <svmac.h>
#include <mac_start.h>
#include <GXMath.h>
#include <GXTypes.h>
#include <mac_end.h>

#define _SV_SALGDI_CXX

#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _NEW_HXX
#include <tools/new.hxx>
#endif
#ifndef _SV_SALDATA_HXX
#include <saldata.hxx>
#endif
#ifndef _SV_SALGDI_HXX
#include <salgdi.hxx>
#endif

#ifndef _SV_OUTFONT_HXX
#include <outfont.hxx>
#endif

#ifndef _MYFONT_HXX
#include <myfont.hxx>
#endif

#ifndef _SALFONT_HXX
#include <salfont.hxx>
#endif

// -----------
// - Defines -
// -----------

#define GLYPH_INC				(512UL)
#define MAX_POLYCOUNT			(2048UL)
#define CHECKPOINTS( _def_nPnt )	\
	if( (_def_nPnt) >= nPtSize )	\
		nPtSize = ImplIncreaseArrays( nPtSize, &pPoints, &pFlags, GLYPH_INC )

// =======================================================================

inline long PostFontError(long error)
{
#ifdef DBG_UTIL
	if (error)
		DBG_ERROR("FontError");
#endif
	return error;
}

// -----------------------------------------------------------------------

Handle GetNamedSfntHandle( const XubString& rName, short styleWord )
{
	Handle hFond = GetNamedResource( 'FOND', rName.GetPascalStr() );
	if ( hFond && !ResError() )
	{
		FamRec* pFrec = (FamRec*)*hFond;
		register short* assoc = (short*)(pFrec + 1);
		register short sfntID = 0;
		register count = *assoc++;

		while ( count-- >= 0 && !sfntID )
		{	if ( *assoc++ == 0 )		/* size == 0 means sfnt */
				if ( *assoc++ == styleWord )
					sfntID = *assoc;
				else
					assoc++;
			else
				assoc += 2;
		}
		if ( sfntID )
		{
			Handle hSfnt = GetResource( 'sfnt', sfntID );
			if ( hSfnt && !ResError() )
				return hSfnt;
		}
	}
	DBG_ERROR( "GetNamedSfntHandle : Font NotFound" );
	return 0;
}

/*************************************************************************/

void InitGlyphOutline(GlyphOutline* out)
{
	out->contourCount = 0;
	out->pointCount = 0;
	out->endPoints = (short**)NewHandle(0);
	out->onCurve = (BYTE**)NewHandle(0);
	out->x = (Fixed**)NewHandle(0);
	out->y = (Fixed**)NewHandle(0);
}

/*************************************************************************/

void KillGlyphOutline(GlyphOutline* out)
{
	DisposeHandle((Handle)out->endPoints);
	DisposeHandle((Handle)out->onCurve);
	DisposeHandle((Handle)out->x);
	DisposeHandle((Handle)out->y);
}

/*************************************************************************/

void LockGlyphOutline(GlyphOutline* out)
{
	HLock((Handle)out->endPoints);
	HLock((Handle)out->onCurve);
	HLock((Handle)out->x);
	HLock((Handle)out->y);
}

/*************************************************************************/

void UnlockGlyphOutline(GlyphOutline* out)
{
	HUnlock((Handle)out->endPoints);
	HUnlock((Handle)out->onCurve);
	HUnlock((Handle)out->x);
	HUnlock((Handle)out->y);
}

/*************************************************************************/

static short GetFontState(Handle sfnt)
{
	short state;

	LoadResource(sfnt);
	state = HGetState(sfnt);
	HNoPurge(sfnt);
	return state;
}

/*************************************************************************/

inline void SetFontState(Handle sfnt, short state)
{
	HSetState(sfnt, state);
}

/*************************************************************************/

FontError GetSfntTableInfo(Handle sfnt, fontTableTag tag, FontTableInfo* fTable)
{
	short state = GetFontState(sfnt);
	register sfnt_OffsetTable* dir = (sfnt_OffsetTable*)*sfnt;
	register sfnt_DirectoryEntry* table = dir->table;
	register short count = dir->numOffsets;
	FontError error = fNoError;

	for (; --count >= 0; table++)
		if (table->tableTag == tag)
		{	fTable->offset = table->offset;
			fTable->length = table->length;
			fTable->checkSum = table->checkSum;
			break;
		}
	if (count < 0)
		error = PostFontError(fTableNotFound);
	SetFontState(sfnt, state);
	return error;
}

/*************************************************************************/

static void* GetSfntTablePtr(Handle sfnt, fontTableTag tag)
{
	FontTableInfo info;

	if (GetSfntTableInfo(sfnt, tag, &info))
		return 0;
	return *sfnt + info.offset;
}

/*************************************************************************/

static void* GetSfntGlyphPtr(Handle sfnt, long glyphIndex, long* length)
{
	void* loc;
	char* glyphStart;
	sfnt_FontHeader* head;

	if (!((0 != (head = (sfnt_FontHeader*)GetSfntTablePtr(sfnt, tag_FontHeader))) &&
		  (0 != (loc =  				  GetSfntTablePtr(sfnt, tag_IndexToLoc))) &&
		  (0 != (glyphStart = (char*)     GetSfntTablePtr(sfnt, tag_GlyphData)))))
		return 0;

	if (head->indexToLocFormat == SHORT_INDEX_TO_LOC_FORMAT)
	{	unsigned short* offset = (unsigned short*)loc + glyphIndex;
		*length = (long)(offset[1] - *offset) << 1;
		return glyphStart + ((long)*offset << 1);
	}
	else
	{	long* offset = (long*)loc + glyphIndex;
		*length = offset[1] - *offset;
		return glyphStart + *offset;
	}
}

/*************************************************************************/

void MoveGlyphOutline(GlyphOutline* out, Fixed xDelta, Fixed yDelta)
{
	Fixed* x = *out->x;
	Fixed* y = *out->y;
	short count = out->pointCount;

	for (--count; count >= 0; --count)
	{	*x++ += xDelta;
		*y++ += yDelta;
	}
	out->origin.x += xDelta;
	out->origin.y += yDelta;
}

/*************************************************************************/

void AppendHandle(Handle dst, Handle extra)
{
	long dstSize = GetHandleSize(dst);
	long extraSize = GetHandleSize(extra);

	SetHandleSize(dst, dstSize + extraSize);
	if (MemError())
		Debugger();
	else
		BlockMove(*extra, *dst + dstSize, extraSize);
}

#define APPENDHANDLE(a,b)	AppendHandle((Handle)a, (Handle)b)

/*************************************************************************/

void AppendGlyphOutline(GlyphOutline* a, GlyphOutline* b)
{
	APPENDHANDLE(a->endPoints, b->endPoints);
	{	short* p = *a->endPoints + a->contourCount;
		short* endp = p + b->contourCount;
		short newFirstPoint = a->contourCount ? p[-1] + 1 : 0;
		for (; p < endp; p++)
			*p = *p + newFirstPoint;
	}
	a->contourCount += b->contourCount;
	a->pointCount += b->pointCount;
	APPENDHANDLE(a->onCurve, b->onCurve);
	APPENDHANDLE(a->x, b->x);
	APPENDHANDLE(a->y, b->y);
}

/*************************************************************************/

/*	Glue routine and Macro to make handle growing easier.*/

inline short NiceSetHandleSize(Handle h, long size)
{
	SetHandleSize(h, size);
	return MemError();
}

#define SHS(h, s)	NiceSetHandleSize((Handle)h, s)

/*************************************************************************/

/*	Returns the glyph index for the given character code, or
 *	an error code.
 */
long GetCharGlyphIndex(Handle sfnt, unsigned short charCode)
{
	sfnt_char2IndexDirectory* table;
	short i;
	long mapOffset = 0;
	long glyphIndex = 0;		/* missing character glyph */
	short state = GetFontState(sfnt);

	if (!( 0 != (table = (sfnt_char2IndexDirectory*) GetSfntTablePtr(sfnt, tag_CharToIndexMap))))
	{	SetFontState(sfnt, state);
		return PostFontError(fTableNotFound);
	}

	{	register sfnt_platformEntry* plat = table->platform;

		/* You can change this section to look for other scripts
		*/
		for ( i = table->numTables - 1; i >= 0; --i )
		{	if ( plat->platformID == plat_Macintosh && plat->specificID == smRoman)
			{	mapOffset = plat->offset;
				break;
			}
			++plat;
		}
	}

	if (mapOffset)
	{	sfnt_mappingTable* mapping = (sfnt_mappingTable*)((char*)table + mapOffset);

		switch ( mapping->format ) {
		case 0:
			{	BYTE* glyphs = (BYTE*)(mapping + 1);
				glyphIndex = glyphs[charCode];
			}
			break;
		case 6:
			{	short* glyphs = (short*)(mapping + 1);
				short first = *glyphs++;
				short count = *glyphs++;
				charCode -= first;
				if (charCode < count)
					glyphIndex = glyphs[charCode];
			}
			break;
		default:
			glyphIndex = PostFontError(fUnimplemented);
		}
	}
	else
		glyphIndex = PostFontError(fCMapNotFound);

	SetFontState(sfnt, state);
	return glyphIndex;
}

/*************************************************************************/

#define GetUnsignedByte( p ) ((BYTE)(*p++))

/*************************************************************************/

FontError GetGlyphOutline(Handle hSfnt, long glyphIndex, GlyphOutline* pOutline, Matrix xform)
{
	short upem, state, sideBearing, adjustToLsb;
	short* pGlyph;
	sfnt_FontHeader* pHead;
	sfnt_HorizontalHeader* pHHea;
	sfnt_HorizontalMetrics* pHori;
	long length;
	FontError error = fNoError;

	state = GetFontState( hSfnt );
	HLock( hSfnt );

	if (!((0 != (pHead = (sfnt_FontHeader*) GetSfntTablePtr(hSfnt, tag_FontHeader))) &&
		  (0 != (pHHea = (sfnt_HorizontalHeader*) GetSfntTablePtr(hSfnt, tag_HoriHeader))) &&
		  (0 != (pHori = (sfnt_HorizontalMetrics*) GetSfntTablePtr(hSfnt, tag_HorizontalMetrics)))))
	{
		error = fTableNotFound;
		goto EXIT;
	}

	upem = pHead->unitsPerEm;

	{	long longMetrics = pHHea->numberLongMetrics;
		if ( glyphIndex < longMetrics )
		{	pOutline->advance.x = FixRatio( pHori[glyphIndex].advance, upem );
			sideBearing = pHori[glyphIndex].sideBearing;
		}
		else
		{	short *lsb = (short *)&pHori[longMetrics]; /* first entry after[AW,LSB] array */

			pOutline->advance.x = FixRatio( pHori[longMetrics-1].advance, upem );
			sideBearing = pHori[glyphIndex - longMetrics].sideBearing;
		}
		pOutline->advance.y = 0;
	}

	pOutline->origin.x = pOutline->origin.y = 0;

	if (!(pGlyph = (short*) GetSfntGlyphPtr(hSfnt, glyphIndex, &length)))
	{	error = fGlyphNotFound;
		goto EXIT;
	}

	if (length == 0)
	{	pOutline->contourCount = pOutline->pointCount = 0;
		goto EXIT;
	}

	pOutline->contourCount = *pGlyph++;
	adjustToLsb = *pGlyph - sideBearing;		/* xmin - lsb */
	pGlyph += 4;						/* skip bounds rect */

	if (pOutline->contourCount == 0)
		pOutline->pointCount = 0;
	else if (pOutline->contourCount == -1)
	{	short flags, index, newMatrix;

		pOutline->contourCount = pOutline->pointCount = 0;
		SHS(pOutline->endPoints, 0);
		SHS(pOutline->onCurve, 0);
		SHS(pOutline->x, 0);
		SHS(pOutline->y, 0);
		do
		{	Matrix compXform;
			short arg1, arg2;

			flags = *pGlyph++;
			index = *pGlyph++;
			newMatrix = false;

			if ( flags & ARG_1_AND_2_ARE_WORDS )
			{	arg1 = *pGlyph++;
				arg2 = *pGlyph++;
			}
			else
			{	char* byteP = (char*)pGlyph;
				if ( flags & ARGS_ARE_XY_VALUES )
				{	/* offsets are signed */
					arg1 = *byteP++;
					arg2 = *byteP;
				}
				else
				{	/* anchor points are unsigned */
					arg1 = (unsigned char)*byteP++;
					arg2 = (unsigned char)*byteP;
				}
				++pGlyph;
			}
			{	GlyphOutline out;
				InitGlyphOutline(&out);
				GetGlyphOutline(hSfnt, index, &out, newMatrix ? compXform : xform);
				{	Fixed dx, dy;
					if (flags & ARGS_ARE_XY_VALUES)
					{	dx = FixRatio(arg1, upem);
						dy = -FixRatio(arg2, upem);
					}
					else
					{	dx = (*pOutline->x)[arg1] - (*out.x)[arg2];
						dy = (*pOutline->y)[arg1] - (*out.y)[arg2];
					}
					MoveGlyphOutline(&out, dx, dy);
				}
				AppendGlyphOutline(pOutline, &out);
				KillGlyphOutline(&out);
			}
		} while (flags & MORE_COMPONENTS);
	}
	else if (pOutline->contourCount > 0)
	{	/*	Load in the end points.
		 */
		{	long size = pOutline->contourCount * sizeof(short);

			if (SHS(pOutline->endPoints, size))
			{	error = fMemoryError;
				goto EXIT;
			}
			BlockMove( (MAC_Ptr)pGlyph, (MAC_Ptr)*pOutline->endPoints, size );
			pGlyph += pOutline->contourCount;
		}

		pOutline->pointCount = (*pOutline->endPoints)[pOutline->contourCount - 1] + 1;
		if (SHS(pOutline->onCurve, pOutline->pointCount * sizeof(char)))
		{	error = fMemoryError;
			goto EXIT;
		}
		if (SHS(pOutline->x, pOutline->pointCount * sizeof(Fixed)))
		{	error = fMemoryError;
			goto EXIT;
		}
		if (SHS(pOutline->y, pOutline->pointCount * sizeof(Fixed)))
		{	error = fMemoryError;
			goto EXIT;
		}

		/*	Skip the word for instruction count + the instructions.
		 *	Then load in the onCurve bytes.
		 */
		{	BYTE* p = (BYTE*)pGlyph + sizeof(short) + *pGlyph;
			BYTE* onCurve = *pOutline->onCurve;
			BYTE* stop = onCurve + pOutline->pointCount;
			BYTE flag;

			while (onCurve < stop)
			{	*onCurve++ = flag = GetUnsignedByte( p );
				if ( flag & REPEAT_FLAGS ) {
					short count = GetUnsignedByte( p );
					for (--count; count >= 0; --count)
						*onCurve++ = flag;
				}
			}
			/*	Lets do X
			*/
			{	short coord = adjustToLsb;
				Fixed* x = *pOutline->x;

				onCurve = *pOutline->onCurve;
				while (onCurve < stop)
				{	if ( (flag = *onCurve++) & XSHORT ) {
						if ( flag & SHORT_X_IS_POS )
							coord += GetUnsignedByte( p );
						else
							coord -= GetUnsignedByte( p );
					}
					else if ( !(flag & NEXT_X_IS_ZERO) )
					{	coord += (short)(*p++) << 8;
						coord += (BYTE)*p++;
					}
					*x++ = FixRatio( coord, upem );
				}
			}
			/*	Lets do Y
			*/
			{	short coord = 0;
				Fixed* y = *pOutline->y;

				onCurve = *pOutline->onCurve;
				while (onCurve < stop)
				{	if ( (flag = *onCurve) & YSHORT ) {
						if ( flag & SHORT_Y_IS_POS )
							coord += GetUnsignedByte( p );
						else
							coord -= GetUnsignedByte( p );
					}
					else if ( !(flag & NEXT_Y_IS_ZERO) )
					{	coord += (short)(*p++) << 8;
						coord += (BYTE)*p++;
					}
					*y++ = -FixRatio( coord, upem );

					/*	Filter off the extra bits
					*/
					*onCurve++ = flag & ONCURVE;
				}
			}
		}
	}
	else
		error = fUnimplemented;
EXIT:
	SetFontState( hSfnt, state );

	return PostFontError(error);
}

/*************************************************************************/

static long* PackControlBits(long* p, BYTE * onCurve, long count)
{
	unsigned long mask = 0x80000000;

	*p = 0;
	while (count--)
	{	if (!mask)
		{	mask = 0x80000000;
			*++p = 0;
		}
		if (!*onCurve++)
			*p |= mask;
		mask >>= 1;
	}
	return p + 1;
}

/*************************************************************************/

void ScaleGlyphOutline(GlyphOutline* out, Fixed xScale, Fixed yScale)
{
	Fixed* x = *out->x;
	Fixed* y = *out->y;
	short count = out->pointCount;

	for (--count; count >= 0; --count)
	{	*x = FixMul( *x, xScale );
		x++;
		*y = FixMul( *y, yScale );
		y++;
	}
	out->origin.x = FixMul( out->origin.x, xScale );
	out->origin.y = FixMul( out->origin.y, yScale );
	out->advance.x = FixMul( out->advance.x, xScale );
	out->advance.y = FixMul( out->advance.y, yScale );
}

// =======================================================================

// -----------------------------------------------------------------------

// -----------------------------------------------------------------------

ULONG ImplIncreaseArrays( ULONG nSize, SalPoint** ppPoints, BYTE** ppFlags, ULONG nIncSize )
{
	const ULONG nOldSize = nSize;
	SalPoint*	pNewPoints = new SalPoint[ nSize += nIncSize ];
	BYTE*		pNewFlags = new BYTE[ nSize ];

	if( *ppPoints )
	{
		memcpy( pNewPoints, *ppPoints, nOldSize * sizeof( SalPoint ) );
		memset( pNewPoints + nOldSize, 0, nIncSize * sizeof( SalPoint ) );
		delete[] *ppPoints;
	}
	else
		memset( pNewPoints, 0, nSize * sizeof( SalPoint ) );

	if( *ppFlags )
	{
		memcpy( pNewFlags, *ppFlags, nOldSize );
		memset( pNewFlags + nOldSize, 0, nIncSize );
		delete[] *ppFlags;
	}
	else
		memset( pNewFlags, 0, nSize );

	*ppPoints = pNewPoints;
	*ppFlags = pNewFlags;

	return nSize;
}

// -----------------------------------------------------------------------

BOOL SalGraphics::GetGlyphBoundRect( xub_Unicode cChar, long* pX, long* pY,
									 long* pWidth, long* pHeight )
{
	DBG_ERROR( "SalGraphics::GetGlyphBoundRect NYI" );
	return FALSE;
}

// -----------------------------------------------------------------------

ULONG SalGraphics::GetGlyphOutline( xub_Unicode cChar, USHORT** pPolySizes,
									SalPoint** ppPoints, BYTE** ppFlags )
{
	maGraphicsData.CheckDrawMode( DRAW_TEXT );

	short		style = maGraphicsData.mnFontFace;
	XubString	aFontName = ImplGetFontName( maGraphicsData.mnFontNum );

	Handle hSfnt = GetNamedSfntHandle( aFontName, style );

	if ( ! hSfnt && style ) // Font liegt vielleicht nur in der Grundform vor ?
		hSfnt = GetNamedSfntHandle( aFontName, 0 );

	if ( ! hSfnt )
		return NULL;
	
	FMetricRec aMetrics;
	FontMetrics( &aMetrics );
	long nBaseLineOffset = FixedToInt( aMetrics.ascent );
	long nOrgHeight = maGraphicsData.mnHeight;

	unsigned nState = HGetState( hSfnt );
	HNoPurge( hSfnt );

	GlyphOutline out;

	InitGlyphOutline( &out );

	// Index des Glyphes besorgen
	long glyphIndex = GetCharGlyphIndex( hSfnt, cChar );

	// Glyph in Outline umwandlen
	::GetGlyphOutline( hSfnt, glyphIndex, &out, 0 );

	ScaleGlyphOutline( &out, ff(nOrgHeight), ff(nOrgHeight) );

	// Im Outline steht jetzt wieviele contouren wir haben
	// so gro muss alos unser Ergebnis sein
	ULONG nContourCount = out.contourCount;

	SalPoint	aPoint;
	ULONG		nPtSize = GLYPH_INC;
	SalPoint*	pPoints = new SalPoint[ GLYPH_INC ];
	BYTE*		pFlags = new BYTE[ GLYPH_INC ];

	*pPolySizes = new USHORT[ nContourCount ];

	long	nTotalAnz	= 0;
	long	nCurPos		= 0;
	Fixed	*pX = *out.x;
	Fixed	*pY = *out.y;

	for ( int i = 0; i < nContourCount; i++ )
	{
		long	nFirstPos	= nTotalAnz;
		long	nPointAnz	= 0;
		BOOL	bCloseIt	= TRUE;

		while( nCurPos <= (*out.endPoints)[i] )
		{
			CHECKPOINTS( nTotalAnz+1 );
			aPoint.mnX = (long) FixedToInt( *pX );
			aPoint.mnY = (long) FixedToInt( *pY ) + nBaseLineOffset;
			pFlags[ nTotalAnz ] = 0;
			pPoints[ nTotalAnz++ ] = aPoint;
			nPointAnz += 1;

			/* Wenn Off Curve Points ins Spiel kommen, wirds leider etwas
			 * komplizierter
			 */
			if ( ! (*out.onCurve)[ nCurPos ] )
			{
				CHECKPOINTS( nTotalAnz+5 );
				/* Es gibt wohl wirklich polygone, die mit einem Off
				 * Curve Point anfangen.
				 */
				if ( nPointAnz == 1 )
				{
					Fixed nX = (*out.x)[ (*out.endPoints)[i] ];
					Fixed nY = (*out.y)[ (*out.endPoints)[i] ];

					aPoint.mnX = (long) FixedToInt( nX );
					aPoint.mnY = (long) FixedToInt( nY ) + nBaseLineOffset;

					pFlags[ nTotalAnz ] = 0;
					pPoints[ nTotalAnz ] = pPoints[ nFirstPos ];
					pPoints[ nFirstPos ] = aPoint;
					nTotalAnz++;
					nPointAnz++;
					bCloseIt = FALSE;
				}

				// Punkt verdoppeln fuer Bezier-Wandlung
				pFlags[ nTotalAnz ] = 0;
				pPoints[ nTotalAnz ] = pPoints[ nTotalAnz - 1];
				nTotalAnz++;
				nPointAnz++;

				/* Wenn Polygone mit Off Curve Points anfangen, dann hoeren
				 * sie sicherlich auch mal damit auf
				 */
				if ( nCurPos == (*out.endPoints)[i] )
				{
					pFlags[ nTotalAnz ] = 0;
					pPoints[ nTotalAnz++ ] = pPoints[ nFirstPos ];
					nPointAnz++;
					bCloseIt = FALSE;
				}
				else if ( (*out.onCurve)[ nCurPos + 1 ] )
				{
					/* Wenn der naechste Punkt auf der Kurve liegt, dann
					 * braucht er nur in unser Polygon eingetragen zu werden
					 */
					pX++;
					pY++;
					aPoint.mnX = (long) FixedToInt( *pX );
					aPoint.mnY = (long) FixedToInt( *pY ) + nBaseLineOffset;
					pFlags[ nTotalAnz ] = 0;
					pPoints[ nTotalAnz++ ] = aPoint;
					nPointAnz++;
					nCurPos++;
				}
				else
				{
					/* ansonsten muessen wir noch einen weiteren Punkt
					 * mit aufnehmen. ( Und zwar den Mittelpunkt zwischen
					 * den beiden Kontrollpunkten. )
					 */
					aPoint.mnX = (long) FixedToInt( ( *pX + *(pX+1) ) / 2 );
					aPoint.mnY = (long) FixedToInt( ( *pY + *(pY+1) ) / 2 );
					aPoint.mnY += nBaseLineOffset;

					pFlags[ nTotalAnz ] = 0;
					pPoints[ nTotalAnz++ ] = aPoint;
					nPointAnz++;
				}
				/* Umrechnung in Bezier (PQ=TrueType-Controlpunkt):
				 * P1 = 1/3 * (P0 + 2 * PQ)
				 * P2 = 1/3 * (P3 + 2 * PQ)
				 */
				pPoints[ nTotalAnz-3 ].mnX = ( pPoints[ nTotalAnz-4 ].mnX +
											   pPoints[ nTotalAnz-3 ].mnX * 2 ) / 3;
				pPoints[ nTotalAnz-3 ].mnY = ( pPoints[ nTotalAnz-4 ].mnY +
											   pPoints[ nTotalAnz-3 ].mnY * 2 ) / 3;
				pPoints[ nTotalAnz-2 ].mnX = ( pPoints[ nTotalAnz-1 ].mnX +
											   pPoints[ nTotalAnz-2 ].mnX * 2 ) / 3;
				pPoints[ nTotalAnz-2 ].mnY = ( pPoints[ nTotalAnz-1 ].mnY +
											   pPoints[ nTotalAnz-2 ].mnY * 2 ) / 3;
				pFlags[ nTotalAnz-3 ] = 2;	//  == POLY_CONTROL 
				pFlags[ nTotalAnz-2 ] = 2;
			}
			pX++;
			pY++;
			nCurPos += 1;
		}

		// Polygon schliessen
		if ( bCloseIt )
		{
			pFlags[ nTotalAnz ] = 0;
			pPoints[ nTotalAnz++ ] = pPoints[ nFirstPos ];
			nPointAnz++;
		}

		(*pPolySizes)[i] = nPointAnz;
	}

	KillGlyphOutline( &out );

	HSetState( hSfnt, nState );

	*ppPoints = pPoints;
	*ppFlags = pFlags;

	return nContourCount;
}
