/*
	File:		sv.r

	Contains:	Resourcen die JEDE StarView Applikation braucht

	Written by:	KH,DV

	Copyright:	 1995 ,	Star Division GmbH, alle Rechte vorbehalten

	Change History (most recent first):

	   <13+>	  25.09.96	RG		6 Neue Pointer 154, 155, 156, 159, 160, 161
	   <12+>	  08.03.96	KH		Der Error Alert ist zu klein fr die Meldung des SFX
	   <11+>	  04.03.96	WKC		1995 -> 1996
		<11>	  09.02.96	KH		Einer war doppelt
		<9+>	  08.02.96	KH		SV_CROSS_CURS nicht mehr aus System
		 <9>	  08.02.96	KH		POINTER_FILL wie im Writer
		<7+>	  07.12.95	DV		Neuer Pointer Pen
		<6+>	  21.11.95	WKC		neuer VersionsNr Parameter
		<5+>	  20.11.95	WKC		resource 'vers' (2) Star Office component
		 <5>	  08.11.95	KH		PathDialog ist entfallen
		<4+>	  08.11.95	KH		Neu ppats und PAT#s fuer gestrichelte Linien
		<3+>	  05.10.95	KH		MemAlert raus
		<2+>	  21.09.95	DV		Pattern UpDiag und DownDiag vertauscht
		<1+>	  09.08.95	KH		WDEF mit grossem und kleinem SizeGadget

	To Do:
*/

#define SystemSevenOrLater 1

#include "SysTypes.r"
#include "Types.r"

#ifndef OFFICEAPPVERS
	#define OFFICEAPPVERS 0x02,0x045,beta,0x00
#endif

#ifndef APPVERSION
	#define APPVERSION $$SHELL("SV_OFFVERSION")
#endif

resource 'vers' (1) {
	OFFICEAPPVERS,													/* 0x02,0x045,beta,0x00,*/
	verGermany,														/* Region code			*/
	APPVERSION,														/* Folder version number*/
	APPVERSION",  Star Division GmbH, 1992-1997"					/* Long version number	*/
};

resource 'vers' (2) {
	OFFICEAPPVERS,													/* 0x02,0x045,beta,0x00,*/
	verGermany,														/* Region code			*/
	APPVERSION,														/* Folder version number*/
	"A StarOffice component"										/* Short version number	*/
};

resource 'CURS' (128,preload)	// Schmiert sonst weg in ??? (DV)
{								// SV_HELP_CURS
	$"0000 3E00 7F00 6300 6300 0600 0C00 1800"
	$"1800 0000 1800 18",
	$"3E00 7F00 FF80 FF80 FF80 FF00 1E00 3C00"
	$"3C00 3C00 3C00 3C00 3C",
	{4, 4}
};

resource 'CURS' (129) {		// SV_CROSS_CURS
	$"0000 0200 0200 0200 0200 0200 7FF0 0200"
	$"0200 0200 0200 0200 02",
	$"0200 0700 0700 0700 0700 7FF0 FFF8 7FF0"
	$"0700 0700 0700 0700 0700 02",
	{6, 6}
};

resource 'CURS' (130) {		// POINTER_MOVE
	$"0000 0100 0380 07C0 0100 1110 3118 7FFC"
	$"3118 1110 0100 07C0 0380 01",
	$"0100 0380 07C0 0FE0 17D0 3BB8 7BFC FFFE"
	$"7FFC 3BB8 17D0 0FE0 07C0 0380 01",
	{7, 7}
};

resource 'CURS' (131) {		// POINTER_HSIZE
	$"0000 0000 0000 0000 0000 0000 1008 300C"
	$"7FFE 300C 1008",
	$"0000 0000 0000 0000 0000 1818 381C 7FFE"
	$"FFFF 7FFE 381C 1818",
	{8, 7}
};

resource 'CURS' (132) {		// POINTER_VSIZE
	$"0000 0100 0380 07C0 0100 0100 0100 0100"
	$"0100 0100 0100 0100 07C0 0380 01",
	$"0100 0380 07C0 0FE0 0FE0 0380 0380 0380"
	$"0380 0380 0380 0FE0 0FE0 07C0 0380 01",
	{8, 7}
};

resource 'CURS' (133) {		// POINTER_NESWSIZE
	$"0000 0000 007C 003C 001C 002C 0044 0080"
	$"0100 2200 3400 3800 3C00 3E",
	$"0000 007E 00FE 007E 003E 007E 00EE 01C4"
	$"2380 7700 7E00 7C00 7E00 7F00 7E",
	{7, 7}
};

resource 'CURS' (134) {		// POINTER_NWSESIZE
	$"0000 0000 3E00 3C00 3800 3400 2200 0100"
	$"0080 0044 002C 001C 003C 007C",
	$"0000 7E00 7F00 7E00 7C00 7E00 7700 2380"
	$"01C4 00EE 007E 003E 007E 00FE 007E",
	{7, 7}
};

resource 'CURS' (135) {		// POINTER_HSPLIT
	$"0000 06C0 06C0 06C0 06C0 26C8 66CC FEFE"
	$"66CC 26C8 06C0 06C0 06C0 06C0",
	$"0FE0 0FE0 0FE0 0FE0 3FF8 7FFC FFFE FFFE"
	$"FFFE 7FFC 3FF8 0FE0 0FE0 0FE0 0FE0",
	{7, 7}
};

resource 'CURS' (136) {		// POINTER_VSPLIT
	$"0000 0100 0380 07C0 0100 0100 7FFC 7FFC"
	$"0000 7FFC 7FFC 0100 0100 07C0 0380 01",
	$"0000 0380 07C0 0FE0 0FE0 FFFE FFFE FFFE"
	$"FFFE FFFE FFFE FFFE 0FE0 0FE0 07C0 0380",
	{7, 7}
};

resource 'CURS' (137) {		// POINTER_HSIZEBAR
	$"0000 0000 0180 0180 0180 0180 1188 318C"
	$"7FFE 318C 1188 0180 0180 0180 0180",
	$"0000 03C0 03C0 03C0 03C0 1BD8 3BDC 7FFE"
	$"FFFF 7FFE 3BDC 1BD8 03C0 03C0 03C0 03C0",
	{8, 7}
};

resource 'CURS' (138) {		// POINTER_VSIZEBAR
	$"0000 0100 0380 07C0 0100 0100 0100 7FFC"
	$"7FFC 0100 0100 0100 07C0 0380 01",
	$"0100 0380 07C0 0FE0 0FE0 0380 FFFE FFFE"
	$"FFFE FFFE 0380 0FE0 0FE0 07C0 0380 01",
	{8, 7}
};

resource 'CURS' (139) {		// POINTER_HAND
	$"0180 1A70 2648 264A 124D 1249 6809 9801"
	$"8802 4002 2002 2004 1004 0808 0408 0408",
	$"0180 1BF0 3FF8 3FFA 1FFF 1FFF 6FFF FFFF"
	$"FFFE 7FFE 3FFE 3FFC 1FFC 0FF8 07F8 07F8",
	{9, 8}
};

resource 'CURS' (140) {		// POINTER_REFHAND
	$"0000 1800 2400 2580 1270 124C 080A 0802"
	$"1802 2002 2002 2004 1004 0808 0408 0408",
	$"0000 1800 3C00 3D80 1FF0 1FFC 0FFE 0FFE"
	$"1FFE 3FFE 3FFE 3FFC 1FFC 0FF8 07F8 07F8",
	{2, 3}
};

resource 'CURS' (141) {		// POINTER_PEN
	$"00E0 0110 0210 0320 04E0 0440 0840 0880"
	$"1080 1100 1900 1E00 1C00 1800 10",
	$"00E0 01F0 03F0 03E0 07E0 07C0 0FC0 0F80"
	$"1F80 1F00 1F00 1E00 1C00 1800 10",
	{14, 3}
};

resource 'CURS' (142) {		// POINTER_MAGNIFY
	$"0F00 30C0 4020 4C20 9010 9010 8090 8090"
	$"4320 4020 30F0 0F38 001C 000E 0007 0002",
	$"0F00 3FC0 7FE0 7FE0 FFF0 FFF0 FFF0 FFF0"
	$"7FE0 7FF0 3FF8 0F7C 003E 001F 000F 0007",
	{5, 5}
};

resource 'CURS' (143) {		// POINTER_FILL
	$"6000 59C0 2FE0 3FF0 1F78 38BC 785E 742F"
	$"EA17 C50B C286 C14C 80B8 8070 8000 80",
	$"6000 79C0 3FE0 3FF0 1FF8 3FFC 7FFE 7FFF"
	$"EFFF C7FF C3FE C1FC 80F8 8070 8000 80",
	{15, 0}
};

resource 'CURS' (144) {		// POINTER_ROTATE
	$"0000 0100 0180 07C0 0980 1100 2008 201C"
	$"203E 2008 2008 1010 0820 07C0",
	$"0300 0380 0FC0 1FE0 3FC0 7F88 7B1C 703E"
	$"707F 707F 701C 783C 3FF8 1FF0 0FE0",
	{8, 7}
};

resource 'CURS' (145) {		// POINTER_HSHEAR
	$"0000 0000 0000 0000 0800 1800 3FF8 1800"
	$"0810 0018 1FFC 0018 0010",
	$"0000 0000 0000 0C00 1C00 3FFC 7FFC 3FFC"
	$"1C38 3FFC 3FFE 3FFC 0038 0030",
	{8, 8}
};

resource 'CURS' (146) {		// POINTER_VSHEAR
	$"0000 0000 0020 0270 02F8 0220 0220 0220"
	$"0220 0220 0220 0FA0 0720 02",
	$"0000 0020 0770 07F8 07FC 07FC 0770 0770"
	$"0770 0770 1FF0 1FF0 0FF0 0770 02",
	{8, 8}
};

resource 'CURS' (147) {		// POINTER_MIRROR
	$"0000 0004 3C0A 2404 2410 2420 2440 3C80"
	$"0100 0200 04FC 0884 2084 50FC 20",
	$"0004 7E0E 7E1F 7E1E 7E3C 7E70 7EE0 7FC0"
	$"7F80 07FE 0FFE 3DFE 79FE F9FE 71FE 20",
	{8, 7}
};

resource 'CURS' (148) {		// POINTER_CROOK
	$"0000 0000 0000 0000 0100 2108 2108 1110"
	$"1010 07C0 1830 3018 2008 4004 4004",
	$"0000 0000 0000 0100 2388 739C 739C 3BB8"
	$"3FF8 1FF0 3FF8 783C 701C E00E E00E 4004",
	{7, 7}
};

resource 'CURS' (149) {		// SV_CROP_CURS
	$"0000 0020 0020 0020 0FAC 0820 0820 0820"
	$"0820 0820 6BE0 0800 0800 08",
	$"0070 0070 0070 1FFE 1FFE 1FFE 1C70 1C70"
	$"1C70 FFF0 FFF0 FFF0 1C00 1C00 1C",
	{7, 7}
};

resource 'CURS' (150) { 	// SV_MOVEPOINT_CURS
	$"0000 4000 6000 7000 7800 7C00 7E00 7F00"
	$"7FBE 7C22 6C22 4622 063E 0300 03",
	$"C000 E000 F000 F800 FC00 FE00 FF00 FFFF"
	$"FFFF FFFF FE7F EF7F CF7F 87FF 0780 03",
	{1, 1}
};


resource 'CURS' (151) { 	// SV_MOVEBEZIERWEIGHT_CURS
	$"0000 4000 6000 5000 4800 4400 4200 4300"
	$"4F80 7C00 6C00 4600 0600 0300 03",
	$"C000 E000 F000 F800 FC00 FE00 FF00 FF80"
	$"FFC0 FFE0 FE00 EF00 CF00 8780 0780 03",
	{1, 1}
};


resource 'CURS' (152) {		// SV_MOVEDATA_CURS
	$"0000 4000 6000 7000 7800 7C00 7E54 7FAA"
	$"7F84 7C02 6C04 6602 1604 2BAA 1754",
	$"C000 E000 F000 F800 FC00 FE00 FFFE FFFE"
	$"FF86 FC06 FE06 FF06 BF06 3FFE 3FFE 0380",
	{1, 1}
};

resource 'CURS' (153) {		// SV_COPYDATA_CURS
	$"0000 4030 6048 7040 7848 7C30 7E54 7FAA"
	$"7F84 7C02 6C04 6602 1604 2BAA 1754",
	$"C078 E0FC F0FC F8E8 FCFC FEFC FFFE FFFE"
	$"FF86 FC06 FE06 FF06 BF06 3FFE 3FFE 0380",
	{1, 1}
};

resource 'CURS' (154) {		// SV_LINKDATA_CURS
	$"0000 4030 6030 7030 7830 7C30 7E3C 7FBC"
	$"7F80 7C02 6C04 6602 1604 2BAA 1754 0000",
	$"C078 E078 F078 F878 FC78 FE7E FFFE FFFE"
	$"FF86 FC06 FE06 FF06 BF06 3FFE 3FFE 0380",
	{1, 1}
};

resource 'CURS' (155) {		// SV_MOVEDATALINK_CURS
	$"0000 4004 6004 7004 7804 7C07 7E50 7FAA"
	$"7F84 7C02 6C04 6602 1604 2BAA 1754 0000",
	$"C00E E00E F00E F80E FC0F FE0F FFFF FFFE"
	$"FF86 FC06 FE06 FF06 BF06 3FFE 3FFE 0380",
	{1, 1}
};

resource 'CURS' (156) {		// SV_COPYDATALINK_CURS
	$"0000 4034 604C 7044 784C 7C37 7E54 7FAA"
	$"7F84 7C02 6C04 6602 1604 2BAA 1754 0000",
	$"C07E E0FE F0FE F8FE FCFF FEFF FFFF FFFE"
	$"FF86 FC06 FE06 FF06 BF06 3FFE 3FFE 0380",
	{1, 1}
};


resource 'CURS' (157) {		// SV_MOVEFILE_CURS
	$"0000 3F00 2180 2140 21E0 2820 2C20 2E20"
	$"2F20 2FA0 2FE0 2B20 3FE0 0180 0180",
	$"7F80 7FC0 7FE0 7FF0 7FF0 7FF0 7FF0 7FF0"
	$"7FF0 7FF0 7FF0 7FF0 7FF0 7FF0 03C0 03C0",
	{5, 4}
};

resource 'CURS' (158) {		// SV_COPYFILE_CURS
	$"0000 3F06 2189 2148 21E8 2829 2C26 2E20"
	$"2F20 2FA0 2FE0 2B20 3FE0 0180 0180",
	$"7F8F 7FDF 7FFF 7FFF 7FFF 7FFF 7FFF 7FFF"
	$"7FF0 7FF0 7FF0 7FF0 7FF0 7FF0 03C0 03C0",
	{5, 4}
};

resource 'CURS' (159) {		// SV_LINKFILE_CURS
	$"0000 3F00 2180 2140 21EC 282C 2C2C 2E2C"
	$"2F2C 2FAF 2FEF 2B20 3FE0 0180 0180 0000",
	$"7F80 7FC0 7FE0 7FF0 7FFE 7FFE 7FFE 7FFE"
	$"7FFE 7FFF 7FFF 7FFF 7FF0 7FF0 03C0 03C0",
	{5, 4}
};

resource 'CURS' (160) {		// SV_MOVEFILELINK_CURS
	$"0000 3F00 2180 2140 21E0 2820 2C20 2E20"
	$"2F28 2FA8 2FE8 2B28 3FEE 0180 0180 0000",
	$"7F80 7FC0 7FE0 7FF0 7FF0 7FF0 7FF0 7FFF"
	$"7FFF 7FFF 7FFF 7FFF 7FFF 7FFF 03C0 03C0",
	{5, 4}
};

resource 'CURS' (161) {		// SV_COPYFILELINK_CURS
	$"0000 3F06 2189 2148 21E8 2829 2C26 2E20"
	$"2F28 2FA8 2FE8 2B28 3FEE 0180 0180 0000",
	$"7F8F 7FDF 7FFF 7FFF 7FFF 7FFF 7FFF 7FFF"
	$"7FFF 7FFF 7FFF 7FFF 7FFF 7FFF 03C0 03C0",
	{5, 4}
};


resource 'CURS' (162) {		// SV_MOVEFILES_CURS
	$"0000 1F80 10C0 50A0 50F0 5410 5610 5710"
	$"5790 57D0 57F0 5590 5FF0 40C0 7EC0",
	$"3F80 3FC0 FFE0 FFF0 FFF8 FFF8 FFF8 FFF8"
	$"FFF8 FFF8 FFF8 FFF8 FFF8 FFF8 FFF0 FFF0",
	{6, 5}
};

resource 'CURS' (163) {		// SV_COPYFILES_CURS
	$"0000 1F86 10C9 50A8 50F8 5419 5616 5710"
	$"5790 57D0 57F0 5590 5FF0 40C0 7EC0",
	$"3F8F 3FDF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFF8 FFF8 FFF8 FFF8 FFF8 FFF8 FFF0 FFF0",
	{6, 5}
};

resource 'CURS' (164) {		// SV_NOTALLOWED_CURS
	$"0000 07C0 1FF0 3838 3C38 6E0C 670C 638C"
	$"61CC 60EC 3878 3838 1FF0 07C0",
	$"07C0 1FF0 3FF8 7FFC 7FFC FFFE FFFE FFFE"
	$"FFFE FFFE 7FFC 7FFC 3FF8 1FF0 07C0",
	{6, 5}
};

resource 'CURS' (165) {		//	SV_DRAW_LINE_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 0006"
	$"0018 0060 0180 06",
	$"3800 3800 FE00 EE00 FE00 3800 380F 003F"
	$"00FF 03FC 0FF0 0FC0 0F",
	{3, 3}
};

resource 'CURS' (166) {		//	SV_DRAW_RECT_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 0000"
	$"07FC 0404 0404 0404 0404 07FC",
	$"3800 3800 FE00 EE00 FE00 3800 3800 0000"
	$"07FC 07FC 060C 060C 07FC 07FC",
	{3, 3}
};

resource 'CURS' (167) {		//	SV_DRAW_POLYGON_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 0400"
	$"0620 0650 0588 0590 0410",
	$"3800 3800 FE00 EE00 FE00 3800 3C00 0E70"
	$"0CF8 0FFC 0FFC 0FFC 0FF8 0E38",
	{3, 3}
};

resource 'CURS' (168) {		//	SV_DRAW_BEZIER_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 0218"
	$"0120 00A0 0040 00A0 0090 0308",
	$"3800 3800 FE00 EE00 FE00 3800 3A1C 073C"
	$"03FC 01F0 00E0 01F0 07F8 079C 0708",
	{3, 3}
};

resource 'CURS' (169) {		//	SV_DRAW_ARC_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 00E0"
	$"0110 0200 0200 0200 01",
	$"3800 3800 FE00 EE00 FE00 3800 38E0 01F0"
	$"03F8 0710 0700 0700 0380 01",
	{3, 3}
};

resource 'CURS' (170) {		//	SV_DRAW_PIE_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 00C0"
	$"0140 0240 0278 0208 0110 00E0",
	$"3800 3800 FE00 EE00 FE00 3800 38E0 01E0"
	$"03E0 07FC 07FC 07FC 03F8 01F0 00E0",
	{3, 3}
};

resource 'CURS' (171) {		//	SV_DRAW_CIRCLECUT_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 0080"
	$"0140 0220 0210 0208 0110 00E0",
	$"3800 3800 FE00 EE00 FE00 3800 3880 01C0"
	$"03E0 07F0 07F8 07FC 03F8 01F0 00E0",
	{3, 3}
};

resource 'CURS' (172) {		//	SV_DRAW_ELLIPSE_CURS
	$"0000 1000 1000 6C00 1000 1000 0000 00E0"
	$"0110 0208 0208 0208 0110 00E0",
	$"3800 3800 FE00 EE00 FE00 3800 38E0 01F0"
	$"03F8 07FC 07FC 07FC 03F8 01F0 00E0",
	{3, 3}
};

resource 'CURS' (173) {	// SV_DRAW_FREEHAND_CURS
	$"0000 1000 1000 6C00 1000 1000 0010 002C"
	$"0842 1640 1220 11A0 1040",
	$"3800 3800 FE00 EE00 FE00 3818 383C 087E"
	$"1EE7 3FE2 3FF0 3BF0 39E0 10",
	{3, 3}
};

resource 'CURS' (174) {		// POINTER_DRAW_CONNECT
	$"0000 1000 1000 6C00 1000 1000 0000 0000"
	$"0800 1400 0AFE 0182 0082 00FE",
	$"3800 3800 FE00 EE00 FE00 3800 3800 0800"
	$"1E00 37FF 1FFF 0B83 0183 01FF 01FF",
	{3, 3}
};

resource 'CURS' (175) {		// POINTER_DRAW_TEXT
	$"0000 1000 1000 6C00 1000 1000 0000 01B0"
	$"0040 0040 0040 0040 0040 0040 01B0",
	$"3800 3800 FE00 EE00 FE00 3800 3BF8 03F8"
	$"03F8 00E0 00E0 00E0 00E0 03F8 03F8 03F8",
	{3, 3}
};

resource 'CURS' (176) {		// POINTER_DRAW_CAPTION
	$"0000 1000 1000 6C00 1000 1000 0008 0074"
	$"0048 0040 0040 0040 0240 05C0 02",
	$"3800 3800 FE00 EE00 FE00 3808 38FC 00F6"
	$"00FC 00E8 00E0 02E0 07E0 0DE0 07E0 02",
	{3, 3}
};

resource 'CURS' (177) {    // POINTER_CHART
	$"0000 1000 1000 7C00 1000 1000 0078 0E48"
	$"0A48 0A4F 0BC9 0A49 0A49 0A49 0800 0FFF",
	$"3800 3800 FE00 FE00 FE00 3800 3878 0E78"
	$"0E78 0E7F 0FFF 0FFF 0FFF 0FFF 0FFF 0FFF",
	{3, 3}
};

resource 'CURS' (178) {    //POINTER_DETECTIVE
	$"0F00 30C0 4020 5F20 8E10 8410 8010 8F90"
	$"4720 4220 30F0 0F38 001C 000E 0007 0002",
	$"0F00 3FC0 7FE0 7FE0 FFF0 FFF0 FFF0 FFF0"
	$"7FE0 7FF0 3FF8 0F7C 003E 001F 000F 0007",
	{0, 6}
};

resource 'CURS' (179) {   //POINTER_PIVOTCOL
	$"0000 7FFE 4002 4002 7FFE 4082 4082 7FFE"
	$"0000 0040 0060 0070 0078 0074 0050 0008",
	$"FFFF FFFF FFFF FFFF FFFF FFFF FFFF FFFF"
	$"FFFF 00E0 00F0 00F8 00FC 00FE 00F8 00DC",
	{0, 0}
};

resource 'CURS' (180) {   //POINTER_PIVOTROW
	$"0000 7F00 4900 4900 4900 4900 4900 4F00"
	$"4900 4940 4960 4970 4978 4974 7F50 0008",
	$"FF00 FF00 FF00 FF00 FF00 FF00 FF00 FF00"
	$"FF80 FFE0 FFF0 FFF8 FFFC FFFE FFF8 FFDC",
	{0, 0}
};

resource 'CURS' (181) {   //POINTER_PIVOT_FIELD
	$"0000 3FFC 2004 2004 3FFC 0200 0300 0380"
	$"03C0 03E0 03F0 02C0 00E0 0060 0060",
	$"0000 3FFC 3FFC 3FFC 3FFC 0700 0780 07C0"
	$"07E0 07F0 07F8 07FC 05F0 00F0 00F0 0060",
	{5, 6}
};

resource 'CURS' (182) {		// POINTER_NULL
	$"",
	$"",
	{1, 1}
};

data 'ppat' (128) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 FFFF FFFF FFFF FFFF 0000 0000"            /* ........ */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 0000"            /* .........V...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"FFFF FFFF FFFF"                                     /*  */
};

data 'ppat' (129) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 FF00 0000 0000 0000 0000 0000"            /* ............... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 FF00"            /* .........V..... */
	$"0000 0000 0000 0000 0000 0000 0001 0000"            /* ................ */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};

data 'ppat' (130) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 8080 8080 8080 8080 0000 0000"            /* ........ */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 8080"            /* .........V.... */
	$"8080 8080 8080 0000 0000 0000 0001 0000"            /* .......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (131) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 FF80 8080 8080 8080 0000 0000"            /* ........ */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 FF80"            /* .........V.... */
	$"8080 8080 8080 0000 0000 0000 0001 0000"            /* .......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};

data 'ppat' (132) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 0182 4428 1028 4482 0000 0000"            /* .....D(.(D.... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 0182"            /* .........V..... */
	$"4428 1028 4482 0000 0000 0000 0001 0000"            /* D(.(D.......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (133) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 0102 0408 1020 4080 0000 0000"            /* ......... @.... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 0102"            /* .........V...... */
	$"0408 1020 4080 0000 0000 0000 0001 0000"            /* ... @.......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (134) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 8040 2010 0804 0201 0000 0000"            /* ....@ ......... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 8040"            /* .........V....@ */
	$"2010 0804 0201 0000 0000 0000 0001 0000"            /*  ............... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (135) {
	$"0001 0000 001C 0000 004E 0000 0000 0000"            /* .........N...... */
	$"0000 0000 0000 0000 0000 0000 0000 0000"            /* ................ */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 FFFF"            /* .........V...... */
	$"FFFF FFFF FFFF 0000 0000 0000 0001 0000"            /* .......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (136) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 77DD 77DD 77DD 77DD 0000 0000"            /* ....wwww.... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 77DD"            /* .........V....w */
	$"77DD 77DD 77DD 0000 0000 0000 0001 0000"            /* www.......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (137) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 AA55 AA55 AA55 AA55 0000 0000"            /* ....UUUU.... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 AA55"            /* .........V....U */
	$"AA55 AA55 AA55 0000 0000 0000 0001 0000"            /* UUU.......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (138) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 8822 8822 8822 8822 0000 0000"            /* ...."""".... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 8822"            /* .........V...." */
	$"8822 8822 8822 0000 0000 0000 0001 0000"            /* """.......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};

data 'ppat' (139) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 CCCC 3333 CCCC 3333 0000 0000"            /* ....3333.... */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 CCCC"            /* .........V.... */
	$"3333 CCCC 3333 0000 0000 0000 0001 0000"            /* 3333.......... */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};


data 'ppat' (140) {
	$"0001 0000 001C 0000 004E 0000 0000 FFFF"            /* .........N.... */
	$"0000 0000 F0F0 F0F0 0F0F 0F0F 0000 0000"            /* ............ */
	$"8001 0000 0000 0008 0008 0000 0000 0000"            /* ............... */
	$"0000 0048 0000 0048 0000 0000 0001 0001"            /* ...H...H........ */
	$"0001 0000 0000 0000 0056 0000 0000 F0F0"            /* .........V.... */
	$"F0F0 0F0F 0F0F 0000 0000 0000 0001 0000"            /* .............. */
	$"FFFF FFFF FFFF 0001 0000 0000 0000"                 /* ........ */
};

resource 'PAT#' (128) {
	{	/* array PatArray: 13 elements */
		/* [1] */
		$"FFFF FFFF FFFF FFFF",
		/* [2] */
		$"FF",
		/* [3] */
		$"8080 8080 8080 8080",
		/* [4] */
		$"FF80 8080 8080 8080",
		/* [5] */
		$"0182 4428 1028 4482",
		/* [6] */
		$"0102 0408 1020 4080",
		/* [7] */
		$"8040 2010 0804 0201",
		/* [8] */
		$"",
		/* [9] */
		$"77DD 77DD 77DD 77DD",
		/* [10] */
		$"AA55 AA55 AA55 AA55",
		/* [11] */
		$"8822 8822 8822 8822",
		/* [12] */
		$"CCCC 3333 CCCC 3333",
		/* [13] */
		$"F0F0 F0F0 0F0F 0F0F"
	}
};


resource 'ICON' (129, "????", purgeable) {
	$"FFFF FFFF 8000 0001 8000 0001 8000 0001"
	$"801F F801 807F FE01 80FF FF01 81F8 1F81"
	$"83E0 07C1 83C0 03C1 83C0 03C1 83C0 03C1"
	$"8180 0781 8000 0F01 8000 1E01 8000 3C01"
	$"8000 7801 8000 F001 8001 E001 8003 C001"
	$"8003 C001 8003 C001 8001 8001 8000 0001"
	$"8000 0001 8001 8001 8003 C001 8003 C001"
	$"8001 8001 8000 0001 8000 0001 FFFF FFFF"
};

resource 'clut' (128) {
	{	/* array ColorSpec: 4 elements */
		/* [1] */
		0, 0, 0,
		/* [2] */
		32178, 32178, 32178,
		/* [3] */
		0, 0, 0,
		/* [4] */
		32178, 32178, 32178
	}
};

resource 'STR#' (128, purgeable) {
	{
		"Unknown CPU",
		"No Application Object",
		"This program requires System 7",
		"Unable to load Shared Library",
		"This Program is designed for Power Macintosh only",	// eNoPPC
		"Star Division"											// eStarDivFolder
	}
};

resource 'MENU' (255) {
	255,
	textMenuProc,
	allEnabled,
	enabled,
	"Title",
	{	/* array: 2 elements */
		/* [1] */
		"Dummy1", noIcon, noKey, noMark, plain,
		/* [2] */
		"Dummy2", noIcon, noKey, noMark, plain
	}
};

#include "SV_Language.r"
#include "alerts.r"
