/*************************************************************************
 *
 *  $RCSfile: utility.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 15:18:18 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _UTILITY_HXX_
#define _UTILITY_HXX_ "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _OSL_TIME_H_
#include <osl/time.h>
#endif

namespace com
{
namespace sun
{
namespace star
{
namespace proxy
{

/*========================================================================
 *
 * OTimeValue.
 *
 *======================================================================*/
struct OTimeValue : public TimeValue
{
	void normalize (void)
	{
		if (Nanosec > 1000000000)
		{
			Seconds += Nanosec / 1000000000;
			Nanosec %= 1000000000;
		}
	}

	OTimeValue (sal_uInt32 nSeconds = 0, sal_uInt32 nNanosec = 0)
	{
		Seconds = nSeconds;
		Nanosec = nNanosec;
		normalize();
	}

	OTimeValue& operator+= (const OTimeValue& rTime)
	{
		Seconds += rTime.Seconds;
		Nanosec += rTime.Nanosec;
		normalize();
		return *this;
	}

	OTimeValue& operator-= (const OTimeValue& rPast)
	{
		Seconds -= rPast.Seconds;
		if (Nanosec < rPast.Nanosec)
		{
			Seconds -= 1;
			Nanosec += 1000000000;
		}
		Nanosec -= rPast.Nanosec;
		return *this;
	}

	sal_Bool operator> (const OTimeValue& rTime)
	{
		if (Seconds > rTime.Seconds)
			return sal_True;
		else if (Seconds < rTime.Seconds)
			return sal_False;
		else
			return (Nanosec > rTime.Nanosec);
	}

	static OTimeValue getSystemTime (void)
	{
		OTimeValue tv;
		osl_getSystemTime (&tv);
		return tv;
	}
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

} // proxy
} // star
} // sun
} // com

#endif /* !_UTILITY_HXX_ */

