#ifndef _DB_HXX_
#define _DB_HXX_

#ifndef _DB_H_
#include <berkeleydb/db.h>
#endif


namespace chelp {
  
  class Dbc;
  
  class Dbt;
  
  class Db {
	
  private:
	
	DB* m_pDBP;
	
  public:
	
	Db(DB_ENV* dbbenv,u_int32_t flags);

	~Db();

	int close(u_int32_t flags);

	int open(DB_TXN *txnid, 
			 const char *file,
			 const char *database, 
			 DBTYPE type, 
			 u_int32_t flags, 
			 int mode);
	
	int get(DB_TXN *txnid, Dbt *key, Dbt *data, u_int32_t flags);
	
	int cursor(DB_TXN *txnid, Dbc **cursorp, u_int32_t flags);
  };
  
  
  class Dbt: public DBT {
	
	friend class Db;
	friend class Dbc;
	
  private:
	
	DBT* m_pDBT;

  public:
	
	Dbt(void *data, size_t size); 
	
	Dbt(); 
	
	~Dbt();

  	void *get_data() const;
	
	void set_data(void *value);
	  
  	u_int32_t get_size() const;
	
	void set_size(u_int32_t value);

	void set_flags(u_int32_t);
  };

  
  class Dbc {
	
	friend class Db;
	friend class Dbt;

  private:
	
	DBC* m_pDBC;
	
	Dbc();

  public:
	
	~Dbc();
	
	int close();
	
	int get(Dbt *key, Dbt *data, u_int32_t flags);
  };
  
  
}

#endif















