package com.sun.star.help;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XBridgeFactory;
import com.sun.star.bridge.XInstanceProvider;

import com.sun.star.comp.servicemanager.ServiceManager;

import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;

import com.sun.star.uno.UnoRuntime;
import com.sun.star.lang.XMultiServiceFactory;

public class HelpServer {
	static String neededServices[] = new String[] {
		"com.sun.star.comp.servicemanager.ServiceManager",
		"com.sun.star.comp.loader.JavaLoader",
		"com.sun.star.comp.connections.Acceptor",
		"com.sun.star.comp.bridgefactory.BridgeFactory",
		"com.sun.star.help.HelpProvider"
	};

	static class InstanceProvider implements XInstanceProvider {
		XMultiServiceFactory _xSmgr;
		String _name;

		InstanceProvider(XMultiServiceFactory xSmgr, String name) {
			_xSmgr = xSmgr;
			_name = name;
		}

		public Object getInstance( /*IN*/String sInstanceName )
			throws com.sun.star.container.NoSuchElementException,com.sun.star.uno.RuntimeException {
			System.err.println("##### " + getClass().getName() + ".getInstance:" + sInstanceName);

			Object obj = null;
			if( sInstanceName.equals(_name ) )
				try
				{
					obj = _xSmgr.createInstance("com.sun.star.help.HelpProvider" );
				}
				catch( com.sun.star.uno.Exception e )
				{

				}
			return obj;
		}
	}

	static public void main(String args[]) throws Exception {
		if(args.length != 1)	{
			System.err.println("usage : SCalc uno:connection;protocol;objectName");
			System.exit(-1);
		}

		// CreateDb.CreateDatabase();

		String conDcp = null;
		String protDcp = null;
		String rootOid = null;

		String dcp = args[0];

		if(dcp.indexOf(';') == -1)
  		{// use old style
			conDcp = dcp;
			protDcp = "iiop";
			rootOid = "classic_uno";
		}
		else
  		{ // new style
			int index = dcp.indexOf(':');
			String url = dcp.substring(0, index).trim();
			dcp = dcp.substring(index + 1).trim();

			index = dcp.indexOf(';');
			conDcp = dcp.substring(0, index).trim();
			dcp = dcp.substring(index + 1).trim();

			index = dcp.indexOf(';');
			protDcp = dcp.substring(0, index).trim();
			dcp = dcp.substring(index + 1).trim();

			rootOid = dcp.trim().trim();
		}

		ServiceManager serviceManager = new ServiceManager();
		serviceManager.addFactories(neededServices);

		XAcceptor xAcceptor = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, serviceManager.createInstance("com.sun.star.connection.Acceptor"));

		System.err.println("waiting for connect...");
		while( true )
		{
			XConnection xConnection = xAcceptor.accept(conDcp);
			System.out.println( xConnection.getDescription() );
			XBridgeFactory xBridgeFactory = (XBridgeFactory)UnoRuntime.queryInterface(XBridgeFactory.class, serviceManager.createInstance("com.sun.star.bridge.BridgeFactory"));
			XBridge xBridge = xBridgeFactory.createBridge(conDcp + ";" + protDcp, protDcp, xConnection, new InstanceProvider(serviceManager, rootOid));
		}
	}
}



