/**
 * =========================================
 * LibXML : a free Java layouting library
 * =========================================
 *
 * Project Info:  http://reporting.pentaho.org/libxml/
 *
 * (C) Copyright 2006-2008, by Object Refinery Ltd, Pentaho Corporation and Contributors.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation;
 * either version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License along with this
 * library; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * [Java is a trademark or registered trademark of Sun Microsystems, Inc.
 * in the United States and other countries.]
 *
 *
 * ------------
 * NoRootHandlerException.java
 * ------------
 */

package org.pentaho.reporting.libraries.xmlns.parser;

import org.xml.sax.Locator;

/**
 * Todo: Document Me
 *
 * @author Thomas Morgner
 */
public class NoRootHandlerException extends ParseException
{
  /**
   * Creates a new ParseException with the given message.
   *
   * @param message the message
   */
  public NoRootHandlerException(final String message)
  {
    super(message);
  }

  /**
   * Creates a new ParseException with the given root exception.
   *
   * @param e the exception
   */
  public NoRootHandlerException(final Exception e)
  {
    super(e);
  }

  /**
   * Creates a new ParseException with the given message and root exception.
   *
   * @param message the message
   * @param e       the exception
   */
  public NoRootHandlerException(final String message, final Exception e)
  {
    super(message, e);
  }

  /**
   * Creates a new ParseException with the given message and the locator.
   *
   * @param message the message
   * @param locator the locator of the parser
   */
  public NoRootHandlerException(final String message, final Locator locator)
  {
    super(message, locator);
  }

  /**
   * Creates a new ParseException with the given root exception and the
   * locator.
   *
   * @param e       the exception
   * @param locator the locator of the parser
   */
  public NoRootHandlerException(final Exception e, final Locator locator)
  {
    super(e, locator);
  }

  /**
   * Creates a new ParseException with the given message, root exception and
   * the locator.
   *
   * @param message the message
   * @param e       the exception
   * @param locator the locator of the parser
   */
  public NoRootHandlerException(final String message, final Exception e, final Locator locator)
  {
    super(message, e, locator);
  }
}
