package org.pentaho.reporting.libraries.repository.email;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;


/**
 * Creation-Date: 17.09.2008, 15:00:00
 *
 * @author Pedro Alves - WebDetails
 */
public class EmailContentItem implements ContentItem
{
  private boolean newItem;
  private String name;
  private String contentId;
  private EmailRepository repository;
  private EmailContentLocation parent;

  public EmailContentItem(final String name,
                        final EmailRepository repository,
                        final EmailContentLocation parent)
  {
    this.name = name;
    this.repository = repository;
    this.parent = parent;
    this.contentId = RepositoryUtilities.buildName(this, "/");
    this.newItem = true;
  }

  public String getMimeType() throws ContentIOException
  {
    return getRepository().getMimeRegistry().getMimeType(this);
  }

  public OutputStream getOutputStream() throws ContentIOException, IOException
  {
    if (newItem == false)
    {
      throw new ContentIOException("This item is no longer writeable.");
    }
    newItem = false;
    return new EmailEntryOutputStream(this);
  }

  public InputStream getInputStream() throws ContentIOException, IOException
  {
    throw new ContentIOException("This item is not readable.");
  }

  public boolean isReadable()
  {
    return false;
  }

  public boolean isWriteable()
  {
    return newItem;
  }

  public String getName()
  {
    return name;
  }

  public Object getContentId()
  {
    return contentId;
  }

  public Object getAttribute(final String domain, final String key)
  {
    return null;
  }

  public boolean setAttribute(final String domain, final String key, final Object value)
  {
    return false;
  }

  public Repository getRepository()
  {
    return repository;
  }

  public ContentLocation getParent()
  {
    return parent;
  }

  public boolean delete()
  {
    return false;
  }
}
