//===========================================================================
//
//      fclose.cxx
//
//      Implementation of C library file close function as per ANSI 7.9.5.1
//
//===========================================================================
//####COPYRIGHTBEGIN####
//
// -------------------------------------------
// The contents of this file are subject to the Cygnus eCos Public License
// Version 1.0 (the "License"); you may not use this file except in
// compliance with the License.  You may obtain a copy of the License at
// http://sourceware.cygnus.com/ecos
// 
// Software distributed under the License is distributed on an "AS IS"
// basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See the
// License for the specific language governing rights and limitations under
// the License.
// 
// The Original Code is eCos - Embedded Cygnus Operating System, released
// September 30, 1998.
// 
// The Initial Developer of the Original Code is Cygnus.  Portions created
// by Cygnus are Copyright (C) 1998 Cygnus Solutions.  All Rights Reserved.
// -------------------------------------------
//
//####COPYRIGHTEND####
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour@cygnus.co.uk
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       
//
//####DESCRIPTIONEND####
//
//===========================================================================

// CONFIGURATION

#include <pkgconf/libc.h>   // Configuration header


// Include the C library? And do we want the stdio stuff? And we can't have
// fclose() without fopen()
#if defined(CYGPKG_LIBC) && defined(CYGPKG_LIBC_STDIO) && \
    defined(CYGPKG_LIBC_STDIO_OPEN)

// INCLUDES

#include <cyg/infra/cyg_type.h>     // Common project-wide type definitions
#include <stddef.h>                 // NULL and size_t from compiler
#include <errno.h>                  // Error codes
#include <stdio.h>                  // header for fclose()
#include "clibincl/stdlibsupp.hxx"  // _free()
#include "clibincl/clibdata.hxx"    // C library private data
#include "clibincl/stream.hxx"      // C libray streams
#include "clibincl/stdiosupp.hxx"   // support for stdio


// EXPORTED SYMBOLS

externC int
fclose( FILE * ) CYGPRI_LIBC_WEAK_ALIAS("_fclose");


// FUNCTIONS


externC int
_fclose( FILE *stream )
{
    Cyg_StdioStream *real_stream = (Cyg_StdioStream *)stream;
    int i;

#ifdef CYGSEM_LIBC_STDIO_THREAD_SAFE_STREAMS
    Cyg_CLibInternalData::files_lock.lock();
#endif // CYGSEM_LIBC_STDIO_THREAD_SAFE_STREAMS

    // find the stream in the table
    for (i=0; i < FOPEN_MAX; i++)
    {
        if (real_stream == Cyg_CLibInternalData::get_file_stream(i))
            break;
    } // for

    if (i == FOPEN_MAX) // didn't find it
    {
        errno = EBADF;

        return EOF;
    } // if

    // Explicitly call destructor - this flushes the output too
    real_stream->~Cyg_StdioStream();

    // and free it
    _free(real_stream);

    // and mark the stream available for use
    Cyg_CLibInternalData::set_file_stream(i, NULL);
        
#ifdef CYGSEM_LIBC_STDIO_THREAD_SAFE_STREAMS
    Cyg_CLibInternalData::files_lock.unlock();
#endif // CYGSEM_LIBC_STDIO_THREAD_SAFE_STREAMS

    return 0;

} // _fclose()
        
#endif // if defined(CYGPKG_LIBC) && defined(CYGPKG_LIBC_STDIO) && 
       //    defined(CYGPKG_LIBC_STDIO_OPEN)

// EOF fclose.cxx
