//==========================================================================
//
//      snmp/snmpagent/current/src/mibgroup/mibII/udp.c
//
//
//==========================================================================
//####ECOSGPLCOPYRIGHTBEGIN####
// -------------------------------------------
// This file is part of eCos, the Embedded Configurable Operating System.
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Red Hat, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 or (at your option) any later version.
//
// eCos is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
// for more details.
//
// You should have received a copy of the GNU General Public License along
// with eCos; if not, write to the Free Software Foundation, Inc.,
// 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
//
// As a special exception, if other files instantiate templates or use macros
// or inline functions from this file, or you compile this file and link it
// with other works to produce a work based on this file, this file does not
// by itself cause the resulting work to be covered by the GNU General Public
// License. However the source code for this file must still be made available
// in accordance with section (3) of the GNU General Public License.
//
// This exception does not invalidate any other reasons why a work based on
// this file might be covered by the GNU General Public License.
//
// Alternative licenses for eCos may be arranged by contacting Red Hat, Inc.
// at http://sources.redhat.com/ecos/ecos-license/
// -------------------------------------------
//####ECOSGPLCOPYRIGHTEND####
//####UCDSNMPCOPYRIGHTBEGIN####
//
// -------------------------------------------
//
// Portions of this software may have been derived from the UCD-SNMP
// project,  <http://ucd-snmp.ucdavis.edu/>  from the University of
// California at Davis, which was originally based on the Carnegie Mellon
// University SNMP implementation.  Portions of this software are therefore
// covered by the appropriate copyright disclaimers included herein.
//
// The release used was version 4.1.2 of May 2000.  "ucd-snmp-4.1.2"
// -------------------------------------------
//
//####UCDSNMPCOPYRIGHTEND####
//==========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):    hmt
// Contributors: hmt
// Date:         2000-05-30
// Purpose:      Port of UCD-SNMP distribution to eCos.
// Description:  
//              
//
//####DESCRIPTIONEND####
//
//==========================================================================
/********************************************************************
       Copyright 1989, 1991, 1992 by Carnegie Mellon University
 
                          Derivative Work -
Copyright 1996, 1998, 1999, 2000 The Regents of the University of California
 
                         All Rights Reserved
 
Permission to use, copy, modify and distribute this software and its
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appears in all copies and
that both that copyright notice and this permission notice appear in
supporting documentation, and that the name of CMU and The Regents of
the University of California not be used in advertising or publicity
pertaining to distribution of the software without specific written
permission.
 
CMU AND THE REGENTS OF THE UNIVERSITY OF CALIFORNIA DISCLAIM ALL
WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL CMU OR
THE REGENTS OF THE UNIVERSITY OF CALIFORNIA BE LIABLE FOR ANY SPECIAL,
INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
FROM THE LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
*********************************************************************/
/* This file was generated by mib2c and is intended for use as a mib module
   for the ucd-snmp snmpd agent. */


/* This should always be included first before anything else */
#include <config.h>


/* minimal include directives */
#include "mibincl.h"
#include "mibgroup/util_funcs.h"
#include "mibgroup/mibII/udp.h"



#define _KERNEL

#include <net/if.h>
#include <net/route.h>

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/in_var.h>
#include <netinet/ip.h>
#include <netinet/in_pcb.h>
#include <netinet/ip_var.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>

/* 
 * udp_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */


oid udp_variables_oid[] = { 1,3,6,1,2,1,7 };


/* 
 * variable4 udp_variables:
 *   this variable defines function callbacks and type return information 
 *   for the udp mib section 
 */


struct variable4 udp_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
#define   UDPINDATAGRAMS        1
  { UDPINDATAGRAMS      , ASN_COUNTER   , RONLY , var_udp, 1, { 1 } },
#define   UDPNOPORTS            2
  { UDPNOPORTS          , ASN_COUNTER   , RONLY , var_udp, 1, { 2 } },
#define   UDPINERRORS           3
  { UDPINERRORS         , ASN_COUNTER   , RONLY , var_udp, 1, { 3 } },
#define   UDPOUTDATAGRAMS       4
  { UDPOUTDATAGRAMS     , ASN_COUNTER   , RONLY , var_udp, 1, { 4 } },
#define   UDPLOCALADDRESS       7
  { UDPLOCALADDRESS     , ASN_IPADDRESS , RONLY , var_udpTable, 3, { 5,1,1 } },
#define   UDPLOCALPORT          8
  { UDPLOCALPORT        , ASN_INTEGER   , RONLY , var_udpTable, 3, { 5,1,2 } },

//#define   IPV6UDPIFINDEX        13
//  { IPV6UDPIFINDEX      , ASN_INTEGER   , RONLY , var_ipv6UdpTable, 3, { 6,1,3 } },

};
/*    (L = length of the oidsuffix) */


/*
 * init_udp():
 *   Initialization routine.  This is called when the agent starts up.
 *   At a minimum, registration of your variables should take place here.
 */
void init_udp(void) {


  /* register ourselves with the agent to handle our mib tree */
  REGISTER_MIB("udp", udp_variables, variable4,
               udp_variables_oid);


  /* place any other initialization junk you need here */
}


/*
 * var_udp():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_udp(struct variable *vp, 
                oid     *name, 
                size_t  *length, 
                int     exact, 
                size_t  *var_len, 
                WriteMethod **write_method)
{
    static long long_ret;

    if (header_generic(vp,name,length,exact,var_len,write_method)
        == MATCH_FAILED )
        return NULL;

    switch(vp->magic) {
    case UDPINDATAGRAMS:
        long_ret = udpstat.udps_ipackets;
        return (u_char *) &long_ret;
    case UDPNOPORTS:
        long_ret = udpstat.udps_noport;
        return (u_char *) &long_ret;
    case UDPOUTDATAGRAMS:
        long_ret = udpstat.udps_opackets;
        return (u_char *) &long_ret;
    case UDPINERRORS:
        long_ret = udpstat.udps_hdrops + udpstat.udps_badsum +
            udpstat.udps_badlen;
        return (u_char *) &long_ret;
    default:
        ERROR_MSG("");
    }
    return NULL;
}


/*
 * var_udpTable():
 *   Handle this table separately from the scalar value case.
 *   The workings of this are basically the same as for var_udpTable above.
 */
unsigned char *
var_udpTable(struct variable *vp,
    	    oid     *name,
    	    size_t  *length,
    	    int     exact,
    	    size_t  *var_len,
    	    WriteMethod **write_method)
{
    static long long_ret;
    static unsigned char string[SPRINT_MAX_LEN];
    register struct inpcb *inp;
    register struct inpcb *low_inp = NULL;
    oid                    lowest[16];
    oid                    newname[16];
    u_char		   *cp;
    oid			   *op;

    // This is indexed by local-address, local-port, at 1,3,6,1,2,1,7,5,1,1,
    // so we get 1,3,6,1,2,1,7,5,1,?,A,B,C,D,port
    // initial length is 10, out-length is 15,
    // Address is offsets 10-13, port is offset 14.
    
    // starting from udbtable, look in
    //      low_pcb->inp_laddr.s_addr
    // and  low_pcb->inp_lport

    /* fill in object part of name for current (less sizeof instance part) */
    memcpy((char *)newname, (char *)vp->name, (int)vp->namelen * sizeof(oid));

    for (inp = udbtable.inpt_queue.cqh_first;
         inp != (struct inpcb *)&udbtable.inpt_queue;
         inp = inp->inp_queue.cqe_next) {
        cp = (u_char *)&inp->inp_laddr.s_addr;
        op = newname + 10;
        *op++ = *cp++;
        *op++ = *cp++;
        *op++ = *cp++;
        *op++ = *cp++;
        
        newname[14] = ntohs(inp->inp_lport);

        if (exact){
            if (snmp_oid_compare(newname, 15, name, *length) == 0){
                memcpy( (char *)lowest,(char *)newname, 15 * sizeof(oid));
                low_inp = inp;
                break;  /* no need to search further */
            }
        } else {
            if ((snmp_oid_compare(newname, 15, name, *length) > 0) &&
                (!low_inp || (snmp_oid_compare(newname, 15, lowest, 15) < 0))){
                /*
                 * if new one is greater than input and closer to input than
                 * previous lowest, save this one as the "next" one.
                 */
                memcpy( (char *)lowest,(char *)newname, 15 * sizeof(oid));
                low_inp = inp;
            }
        }
    }

    if ( ! low_inp )
        return NULL;

    memcpy( (char *)name,(char *)lowest, 15 * sizeof(oid));
    *length = 15;
    *var_len = sizeof( long_ret );
    *write_method = 0;

    switch(vp->magic) {

    case UDPLOCALADDRESS:
        cp = (u_char *)&low_inp->inp_laddr.s_addr;
        string[0] = *cp++;
        string[1] = *cp++;
        string[2] = *cp++;
        string[3] = *cp++;
        *var_len = 4;
        return (unsigned char *) string;

    case UDPLOCALPORT:
        long_ret = (long)ntohs(low_inp->inp_lport);
        return (unsigned char *) &long_ret;

    default:
        ERROR_MSG("");
    }
    return NULL;
}


// EOF udp.c
