#ifndef CYGONCE_LIBM_ACOS_H
#define CYGONCE_LIBM_ACOS_H
//===========================================================================
//
//      acos.h
//
//      Test vectors for testing of acos() math library function
//
//===========================================================================
// ####ECOSGPLCOPYRIGHTBEGIN####                                            
// -------------------------------------------                              
// This file is part of eCos, the Embedded Configurable Operating System.   
// Copyright (C) 1998, 1999, 2000, 2001, 2002 Free Software Foundation, Inc.
//
// eCos is free software; you can redistribute it and/or modify it under    
// the terms of the GNU General Public License as published by the Free     
// Software Foundation; either version 2 or (at your option) any later      
// version.                                                                 
//
// eCos is distributed in the hope that it will be useful, but WITHOUT      
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or    
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License    
// for more details.                                                        
//
// You should have received a copy of the GNU General Public License        
// along with eCos; if not, write to the Free Software Foundation, Inc.,    
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.            
//
// As a special exception, if other files instantiate templates or use      
// macros or inline functions from this file, or you compile this file      
// and link it with other works to produce a work based on this file,       
// this file does not by itself cause the resulting work to be covered by   
// the GNU General Public License. However the source code for this file    
// must still be made available in accordance with section (3) of the GNU   
// General Public License v2.                                               
//
// This exception does not invalidate any other reasons why a work based    
// on this file might be covered by the GNU General Public License.         
// -------------------------------------------                              
// ####ECOSGPLCOPYRIGHTEND####                                              
//===========================================================================
//#####DESCRIPTIONBEGIN####
//
// Author(s):   jlarmour
// Contributors:  jlarmour
// Date:        1998-02-13
// Purpose:     
// Description: 
// Usage:       #include "vectors/acos.h"
//
//####DESCRIPTIONEND####
//
//===========================================================================


// CONFIGURATION

#include <pkgconf/libm.h>   // Configuration header


// INCLUDES

#include <cyg/infra/cyg_type.h>    // Common type definitions and support
#include "vectors/vector_support.h"// extra support for math tests

#define ACOS_TOLERANCE 1.0E-04

static const Cyg_libm_test_double_vec_t acos_vec[] = {

// AUTOMATICALLY GENERATED VECTORS START

{ 1, 604042796u, 2506787616u, 3214772338u, 2077734866u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 2, 182169888u, 3065862417u, 1106988572u, 4273582707u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 3, 2664755801u, 1226547830u, 1071032732u, 3857964939u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 4, 94291757u, 4010703484u, 1081727025u, 4287567452u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 5, 118911615u, 2977931045u, 1104283808u, 3843658091u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 6, 2656608405u, 3088088668u, 1073408149u, 2318866154u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 7, 263730613u, 2451317798u, 3210911814u, 1038562750u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 8, 580821368u, 2221564313u, 1059115557u, 977275158u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 9, 399687375u, 97950278u, 3204919842u, 1605286142u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 10, 460757591u, 4233776869u, 1087533966u, 1919858904u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 11, 2870376804u, 1472965721u, 3230691143u, 2574511435u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 12, 2882092039u, 1204637550u, 3213143089u, 2421516003u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 13, 3037750340u, 3337705339u, 3238331976u, 3183442542u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 14, 2949649050u, 1086075996u, 1067714579u, 3477152375u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 15, 535591366u, 247024800u, 1040265469u, 3354345619u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 16, 63178737u, 2781269805u, 3188799281u, 3391715197u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 17, 768313194u, 865544864u, 3230216062u, 1200273272u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 18, 591877388u, 3157038143u, 3249401130u, 314151656u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 19, 3219509280u, 1564829925u, 1065671376u, 3088950051u, 1073910026u, 254064179u, 0, ACOS_TOLERANCE, 0},
{ 20, 141374533u, 3933975298u, 1065991760u, 2304772640u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 21, 2396283075u, 1799495751u, 1094899225u, 1827380665u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 22, 2598153594u, 1112370977u, 1061103890u, 196988907u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 23, 1040851532u, 490122851u, 3216810265u, 576637874u, 1073291771u, 1410328704u, 0, ACOS_TOLERANCE, 0},
{ 24, 849190915u, 1390621543u, 1055043150u, 915412872u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 25, 488493877u, 2591320551u, 1070339013u, 1237443094u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 26, 3077582663u, 3936235618u, 1099376266u, 1904940295u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 27, 71827124u, 222155510u, 1044902177u, 252085215u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 28, 2583183683u, 4139068910u, 3215004552u, 4245048106u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 29, 32118299u, 168794155u, 1090475726u, 3160414606u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 30, 975557826u, 4157503437u, 1104600163u, 1792103377u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 31, 137283993u, 1382645956u, 3240285101u, 4024164216u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 32, 118046910u, 3480120317u, 1100404348u, 478417819u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 33, 2828521286u, 2549311006u, 1055917530u, 3778440054u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 34, 2530903114u, 1593784258u, 1069213493u, 1951351053u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 35, 3103251986u, 631744430u, 3206072611u, 1047143174u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 36, 722650436u, 1584726864u, 3215417793u, 624695933u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 37, 2434300838u, 705725219u, 3217662205u, 1967294577u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 38, 664091785u, 2952818482u, 3239402263u, 1848641259u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 39, 642185311u, 1370937055u, 1055482637u, 2410810400u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 40, 889092079u, 1330047076u, 1093469262u, 1857263512u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 41, 2562391789u, 1246486570u, 1067165665u, 743938884u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 42, 1013509315u, 3107531809u, 1058433800u, 958446936u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 43, 2379321348u, 1698195744u, 3234826710u, 1808768063u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 44, 223594865u, 2594747457u, 1045397427u, 3927603841u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 45, 2251329048u, 348093397u, 1064733299u, 1710279345u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 46, 3162272236u, 3528946000u, 1045927362u, 1602290403u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 47, 2415703348u, 398813542u, 1052866292u, 1436851684u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 48, 1033199706u, 3319748577u, 3227196113u, 3607301229u, 1073291771u, 1413732247u, 0, ACOS_TOLERANCE, 0},
{ 49, 23891811u, 2548745907u, 1105253912u, 370162110u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 50, 764517244u, 4204294028u, 3192923960u, 2626702805u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 51, 173888262u, 390319448u, 1104422077u, 120202647u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 52, 2730779741u, 2815627218u, 1099019491u, 731750493u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 53, 864070021u, 3900661840u, 3200970392u, 2907096477u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 54, 842667049u, 4269246624u, 3222902057u, 2762779203u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 55, 2347188326u, 184131949u, 3225314008u, 2237882876u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 56, 2323813472u, 4276663739u, 3254076585u, 4265258845u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 57, 560407162u, 1656691045u, 3252113914u, 4132573504u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 58, 271448936u, 1052817888u, 1061186300u, 352861436u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 59, 2742827957u, 636068836u, 1093702210u, 4149510462u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 60, 3110435514u, 1869774195u, 1056841761u, 2029664212u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 61, 2782135403u, 481356510u, 1098012633u, 1760061418u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 62, 2210852465u, 2918398424u, 1066749948u, 3643952367u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 63, 2255864064u, 3722025458u, 3192516074u, 1732245037u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 64, 984980019u, 1533536108u, 3226159655u, 3412938290u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 65, 2302294008u, 3539403428u, 1044896671u, 2743023547u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 66, 2437282418u, 965485575u, 1074677964u, 2239092099u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 67, 3161462367u, 479602785u, 3245398415u, 1570702137u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 68, 454239397u, 3987656554u, 3201134469u, 2639458165u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 69, 270690192u, 902270460u, 3200236493u, 2060263082u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 70, 3101979469u, 119561873u, 1067242459u, 4238218095u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 71, 342005410u, 1489535917u, 1052674720u, 3229843554u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 72, 2431479818u, 1372780257u, 1087299442u, 2877794600u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 73, 749807578u, 547642046u, 1068507828u, 2261901967u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 74, 2886390034u, 2655610998u, 1063417350u, 3897975437u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 75, 250812866u, 3444039742u, 3204905205u, 72985499u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 76, 2855285209u, 685471642u, 1052893000u, 3994091533u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 77, 438792265u, 3273039144u, 3234242951u, 2105125638u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 78, 2645727074u, 1149591862u, 1079300031u, 2852890893u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 79, 2752966212u, 964007987u, 1089046728u, 3863233156u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 80, 512535166u, 27186676u, 1092292231u, 131338606u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 81, 670177097u, 2614232599u, 3216359929u, 1186945904u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 82, 3154698801u, 1896750851u, 3253696392u, 920368431u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 83, 2442691738u, 29704081u, 3253306050u, 1477489465u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 84, 2226625355u, 1908380994u, 1041152721u, 3015183476u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 85, 681844560u, 470785250u, 3211309660u, 1296080311u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 86, 3173267991u, 3766553196u, 1063117318u, 3703961407u, 1073291771u, 1413754298u, 0, ACOS_TOLERANCE, 0},
{ 87, 2455017061u, 4149594176u, 1090202405u, 3293225914u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 88, 313616459u, 77747397u, 3224848375u, 1095737976u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 89, 3083383675u, 594138985u, 3217133121u, 1435082240u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 90, 2240663447u, 1803548147u, 3240157452u, 4122845725u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 91, 692524862u, 311336721u, 1045850005u, 536548906u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 92, 39331613u, 1667857221u, 1062792545u, 2329662186u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 93, 2957138228u, 1918705224u, 1059647808u, 2861487662u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 94, 3070750532u, 3709104626u, 3220237199u, 997732637u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 95, 2444448896u, 1774627130u, 3192826790u, 2597228841u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 96, 702397604u, 2705552003u, 1041691115u, 3314033947u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 97, 2530979608u, 820086279u, 1085001393u, 3341643348u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 98, 481329467u, 3136820894u, 1093140313u, 4023285864u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 99, 2613158354u, 443835590u, 3197412883u, 166402802u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 100, 2939403391u, 3572369260u, 3225005050u, 1183942370u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 101, 456836645u, 2446986142u, 1100226690u, 3561788365u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 102, 995574146u, 279968558u, 1056612692u, 605059609u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 103, 2720425755u, 1360758659u, 1045149981u, 3634982365u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 104, 219648965u, 4068690904u, 3212392076u, 3185930294u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 105, 245268713u, 1440185463u, 1067865294u, 2959231845u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 106, 3124081158u, 3352139409u, 3211602972u, 64439686u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 107, 2799322658u, 1508169460u, 3213875925u, 3893561170u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 108, 2966132661u, 146763905u, 1061635587u, 1173102190u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 109, 2950948333u, 2882725208u, 1046547680u, 3137609802u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 110, 281607514u, 2987408195u, 1104831334u, 2360906919u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 111, 583237163u, 2272922429u, 3230247604u, 3220743043u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 112, 2279259017u, 486798710u, 1051847313u, 1164056378u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 113, 2707413568u, 14851197u, 3194383659u, 2622433447u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 114, 2729877535u, 1346176789u, 1059030682u, 1585821890u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 115, 925396515u, 1008663444u, 3253626162u, 1058337847u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 116, 2213579028u, 3506658319u, 3219431539u, 543446309u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 117, 3163196851u, 3413687955u, 1072253426u, 343404215u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 118, 334409439u, 4266232536u, 3240608065u, 4109813813u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 119, 3177753519u, 1144242316u, 1071012025u, 2790944540u, 1073291771u, 1413757294u, 0, ACOS_TOLERANCE, 0},
{ 120, 2754858880u, 265926617u, 1095794063u, 1345870736u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 121, 49590943u, 3193385121u, 1097323612u, 2009367488u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 122, 2389359641u, 1233370553u, 1064565351u, 322637795u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 123, 954404777u, 3410634251u, 3243916607u, 4042570547u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 124, 2849680709u, 2524001714u, 1072116817u, 3983083207u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 125, 959555327u, 3501343645u, 3237287213u, 1887353658u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 126, 2934409098u, 689800034u, 3246333414u, 2135700283u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 127, 263792941u, 4171919805u, 3238308636u, 3129081398u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 128, 926728083u, 1550999328u, 3219525990u, 2031663879u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 129, 2989628620u, 949669377u, 3226383614u, 3948448651u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 130, 2243494997u, 4293630712u, 1060526636u, 438407499u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 131, 2756107420u, 1535381711u, 1054391309u, 4072415576u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 132, 3025827769u, 1347758084u, 3238820771u, 1059069486u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 133, 3294258u, 3498512759u, 1092903052u, 2047817298u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 134, 2919775476u, 1226560794u, 1069263873u, 685537815u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 135, 982026620u, 4000990876u, 1076297936u, 3803689997u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 136, 499108416u, 2263729518u, 3254424928u, 3450332551u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 137, 347296393u, 1637536851u, 3238793417u, 747232103u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 138, 34763760u, 902498990u, 3205956257u, 245434170u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 139, 3201690145u, 1482770161u, 3244873095u, 2292235133u, 1073291776u, 3469509425u, 0, ACOS_TOLERANCE, 0},
{ 140, 2990655242u, 36045768u, 1071182448u, 3868790688u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 141, 3083340050u, 1885951730u, 3207806174u, 2553919637u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 142, 2693238911u, 4059459408u, 1055146851u, 2731735627u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 143, 2290935302u, 3819720014u, 3203031655u, 4218515595u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 144, 2348280948u, 3038411370u, 3236511256u, 2472176453u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 145, 2880785553u, 182132862u, 3252592387u, 1793714415u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 146, 2799656331u, 4227997622u, 1087681073u, 3265812129u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 147, 801513493u, 1010183244u, 1091844280u, 675001864u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 148, 318478599u, 4193366103u, 1056610361u, 3831235255u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 149, 2378498000u, 465836562u, 3189131504u, 1330642846u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 150, 43741656u, 1192547728u, 1080448013u, 2251835756u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 151, 172875845u, 2123384287u, 3198090050u, 2528390848u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 152, 911443207u, 3964517760u, 3252496130u, 1755935266u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 153, 844811578u, 2753105123u, 3223721534u, 3995725873u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 154, 151452687u, 777231627u, 1042074674u, 36182517u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 155, 3158956730u, 3937520057u, 3230206414u, 1507556284u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 156, 910363913u, 1910829179u, 1052726418u, 90890556u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 157, 3107838682u, 1962827704u, 1080960105u, 1706263669u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 158, 2177675826u, 3863498922u, 1084020789u, 2439263794u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 159, 2909835385u, 2329801749u, 1098707350u, 2852802137u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 160, 2979393160u, 3548991905u, 3213586763u, 3269946829u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 161, 790744031u, 2009174302u, 1097495331u, 312449728u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 162, 2160628293u, 648730712u, 3246307879u, 4265764460u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 163, 1000831562u, 366653268u, 1051541874u, 1478215551u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 164, 2470023790u, 2605647918u, 1042539011u, 969681033u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 165, 2322196276u, 1909222641u, 1092825252u, 3029685419u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 166, 3159166635u, 1128432313u, 3200082887u, 2582838060u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 167, 2525309230u, 546560372u, 1070003814u, 2343707656u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 168, 849110626u, 309618405u, 3246395018u, 3002005209u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 169, 2706804529u, 3151760818u, 3196548461u, 1969485838u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 170, 639469972u, 3667631361u, 3196181592u, 3743448274u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 171, 2658009958u, 3097521578u, 3216630070u, 1141349287u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 172, 918158805u, 3403438584u, 3208257181u, 2221276438u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 173, 2401852086u, 1683102397u, 3250341256u, 108768173u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 174, 2343899229u, 564813835u, 1064153550u, 3058531228u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 175, 2813220880u, 131949913u, 1090262840u, 2146798879u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 176, 2465897203u, 1934391255u, 3188783235u, 1341236714u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 177, 1070130951u, 418478585u, 3248733961u, 5029000u, 1073086461u, 494572026u, 0, ACOS_TOLERANCE, 0},
{ 178, 453997460u, 2676092597u, 1105486693u, 1833595891u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 179, 522042376u, 1030769844u, 1071155175u, 2766628533u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 180, 2635141434u, 1153943376u, 3209762784u, 953839852u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 181, 1029467775u, 143071571u, 1050966579u, 2318822594u, 1073291771u, 1413752317u, 0, ACOS_TOLERANCE, 0},
{ 182, 287910954u, 1347533411u, 3242337825u, 3256720041u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 183, 444067826u, 1840809642u, 1105293543u, 639604076u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 184, 37282545u, 113530717u, 3194758036u, 699784099u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 185, 435549826u, 2950098243u, 1061587493u, 3565445501u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 186, 2385974507u, 2103316697u, 1076082218u, 4043789060u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 187, 811546601u, 1521715421u, 3251785075u, 651105558u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 188, 491306771u, 2545467538u, 3213898932u, 3889824094u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 189, 503065027u, 4133138143u, 3246676260u, 2160225215u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 190, 994621531u, 836655570u, 3245194924u, 2865254908u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 191, 2309344440u, 1678396836u, 3226762726u, 424413376u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 192, 2164934365u, 2155776900u, 3222643433u, 2889736031u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 193, 3003862757u, 33676353u, 1090754016u, 4128530794u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 194, 2386204171u, 3176672093u, 1052578754u, 2282864811u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 195, 446288958u, 2747259961u, 1103923331u, 1909074501u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 196, 3119895314u, 482497137u, 3223384022u, 3259766501u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 197, 2460401984u, 1710626079u, 3222593534u, 834878686u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 198, 3041977808u, 4271421721u, 1047020885u, 1742757458u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 199, 2215391645u, 1265459564u, 1080678447u, 685348463u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 200, 2688170568u, 4066044320u, 1054128905u, 376413109u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 201, 716821218u, 3237497681u, 3242751645u, 260260645u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 202, 2385659123u, 2882820086u, 1085407846u, 2301658312u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 203, 420514989u, 3656359254u, 3203021744u, 2817965308u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 204, 2841879402u, 2859722465u, 3197490752u, 3892072777u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 205, 2665431021u, 2538156443u, 3215734057u, 831239754u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 206, 953028035u, 3071308141u, 3231671892u, 30345936u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 207, 2210978501u, 3595439756u, 3214985609u, 739408315u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 208, 3029757061u, 3298589427u, 3196131526u, 2084665197u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 209, 2823345962u, 3955601456u, 1076543910u, 3304852042u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 210, 640515933u, 2419975459u, 1073769087u, 1988016581u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 211, 2453833475u, 2659973204u, 3216007439u, 2731594173u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 212, 697318369u, 3938264868u, 1062532020u, 2975148216u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 213, 225366869u, 453215326u, 3200044385u, 467903731u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 214, 499614828u, 372130653u, 3235313361u, 3772501596u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 215, 2298173054u, 2406734491u, 1099766912u, 3221574013u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 216, 211434314u, 2841672781u, 3228298587u, 2623399873u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 217, 2562278951u, 2034292219u, 3248774822u, 699680428u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 218, 1030621435u, 1386943632u, 1088782030u, 3724905992u, 1073291771u, 1413750292u, 0, ACOS_TOLERANCE, 0},
{ 219, 217306301u, 1495300013u, 3240548807u, 1518804038u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 220, 362076244u, 3050489517u, 1049468975u, 2940604216u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 221, 516072020u, 387594449u, 3238538261u, 3010872301u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 222, 2417270868u, 1683571756u, 1098214271u, 3243467912u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 223, 2453871840u, 547789874u, 1074621795u, 671680995u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 224, 819681449u, 2315535361u, 1076278343u, 3851723081u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 225, 925396663u, 2690952636u, 3195785827u, 1648844317u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 226, 835916575u, 2105507379u, 1060210356u, 2061848524u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 227, 2882329693u, 1771437899u, 1102743884u, 4195142780u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 228, 547945591u, 1310074754u, 1072476006u, 1313198415u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 229, 979656894u, 3914592621u, 3228159980u, 2457917034u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 230, 2718226491u, 2240965174u, 3236288087u, 3605857252u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 231, 41761399u, 196714912u, 1054040628u, 3084755276u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 232, 2665587864u, 2058851477u, 1052873711u, 1233598120u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 233, 101299669u, 1909994277u, 3220384775u, 2863812374u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 234, 532015965u, 3697551156u, 1083211400u, 2869735287u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 235, 2830857894u, 2697221770u, 1092525956u, 2160271449u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 236, 230734239u, 2762796844u, 1059257507u, 3160137573u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 237, 247044829u, 1758968847u, 1101109420u, 3270770898u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 238, 73012604u, 4005141897u, 3216213297u, 4129052985u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 239, 2970233606u, 137758261u, 1060349030u, 3082136857u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 240, 1068792039u, 2371653203u, 3211892131u, 3951914469u, 1073207827u, 951674575u, 0, ACOS_TOLERANCE, 0},
{ 241, 3109437504u, 3213595557u, 1043958672u, 2986160931u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 242, 575927156u, 2540046258u, 3208370548u, 2048583911u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 243, 546830286u, 2264504930u, 3228769528u, 1854181735u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 244, 2183016286u, 3809768956u, 1054933586u, 595351688u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 245, 723947614u, 3071069520u, 3207129696u, 3120974660u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 246, 945283056u, 1952618732u, 3236532520u, 1540955277u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 247, 747620529u, 1438803217u, 1049266525u, 957676449u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 248, 92767291u, 4222295662u, 1076131984u, 2183319069u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 249, 334611718u, 3887074118u, 3191649564u, 3233378721u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 250, 771768198u, 2099099488u, 3222430705u, 2071674991u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 251, 2409204087u, 2295269094u, 3196265320u, 3987032629u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 252, 2377503648u, 4200095882u, 1086809994u, 1339996745u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 253, 797809565u, 2431996507u, 1102017594u, 242934189u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 254, 2312749311u, 2330084417u, 1043172813u, 4043102110u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 255, 988771849u, 1106978707u, 1082509751u, 2520765777u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 256, 864960887u, 3192168224u, 1066340820u, 3603945646u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 257, 2589695756u, 1952396835u, 3199434577u, 3703639356u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 258, 320682810u, 1198219673u, 3230438668u, 2418060633u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 259, 551093026u, 2638353760u, 1093840413u, 1751560711u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 260, 540797521u, 180987057u, 1085420898u, 530063370u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 261, 2760303516u, 3179145654u, 1048020008u, 3061407249u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 262, 162525363u, 1884787302u, 1068713554u, 1737020797u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 263, 214216231u, 3459566012u, 3251200938u, 4126298722u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 264, 2764328342u, 1036370112u, 3235918644u, 3898933279u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 265, 653867113u, 3276084832u, 3189072211u, 1864601262u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 266, 298324788u, 263075055u, 1100754245u, 1667825741u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 267, 3015536039u, 2387220960u, 3253010819u, 3505575323u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 268, 642739166u, 3154304623u, 1063475914u, 3150741666u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 269, 332025563u, 4200269406u, 3194288972u, 3577694711u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 270, 2339885777u, 2064011737u, 1089860833u, 3657008595u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 271, 842190281u, 210665237u, 3197168874u, 510714829u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 272, 728283504u, 1589701259u, 3251310843u, 17001602u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 273, 975043445u, 2928317152u, 3246958541u, 122162205u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 274, 3101610657u, 1288582346u, 1071556960u, 4177188454u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 275, 151289169u, 3962848462u, 3243017171u, 3661038757u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 276, 2755192415u, 2162985241u, 3226640955u, 1639319068u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 277, 2942384609u, 1996676305u, 1099130747u, 3840380763u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 278, 134315769u, 550040067u, 3241901241u, 3372594924u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 279, 3137373248u, 3164451169u, 1076627605u, 317246751u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 280, 2423768299u, 784217153u, 1066058157u, 1225003160u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 281, 2378706924u, 1715871558u, 1101460352u, 3401958038u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 282, 363631767u, 4086269531u, 1102279679u, 2517481591u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 283, 2329360168u, 2624677381u, 1085107111u, 1970804718u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 284, 1010793546u, 3379532114u, 3249898830u, 3723025783u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 285, 999588552u, 2651435439u, 3229039621u, 1030985387u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 286, 3145033808u, 1199535056u, 1077836259u, 3604666660u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 287, 2548507371u, 3115209742u, 3237451386u, 3863935859u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 288, 2398143146u, 4209496277u, 3199416183u, 1216202995u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 289, 614398964u, 2544695332u, 3210577461u, 596332114u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 290, 514278395u, 1338323803u, 1041925718u, 99526924u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 291, 856573491u, 3149653097u, 1103058665u, 2483495776u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 292, 2339743312u, 280536835u, 1044395245u, 3715707641u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 293, 128894757u, 3670016377u, 1050809029u, 3775007802u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 294, 3109073100u, 3526859225u, 3222673081u, 4030462447u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 295, 640779949u, 1602527268u, 3242467576u, 2018361566u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 296, 957271688u, 3985805054u, 1088518381u, 1679321540u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 297, 2801498828u, 1663896708u, 3248819198u, 4229852270u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 298, 467728155u, 2346627527u, 3239438934u, 2290493820u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 299, 2208629720u, 2296736794u, 3207683799u, 1456667044u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 300, 2958022504u, 4132454009u, 1106540396u, 4243490703u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 301, 235395447u, 1359445676u, 3190130903u, 1569883678u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 302, 277859320u, 333214083u, 1076552006u, 1385185236u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 303, 2942645471u, 950097945u, 1041232546u, 3621700966u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 304, 370898672u, 149336372u, 3191764868u, 2940199511u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 305, 2384610875u, 2875684421u, 3249377056u, 4253432396u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 306, 837504978u, 2081484836u, 3199314748u, 2264912911u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 307, 632882934u, 3967859615u, 3229710481u, 2667348142u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 308, 2181979516u, 3630082248u, 3227364534u, 4156569147u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 309, 946956756u, 2993509124u, 1091331299u, 4018898246u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 310, 338207615u, 1642285349u, 3208379731u, 1196091123u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 311, 4693283u, 3356597889u, 1040231079u, 2420753479u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 312, 2762118529u, 977967943u, 3228887283u, 807395730u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 313, 2919435607u, 2730725979u, 3207120390u, 3867917386u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 314, 999294480u, 3504746045u, 1075794770u, 665882260u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 315, 2269075155u, 3385464702u, 1049896268u, 2757059958u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 316, 536095951u, 1299923384u, 1101872081u, 2574386817u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 317, 2675071145u, 3171042375u, 1078533152u, 2312086600u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 318, 2360735442u, 4236561530u, 1068042271u, 256515531u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 319, 2609926553u, 4152554926u, 1100304772u, 3545562886u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 320, 2403546570u, 350924105u, 1040286251u, 1468770658u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 321, 544551146u, 3000822699u, 3232925779u, 2540988650u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 322, 2780107631u, 2928199244u, 3245167989u, 44275991u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 323, 2165210001u, 1174874204u, 1057110584u, 848081004u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 324, 2354568060u, 1412948540u, 3239110676u, 3215002775u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 325, 863277892u, 2701562677u, 1065879622u, 2897481417u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 326, 199312991u, 2980401690u, 3216742908u, 2549609731u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 327, 2827983212u, 585456984u, 3201746087u, 638714580u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 328, 575008531u, 4260896505u, 1089137884u, 4274648992u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 329, 2728904219u, 4055046173u, 3198391736u, 3482894513u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 330, 341009704u, 2493198836u, 3198094528u, 2484800635u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 331, 3153287889u, 599921010u, 1103847606u, 1674254897u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 332, 104926329u, 217148561u, 1097066495u, 3536010689u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 333, 933395812u, 1605519917u, 3225218243u, 2732577078u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 334, 573219110u, 417261654u, 3246267157u, 3401343872u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 335, 1039272770u, 2150330697u, 1080405602u, 3197535445u, 1073291771u, 1412571606u, 0, ACOS_TOLERANCE, 0},
{ 336, 1065739247u, 2334624779u, 1070288136u, 147709079u, 1073280563u, 1049296574u, 0, ACOS_TOLERANCE, 0},
{ 337, 3178645135u, 665848401u, 3235013045u, 2195099382u, 1073291771u, 1413759839u, 0, ACOS_TOLERANCE, 0},
{ 338, 364316788u, 238721142u, 3238780023u, 2612316049u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 339, 2974180417u, 328119069u, 3231550903u, 696220816u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 340, 649641437u, 2886210843u, 1055433962u, 3331415058u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 341, 335135121u, 2420250111u, 3214614526u, 510850312u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 342, 2216193203u, 1658541647u, 1071956366u, 53496813u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 343, 2567194005u, 3872563165u, 1098494887u, 2790313039u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 344, 3219733872u, 3859621368u, 3205775949u, 4015749711u, 1073993256u, 2063983841u, 0, ACOS_TOLERANCE, 0},
{ 345, 311334852u, 1732769560u, 1052132915u, 2774541952u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 346, 317917675u, 1689088021u, 1066883290u, 3270546122u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 347, 491335395u, 1959705843u, 1106618962u, 4198868105u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 348, 124503353u, 3906315805u, 3235289682u, 1109820549u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 349, 3036818075u, 3370448446u, 1063890856u, 4022784584u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 350, 323334929u, 3264056381u, 1104622566u, 3697934821u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 351, 82666680u, 2912871781u, 3242116859u, 1560571600u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 352, 2776916990u, 3103325650u, 3237224234u, 3681651958u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 353, 333678608u, 3330581237u, 1086856468u, 3110345659u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 354, 2487169180u, 2478706589u, 1099546513u, 4177071445u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 355, 3183204741u, 3514067221u, 3247338343u, 585148435u, 1073291771u, 1413868209u, 0, ACOS_TOLERANCE, 0},
{ 356, 2811486197u, 3689342853u, 3208758774u, 200507809u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 357, 3116462959u, 1049872171u, 3210445232u, 1453705582u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 358, 3129943472u, 1932668626u, 1098808013u, 1044068983u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 359, 2295964401u, 4093388677u, 3210795947u, 1617393713u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 360, 2293016564u, 778812087u, 3246232571u, 731905539u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 361, 2907822649u, 4050829759u, 1086605180u, 1863848117u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 362, 6647363u, 718161191u, 1071063889u, 2637291484u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 363, 224521970u, 1909842364u, 1102747575u, 3614304657u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 364, 761500166u, 895493977u, 3236485375u, 1701194116u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 365, 2171563276u, 1493115846u, 3233339987u, 296022762u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 366, 2783624899u, 4099447408u, 3187790416u, 3564720305u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 367, 848425142u, 2404172709u, 3219922640u, 2284484846u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 368, 2654315895u, 3240896015u, 3208621510u, 1226668421u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 369, 2488218361u, 4127752456u, 3200753143u, 2161953369u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 370, 489605006u, 1168774591u, 3191311819u, 2375467787u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 371, 347845914u, 2883145553u, 3234998320u, 3286468014u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 372, 2588007471u, 3007671464u, 1102234703u, 1209628408u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 373, 127334109u, 571692916u, 3243349276u, 1910625797u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 374, 524138712u, 2510184860u, 1089525631u, 2209639467u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 375, 2615466346u, 1945605229u, 3227105252u, 3777119615u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 376, 398493829u, 215226593u, 3235434773u, 224271737u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 377, 2242993828u, 2134662911u, 1080232319u, 1056746021u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 378, 2923358085u, 1099524039u, 1085032107u, 3905384073u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 379, 842579915u, 985866260u, 3225437419u, 3120783698u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 380, 2589795066u, 1700432859u, 3230345428u, 3505263023u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 381, 2297683903u, 953966053u, 1090810641u, 151959421u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 382, 2887420078u, 1520016810u, 1096148013u, 1974161688u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 383, 2738297064u, 1577726432u, 1080717542u, 3407236142u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 384, 3154840433u, 358621181u, 3214344145u, 3735144364u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 385, 2521491907u, 4023613376u, 1095386964u, 959640601u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 386, 2369008919u, 4136915018u, 1042238319u, 1264360404u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 387, 2906418341u, 3543839161u, 1093859356u, 2852227162u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 388, 2218509603u, 2154399659u, 3218171985u, 2610173674u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 389, 165687034u, 2502718011u, 1105407582u, 4037997673u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 390, 3034344010u, 2429891750u, 3220651893u, 3433646170u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 391, 397029567u, 1233242847u, 3233842223u, 1978947905u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 392, 32753845u, 3055512924u, 1085895689u, 2569766862u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 393, 498004465u, 3103627383u, 1075642950u, 676014010u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 394, 2622487710u, 3587249671u, 1050343198u, 2034180320u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 395, 2559467693u, 1175750283u, 3228052153u, 441772035u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 396, 639279177u, 1096886368u, 1067186387u, 4256284279u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 397, 208471934u, 2746455711u, 3243186220u, 383175406u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 398, 2829822244u, 1056466374u, 3247450556u, 3263564076u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 399, 2468230336u, 1734210936u, 3195265560u, 514072505u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 400, 758811245u, 1728341051u, 1092832248u, 3823410158u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 401, 2347191449u, 1235712656u, 3219475794u, 3622129011u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 402, 79742765u, 1575194991u, 3197615492u, 3446988115u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 403, 2161423950u, 2362441752u, 1088255327u, 270039934u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 404, 3010727959u, 3063626339u, 1105039555u, 1845818221u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 405, 192788472u, 3718151518u, 3240183167u, 3113149567u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 406, 313112913u, 3686096237u, 3199484638u, 191185038u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 407, 195422631u, 3680158556u, 1105637038u, 349436087u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 408, 2844026099u, 150975354u, 1100107824u, 729077351u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 409, 3016106050u, 2974566906u, 1091481543u, 195479384u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 410, 2820952232u, 953930448u, 3232752339u, 1009878771u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 411, 179600265u, 3369386607u, 1057414346u, 1319431804u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 412, 586131522u, 3279403983u, 3223631624u, 3404608264u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 413, 937427869u, 559918757u, 1105263000u, 1026957442u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 414, 128542208u, 2658716822u, 1104708872u, 996387212u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 415, 2731512332u, 3244026687u, 1047704829u, 2987820261u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 416, 829571115u, 1205633467u, 3212336151u, 731560768u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 417, 2850353849u, 3269211356u, 3233229218u, 2632041754u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 418, 1070113635u, 1007200508u, 1086406456u, 1484610595u, 1073088667u, 1300367880u, 0, ACOS_TOLERANCE, 0},
{ 419, 968866968u, 3805991624u, 1101562011u, 3292762908u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 420, 2437809818u, 3314105762u, 3211254740u, 3489200637u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 421, 2571363594u, 3198252706u, 3200980182u, 558779875u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 422, 2377866012u, 2338464653u, 1083319346u, 4167405697u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 423, 2919015115u, 2320792999u, 3245310028u, 2734025087u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 424, 2318992495u, 832495279u, 3189857572u, 919851193u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 425, 3116721767u, 594640291u, 1077503330u, 976536412u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 426, 3139145310u, 79400523u, 3241084263u, 3353474633u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 427, 3132785785u, 1078965987u, 3233772596u, 3496966466u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 428, 892587941u, 4243435186u, 1078663150u, 2446827483u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 429, 644490711u, 699817447u, 1081268534u, 2111588814u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 430, 536635513u, 177265199u, 3233855943u, 965677531u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 431, 624474831u, 3957229084u, 1065403841u, 3870961932u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 432, 2495519163u, 2768873929u, 3212244708u, 4127917680u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 433, 445621604u, 3639227340u, 1068863190u, 4192848976u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 434, 2543806408u, 2824651320u, 1092946600u, 2150743372u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 435, 417715333u, 1542109195u, 3223841580u, 2386809036u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 436, 192029360u, 1374810628u, 3218415587u, 1623455911u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 437, 733790955u, 226433601u, 1048463914u, 2667067819u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 438, 768579443u, 1339325351u, 1074062507u, 701901582u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 439, 2920705365u, 3631553324u, 1068350633u, 1231934926u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 440, 2933708324u, 603977748u, 1098802865u, 1502493757u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 441, 852954796u, 4255242031u, 1076182326u, 2417637015u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 442, 3089857028u, 3270297477u, 1057486942u, 2885336275u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 443, 2809553007u, 1162164397u, 3250508564u, 2047944882u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 444, 2875372587u, 129658419u, 3243244851u, 817360375u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 445, 286421081u, 4166988101u, 3246796270u, 1780823036u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 446, 668574270u, 418009120u, 1081026514u, 909013508u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 447, 3082072506u, 4186670845u, 1073362089u, 2619129420u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 448, 795252317u, 1348987467u, 3217165795u, 4162017137u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 449, 2946795826u, 2808968027u, 1057864611u, 275397670u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 450, 513174607u, 240711581u, 3188571226u, 991292615u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 451, 2439023326u, 1881121353u, 1082366688u, 3029043132u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 452, 192508083u, 4250650421u, 3246612558u, 2498768625u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 453, 3180747941u, 2999983605u, 1096654323u, 2577373394u, 1073291771u, 1413777035u, 0, ACOS_TOLERANCE, 0},
{ 454, 868314815u, 1300140379u, 3213491585u, 55226854u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 455, 49966445u, 13489454u, 3217461344u, 1447224005u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 456, 2210271568u, 180789028u, 3221481024u, 2263184048u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 457, 2397088667u, 426293588u, 3239818611u, 1789635787u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 458, 302342406u, 1048286093u, 3227133745u, 2920139253u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 459, 540854981u, 287184966u, 1093076159u, 1371882685u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 460, 770805810u, 2474797470u, 1065280366u, 1506889536u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 461, 2555731452u, 345487446u, 1053421486u, 1197157341u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 462, 2628226629u, 515700445u, 3214016873u, 2783826669u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 463, 467959892u, 1025779807u, 3217947229u, 937205825u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 464, 3185898801u, 503864881u, 1076822915u, 2345033570u, 1073291771u, 1414440881u, 0, ACOS_TOLERANCE, 0},
{ 465, 393896468u, 596014050u, 3250464728u, 3171536734u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 466, 2267420964u, 3948135817u, 3235208235u, 557360557u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 467, 2954074298u, 110029735u, 1081878271u, 658156641u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 468, 566438875u, 2733782773u, 1068148429u, 2141208212u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 469, 2666943954u, 790308557u, 1107048971u, 563615979u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 470, 2405996540u, 2566307075u, 1083723970u, 1428203311u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 471, 2270749356u, 3880424699u, 3236471057u, 2886278126u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 472, 524758414u, 2701977458u, 1043006318u, 4263191658u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 473, 2942114697u, 1360096867u, 3234511235u, 722957892u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 474, 3154505042u, 1993420044u, 1095357710u, 2156133394u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 475, 2461372509u, 3917014693u, 3239137997u, 3218865041u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 476, 2423614376u, 3840388050u, 1044708748u, 3339981792u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 477, 68664930u, 2548196869u, 1075650752u, 2503792874u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 478, 27003265u, 3589631476u, 3235077884u, 2445744426u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 479, 520248228u, 203410210u, 1058974455u, 4258595472u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 480, 191352353u, 3053913996u, 1043884546u, 2757616601u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 481, 2602287836u, 1038998189u, 3205430458u, 3695555540u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 482, 2449136794u, 4118722076u, 1042468417u, 3583005947u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 483, 2166884388u, 1539535238u, 3246934215u, 508708967u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 484, 2298893886u, 1355147861u, 3251354609u, 4133432965u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 485, 826309703u, 1630207738u, 3189562989u, 2643371954u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 486, 1044987158u, 3806259293u, 3242741783u, 15657985u, 1073291771u, 1360824892u, 0, ACOS_TOLERANCE, 0},
{ 487, 497456897u, 151607638u, 3227697753u, 467630898u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 488, 3017637501u, 1016107066u, 1077142954u, 2195497000u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 489, 2893082164u, 605010161u, 1050995677u, 3081653542u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 490, 469011148u, 4071435209u, 3207925259u, 1894382776u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 491, 2531356920u, 1522707251u, 3218735666u, 1578075186u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 492, 431642664u, 1500392608u, 3190947192u, 3634607405u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 493, 2582144456u, 3646244007u, 3197852749u, 3808681655u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 494, 233126338u, 1821773119u, 1094752155u, 1757234723u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 495, 2765502023u, 3794954283u, 3238755664u, 1209121339u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 496, 2342622984u, 1775878726u, 1096028209u, 221183908u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 497, 231520693u, 615054313u, 1105995987u, 1405024657u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 498, 2401381272u, 2784860416u, 1074009275u, 787419698u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 499, 943699878u, 2079960298u, 1074123223u, 2100091620u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 500, 592542034u, 311050208u, 3211234312u, 806358659u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 501, 554939259u, 898080849u, 1106754706u, 2510882902u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 502, 2949198761u, 2015533813u, 1089275809u, 298982001u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 503, 989540066u, 914741728u, 1092886795u, 464054401u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 504, 2304253208u, 3863739765u, 3214711653u, 3915767823u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 505, 958251880u, 3239739200u, 1104805370u, 2971054003u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 506, 2670649374u, 2491104644u, 3198242303u, 2559304728u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 507, 939123286u, 684435317u, 1055177809u, 2787628393u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 508, 2541359251u, 1636085321u, 1069717586u, 4235233108u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 509, 1044593898u, 202708387u, 3196003256u, 482423661u, 1073291771u, 1373409239u, 0, ACOS_TOLERANCE, 0},
{ 510, 139626925u, 2518164801u, 3206911657u, 1250530357u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 511, 2850784019u, 3737313137u, 1045922781u, 3136078996u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 512, 2263385372u, 2650572904u, 3215945256u, 2341430700u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 513, 2703884311u, 4279456618u, 1045375126u, 3817511514u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 514, 2332933790u, 1898920133u, 3238856617u, 3322385778u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 515, 628125129u, 769863378u, 3205646293u, 3033900668u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 516, 3150112853u, 2363605017u, 1057042323u, 3607277737u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 517, 453059902u, 2102433536u, 1073687186u, 1772007848u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 518, 3088101403u, 1756195518u, 3225902960u, 1222779056u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 519, 936228020u, 1142293403u, 3242693386u, 741039297u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 520, 1034983355u, 2830408439u, 1041913758u, 3306391490u, 1073291771u, 1413686173u, 0, ACOS_TOLERANCE, 0},
{ 521, 2352979086u, 2205233857u, 1075419064u, 4008575827u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 522, 445518797u, 2566866389u, 1094655457u, 4036587454u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 523, 311145393u, 1824828952u, 3243078353u, 4292530873u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 524, 2553824191u, 4155068217u, 3207589361u, 3447729183u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 525, 2798856384u, 2756570858u, 1076273685u, 3333057399u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 526, 2550428645u, 1207089191u, 1092166391u, 1769908602u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 527, 554295846u, 859290299u, 1041428225u, 1286082196u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 528, 246159230u, 2207831048u, 1106576697u, 1339163028u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 529, 2239899566u, 1165991857u, 3203879091u, 4174125604u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 530, 182461702u, 2169701868u, 3241819561u, 4227279451u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 531, 2888196098u, 2123622490u, 1052662593u, 2279271809u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 532, 702835388u, 695374285u, 1047701002u, 522745399u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 533, 280094216u, 1510677208u, 1076782817u, 1111322288u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 534, 179077993u, 2623205988u, 1103171923u, 4172761053u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 535, 2177736938u, 4217535562u, 1105411820u, 178360855u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 536, 682463458u, 3302529767u, 3204908280u, 3960051056u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 537, 398729522u, 3128926115u, 3230393394u, 689920399u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 538, 2611898873u, 2975884353u, 1080874032u, 706326922u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 539, 893776139u, 198291836u, 1095644375u, 1686271744u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 540, 2380685920u, 3678973777u, 3196054178u, 2497695971u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 541, 2240996065u, 3714083293u, 3243953714u, 2851269113u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 542, 7542429u, 2117586075u, 1087270529u, 1032855763u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 543, 2223653732u, 3495001046u, 1086693149u, 4162905644u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 544, 2567370325u, 2825204949u, 3197807718u, 3067810875u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 545, 2595670946u, 3719019697u, 1095625346u, 658578931u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 546, 387363057u, 2429869396u, 3239113006u, 3188949762u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 547, 396063874u, 322135328u, 3248332291u, 1527590526u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 548, 2461424020u, 2823164069u, 3201760069u, 602345917u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 549, 654769735u, 720378027u, 1076110022u, 259686655u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 550, 2360883068u, 625961575u, 1060816217u, 2476435835u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 551, 788830837u, 606139429u, 3232916885u, 3326100828u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 552, 3212982376u, 2141060868u, 1067726443u, 252856858u, 1073301100u, 1153746486u, 0, ACOS_TOLERANCE, 0},
{ 553, 3127084040u, 474202816u, 1089644854u, 1764399210u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 554, 1019198392u, 2947116437u, 1041572001u, 3959708969u, 1073291771u, 1413754134u, 0, ACOS_TOLERANCE, 0},
{ 555, 3213251752u, 4230614930u, 1056210276u, 3150822221u, 1073303204u, 3762064379u, 0, ACOS_TOLERANCE, 0},
{ 556, 696157297u, 3263173528u, 1080112083u, 1228319033u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 557, 124362722u, 500312015u, 1063102682u, 2095470952u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 558, 2571317678u, 989529088u, 1056203473u, 3527737002u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 559, 2250338535u, 1703579132u, 3224570219u, 634351649u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 560, 2855421441u, 66133u, 3240749422u, 3515147331u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 561, 2627889255u, 2627336059u, 1089793281u, 1944911728u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 562, 759942356u, 2319970119u, 3249679385u, 445677602u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 563, 2547610355u, 3313890389u, 1096842854u, 754196284u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 564, 2871033704u, 1726998596u, 3210485282u, 4166556675u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 565, 501872914u, 486863841u, 3218994498u, 2509132460u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 566, 1002164234u, 2205707903u, 1085826634u, 3041478081u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 567, 525633549u, 4009409345u, 1040942443u, 2147611409u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 568, 2251207280u, 2036870072u, 1084696514u, 3107506430u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 569, 756690877u, 690866455u, 3226560542u, 2431563109u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 570, 998557361u, 3129862588u, 3198582472u, 2304023232u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 571, 2906016865u, 3579751536u, 3209420505u, 975391569u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 572, 2560287784u, 546279008u, 1081489128u, 2489420520u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 573, 31598644u, 3355765111u, 3194253290u, 994990765u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 574, 2828168124u, 1040855381u, 1043794244u, 3259056345u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 575, 2926398160u, 3002823940u, 1089005277u, 3148403594u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 576, 860472364u, 4135775260u, 1062496213u, 1421204191u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 577, 2375372972u, 1772673503u, 1068413298u, 3250253780u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 578, 2382680286u, 1058735200u, 3198812726u, 2912456147u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 579, 207257772u, 3116809444u, 3228961207u, 1489607764u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 580, 3161255502u, 3193356522u, 1098081503u, 3349879051u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 581, 2263814703u, 3863515794u, 3224248078u, 811645039u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 582, 2558000392u, 257027843u, 3188376713u, 3688710472u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 583, 1047583344u, 1618589681u, 3252953815u, 1796441468u, 1073291771u, 1131003064u, 0, ACOS_TOLERANCE, 0},
{ 584, 963715447u, 2772711004u, 1068817762u, 1417472413u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 585, 2899022012u, 3229431619u, 1048945392u, 2667359336u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 586, 39332833u, 3031365654u, 3254047221u, 3088152449u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 587, 2400099045u, 1889351944u, 1105391374u, 3778764776u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 588, 2853164987u, 2277852166u, 3203738947u, 1874699830u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 589, 2730925178u, 341842475u, 1075005257u, 146768835u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 590, 2308700527u, 2872887668u, 1084601028u, 2879218577u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 591, 2587566446u, 1935797167u, 1071669036u, 2712989912u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 592, 253790896u, 1441615044u, 1092569414u, 3235243477u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 593, 2246162369u, 3221475559u, 1076923264u, 1614189331u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 594, 883591469u, 1521698692u, 1063187098u, 2905773788u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 595, 578813437u, 1875339612u, 1097776841u, 3512997257u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 596, 313284539u, 1310991474u, 1042232933u, 315006632u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 597, 2187872770u, 400944269u, 1084139528u, 1113187101u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 598, 2196755783u, 4228884820u, 1086244087u, 4239134992u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 599, 625667119u, 3885190346u, 1076394312u, 1081883031u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 600, 102978620u, 1185360438u, 1047721048u, 3255616886u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 601, 253870868u, 3242646057u, 3206743917u, 2797651324u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 602, 2741016991u, 2374818327u, 3200069106u, 409774909u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 603, 541948600u, 129626762u, 3222418776u, 3265842151u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 604, 409023275u, 2563211098u, 3195891786u, 3312029907u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 605, 590108432u, 2326742435u, 1061528026u, 3658027611u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 606, 47946496u, 4130434851u, 1086613209u, 1406937614u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 607, 2203282384u, 694337229u, 1098392210u, 673996985u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 608, 383120483u, 2165782899u, 3201118320u, 755437166u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 609, 2738514249u, 1631447464u, 1073129346u, 1109813769u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 610, 996195808u, 1404490212u, 3191965790u, 388374829u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 611, 621407424u, 1187403069u, 3249235911u, 2333348025u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 612, 2238876819u, 3949359805u, 3217090542u, 278931643u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 613, 122205568u, 3433131795u, 3216075884u, 1048643019u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 614, 378630966u, 2161249988u, 1080050285u, 1886767872u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 615, 2469519430u, 56508471u, 1101093005u, 3134765996u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 616, 2160574759u, 390814486u, 3252597757u, 4155481783u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 617, 244834788u, 2634623473u, 1106605935u, 3462407026u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 618, 3068667858u, 1081553801u, 3212510682u, 3597193645u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 619, 2681145113u, 2712139310u, 1067397110u, 3991830201u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 620, 2469611210u, 1021245839u, 1043439185u, 1476242017u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 621, 605118806u, 3027425274u, 1057959382u, 1693579371u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 622, 723258643u, 890268116u, 3208358957u, 2499328701u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 623, 3012075542u, 2762939960u, 1094140192u, 1946947338u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 624, 2624504981u, 2848774892u, 1043728239u, 1868742480u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 625, 631395565u, 2118639219u, 3208384560u, 392586300u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 626, 3100564519u, 3212404590u, 3227625019u, 2217276325u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 627, 2726525578u, 3155371392u, 1098886483u, 418306480u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 628, 404732165u, 2073105109u, 3222252812u, 4126276047u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 629, 666104043u, 3942715706u, 3225850891u, 2149087853u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 630, 691861022u, 2516919494u, 1054814504u, 3292931762u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 631, 158110000u, 1551415022u, 3207905213u, 640268289u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 632, 3017186687u, 576149615u, 1089986684u, 1988363455u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 633, 2189052396u, 3827250147u, 1092018604u, 3082769758u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 634, 2963530013u, 2640124381u, 3224863391u, 3684597672u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 635, 2674433095u, 3504206450u, 3208001954u, 1486636350u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 636, 172271302u, 3087550224u, 1050189716u, 1104066383u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 637, 2937291508u, 3152457596u, 3248116497u, 1671039260u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 638, 743510680u, 3745833360u, 1104273854u, 220649566u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 639, 455612679u, 3044998553u, 3244012440u, 3016971473u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 640, 2707727413u, 3615317113u, 1060844794u, 880769846u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 641, 91972307u, 663715669u, 1063876456u, 1939925527u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 642, 1031258381u, 3544355485u, 1082114513u, 2610512411u, 1073291771u, 1413748055u, 0, ACOS_TOLERANCE, 0},
{ 643, 3062260532u, 4072884955u, 1076396408u, 1001273000u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 644, 169240433u, 1808609104u, 3232187528u, 3260138616u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 645, 982018300u, 1018873491u, 3222306114u, 3725685935u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 646, 601770903u, 200987283u, 1044223733u, 3512285706u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 647, 2542854589u, 4073670723u, 1077133533u, 2092229545u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 648, 2434772723u, 1045739827u, 1099698978u, 2401260358u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 649, 513980741u, 4127547980u, 1041823582u, 96012619u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 650, 2244412580u, 685986273u, 3236054528u, 743504842u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 651, 3152410687u, 3762173332u, 3229804761u, 4257281451u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 652, 2398221552u, 883225705u, 1052657715u, 3748197546u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 653, 2914372880u, 1745689276u, 3189483003u, 3144701638u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 654, 584466975u, 1188703132u, 3241765574u, 2567092606u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 655, 3142928545u, 1507281554u, 1093182670u, 3093165197u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 656, 525538133u, 2853215019u, 1102960933u, 4219424176u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 657, 743378254u, 3350157882u, 3218026125u, 3380902958u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 658, 2920865644u, 3965656635u, 1041729367u, 1488955390u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 659, 76342162u, 4066317764u, 3250193636u, 3709306303u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 660, 778187300u, 3648159195u, 1060671775u, 4137599200u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 661, 298140314u, 1730811304u, 3218425255u, 3228251203u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 662, 548008019u, 1112642402u, 1046926075u, 2339033206u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 663, 373953465u, 3920135590u, 1068578082u, 3455242298u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 664, 466000998u, 171021716u, 1104170032u, 643991456u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 665, 2888399469u, 2072550721u, 3230599505u, 973021091u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 666, 50905317u, 2724027649u, 1085564300u, 4142466137u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 667, 143727064u, 2551822580u, 3246069024u, 1987298072u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 668, 890335217u, 3397840241u, 3222713245u, 1041924997u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 669, 2679007644u, 1492572480u, 1050371810u, 2325437597u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 670, 114124970u, 2135762681u, 3203689878u, 3625230590u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 671, 2580021722u, 3462823473u, 1042304476u, 902729486u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 672, 2558456833u, 652173352u, 1093628675u, 363109783u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 673, 2931846653u, 3131010476u, 3195084967u, 2163853087u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 674, 2860857242u, 2962422808u, 3191806742u, 291534500u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 675, 3180910087u, 148717545u, 3227570855u, 1176638793u, 1073291771u, 1413779568u, 0, ACOS_TOLERANCE, 0},
{ 676, 846507519u, 592218494u, 3236967859u, 3643659929u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 677, 799992724u, 3637018510u, 1096065187u, 2759677467u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 678, 2669496048u, 1394154169u, 3225515010u, 2895919661u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 679, 2888699650u, 2576460670u, 3195138207u, 278693366u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 680, 2397030301u, 3525993125u, 1046206559u, 960482701u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 681, 566728356u, 3623493345u, 3245957327u, 2358092842u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 682, 2920406944u, 1470157513u, 1068598730u, 2360266862u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 683, 287105933u, 2673272949u, 3190126532u, 3307152371u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 684, 2190509100u, 3554040933u, 3243091661u, 1074231128u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 685, 2949859096u, 506000682u, 1099596445u, 3719284608u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 686, 143293603u, 1500851201u, 1079029789u, 395506977u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 687, 2216398316u, 2396922893u, 3215773801u, 3631674284u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 688, 94791165u, 265423085u, 1064366729u, 2757995135u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 689, 2260683291u, 3335726874u, 3204388695u, 1913160810u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 690, 985593981u, 177525642u, 1089544219u, 1163479070u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 691, 1059251204u, 1356562406u, 3218720719u, 3954981400u, 1073291620u, 874618229u, 0, ACOS_TOLERANCE, 0},
{ 692, 199560954u, 2411049585u, 3200282058u, 4212977532u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 693, 3115392997u, 1969400668u, 1082838033u, 792484989u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 694, 413791550u, 3185069889u, 1102744820u, 1679200952u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 695, 816641623u, 2092563199u, 1077400892u, 3625477257u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 696, 990732070u, 3645477920u, 3233940628u, 730323504u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 697, 2640158643u, 1955024619u, 3229376333u, 3062236193u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 698, 748924276u, 673553144u, 3222681322u, 3821101717u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 699, 872312580u, 2833907590u, 1087265939u, 2570284543u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 700, 531712086u, 2911302424u, 1088378861u, 3400401866u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 701, 541730201u, 552676385u, 1048022712u, 1642148205u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 702, 323876482u, 3259465719u, 1063427827u, 4168942284u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 703, 2757624524u, 757177023u, 3224829944u, 54374532u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 704, 25847614u, 3253287925u, 3239197056u, 3859570507u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 705, 2460961478u, 3154974007u, 1089011136u, 3913013165u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 706, 311234957u, 2785357403u, 1103967007u, 2809598610u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 707, 484603275u, 3644503084u, 1071705136u, 2739219317u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 708, 2578002590u, 3518663743u, 1085926548u, 3708967464u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 709, 3007242152u, 731479478u, 1076236288u, 2805941787u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 710, 2619048947u, 779131141u, 3197589176u, 237706897u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 711, 2641650858u, 2888131473u, 3245067887u, 2007039966u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 712, 878934658u, 2219795442u, 1097959451u, 920385234u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 713, 970070259u, 1786246284u, 3210593296u, 3141517655u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 714, 28474706u, 1268866168u, 1056332378u, 3807437549u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 715, 593283356u, 2441697849u, 1095257734u, 352511160u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 716, 537273837u, 3291810518u, 1078085447u, 381074875u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 717, 466362499u, 387817055u, 3243585398u, 409681933u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 718, 337512666u, 139599181u, 1104463616u, 3501253426u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 719, 152302801u, 1804177501u, 1107025740u, 30866148u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 720, 2982215560u, 793748989u, 1082924614u, 1001569450u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 721, 3089760601u, 959143764u, 1058620462u, 2685722619u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 722, 2594786226u, 1587148467u, 1069298743u, 2465926195u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 723, 932092665u, 2374376082u, 1041131964u, 1275798358u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 724, 3064898943u, 732591095u, 1105513168u, 188500721u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 725, 833576046u, 2203077164u, 1086779764u, 2814822707u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 726, 414881598u, 3478844638u, 1064472491u, 3289144186u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 727, 964227992u, 2435698269u, 3249016304u, 440309030u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 728, 2567296069u, 3788040806u, 3187722224u, 3342255097u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 729, 723295838u, 2455751020u, 1103514973u, 3245053142u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 730, 844693850u, 4056651767u, 3239516201u, 4169582895u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 731, 550385160u, 2093642662u, 1100623425u, 792491672u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 732, 2816313046u, 83889365u, 1087600688u, 1006331335u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 733, 2572367713u, 1140517802u, 3243890765u, 4090711271u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 734, 666576601u, 2418701513u, 3216964687u, 1555649649u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 735, 2251046969u, 1215163489u, 1051353113u, 3503287900u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 736, 3159618610u, 641457589u, 1051716814u, 4121125128u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 737, 401932052u, 321857207u, 3250350790u, 1246006125u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 738, 2953696013u, 120564990u, 1097266968u, 300149226u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 739, 2254220803u, 3244980052u, 1076924215u, 847775621u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 740, 2771951028u, 112839452u, 3212858842u, 1569943525u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 741, 2165404842u, 2934678057u, 3212657738u, 3091042797u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 742, 2704093164u, 547060795u, 1079752403u, 4043827022u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 743, 244578012u, 1790462845u, 1067969586u, 2345441039u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 744, 2182959566u, 2353653565u, 1049624664u, 882286568u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 745, 462586144u, 1186302263u, 1078662178u, 2626148789u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 746, 279527707u, 4121656076u, 3224287260u, 1299277508u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 747, 470047975u, 2010385858u, 3233120941u, 4186702461u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 748, 2221693080u, 1323708810u, 3211281520u, 1640799315u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 749, 3124323904u, 3503897938u, 3210262651u, 258643165u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 750, 2619485313u, 2959074653u, 1058897059u, 4239182527u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 751, 302551175u, 153547307u, 1099812861u, 3156123094u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 752, 420210788u, 3996883503u, 1071341265u, 72657681u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 753, 158488136u, 1698212750u, 1068334402u, 160302703u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 754, 289138234u, 2257686389u, 1051856116u, 430357614u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 755, 2795510903u, 395145384u, 1046317717u, 1912800227u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 756, 935515004u, 674021561u, 3222496667u, 743247292u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 757, 2822969173u, 1075007837u, 3222487779u, 639284837u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 758, 924678051u, 3492386324u, 3251519349u, 1241408247u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 759, 2881777125u, 3998363272u, 3228147294u, 365769855u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 760, 2662939411u, 4030509561u, 1066028735u, 1163947030u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 761, 564717585u, 1914428658u, 3214617694u, 4147847493u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 762, 993107584u, 2889684117u, 1042972779u, 1225674604u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 763, 750290683u, 273406410u, 3206108502u, 145234164u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 764, 3157290800u, 912384201u, 3237262916u, 3366320623u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 765, 3022814103u, 349339167u, 3197347448u, 3262060258u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 766, 393652178u, 2097272974u, 1064845294u, 1630215394u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 767, 2250994257u, 3355589350u, 3243019072u, 2316123825u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 768, 307759713u, 1457407347u, 1101422760u, 4120356538u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 769, 2168158322u, 3228185359u, 3198251445u, 3743078041u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 770, 880898735u, 1289357713u, 3230160936u, 2794962547u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 771, 903112316u, 1699456459u, 1083794396u, 4195811825u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 772, 129746399u, 1949114369u, 1084908557u, 1325384361u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 773, 709313868u, 3979168763u, 1049036668u, 2542947959u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 774, 776361251u, 676749439u, 3192662415u, 4013712036u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 775, 255079628u, 3701636708u, 1042322101u, 3983171212u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 776, 2885977639u, 3830039616u, 3239465315u, 175489420u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 777, 2871663155u, 2897269792u, 3230650366u, 3102389747u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 778, 515647990u, 582170006u, 1068093936u, 3324264433u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 779, 870187117u, 3574970337u, 1061955111u, 637826033u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 780, 2474474250u, 1733806710u, 3216760526u, 3188307974u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 781, 25157138u, 2296028823u, 1096788400u, 1413568905u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 782, 967771954u, 1627289946u, 1046506286u, 1860326351u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 783, 876029804u, 1139086265u, 3242570406u, 3276908361u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 784, 444923881u, 3323762166u, 3206918506u, 946766885u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 785, 2438959626u, 188768962u, 1088324147u, 4105901663u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 786, 2731858209u, 460037366u, 3227174677u, 2159793181u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 787, 647960579u, 2589781051u, 3243737020u, 107237481u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 788, 342985206u, 3519881651u, 1057272132u, 2685921459u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 789, 620434247u, 1169160155u, 3206674485u, 3139856281u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 790, 1000422649u, 1898254525u, 3196770014u, 2458988443u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 791, 756268268u, 2023065054u, 1050415907u, 4070768353u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 792, 284716157u, 3336260906u, 3237972475u, 3524355405u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 793, 2520138858u, 3298979042u, 3250099033u, 1003322861u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 794, 780415343u, 1629423892u, 1061722650u, 2396420130u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 795, 2512306741u, 1945417606u, 3192839521u, 1585136212u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 796, 2649414854u, 1527139640u, 1076681917u, 4150904895u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 797, 315452952u, 267572666u, 1088475235u, 1517640973u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 798, 948438656u, 1100855041u, 3229298529u, 2451533501u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 799, 2280476280u, 853088805u, 1050931318u, 3551516956u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 800, 927051214u, 1317953425u, 3217154900u, 431061758u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 801, 803065499u, 2317271661u, 1070436470u, 4014139535u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 802, 2766450812u, 3959292396u, 3249638947u, 906232948u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 803, 475259033u, 1939780068u, 3253991906u, 906880052u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 804, 174037547u, 4170524292u, 3237763507u, 4075099457u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 805, 3111709674u, 3520923293u, 1067530616u, 2252399455u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 806, 705974097u, 1097415680u, 1055600706u, 2690540698u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 807, 465450487u, 3086226264u, 3213898048u, 3220232067u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 808, 2906752413u, 2955360278u, 1051258339u, 557182478u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 809, 2407140190u, 186287752u, 1104388811u, 1727111982u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 810, 3170043637u, 4057007843u, 1076281145u, 2008293104u, 1073291771u, 1413754155u, 0, ACOS_TOLERANCE, 0},
{ 811, 3198834469u, 2741338484u, 3252544447u, 1207037505u, 1073291772u, 654137907u, 0, ACOS_TOLERANCE, 0},
{ 812, 625923799u, 102938901u, 3218894213u, 3620282197u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 813, 2527426501u, 763746284u, 1060949875u, 80236875u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 814, 3055119358u, 1117970157u, 1084109014u, 939675744u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 815, 1002709241u, 3478694019u, 1105453279u, 2493398454u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 816, 278925941u, 2014323735u, 1096417600u, 1077078168u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 817, 22160783u, 1569149351u, 1091835152u, 3751608506u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 818, 2855839310u, 930375071u, 1084274438u, 1096450032u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 819, 949603377u, 4197396799u, 3220768028u, 3419252837u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 820, 2427096043u, 2553375912u, 3237078043u, 1357572894u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 821, 2946808178u, 703318468u, 3198897773u, 3216391250u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 822, 682409255u, 3167959965u, 1069972300u, 4099039274u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 823, 551957760u, 1199490036u, 1047137152u, 2723130471u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 824, 2635855937u, 933683213u, 3243757155u, 1468458131u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 825, 954259401u, 763829445u, 3190480801u, 1772616584u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 826, 1017324786u, 3416067384u, 1056206159u, 172017902u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 827, 2553315334u, 2799176222u, 1099022088u, 1324575553u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 828, 54501096u, 2237472662u, 3202361378u, 1770080863u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 829, 697886575u, 1509098263u, 3227321831u, 3313535397u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 830, 2834201307u, 1157206501u, 3201667023u, 2771836065u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 831, 2845352423u, 841047693u, 3220229941u, 3851041620u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 832, 2559038255u, 1637635007u, 1096670395u, 363436727u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 833, 895812927u, 544867276u, 3250055151u, 2005291812u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 834, 613660095u, 1577788839u, 3213516258u, 3678234583u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 835, 2787880976u, 3005922702u, 1060624530u, 3900344258u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 836, 369490497u, 4206745890u, 3212325607u, 3363748875u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 837, 547531448u, 2586849496u, 3195881612u, 1817038482u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 838, 2947779739u, 3675119568u, 3217354316u, 1280515099u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 839, 2360207944u, 3785128270u, 3206980957u, 986337114u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 840, 30415045u, 1959045465u, 3205100821u, 2165602568u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 841, 2874345345u, 4164694429u, 3228096442u, 1919088329u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 842, 430207315u, 1381882442u, 3215734246u, 2587666792u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 843, 721933456u, 3295845115u, 1099763106u, 4189733918u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 844, 1020902692u, 528513718u, 3241318094u, 2446416887u, 1073291771u, 1413754130u, 0, ACOS_TOLERANCE, 0},
{ 845, 23459988u, 2336116589u, 1065985897u, 3314083915u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 846, 666699893u, 3946191348u, 3195771050u, 906783975u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 847, 2277669009u, 1307551746u, 3210796216u, 988905760u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 848, 659686858u, 3690487540u, 1056058539u, 3252665112u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 849, 42479044u, 1832665932u, 1055271260u, 2605540156u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 850, 158726331u, 4095344603u, 3215114657u, 3444794506u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 851, 2383875900u, 1287837711u, 3242597773u, 4213798139u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 852, 3153341967u, 2816125725u, 1059414555u, 1477859711u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 853, 935772631u, 714564399u, 3193282956u, 2533012202u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 854, 626995971u, 3592268374u, 1058283383u, 2901729097u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 855, 793386186u, 3559004137u, 1068514800u, 3160920849u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 856, 292955800u, 691190239u, 3222935981u, 1615104840u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 857, 239139675u, 2475984769u, 1103239897u, 703637359u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 858, 710643921u, 441140946u, 3190536898u, 3492228424u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 859, 161483935u, 3877369975u, 3202400099u, 3215202168u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 860, 2961770699u, 1491180815u, 3239294185u, 1154272588u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 861, 3205774388u, 3583450204u, 1087671320u, 674510731u, 1073291852u, 1159169230u, 0, ACOS_TOLERANCE, 0},
{ 862, 2732840881u, 3456820098u, 1089546472u, 2907918480u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 863, 685577817u, 81928569u, 1075278180u, 1990416786u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 864, 1038142999u, 1400620994u, 3225378967u, 1180415269u, 1073291771u, 1413203469u, 0, ACOS_TOLERANCE, 0},
{ 865, 821776812u, 2762887697u, 3211549123u, 335890509u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 866, 3188234303u, 1362922028u, 3190091315u, 3628762502u, 1073291771u, 1416977815u, 0, ACOS_TOLERANCE, 0},
{ 867, 721900432u, 3813492886u, 3202458179u, 1901070055u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 868, 2869411161u, 242471816u, 1098704131u, 1526904338u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 869, 1027232266u, 671155008u, 1093002146u, 4241764136u, 1073291771u, 1413753715u, 0, ACOS_TOLERANCE, 0},
{ 870, 2277521859u, 4097248738u, 1056810493u, 578681886u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 871, 277897075u, 2743813242u, 1048038468u, 2228686199u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 872, 2669729433u, 777624847u, 3204357191u, 721009894u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 873, 900729335u, 724757172u, 1074804044u, 1443361721u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 874, 2794978652u, 1829019782u, 1092425225u, 921360204u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 875, 1055573469u, 599714409u, 3252379270u, 4008804686u, 1073291757u, 4048919351u, 0, ACOS_TOLERANCE, 0},
{ 876, 2335315701u, 1009458928u, 1083845809u, 4245287698u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 877, 407962355u, 1393652229u, 3198335362u, 477976573u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 878, 119992u, 617334033u, 3226883256u, 1392617441u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 879, 2526781811u, 3189972160u, 1058939729u, 1442809487u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 880, 2785887182u, 1497507448u, 3207820115u, 1605709634u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 881, 400505812u, 1497124553u, 1056018407u, 1916183627u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 882, 379250418u, 187810760u, 1045258725u, 2282203450u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 883, 619840292u, 3486351235u, 3238811394u, 4182495542u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 884, 2587166700u, 1845445426u, 1101440582u, 1926724082u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 885, 2208479151u, 3630948001u, 3210436304u, 3757166747u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 886, 156467129u, 2426945694u, 1100551290u, 691736139u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 887, 3176502800u, 648364171u, 1041433075u, 4184885944u, 1073291771u, 1413755518u, 0, ACOS_TOLERANCE, 0},
{ 888, 1000987303u, 4288583860u, 1088664697u, 2475611219u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 889, 1063779408u, 1032586628u, 1093050016u, 1335820726u, 1073288701u, 721808240u, 0, ACOS_TOLERANCE, 0},
{ 890, 2203998268u, 1808427032u, 1080779860u, 3408316613u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 891, 2973050448u, 377900895u, 3246382680u, 3547565419u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 892, 2189796743u, 2323627716u, 1059972652u, 2094048557u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 893, 3196853156u, 698816446u, 3234028118u, 1825626029u, 1073291771u, 2356901228u, 0, ACOS_TOLERANCE, 0},
{ 894, 3053056428u, 4246800079u, 3198693322u, 1124410156u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 895, 418318520u, 2453135589u, 1055899444u, 314708747u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 896, 2903016736u, 3296787864u, 1068197912u, 3000361169u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 897, 3078102424u, 2237367418u, 1089582486u, 4042266354u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 898, 3141633458u, 3484406269u, 3222793392u, 1868977643u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 899, 551079618u, 3353193428u, 1046058481u, 1204175477u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 900, 372140985u, 2936300483u, 3219636923u, 3841711417u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 901, 673975119u, 1967394048u, 1058351548u, 460961975u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 902, 186542430u, 2037284927u, 3201399531u, 2969937827u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 903, 605316943u, 4193097538u, 3187909191u, 3039418420u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 904, 560007813u, 3490045229u, 1095745195u, 4291149159u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 905, 2719344253u, 2428281947u, 3244840847u, 1401325941u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 906, 3086950621u, 2958762056u, 1053682542u, 1079751324u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 907, 2586448231u, 4153073282u, 3242138780u, 2976596113u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 908, 2225350223u, 3033242648u, 3218615502u, 4046734098u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 909, 144835976u, 3784918863u, 3247369913u, 2134568674u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 910, 1037093430u, 2677404300u, 1085544968u, 741961444u, 1073291771u, 1413479051u, 0, ACOS_TOLERANCE, 0},
{ 911, 3191671070u, 3184472282u, 1092761713u, 2878921656u, 1073291771u, 1444200196u, 0, ACOS_TOLERANCE, 0},
{ 912, 2174282657u, 3434230759u, 3221702019u, 3917984952u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 913, 2545165920u, 2576188896u, 3242449625u, 1091446541u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 914, 331286912u, 1182911629u, 3252138078u, 370659473u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 915, 2176330507u, 1444733769u, 1073172315u, 1980291498u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 916, 2678247043u, 2360783610u, 3208952465u, 1231254630u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 917, 2305545884u, 3838689849u, 1072879962u, 256746588u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 918, 2902784540u, 3667306355u, 3251214292u, 749864809u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 919, 2604503669u, 507891905u, 1053625983u, 2704533753u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 920, 1030839861u, 3584765547u, 3245124397u, 2257447093u, 1073291771u, 1413749690u, 0, ACOS_TOLERANCE, 0},
{ 921, 3066547476u, 3315149772u, 1066493112u, 1016007949u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 922, 449363956u, 825363580u, 3232843486u, 209798625u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 923, 835609236u, 3268577204u, 1096097376u, 1911303780u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 924, 2498038993u, 1753975943u, 1042812372u, 3813343580u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 925, 2711382061u, 729612230u, 3214799337u, 998858159u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 926, 362629194u, 436029885u, 1040410334u, 1429955158u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 927, 535596587u, 3221540113u, 1098769124u, 1388898057u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 928, 3182989542u, 324306108u, 3236216574u, 3657300235u, 1073291771u, 1413854759u, 0, ACOS_TOLERANCE, 0},
{ 929, 2615512563u, 583339032u, 1059119779u, 2312064517u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 930, 1018901539u, 1094068533u, 3243006833u, 3107499181u, 1073291771u, 1413754135u, 0, ACOS_TOLERANCE, 0},
{ 931, 621064893u, 2330095236u, 1045494806u, 3166363539u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 932, 848850921u, 2922855425u, 1055270013u, 3382352474u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 933, 2636544164u, 2042479846u, 1052493506u, 1108839173u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 934, 14409368u, 3796172167u, 1093571065u, 169360454u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 935, 792852082u, 1860101737u, 1103906352u, 1684270183u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 936, 857946959u, 1478693394u, 1081338739u, 2709296315u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 937, 148167699u, 2960729928u, 1099267383u, 1713640531u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 938, 385577172u, 3119726590u, 1073506160u, 3652712370u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 939, 2345316997u, 2223927344u, 1087592708u, 1855918127u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 940, 283564999u, 1025757067u, 1082898254u, 4130586757u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 941, 248963649u, 1732390968u, 3252871699u, 2342842299u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 942, 968306674u, 284897931u, 3252953804u, 1924892993u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 943, 2792404953u, 3037915642u, 3201314702u, 236884699u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 944, 2786424109u, 2193269825u, 1080777124u, 2443415975u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 945, 519195528u, 875427160u, 3254060908u, 2005185235u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 946, 2834778379u, 1185249950u, 3192573802u, 43728140u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 947, 941414883u, 1968452001u, 3208083074u, 2872106033u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 948, 1058483372u, 1955688296u, 1041438818u, 4288876237u, 1073291678u, 2710722764u, 0, ACOS_TOLERANCE, 0},
{ 949, 260098041u, 1687624754u, 1047766046u, 3073412424u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 950, 3060253014u, 1209878394u, 1095484022u, 291364597u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 951, 468175369u, 3483008135u, 1104326057u, 3143994227u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 952, 2417131043u, 3223340235u, 1090336173u, 1399132887u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 953, 783617139u, 4188530565u, 1049645776u, 3448942728u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 954, 660957346u, 1627557770u, 1058246656u, 2945931719u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 955, 1018601337u, 3373123648u, 3197792793u, 672208537u, 1073291771u, 1413754135u, 0, ACOS_TOLERANCE, 0},
{ 956, 408015225u, 3778617114u, 1062846388u, 1358342023u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 957, 410316381u, 2900182547u, 3199310787u, 414812664u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 958, 633591966u, 2464347659u, 3205131467u, 3988778663u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 959, 229808805u, 3135249601u, 1100087621u, 4100875262u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 960, 793399715u, 2358359525u, 1045184735u, 1183252266u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 961, 971564307u, 1400352853u, 3240053853u, 734055542u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 962, 348066411u, 1753967678u, 3224978909u, 1995531974u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 963, 2638555255u, 1500031970u, 3233676488u, 4052958340u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 964, 536164755u, 1866935720u, 3200756597u, 3746696244u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 965, 91363664u, 2978288684u, 1106515721u, 564707827u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 966, 447397583u, 1517077030u, 1044934689u, 4156529635u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 967, 884390674u, 1427263585u, 3247549500u, 559009887u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 968, 709965825u, 427386166u, 3224310223u, 2897984604u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 969, 748422445u, 984833499u, 1086168339u, 3414464869u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 970, 3037316018u, 1275655663u, 1051250192u, 1788042252u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 971, 647298401u, 1752811522u, 1054424401u, 3069200833u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 972, 336691782u, 4159629802u, 3227935989u, 905739373u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 973, 840207318u, 3449457931u, 1053675501u, 651755324u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 974, 588654397u, 824950980u, 1063835328u, 2970166564u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 975, 1002643220u, 3980858800u, 1097889355u, 860102770u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 976, 2925126437u, 3352952738u, 1087086428u, 1202852913u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 977, 3153295755u, 3493096285u, 3210665381u, 1226230602u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 978, 2861370199u, 2237153875u, 1063605905u, 2592496943u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 979, 812704965u, 1204681469u, 1084151922u, 928193012u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 980, 717902981u, 1892558657u, 3188880850u, 472712482u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 981, 206133394u, 1107589453u, 3240016549u, 2840254081u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 982, 645145771u, 1760994629u, 3217094564u, 2931138356u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 983, 2682176516u, 3313118532u, 1095060283u, 1256408484u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 984, 958852249u, 2822240883u, 3191644368u, 1759139386u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 985, 3064303449u, 3148616726u, 3216643810u, 4033784566u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 986, 2672549129u, 50508488u, 3234572856u, 2196737134u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 987, 199760205u, 1739301489u, 1047113374u, 2964036605u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 988, 2742280838u, 32766355u, 1078278376u, 684801414u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 989, 860036812u, 2725458084u, 3197542874u, 3768641510u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 990, 602166919u, 2877639205u, 3248394899u, 2733580401u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 991, 217158246u, 3237117913u, 1086314718u, 1194088701u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 992, 507701220u, 2969027390u, 3254737744u, 2845466153u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 993, 39202927u, 1308825168u, 3231339694u, 1185199746u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 994, 2538930797u, 3429306274u, 3236439133u, 3100989857u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 995, 2251277391u, 4179597430u, 1060231463u, 2735521684u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 996, 863742433u, 1926531024u, 1040565159u, 1724549325u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 997, 344684868u, 1215071411u, 1068384117u, 483238293u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 998, 317818997u, 197061949u, 1043473339u, 249253513u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},
{ 999, 2250299688u, 1410107326u, 3198269248u, 2880209598u, 1073291771u, 1413754136u, 0, ACOS_TOLERANCE, 0},


// AUTOMATICALLY GENERATED VECTORS STOP

};

#endif // CYGONCE_LIBM_ACOS_H multiple inclusion protection

// EOF acos.h
