//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that it is possible to use the address of member function
// in an initialization or in an assignment.
//
// Specifically check that the type of the pointer(s) may be recast
// to (void*) in order to make them compatible with the type of the
// target of the assignment or initialization.
//
// Cases:
//	overloaded constructors
//	overloaded member functions
//	overloaded virtual member functions
//	virtual destructors
//
// Cases:
//	initialization for storage class 'static' objects
//	initialization for storage class 'auto' objects
//	assignment to storage class 'auto' objects
//
// Cases:
//	member function name preceeded by &
//	member function name *not* preceeded by &

class base {
	int data_member;
public:
	base () {}
	base (int i, int j) {}
	int member_function_1 () { return 0; }
	int member_function_1 (int i, int j) { return 0; }
	virtual int member_function_2 () { return 0; }
	virtual int member_function_2 (int i, int j) { return 0; }
	virtual ~base () {}
};

typedef base* (base::*base_mfp_basep_void) ();
typedef base* (base::*base_mfp_basep_int_int) (int, int);
typedef int (base::*base_mfp_int_void) ();
typedef int (base::*base_mfp_int_int_int) (int, int);
typedef void (base::*base_mfp_void_void) ();

void* static_p0 = (void*) ((base_mfp_basep_void)	base::base);
void* static_p1 = (void*) ((base_mfp_basep_int_int)	base::base);
void* static_p2 = (void*) ((base_mfp_int_void)		base::member_function_1);
void* static_p3 = (void*) ((base_mfp_int_int_int)	base::member_function_1);
void* static_p4	= (void*) ((base_mfp_int_void)		base::member_function_2);
void* static_p5 = (void*) ((base_mfp_int_int_int)	base::member_function_2);
void* static_p6 = (void*) ((base_mfp_void_void)		base::~base);

void* static_q0 = (void*) ((base_mfp_basep_void)	&base::base);
void* static_q1 = (void*) ((base_mfp_basep_int_int)	&base::base);
void* static_q2 = (void*) ((base_mfp_int_void)		&base::member_function_1);
void* static_q3 = (void*) ((base_mfp_int_int_int)	&base::member_function_1);
void* static_q4 = (void*) ((base_mfp_int_void)		&base::member_function_2);
void* static_q5 = (void*) ((base_mfp_int_int_int)	&base::member_function_2);
void* static_q6 = (void*) ((base_mfp_void_void)		&base::~base);

void test ()
{
	void* auto_p0 = (void*) ((base_mfp_basep_void)		base::base);
	void* auto_p1 = (void*) ((base_mfp_basep_int_int)	base::base);
	void* auto_p2 = (void*) ((base_mfp_int_void)		base::member_function_1);
	void* auto_p3 = (void*) ((base_mfp_int_int_int)		base::member_function_1);
	void* auto_p4 = (void*) ((base_mfp_int_void)		base::member_function_2);
	void* auto_p5 = (void*) ((base_mfp_int_int_int)		base::member_function_2);
	void* auto_p6 = (void*) ((base_mfp_void_void)		base::~base);

	void* auto_q0 = (void*) ((base_mfp_basep_void)		&base::base);
	void* auto_q1 = (void*) ((base_mfp_basep_int_int)	&base::base);
	void* auto_q2 = (void*) ((base_mfp_int_void)		&base::member_function_1);
	void* auto_q3 = (void*) ((base_mfp_int_int_int)		&base::member_function_1);
	void* auto_q4 = (void*) ((base_mfp_int_void)		&base::member_function_2);
	void* auto_q5 = (void*) ((base_mfp_int_int_int)		&base::member_function_2);
	void* auto_q6 = (void*) ((base_mfp_void_void)		&base::~base);

	auto_p0 = (void*) ((base_mfp_basep_void)	base::base);
	auto_p1 = (void*) ((base_mfp_basep_int_int)	base::base);
	auto_p2 = (void*) ((base_mfp_int_void)		base::member_function_1);
	auto_p3 = (void*) ((base_mfp_int_int_int)	base::member_function_1);
	auto_p4 = (void*) ((base_mfp_int_void)		base::member_function_2);
	auto_p5 = (void*) ((base_mfp_int_int_int)	base::member_function_2);
	auto_p6 = (void*) ((base_mfp_void_void)		base::~base);

	auto_q0 = (void*) ((base_mfp_basep_void)	&base::base);
	auto_q1 = (void*) ((base_mfp_basep_int_int)	&base::base);
	auto_q2 = (void*) ((base_mfp_int_void)		&base::member_function_1);
	auto_q3 = (void*) ((base_mfp_int_int_int)	&base::member_function_1);
	auto_q4 = (void*) ((base_mfp_int_void)		&base::member_function_2);
	auto_q5 = (void*) ((base_mfp_int_int_int)	&base::member_function_2);
	auto_q6 = (void*) ((base_mfp_void_void)		&base::~base);

}

int main ()
{
	return 0;
}
