//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that the sizeof operator can be legally applied to function
// names, and that it yields the value one.
//
// Note that the proper size value to return when sizeof() is applied
// directly to a function name is subject to interpretation.  ANSI doesn't
// even allow such usage.  RMS thinks that the value returned for this
// "extension" should be 1.

void function ();

int func_size_1 = sizeof (function);
int func_size_2 = sizeof function;

int main ()
{
	int main_size_1 = sizeof (main);
	int main_size_2 = sizeof main;

	return ((func_size_1 != 1) || (func_size_2 != 1)
	    ||  (main_size_1 != 1) || (main_size_2 != 1));
}

void function ()
{
}
