//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Options: -O
//
// Check that the number of bytes worth of arguments is correct when
// the overloaded method call operator is invoked.
//
// In particular, check that the number of bytes of arguments is
// computed based on the actual number of bytes passed (taking into
// account implicit default type conversions which happen to actual
// arguments) and *not* just based on the total sizes of all of the
// declared formal parameter types.
//
// Note that in order for this test to pass, the cplus-class.c file
// of the G++ compiler must have been compiled with the -DESKIT flag.

int last_argument_byte_count = 0;
int number_of_calls = 0;
int errors = 0;

class c1
{
public:
    operator->() (int method_vtable_index, int argument_bytes, ...) 
      {
	number_of_calls++;
	if (last_argument_byte_count) {
		if (argument_bytes != last_argument_byte_count) {
			errors++;
		}
	} else
		last_argument_byte_count = argument_bytes;
      }

    virtual void float_method (float f);

    virtual void double_method (double d);
};

int test()
{
	c1 *c1_object_ptr = new c1;
	float f = 1.2345;
	double d = 1.2345;

	c1_object_ptr->float_method(f);
	c1_object_ptr->double_method(d);
}

int main ()
{
	test();
	return ((number_of_calls != 2) || errors) ? 1 : 0;
}

void c1::float_method (float f)
{
}

void c1::double_method (double d)
{
}
