//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a base class declares a virtual member with a given name,
// and if a class derived from that base class also declares a member
// (virtual or non-virtual) with the same name, but with a different
// parameter type profile, no errors are issued, and both functions
// can be called.

struct base {
	virtual void member (int i, int j) { i = j; };
};

struct derived : public base {
	virtual void member (int i) { i = i; };
};

int main ()
{
	base base_object;
	derived derived_object;
	int i = 0, j = 0;

	base_object.member (i, j);
	derived_object.member (i);
	derived_object.member (i, j);
	return 0;
}
