//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

//  Test that compiler correctly handles private base classes. In particular,
//  an implicit conversion from a derived pointer to a base pointer should
//  only be made when the base class is public. See Stroustrap, p. 197.
//
//  Actually, g++ carries this rule even farther and performs implicit
//  conversions on objects and references as well as pointers. Though this
//  doesn't conform to The Book, if you're going to do this, it should
//  follow the same rules as pointers regarding private base classes.
//  As demonstrated below, this is only partially true.

class base {
    int data_member;
public:
    base ()   {data_member = 0;}
    base (int i)  {data_member = i;}
    void do_something (base& param) { param.data_member = param.data_member;}
};

class derived : private base {
    int data_member;
public:
     derived () {data_member = 0;}
};

void test ()
{
   base     base_obj;
   derived  derived_obj;

      //
      // The following statements should be in error on one hand because
      // you can only perform implicit pointer conversions between derived
      // and base class objects. However, even if you accept this behavior,
      // they should still be in error because <base> is private.
      //
   base_obj = derived_obj;                // ERROR
   base_obj.do_something (derived_obj);   // ERROR
}
