//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a constant object is declared as external, it may not
// also be initialized to a value in the same declarative statement.
//
// Cases:
//	file scope
//	function local scope
//	block scope

extern const int global_int_const = 11;			// ERROR

int j;
void fake (int i) { j = i; }

int main ()
{
	extern const int local_int_const = 33;		// ERROR

	fake (local_int_const);
	if (j)
	{
		extern const int block_local = 55;	// ERROR

		fake (block_local);
	}
	fake (global_int_const);
	return 0;
}
