//  This file is part of GNU c++-suite.
//  
//  GNU c++-suite is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 1, or (at your option)
//  any later version.
//  
//  GNU c++-suite is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//  
//  You should have received a copy of the GNU General Public License
//  along with GNU c++-suite; see the file COPYING.  If not, write to
//  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

// Check that if a member function is called via its (class name)
// qualified name, that this insures that that particular function
// will be called and that the call will not be routed through the
// virtual function table.

struct base
{
	int data_member;

	virtual void function_member ();
};
 
struct derived : public base
{
	int data_member;

	virtual void function_member ();
};

int base_function_called = 0;

derived *dp;
 
int main ()
{
	derived d_object;

	dp = new derived ();

	d_object.base::function_member ();
	dp->base::function_member ();

	return (base_function_called != 2);
} 

void base::function_member ()
{
	base_function_called++;
}

void derived::function_member ()
{
}
