// File based streams -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ working draft paper: 27.8  File-based streams
//

namespace std
{

template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>::
    basic_filebuf()
: _M_fd(-1)
, _M_state(_S_closed)
, _M_unbuffered(false)
, _M_ibuf_size(0)
, _M_ibuffer(0)
, _M_ebuffer(0)
, _M_can_write(false)
{
  try {
    _M_ibuf_size = _S_page_size/sizeof(_CharT);
    _M_ibuffer = new _CharT[_M_ibuf_size];
    _M_ebuffer = new char  [_S_page_size];
  } catch (...) {
    delete [] _M_ibuffer;
    delete [] _M_ebuffer;
    throw;
  }
  this->setg(0,0,0);
  this->setp(0,0);
}

template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>::
    basic_filebuf(int __fd, ios_base::_Fd_selector __way)
: _M_fd(__fd)
, _M_state(_S_seeked)
, _M_unbuffered(false)
, _M_ibuf_size(0)
, _M_ibuffer(0)
, _M_ebuffer(0)
, _M_can_write(__way == ios_base::_S_fd_out)
, _M_can_read( __way == ios_base::_S_fd_in)
{
  try {
    _M_ibuf_size = _S_page_size/sizeof(_CharT);
    _M_ibuffer = new _CharT[_M_ibuf_size];
    _M_ebuffer = new char  [_S_page_size];
  } catch (...) {
    delete [] _M_ibuffer;
    delete [] _M_ebuffer;
    throw;
  }
  this->setg(0,0,0);
  this->setp(0,0);
}

template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>*
  basic_filebuf<_CharT,_Traits>::
    open(const char* __s, ios_base::openmode __mode)
{
  if (_M_state != _S_closed || (_M_fd = _S_os_raw_open(__s, __mode)) < 0)
    return 0;
  _M_state = _S_seeked;
  _M_can_write = ((__mode & ios_base::out) != 0);
  _M_can_read =  ((__mode & ios_base::in) != 0);
  return this;
}

template <class _CharT, class _Traits>
  void
  basic_filebuf<_CharT,_Traits>::
    _M_open(int __fd, ios_base::openmode __mode)
{
  if (_M_state != _S_closed || __fd < 0)
    return;
  _M_fd = __fd;
  _M_state = _S_seeked;
  _M_can_write = ((__mode & ios_base::out) != 0);
  _M_can_read =  ((__mode & ios_base::in)  != 0);
}

template <class _CharT, class _Traits>
  basic_filebuf<_CharT,_Traits>*
  basic_filebuf<_CharT,_Traits>::
    close ()
{
  if (_M_state == _S_closed)
    return 0;

  if (_M_state == _S_writing)
    this->sync();
  if (0 == _S_os_raw_close(_M_fd))
    return 0;

  _M_state = _S_closed;
  return this;
}

template <class _CharT, class _Traits>
  int
  basic_filebuf<_CharT,_Traits>::
    showmanyc()
{
  // XXX call _S_os_raw_fstat to get a better estimate.
  return 0;
}

template <class _CharT, class _Traits>
  streamsize
  basic_filebuf<_CharT,_Traits>::
    xsgetn(char_type* __s, streamsize __n)
{
  // XXX
  return 0;
}

template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_filebuf<_CharT,_Traits>::
    underflow()
{
  // XXX
  return _Traits::eof();
}

template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_filebuf<_CharT,_Traits>::
    uflow()
{
  // XXX
  return _Traits::eof();
}

template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_filebuf<_CharT,_Traits>::
    pbackfail(int_type __c)
{
  // XXX
  return _Traits::eof();
}

template <class _CharT, class _Traits>
  streamsize
  basic_filebuf<_CharT,_Traits>::
    xsputn(const char_type* __s, streamsize __n)
{
  // XXX far from optimal
  streamsize __i = 0;
  for (;__i < __n; ++__i)
    if (_Traits::eq_int_type(this->sputc(__s[__i]),_Traits::eof()))
      break;
  return __i;
}

template <class _CharT, class _Traits>
  typename _Traits::int_type
  basic_filebuf<_CharT,_Traits>::
    overflow(int_type __c)
{
  if (_M_state == _S_writing) {
    if (!_Traits::eq_int_type(__c,_Traits::eof())) {
      *this->pptr() = _Traits::to_char_type(__c);
      this->pbump(1);  // force it! now pptr() > epptr().
    }
    if (this->pubsync() == -1)
      return _Traits::eof();
  } else if (_M_state == _S_seeked && _M_can_write) {
    if (_M_unbuffered) {
       _M_state = _S_writing;
       _CharT __cb[1] = { _Traits::to_char_type(__c) };
       this->setp(__cb,__cb+1);
       this->pbump(1);
       if (this->pubsync() == -1)
         return _Traits::eof();
    } else {
      _M_state = _S_writing;
      this->setp(_M_ibuffer,_M_ibuffer+_M_ibuf_size-1);
      if (!_Traits::eq_int_type(__c,_Traits::eof())) {
        *this->pptr() = _Traits::to_char_type(__c);
        this->pbump(1);
      }
    }
  } else
     return _Traits::eof();
  return _Traits::not_eof(__c);
}

template <class _CharT, class _Traits>
  basic_streambuf<_CharT,_Traits>*
  basic_filebuf<_CharT,_Traits>::
    setbuf(char_type* __s, streamsize __n)
{
  if (_M_state == _S_seeked && __s == 0 && __n == 0) {
    this->_M_unbuffered = true;
    return this;
  }
  return 0;
}

template <class _CharT, class _Traits>
  typename _Traits::pos_type
  basic_filebuf<_CharT,_Traits>::
    seekoff(off_type __off, ios_base::seekdir __way,
             ios_base::openmode __which)
{
  // XXX should see if __sp is in the buffer and try to continue using it.
  // XXX but for now, sync, seek, and go.
  typedef typename _Traits::pos_type _Pos;
  return _Pos(); // XXX wrong
}

template <class _CharT, class _Traits>
  typename _Traits::pos_type
  basic_filebuf<_CharT,_Traits>::
    seekpos(pos_type __sp,
            ios_base::openmode __which)
{
  // XXX should see if __sp is in the buffer and try to continue using it.

  // XXX but for now, sync, seek, and go.
  typedef typename _Traits::pos_type _Pos;
  return _Pos(); // XXX wrong
}

template <class _CharT, class _Traits>
  int
  basic_filebuf<_CharT,_Traits>::
    sync()
{
  int __result = 0;
  if (_M_state == _S_writing) {
    int __wrote_total = 0;
    int __towrite = this->pptr() - this->pbase();
    if (__towrite) {
#if 0
      if (_M_translating) {
         // XXX use facet codecvt.  Ignore for now.
      }
#endif
      _CharT* __start = this->pbase();
      int __wrote = 0;
      do {
        __wrote = _S_os_raw_write(_M_fd, __start, __towrite);
        if (__wrote == 0) {
          if (__wrote_total) {  // may succeed later with the rest.
             // XXX should be std::memmove
             memmove(this->pbase(), __start, __towrite);
             this->setp(_M_ibuffer, _M_ibuffer+_M_ibuf_size-1);
	     this->pbump(__towrite);
          } 
          return -1;
        }
        __wrote_total += __wrote;
        __start += __wrote;
      } while ((__towrite -= __wrote) != 0);
    }
    _M_state = _S_seeked;
    this->setp(0,0);
  } else if (_M_state == _S_reading) {
     // XXX clear buffer.
  }
  return __result;
}

template <class _CharT, class _Traits>
  void
  basic_filebuf<_CharT,_Traits>::
    imbue (const locale& __loc)
{
  // XXX check for identical codecvt facet; if not, reinitialize
  //  conversion mode.
}

} // namespace std
