// File based streams -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ working draft paper: 27.8  File-based streams
//

#ifndef _CPP_FSTREAM
#define _CPP_FSTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/std_streambuf.h>
#include <bits/std_istream.h>
#include <bits/std_ostream.h>

namespace std {

    template <class _CharT, class _Traits>
    class basic_filebuf : public basic_streambuf<_CharT,_Traits>
    {
    public:
      // Types (inherited from basic_streambuf):
      typedef _CharT                     char_type;
      typedef typename _Traits::int_type int_type;
      typedef typename _Traits::pos_type pos_type;
      typedef typename _Traits::off_type off_type;
      typedef _Traits                    traits_type;

    private:
      int  _M_fd;          // UNIX file descriptor
      enum _State {
	_S_closed,
	_S_reading,
	_S_writing,
	_S_seeked
      };
      _State _M_state;

      bool    _M_unbuffered;  
      int     _M_ibuf_size; // capacity of _M_ibuffer
      _CharT* _M_ibuffer;   // internal representation.
      char*   _M_ebuffer;   // external representation: just char.
      bool    _M_can_write; // opened for write or read-write.
      bool    _M_can_read;  // opened for read or read-write.
//      bool    _M_translating; // codevt<>::always_noconv returned false

      // XXX this doesn't belong here.  It should be the real machine
      //     page size, suitable for mmap-ing.
      static const int _S_page_size = 4096;

    public:
      // Constructors/destructor:
      basic_filebuf ();
      basic_filebuf (int __fd, ios_base::_Fd_selector);
      virtual ~basic_filebuf ()
	{ close (); }

      // Members:
      bool is_open () const { return _M_state != _S_closed; }
      basic_filebuf<_CharT,_Traits>* open (const char* __s,
					  ios_base::openmode __mode);
      void _M_open(int __fd, ios_base::openmode __mode);
      basic_filebuf<_CharT,_Traits>* close ();

    protected:
      // Overridden virtual functions:
      virtual int showmanyc ();
      virtual streamsize xsgetn (char_type* __s, streamsize __n);
      virtual int_type underflow ();
      virtual int_type uflow ();
      virtual int_type pbackfail (int_type __c = _Traits::eof ());
      virtual streamsize xsputn (const char_type* __s, streamsize __n);
      virtual int_type overflow (int_type __c = _Traits::eof ());
      virtual basic_streambuf<_CharT,_Traits>* setbuf (char_type* __s,
						       streamsize __n);
      virtual pos_type seekoff (off_type __off, ios_base::seekdir __way,
				ios_base::openmode __which =
                                  ios_base::in|ios_base::out);
      virtual pos_type seekpos (pos_type __sp,
				ios_base::openmode __which =
                                  ios_base::in|ios_base::out);
      virtual int sync ();

      virtual void imbue (const locale& __loc);
    };

    typedef basic_filebuf<char> filebuf;
    typedef basic_filebuf<wchar_t> wfilebuf;

#if 0
    // XXX a temporary expedient: specialization, to use libio
    filebuf::basic_filebuf ();
    int filebuf::overflow (int __c);
    filebuf* filebuf::close();
    int filebuf::underflow();
    int filebuf::sync();
    streamsize filebuf::xsputn(const char*, streamsize);
    streamsize filebuf::xsgetn(char*, streamsize);
#endif

    //  27.8.1.5  Template class basic_ifstream
    template <class _CharT, class _Traits>
    class basic_ifstream : public basic_istream<_CharT,_Traits>
    {
    public:
      // Types:
      typedef _CharT char_type;
      typedef typename _Traits::int_type int_type;
      typedef typename _Traits::pos_type pos_type;
      typedef typename _Traits::off_type off_type;

    private:
      basic_filebuf<_CharT,_Traits> _M_sb;

    public:
      // Constructors:
      basic_ifstream ();
      explicit basic_ifstream(const char* __s,
                              ios_base::openmode __mode = ios_base::in);

      // Members:
      basic_filebuf<_CharT,_Traits>* rdbuf () const { return &_M_sb; }
      bool is_open () { return rdbuf ()->is_open (); }
      void open (const char* __s, ios_base::openmode __mode = ios_base::in)
	{ if (!rdbuf ()->open (__s, __mode | ios_base::in))
	    this->setstate (ios_base::failbit); }
      void close ()
        { if (!rdbuf ()->close ())
	    this->setstate (ios_base::failbit);	}
    };

    template <class _CharT, class _Traits>
    basic_ifstream<_CharT,_Traits>::basic_ifstream ()
      : basic_istream<_CharT,_Traits> (&_M_sb), _M_sb ()
      { }

    template <class _CharT, class _Traits>
    basic_ifstream<_CharT,_Traits>::
    basic_ifstream(const char* __s, ios_base::openmode __mode)
      : basic_istream<_CharT,_Traits> (&_M_sb), _M_sb ()
      { this->open (__s, __mode); }


    // 27.8.1.8  Template class basic_ofstream
    template <class _CharT, class _Traits>
    class basic_ofstream : public basic_ostream<_CharT,_Traits>
    {
    public:
      // Types:
      typedef _CharT char_type;
      typedef typename _Traits::int_type int_type;
      typedef typename _Traits::pos_type pos_type;
      typedef typename _Traits::off_type off_type;

    private:
      basic_filebuf<_CharT,_Traits> _M_sb;

    public:
      // Constructors:
      basic_ofstream ()
	: basic_ostream<_CharT,_Traits> (&_M_sb), _M_sb () { }
      explicit basic_ofstream (const char* __s, ios_base::openmode __mode =
                                 (ios_base::out | ios_base::trunc));
      // Members:
      basic_filebuf<_CharT,_Traits>* rdbuf () const
        { return const_cast<basic_filebuf<_CharT,_Traits>*>(&_M_sb); }
      bool is_open () { return rdbuf ()->is_open (); }
      void open (const char* __s, ios_base::openmode __mode = out | trunc)
	{ if (!rdbuf ()->open (__s, __mode | ios_base::out))
	    this->setstate (ios_base::failbit); }
      void close ()
	{ if (!rdbuf ()->close ())
	    setstate (ios_base::failbit); }
    };

    template <class _CharT, class _Traits>
      basic_ofstream<_CharT,_Traits>::
        basic_ofstream (const char* __s, ios_base::openmode __mode)
        : basic_ostream<_CharT,_Traits> (&_M_sb)
        , _M_sb ()
        { this->open(__s, __mode); }

    typedef basic_ofstream<char> ofstream;
    typedef basic_ofstream<wchar_t> wofstream;


    // 27.8.1.11  Template class basic_fstream
    template <class _CharT, class _Traits>
    class basic_fstream : public basic_iostream<_CharT,_Traits>
    {
    public:
      // Types
      typedef _CharT char_type;
      typedef typename _Traits::int_type int_type;
      typedef typename _Traits::pos_type pos_type;
      typedef typename _Traits::off_type off_type;

    private:
      basic_filebuf<_CharT,_Traits> _M_sb;

    public:
      // Constructors/destructor
      basic_fstream ()
	: basic_iostream<_CharT,_Traits> (&_M_sb), _M_sb () { }
      explicit basic_fstream (const char* __s,
			      ios_base::openmode __mode = (ios_base::in
							 | ios_base::out))
	: basic_iostream<_CharT,_Traits> (&_M_sb), _M_sb ()
	{ this->open (__s, __mode | ios_base::in | ios_base::out); }

      // Members:
      basic_filebuf<_CharT,_Traits>* rdbuf () const { return &_M_sb; }
      bool is_open () { return rdbuf ()->is_open (); }
      void open(const char* __s, ios_base::openmode __mode =
                  (ios_base::in | ios_base::out))
	{ if (!rdbuf ()->open (__s, __mode | ios_base::out | ios_base::out))
	    setstate (ios_base::failbit); }
      void close ()
	{ if (!rdbuf ()->close ())
	    setstate (ios_base::failbit); }
    };

    typedef basic_fstream<char> fstream;
    typedef basic_fstream<wchar_t> wfstream;

} // namespace std

#ifdef _G_NO_TEMPLATE_EXPORT
# define export
# include <bits/os_raw.h>
# include <bits/fstream.tcc>
# include <bits/std_cstring.h>  // memmove
#endif

#endif	/* _CPP_FSTREAM */
