// Standard stream manipulators -*- C++ -*-

// Copyright (C) 1997,1998 Cygnus Solutions
//
// This file is part of the libstdc++ version 3 distribution.
//
// This software is a copyrighted work licensed under the terms of the
// Cygnus libstdc++ license. Please consult the file LICENSE.STD for
// details.

//
// ISO C++ working draft paper: 27.6.3  Standard manipulators
//

#ifndef _CPP_IOMANIP
#define _CPP_IOMANIP 1

#include <bits/c++config.h>
#include <bits/std_istream.h>
#include <bits/std_functional.h>

namespace std {

  struct _Resetiosflags { ios_base::fmtflags _M_mask; };
  _Resetiosflags resetiosflags (ios_base::fmtflags __mask)
    { _Resetiosflags __x; __x._M_mask = __mask; return __x; }
  template <class _CharT, class _Traits>
    basic_istream<_CharT,_Traits>& 
    operator>>(basic_istream<_CharT,_Traits>& __is, _Resetiosflags __f)
      { __is.setf(ios_base::fmtflags(0), __f._M_mask); return __is; }
  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>& 
    operator<<(basic_ostream<_CharT,_Traits>& __os, _Resetiosflags __f)
      { __os.setf(ios_base::fmtflags(0), __f._M_mask); return __os; }

  struct _Setiosflags { ios_base::fmtflags _M_mask; };
  _Setiosflags setiosflags (ios_base::fmtflags __mask)
    { _Setiosflags __x; __x._M_mask = __mask; return __x; }
  template <class _CharT, class _Traits>
    basic_istream<_CharT,_Traits>& 
    operator>>(basic_istream<_CharT,_Traits>& __is, _Setiosflags __f)
      { __is.setf(__f._M_mask); return __is; }
  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>& 
    operator<<(basic_ostream<_CharT,_Traits>& __os, _Setiosflags __f)
      { __os.setf(__f._M_mask); return __os; }

  struct _Setbase { int _M_base; };
  _Setbase setbase (int __base)
    { _Setbase __x; __x._M_base = __base; return __x; }
  template <class _CharT, class _Traits>
    basic_istream<_CharT,_Traits>& 
    operator>>(basic_istream<_CharT,_Traits>& __is, _Setbase __f)
      {
	 is.setf(__f._M_base ==  8 ? ios_base::oct : 
		 __f._M_base == 10 ? ios_base::dec : 
		 __f._M_base == 16 ? ios_base::hex : 
		 ios_base::fmtflags(0), ios_base::basefield);
	 return __is; 
      }
  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>& 
    operator<<(basic_ostream<_CharT,_Traits>& __os, _Setbase __f)
      {
    	 __os.setf(__f._M_base ==  8 ? ios_base::oct : 
		   __f._M_base == 10 ? ios_base::dec : 
		   __f._M_base == 16 ? ios_base::hex : 
		   ios_base::fmtflags(0), ios_base::basefield);
  	 return __os; 
      }

  template<class _CharT> struct _Setfill { _CharT _M_c; };
  template<class _CharT> _Setfill<_CharT> setfill (_CharT __c)
    { _Setfill<_CharT> __x; __x._M_c = __c; return __x; }
  template <class _CharT, class _Traits>
    basic_istream<_CharT,_Traits>& 
    operator>>(basic_istream<_CharT,_Traits>& __is, _Setfill<_CharT> __f)
      { __is.fill(__f._M_c); return __is; }
  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>& 
    operator<<(basic_ostream<_CharT,_Traits>& __os, _Setfill<_CharT> __f)
      { __os.fill(__f._M_c); return __os; }

  struct _Setprecision { int _M_n; };
  _Setprecision setprecision (int __n)
    { _Setprecision __x; __x._M_n = __n; return __x; }
  template <class _CharT, class _Traits>
    basic_istream<_CharT,_Traits>& 
    operator>>(basic_istream<_CharT,_Traits>& __is, _Setprecision __f)
      { __is.precision(__f._M_n); return __is; }
  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>& 
    operator<<(basic_ostream<_CharT,_Traits>& __os, _Setprecision __f)
      { __os.precision(__f._M_n); return __os; }

  struct _Setw { int _M_n; };
  _Setw setw (int __n)
    { _Setw __x; __x._M_n = __n; return __x; }
  template <class _CharT, class _Traits>
    basic_istream<_CharT,_Traits>& 
    operator>>(basic_istream<_CharT,_Traits>& __is, _Setw __f)
      { __is.width(__f._M_n); return __is; }
  template <class _CharT, class _Traits>
    basic_ostream<_CharT,_Traits>& 
    operator<<(basic_ostream<_CharT,_Traits>& __os, _Setw __f)
      { __os.width(__f._M_n); return __os; }

} // namespace std

#endif	/* __IOMANIP */
