/* Return value of complex exponential function for float complex value.
   Copyright (C) 1997,1998 Cygnus Solutions

   This file is part of the libstdc++ version 3 distribution.

   This software is a copyrighted work licensed under the terms of the
   Cygnus libstdc++ license. Please consult the file LICENSE.STD for
   details.  */

#include <math.h>
#include "mathconf.h"


__complex__ float
cexpf (__complex__ float x)
{
  __complex__ float retval;

  if (FINITEF_P (__real__ x))
    {
      /* Real part is finite.  */
      if (FINITEF_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  float exp_val = expf (__real__ x);
	  float sinix = sinf (__imag__ x);
	  float cosix = cosf (__imag__ x);

	  if (FINITEF_P (exp_val))
	    {
	      __real__ retval = exp_val * cosix;
	      __imag__ retval = exp_val * sinix;
	    }
	  else
	    {
	      __real__ retval = __copysignf (exp_val, cosix);
	      __imag__ retval = __copysignf (exp_val, sinix);
	    }
	}
      else
	{
	  /* If the imaginary part is +-inf or NaN and the real part
	     is not +-inf the result is NaN + iNaN.  */
	  __real__ retval = NAN;
	  __imag__ retval = NAN;
	}
    }
  else if (INFINITEF_P (__real__ x))
    {
      /* Real part is infinite.  */
      if (FINITEF_P (__imag__ x))
	{
	  /* Imaginary part is finite.  */
	  float value = signbit (__real__ x) ? 0.0 : HUGE_VALF;

	  if (__imag__ x == 0.0)
	    {
	      /* Imaginary part is 0.0.  */
	      __real__ retval = value;
	      __imag__ retval = __imag__ x;
	    }
	  else
	    {
	      float sinix = sinf (__imag__ x);
	      float cosix = cosf (__imag__ x);

	      __real__ retval = __copysignf (value, cosix);
	      __imag__ retval = __copysignf (value, sinix);
	    }
	}
      else if (signbit (__real__ x) == 0)
	{
	  __real__ retval = HUGE_VALF;
	  __imag__ retval = NAN;
	}
      else
	{
	  __real__ retval = 0.0;
	  __imag__ retval = __copysignf (0.0, __imag__ x);
	}
    }
  else
    {
      /* If the real part is NaN the result is NaN + iNaN.  */
      __real__ retval = NAN;
      __imag__ retval = NAN;
    }

  return retval;
}
