// File based streams -*- C++ -*-

// Copyright (C) 1997-1999 Cygnus Solutions
//
// This file is part of the GNU ISO C++ Library.  This library is free
// software; you can redistribute it and/or modify it under the
// terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option)
// any later version.

// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License along
// with this library; see the file COPYING.  If not, write to the Free
// Software Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307,
// USA.

// As a special exception, you may use this file as part of a free software
// library without restriction.  Specifically, if other files instantiate
// templates or use macros or inline functions from this file, or you compile
// this file and link it with other files to produce an executable, this
// file does not by itself cause the resulting executable to be covered by
// the GNU General Public License.  This exception does not however
// invalidate any other reasons why the executable file might be covered by
// the GNU General Public License.

//
// ISO C++ 14882: 27.8  File-based streams
//

#ifndef _CPP_FSTREAM
#define _CPP_FSTREAM	1

#include <bits/c++config.h>
#include <bits/std_ios.h>
#include <bits/std_streambuf.h>
#include <bits/std_istream.h>
#include <bits/std_ostream.h>

namespace std {

  template <class _CharT, class _Traits>
  class basic_filebuf : public basic_streambuf<_CharT,_Traits>
  {
    // Types:
    typedef _CharT                     	       		char_type;
    typedef typename _Traits::int_type 			int_type;
    typedef typename _Traits::pos_type 			pos_type;
    typedef typename _Traits::off_type 			off_type;
    typedef _Traits                    			traits_type;
    typedef basic_streambuf<_CharT, _Traits> 		streambuf_type;
    typedef basic_filebuf<_CharT, _Traits>		filebuf_type;
    typedef _IO_FILE					file_type;
    typedef typename _Traits::state_type		state_type;
    typedef codecvt<_CharT, char, state_type> 		codecvt_type;

    // Data Members:
    int     		_M_flags; 	// Corresponds to _IO_flag in _IO_FILE.
    file_type* 		_M_file;
    state_type		_M_state_cur; 	// Current state type for codecvt.
    state_type 		_M_state_beg; 	// Beginning state tyep for codecvt.
    const codecvt_type*	_M_cvt; 	// Cached value from use_facet.
    int			_M_buf_size; 	// XX const? Necessary? 
    char_type*		_M_buf; 
    bool 		_M_open; 	// XXX Hack--eventually bitmask?
    bool		_M_last_overflowed; // XX Hack as above?

    //981215 bkoz
#if 0
    int  _M_fd;          // UNIX file descriptor
    enum _State {
      _S_closed,
      _S_reading,
      _S_writing,
      _S_seeked
    };
    _State _M_state;


    bool    _M_unbuffered;  
    int     _M_ibuf_size; // capacity of _M_ibuffer
    _CharT* _M_ibuffer;   // internal representation.
    char*   _M_ebuffer;   // external representation: just char.
    bool    _M_can_write; // opened for write or read-write.
    bool    _M_can_read;  // opened for read or read-write.
    //bool    _M_translating; // codevt<>::always_noconv returned false
    
    // XXX this doesn't belong here.  It should be the real machine
    //     page size, suitable for mmap-ing.
    static const int _S_page_size = 4096;
#endif

  public:
    // Constructors/destructor:
    basic_filebuf(): streambuf_type(), 
      _M_flags(0), _M_file(NULL), _M_state_cur(), _M_state_beg(), 
      _M_open(false), _M_last_overflowed(false)
      {
	_M_cvt = &use_facet<codecvt_type>(this->getloc());
	_M_buf_size = 4096 / sizeof(char_type); // XXX Need more abstraction.
	try {
	  _M_buf = new char_type[_M_buf_size];
	}
	catch(...) {
	  delete [] _M_buf;
	}
      }

    basic_filebuf(const char* __name, ios_base::openmode __way);

    virtual ~basic_filebuf() 
      { 
	this->close();
	if (_M_buf_size)
	  delete [] _M_buf;
	_M_last_overflowed = false;
      }

    // Members:
    bool is_open () const 
      { return _M_open; }
    
    filebuf_type* open (const char* __s, ios_base::openmode __mode)
      {
	filebuf_type *__retval = NULL;
	int __sval = 1;
	if (!_M_open)
	  {
	    _M_file = _S_os_open(__s, __mode);
	    if (_M_file && __mode & ios_base::ate)
	      __sval = _S_os_seek(_M_file, 0, SEEK_END);
	    if (__sval < 0) // Reposition fails
	      close();
	    _M_open = true;
	   _M_file->_flags |= __mode;	    
	    this->_M_equilibrate();
	    __retval = this;
	  }
	return __retval;
      }
    
    filebuf_type* close()
      {
	filebuf_type *__retval = NULL;
	if (_M_open)
	  {
	    bool __testput = _M_out_cur != _M_out_beg;
	    int __i = -1;
	    if (__testput)
	      this->overflow(traits_type::eof());
	    if (_M_last_overflowed)
	      {
		// XXX Evenutally, something like this.
		char_type *__last = NULL;
		state_type __st; //XXX
		codecvt_base::result __r = _M_cvt->unshift(__st, _M_out_cur, _M_out_end, __last); 
		if (__r == codecvt_base::ok)
		  this->overflow(EOF);
		// XXX do something if not ok or partical or error
	      }
	    __i = _S_os_close(_M_file);
	    if (!__i)
	      {
		_M_open = false;
		__retval = this;
	      }
	  }
	return __retval;
      }

  protected:
    // Overridden virtual functions:
    virtual int showmanyc ()
      {
	int __retval = -1;
	if (_M_in_cur != _M_in_end)
	  __retval = ((egptr() - gptr()) / sizeof(char_type));
	_M_last_overflowed = false;	
	return __retval;
       }
    
    virtual int_type underflow ()
      {
	int_type __retval = traits_type::eof();
	bool __testcur= this->gptr() != NULL;
	bool __testbeg = this->eback() != NULL;
	bool __testpos = this->gptr() >= this->egptr();
	long __pendinglen = 0;
	long __backuplen = 0; // XXX streamsize, but needs to be signed.
	char_type __retc = 0;
	
	if (__testcur)
	  {
	    __pendinglen = static_cast<long> (this->egptr() - this->gptr()); 
	    __pendinglen /=  sizeof(char_type);
	    __retc = *gptr();
	  }
	
	if (__testbeg)
	  {
	    __backuplen = static_cast<long> (this->gptr() - this->eback());
	    __backuplen /=  sizeof(char_type);
	  }
	// XXX Any ideas as to what the mumbo-jumbo in this definition
	// actually means?
	_M_last_overflowed = false;	
	return __retval;
      }
    
    virtual int_type uflow ()
      {
	int_type __retval = traits_type::eof();
	_M_last_overflowed = false;	
	return __retval;
      }
    
    virtual int_type pbackfail (int_type __c = _Traits::eof ())
      {
	int_type __retval = traits_type::eof();
	_M_last_overflowed = false;	
	return __retval;
      }
    
    virtual int_type overflow (int_type __c = _Traits::eof ())
      {
	int_type __retval = traits_type::eof();
	_M_last_overflowed = true;	
	return __retval;
      }
    
    virtual streambuf_type* setbuf (char_type* __s, streamsize __n)
      {
	bool __testin = this->gptr() == this->eback();
	bool __testout = this->pptr() == this->pbase();
	if (__testin && __testout && __s == 0 && __n == 0)
	  {
	   _M_file->_flags |= _IO_UNBUFFERED;
	   this->_M_equilibrate();
	  }
	// NB Do nothing if __s != 0 or __n !=0
	_M_last_overflowed = false;	
	return dynamic_cast<streambuf_type*> (this); 
      }
    
    virtual pos_type 
    seekoff (off_type __off, ios_base::seekdir __way,
	     ios_base::openmode __which = ios_base::in|ios_base::out)
      {
	pos_type __retval =  pos_type(off_type(-1)); 
	int __width = _M_cvt->encoding();

	if (_M_open && (!__off || __width > 0))
	  {
	    
	    if ( (__way != ios_base::cur || __off) 
		 && (_M_last_overflowed || this->pptr() != this->pbase()))
	      {
		// Update the output sequence, write any unshift
		if (__width < 0)
		  {
		    state_type __st; //XXX
		    codecvt_base::result __r = _M_cvt->unshift(__st, _M_out_cur, _M_out_cur, _M_out_end); 
		    // XXX Output the resulting unshift sequence.
		  }
	      }
	    int __whence = 0;
	    if (__way == ios_base::beg)
	      __whence = SEEK_SET;
	    if (__way == ios_base::cur)
	      __whence = SEEK_CUR;
 	    if (__way == ios_base::end)
	      __whence = SEEK_END;
   
	    int __error = 0;
	    if (__width > 0)
	      __error = _S_os_seek(_M_file, __width, __whence);
	    else
	      __error = _S_os_seek(_M_file, 0, __whence);
	    
	    this->_M_equilibrate();
	    if (!__error)
	      __retval = off_type(_M_out_cur); // XXX Wrong??
	  }

	_M_last_overflowed = false;	
	return __retval;
      }
    
    virtual pos_type 
    seekpos (pos_type __sp,
	     ios_base::openmode __which = ios_base::in|ios_base::out)
      {
	pos_type __retval =  pos_type(off_type(-1)); 
	char_type* __pos = reinterpret_cast<char_type*> (__sp._M_position());

	char_type* __beg = NULL;
	char_type* __end = NULL;
	bool __testvalid = false;

	if (__which & ios_base::in)
	  {
	    __beg = eback();
	    __end = egptr();
	  }

	if (__which & ios_base::out)
	  {
	    __beg = pbase();
	    __end = epptr();
	  }

	__testvalid = __beg <= __pos && __pos <= __end;

	if (__testvalid)
	  {
	    int __fail = -1;
	    if (__which & ios_base::in)
	      {
		__fail = _S_os_seek(_M_file, __pos - __beg, SEEK_SET);
		this->_M_equilibrate();
	      }
	    if (__which & ios_base::out)
	      {
		_M_out_cur = __pos;
		// XXX Write any unshift sequence.
		__fail = _S_os_seek(_M_file, __pos - __beg, SEEK_SET);
	      }
	    
	    if (!__fail)
	      __retval = pos_type(off_type(__pos));
	  }

	_M_last_overflowed = false;	
	return __retval;
      }
    
    virtual int sync()
      {
	// Don't do anything about input sequences.
	bool __testput = _M_out_cur != _M_out_beg;
	while (__testput && _M_out_cur <= _M_out_end)
	    this->overflow(traits_type::to_int_type(*_M_out_cur++));
	_M_last_overflowed = false;	
	return 0;
      }

    virtual void imbue (const locale& __loc)
      {
	bool __testbeg = gptr() == eback() && pptr() == pbase();
	bool __teststate = _M_cvt->encoding() == -1;

	_M_init = true;
	if (__testbeg && !__teststate && _M_locale != __loc)
	 {
	   // XXX Will need to save these older values.
	   _M_locale = __loc;
	   _M_cvt = &use_facet<codecvt_type>(_M_locale);
	 }
	// NB this may require the reconversion of previously
	// converted chars. This in turn may cause the reconstruction
	// of the original file. YIKES!!
	// XXX The part in the above comment is not done.
	_M_last_overflowed = false;	
       }

    void _M_equilibrate(void)
      {
	// Makes sure the basic_streambuf pointers and basic_filebuf
	// data members are the same as the corresponding data in the
	// file_type.  
	// NB This only works with char right now. . because
	// _IO_FILE's data members are specifically char*'s.
	if (_M_open)
	  {
	    _M_flags 	= _M_file->_flags;
	    _M_in_cur 	= _M_file->_IO_read_ptr;
	    _M_in_beg 	= _M_file->_IO_read_base;
	    _M_in_end 	= _M_file->_IO_read_end;
	    if (_M_flags & _IO_UNBUFFERED)
	      _M_out_cur = _M_out_beg = _M_out_end = NULL;
	    else
	      {
		_M_out_cur 	= _M_file->_IO_write_ptr;
		_M_out_beg 	= _M_file->_IO_write_base;
		_M_out_end 	= _M_file->_IO_write_end;
	      }
	  }
#if 0	    
	    _IO_buf_end 	= _M_file->_IO_buf_end;
	    _IO_buf_base 	= _M_file->_IO_buf_base;
	    _IO_save_end 	= _M_file->_IO_save_end;
	    _IO_save_base 	= _M_file->_IO_save_base;
	    _IO_backup_base = _M_file->_IO_backup_base;


	// 981217 bkoz 
	// Currently unimplemented functionality. Is this needed?
				= _M_file->_markers;
				= _M_file->_chain;
				= _M_file->_fileno;
				= _M_file->_blksize;
#ifdef _G_IO_IO_FILE_VERSION
				= _M_file->_old_offset;
#else
				= _M_file->_offset;
#endif
				= _M_file->_cur_column;
				= _M_file->_unused;
				= _M_file->_shortbuf;
#ifdef _IO_LOCK_T
				= _M_file->_lock;
#endif
#if defined(_G_IO_IO_FILE_VERSION) && _G_IO_IO_FILE_VERSION == 0x20001
				= _M_file->_offset;
				= _M_file->_unused2;
#endif
#endif // 981217 bkoz
      }
  };

  typedef basic_filebuf<char> filebuf;
  typedef basic_filebuf<wchar_t> wfilebuf;

  //  27.8.1.5  Template class basic_ifstream
  template <class _CharT, class _Traits>
  class basic_ifstream : public basic_istream<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;

  private:
    basic_filebuf<_CharT,_Traits> _M_fb;
    
  public:
    // Constructors:
    basic_ifstream ();
    explicit basic_ifstream(const char* __s,
			    ios_base::openmode __mode = ios_base::in);
    
    // Members:
    basic_filebuf<_CharT,_Traits>* rdbuf () const { return &_M_fb; }
    bool is_open () { return rdbuf ()->is_open (); }
    void open (const char* __s, ios_base::openmode __mode = ios_base::in)
      { if (!rdbuf ()->open (__s, __mode | ios_base::in))
	this->setstate (ios_base::failbit); }
    void close ()
      { if (!rdbuf ()->close ())
	this->setstate (ios_base::failbit);	}
  };
  
  template <class _CharT, class _Traits>
    basic_ifstream<_CharT,_Traits>::basic_ifstream ()
    : basic_istream<_CharT,_Traits> (&_M_fb), _M_fb ()
    { }
  
  template <class _CharT, class _Traits>
    basic_ifstream<_CharT,_Traits>::
    basic_ifstream(const char* __s, ios_base::openmode __mode)
    : basic_istream<_CharT,_Traits> (&_M_fb), _M_fb ()
    { this->open (__s, __mode); }
  
  
  // 27.8.1.8  Template class basic_ofstream
  template <class _CharT, class _Traits>
  class basic_ofstream : public basic_ostream<_CharT,_Traits>
  {
  public:
    // Types:
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    
  private:
    basic_filebuf<_CharT,_Traits> _M_fb;
    
  public:
    // Constructors:
    basic_ofstream ()
      : basic_ostream<_CharT,_Traits> (&_M_fb), _M_fb () { }
    explicit basic_ofstream (const char* __s, ios_base::openmode __mode =
			     (ios_base::out | ios_base::trunc));
    // Members:
    basic_filebuf<_CharT,_Traits>* rdbuf () const
      { return const_cast<basic_filebuf<_CharT,_Traits>*>(&_M_fb); }
    bool is_open () { return rdbuf ()->is_open (); }
    void open (const char* __s, ios_base::openmode __mode = out | trunc)
      { if (!rdbuf ()->open (__s, __mode | ios_base::out))
	this->setstate (ios_base::failbit); }
    void close ()
      { if (!rdbuf ()->close ())
	setstate (ios_base::failbit); }
  };

  template <class _CharT, class _Traits>
    basic_ofstream<_CharT,_Traits>::
    basic_ofstream (const char* __s, ios_base::openmode __mode)
    : basic_ostream<_CharT,_Traits> (&_M_fb)
    , _M_fb ()
    { this->open(__s, __mode); }
  
  typedef basic_ofstream<char> ofstream;
  typedef basic_ofstream<wchar_t> wofstream;
  

  // 27.8.1.11  Template class basic_fstream
  template <class _CharT, class _Traits>
  class basic_fstream : public basic_iostream<_CharT,_Traits>
  {
  public:
    // Types
    typedef _CharT char_type;
    typedef typename _Traits::int_type int_type;
    typedef typename _Traits::pos_type pos_type;
    typedef typename _Traits::off_type off_type;
    
  private:
      basic_filebuf<_CharT,_Traits> _M_fb;
    
  public:
    // Constructors/destructor
    basic_fstream ()
      : basic_iostream<_CharT,_Traits> (&_M_fb), _M_fb () { }
    explicit basic_fstream (const char* __s,
			      ios_base::openmode __mode = (ios_base::in
							   | ios_base::out))
      : basic_iostream<_CharT,_Traits> (&_M_fb), _M_fb ()
      { this->open (__s, __mode | ios_base::in | ios_base::out); }
    
    // Members:
    basic_filebuf<_CharT,_Traits>* rdbuf () const { return &_M_fb; }
    bool is_open () { return rdbuf ()->is_open (); }
    void open(const char* __s, ios_base::openmode __mode =
	      (ios_base::in | ios_base::out))
      { if (!rdbuf ()->open (__s, __mode | ios_base::out | ios_base::out))
	setstate (ios_base::failbit); }
    void close ()
      { if (!rdbuf ()->close ())
	setstate (ios_base::failbit); }
  };

  typedef basic_fstream<char> fstream;
  typedef basic_fstream<wchar_t> wfstream;

} // namespace std

#ifdef _G_NO_TEMPLATE_EXPORT
# define export
# include <bits/os_raw.h>
# include <bits/fstream.tcc>
# include <bits/std_cstring.h>  // memmove
#endif

#endif	/* _CPP_FSTREAM */
