<?xml version="1.0"?>
<xsl:stylesheet
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:fo="http://www.w3.org/1999/XSL/Format"
     xmlns:d="http://docbook.org/ns/docbook"
     exclude-result-prefixes="d"
     version="1.0">

<xsl:import href="${DOCBOOKXSLNS_DIR}/html/chunk.xsl"/>

<!-- Set dir for output files -->
<xsl:param name="base.dir" select="'html/'" />

<!-- Keep sections in their chapter -->
<xsl:param name="chunk.section.depth" select="0" />

<!-- Use the chapter id for filename -->
<xsl:param name="use.id.as.filename" select="1" />

<!-- Set our default css -->
<xsl:param name="html.stylesheet" select="'sdo.css'"/>

<!-- We do not want section numbering -->
<xsl:param name="section.autolabel">0</xsl:param>
<xsl:param name="chapter.autolabel">0</xsl:param>

<!-- Disable the navigation headers normally generated by chunking -->
<xsl:param name="suppress.navigation">1</xsl:param>

<!-- We do not want weird section refs like 'the section called XYZ' -->
<xsl:param name="local.l10n.xml" select="document('')"/>
<l:i18n xmlns:l="http://docbook.sourceforge.net/xmlns/l10n/1.0">
  <l:l10n language="en">
    <l:context name="xref">
      <l:template name="section" text="%t"/>
      <l:template name="chapter" text="%t"/>
    </l:context>
  </l:l10n>
</l:i18n>

<!-- Our header -->
<xsl:template name="user.header.content">
  <div class="nav">
    <div class="logo">
      <a href="sdo.html"><img style="border: 0px solid ; width: 180px; height: 88px;" alt="NEPOMUK Logo" src="nepomuk.png" /></a>
    </div>
    <div class="menu">
       <div class="menuitem"><a href="classindex.html">All Classes</a></div>
       <div class="menuitem"><a href="propertyindex.html">All Properties</a></div>
    </div>
  </div>
</xsl:template>


<!-- We do not want a TOC for the preface - only for the chapters. -->
<xsl:param name="generate.toc">
appendix  toc,title
article/appendix  nop
article   toc,title
book      toc,title,figure,table,example,equation
chapter   toc,title
part      toc,title
preface   title
qandadiv  toc
qandaset  toc
reference toc,title
sect1     toc
sect2     toc
sect3     toc
sect4     toc
sect5     toc
section   toc
set       toc,title
</xsl:param>

<!-- A title for the author group -->
<!-- WARNING: Dirty hack!
 Tests checks both for d:author and author (etc) because with some versions of
 docbook the use of the namespace "d:" is required to find the author but in some
 other versions the namespace doesn't allow to find it.
-->
<xsl:template name="credits.div">
  <div>
    <xsl:apply-templates select="." mode="common.html.attributes"/>
    <xsl:choose>
      <xsl:when test="self::d:author[position()=1] and not(preceding-sibling::d:author[position()=1])">
        <h4 class="editedby">Authors:</h4>
      </xsl:when>
      <xsl:when test="self::author[position()=1] and not(preceding-sibling::author[position()=1])">
        <h4 class="editedby">Authors:</h4>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="self::d:editor[position()=1] and not(preceding-sibling::d:editor[position()=1])">
        <h4 class="editedby">Maintainers:</h4>
      </xsl:when>
      <xsl:when test="self::editor[position()=1] and not(preceding-sibling::editor[position()=1])">
        <h4 class="editedby">Maintainers:</h4>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="self::d:othercredit[position()=1] and not(preceding-sibling::d:othercredit[position()=1])">
        <h4 class="editedby">Contributors:</h4>
      </xsl:when>
      <xsl:when test="self::othercredit[position()=1] and not(preceding-sibling::othercredit[position()=1])">
        <h4 class="editedby">Contributors:</h4>
      </xsl:when>
    </xsl:choose>
    <h3>
      <xsl:apply-templates select="." mode="common.html.attributes"/>
      <xsl:choose>
        <xsl:when test="d:orgname or orgname">
          <xsl:apply-templates/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:call-template name="person.name"/>
        </xsl:otherwise>
      </xsl:choose>
    </h3>
    <xsl:choose>
      <xsl:when test="not($contrib.inline.enabled = 0) and d:contrib">
        <xsl:apply-templates mode="titlepage.mode" select="d:contrib"/>
      </xsl:when>
      <xsl:when test="not($contrib.inline.enabled = 0) and contrib">
        <xsl:apply-templates mode="titlepage.mode" select="contrib"/>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="d:affiliation">
        <xsl:apply-templates mode="titlepage.mode" select="d:affiliation"/>
      </xsl:when>
      <xsl:when test="affiliation">
        <xsl:apply-templates mode="titlepage.mode" select="affiliation"/>
      </xsl:when>
    </xsl:choose>
    <xsl:choose>
      <xsl:when test="d:email">
        <xsl:apply-templates mode="titlepage.mode" select="d:email"/>
      </xsl:when>
      <xsl:when test="email">
        <xsl:apply-templates mode="titlepage.mode" select="email"/>
      </xsl:when>
    </xsl:choose>
    <xsl:if test="not($blurb.on.titlepage.enabled = 0)">
      <xsl:choose>
        <xsl:when test="$contrib.inline.enabled = 0">
          <xsl:apply-templates mode="titlepage.mode"
                               select="d:contrib|contrib|d:authorblurb|authorblurb|d:personblurb|personblurb"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:apply-templates mode="titlepage.mode"
                               select="d:authorblurb|authorblurb|d:personblurb|personblurb"/>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:if>
  </div>
</xsl:template>

</xsl:stylesheet>
