/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.applet.AppletContext;
import java.net.URL;
import javax.swing.JApplet;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.Robot;
import org.fest.swing.driver.ComponentDriver;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.edt.GuiTask;

public class JAppletDriver
extends ComponentDriver {
    public JAppletDriver(Robot robot) {
        super(robot);
    }

    @RunsInEDT
    public AppletContext appletContextOf(JApplet applet) {
        return JAppletDriver.appletContext(applet);
    }

    @RunsInEDT
    private static AppletContext appletContext(final JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<AppletContext>(){

            @Override
            protected AppletContext executeInEDT() {
                return applet.getAppletContext();
            }
        });
    }

    @RunsInEDT
    public void resize(JApplet applet, int width, int height) {
        JAppletDriver.doResize(applet, width, height);
    }

    @RunsInEDT
    private static void doResize(final JApplet applet, final int width, final int height) {
        GuiActionRunner.execute(new GuiTask(){

            protected void executeInEDT() {
                applet.resize(width, height);
            }
        });
    }

    @RunsInEDT
    public URL codeBaseOf(JApplet applet) {
        return JAppletDriver.codeBase(applet);
    }

    @RunsInEDT
    private static URL codeBase(final JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<URL>(){

            @Override
            protected URL executeInEDT() {
                return applet.getCodeBase();
            }
        });
    }

    @RunsInEDT
    public URL documentBaseOf(JApplet applet) {
        return JAppletDriver.documentBase(applet);
    }

    @RunsInEDT
    private static URL documentBase(final JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<URL>(){

            @Override
            protected URL executeInEDT() {
                return applet.getDocumentBase();
            }
        });
    }

    @RunsInEDT
    public String parameterValue(JApplet applet, String parameterName) {
        return JAppletDriver.parameter(applet, parameterName);
    }

    @RunsInEDT
    private static String parameter(final JApplet applet, final String parameterName) {
        return GuiActionRunner.execute(new GuiQuery<String>(){

            @Override
            protected String executeInEDT() {
                return applet.getParameter(parameterName);
            }
        });
    }

    @RunsInEDT
    public boolean isActive(JApplet applet) {
        return JAppletDriver.active(applet);
    }

    @RunsInEDT
    private static boolean active(final JApplet applet) {
        return GuiActionRunner.execute(new GuiQuery<Boolean>(){

            @Override
            protected Boolean executeInEDT() {
                return applet.isActive();
            }
        });
    }
}

