/*******************************************************************************
 *  This file is AUTOMATICALLY GENERATED by:
 *  tools/fortran_wrappers.pl include/magmablas_d.i
 *  Do not edit.
 ******************************************************************************/

#include <stdint.h>  // for uintptr_t

#include "magma_v2.h"
#include "magma_mangling.h"

// typedef from CUDADIR/src/fortran.h directory
typedef size_t devptr_t;

#ifdef PGI_FORTRAN
    #define magma_devptr(ptr_)  ((void*)              (ptr_))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (ptr_))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(ptr_))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (ptr_))
    #define magma_ddevptr(ptr_) ((double*)            (ptr_))
    #define magma_sdevptr(ptr_) ((float*)             (ptr_))
#else
    #define magma_devptr(ptr_)  ((void*)              (uintptr_t)(*(ptr_)))
    #define magma_idevptr(ptr_) ((magma_int_t*)       (uintptr_t)(*(ptr_)))
    #define magma_zdevptr(ptr_) ((magmaDoubleComplex*)(uintptr_t)(*(ptr_)))
    #define magma_cdevptr(ptr_) ((magmaFloatComplex*) (uintptr_t)(*(ptr_)))
    #define magma_ddevptr(ptr_) ((double*)            (uintptr_t)(*(ptr_)))
    #define magma_sdevptr(ptr_) ((float*)             (uintptr_t)(*(ptr_)))
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define magmablasf_dtranspose_inplace FORTRAN_NAME( magmablasf_dtranspose_inplace, MAGMABLASF_DTRANSPOSE_INPLACE )
void magmablasf_dtranspose_inplace(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_dtranspose_inplace(
        *n,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmablasf_dtranspose FORTRAN_NAME( magmablasf_dtranspose, MAGMABLASF_DTRANSPOSE )
void magmablasf_dtranspose(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dAT, magma_int_t *lddat, magma_queue_t *queue )
{
    magmablas_dtranspose(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dAT), *lddat, *queue );
}

#define magmablasf_dgetmatrix_transpose FORTRAN_NAME( magmablasf_dgetmatrix_transpose, MAGMABLASF_DGETMATRIX_TRANSPOSE )
void magmablasf_dgetmatrix_transpose(
    magma_int_t *m, magma_int_t *n, magma_int_t *nb,
    devptr_t *dAT, magma_int_t *ldda,
    double *hA, magma_int_t *lda,
    devptr_t *dwork, magma_int_t *lddw,
    magma_queue_t queues[2] )
{
    magmablas_dgetmatrix_transpose(
        *m, *n, *nb,
        magma_ddevptr(dAT), *ldda,
        hA, *lda,
        magma_ddevptr(dwork), *lddw,
        queues );
}

#define magmablasf_dsetmatrix_transpose FORTRAN_NAME( magmablasf_dsetmatrix_transpose, MAGMABLASF_DSETMATRIX_TRANSPOSE )
void magmablasf_dsetmatrix_transpose(
    magma_int_t *m, magma_int_t *n, magma_int_t *nb,
    double *hA, magma_int_t *lda,
    devptr_t *dAT, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lddw,
    magma_queue_t queues[2] )
{
    magmablas_dsetmatrix_transpose(
        *m, *n, *nb,
        hA, *lda,
        magma_ddevptr(dAT), *ldda,
        magma_ddevptr(dwork), *lddw,
        queues );
}

#define magmablasf_dprbt FORTRAN_NAME( magmablasf_dprbt, MAGMABLASF_DPRBT )
void magmablasf_dprbt(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *du,
    devptr_t *dv, magma_queue_t *queue )
{
    magmablas_dprbt(
        *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(du),
        magma_ddevptr(dv), *queue );
}

#define magmablasf_dprbt_mv FORTRAN_NAME( magmablasf_dprbt_mv, MAGMABLASF_DPRBT_MV )
void magmablasf_dprbt_mv(
    magma_int_t *n,
    devptr_t *dv,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_dprbt_mv(
        *n,
        magma_ddevptr(dv),
        magma_ddevptr(db), *queue );
}

#define magmablasf_dprbt_mtv FORTRAN_NAME( magmablasf_dprbt_mtv, MAGMABLASF_DPRBT_MTV )
void magmablasf_dprbt_mtv(
    magma_int_t *n,
    devptr_t *du,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_dprbt_mtv(
        *n,
        magma_ddevptr(du),
        magma_ddevptr(db), *queue );
}

#define magmablasf_dgeadd FORTRAN_NAME( magmablasf_dgeadd, MAGMABLASF_DGEADD )
void magmablasf_dgeadd(
    magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_dgeadd(
        *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmablasf_dgeadd2 FORTRAN_NAME( magmablasf_dgeadd2, MAGMABLASF_DGEADD2 )
void magmablasf_dgeadd2(
    magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda, double *beta,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_dgeadd2(
        *m, *n, *alpha,
        magma_ddevptr(dA), *ldda, *beta,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmablasf_dlacpy FORTRAN_NAME( magmablasf_dlacpy, MAGMABLASF_DLACPY )
void magmablasf_dlacpy(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_dlacpy(
        magma_uplo_const(*uplo), *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmablasf_dlacpy_conj FORTRAN_NAME( magmablasf_dlacpy_conj, MAGMABLASF_DLACPY_CONJ )
void magmablasf_dlacpy_conj(
    magma_int_t *n,
    devptr_t *dA1, magma_int_t *lda1,
    devptr_t *dA2, magma_int_t *lda2, magma_queue_t *queue )
{
    magmablas_dlacpy_conj(
        *n,
        magma_ddevptr(dA1), *lda1,
        magma_ddevptr(dA2), *lda2, *queue );
}

#define magmablasf_dlacpy_sym_in FORTRAN_NAME( magmablasf_dlacpy_sym_in, MAGMABLASF_DLACPY_SYM_IN )
void magmablasf_dlacpy_sym_in(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magma_int_t *rows,
    magma_int_t *perm,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_dlacpy_sym_in(
        magma_uplo_const(*uplo), *m, *n,
        rows,
        perm,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmablasf_dlacpy_sym_out FORTRAN_NAME( magmablasf_dlacpy_sym_out, MAGMABLASF_DLACPY_SYM_OUT )
void magmablasf_dlacpy_sym_out(
    const char* uplo, magma_int_t *m, magma_int_t *n,
    magma_int_t *rows,
    magma_int_t *perm,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_dlacpy_sym_out(
        magma_uplo_const(*uplo), *m, *n,
        rows,
        perm,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmablasf_dlange FORTRAN_NAME( magmablasf_dlange, MAGMABLASF_DLANGE )
double magmablasf_dlange(
    const char* norm, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_dlange(
        magma_norm_const(*norm), *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dwork), *lwork, *queue );
}

#define magmablasf_dlansy FORTRAN_NAME( magmablasf_dlansy, MAGMABLASF_DLANSY )
double magmablasf_dlansy(
    const char* norm, const char* uplo, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_dlansy(
        magma_norm_const(*norm), magma_uplo_const(*uplo), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dwork), *lwork, *queue );
}

#define magmablasf_dlascl FORTRAN_NAME( magmablasf_dlascl, MAGMABLASF_DLASCL )
void magmablasf_dlascl(
    const char* type, magma_int_t *kl, magma_int_t *ku, double *cfrom, double *cto, magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_dlascl(
        magma_uplo_const(*type), *kl, *ku, *cfrom, *cto, *m, *n,
        magma_ddevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_dlascl_2x2 FORTRAN_NAME( magmablasf_dlascl_2x2, MAGMABLASF_DLASCL_2X2 )
void magmablasf_dlascl_2x2(
    const char* type, magma_int_t *m,
    devptr_t *dW, magma_int_t *lddw,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_dlascl_2x2(
        magma_uplo_const(*type), *m,
        magma_ddevptr(dW), *lddw,
        magma_ddevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_dlascl2 FORTRAN_NAME( magmablasf_dlascl2, MAGMABLASF_DLASCL2 )
void magmablasf_dlascl2(
    const char* type, magma_int_t *m, magma_int_t *n,
    devptr_t *dD,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_dlascl2(
        magma_uplo_const(*type), *m, *n,
        magma_ddevptr(dD),
        magma_ddevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_dlascl_diag FORTRAN_NAME( magmablasf_dlascl_diag, MAGMABLASF_DLASCL_DIAG )
void magmablasf_dlascl_diag(
    const char* type, magma_int_t *m, magma_int_t *n,
    devptr_t *dD, magma_int_t *lddd,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue,
    magma_int_t *info )
{
    magmablas_dlascl_diag(
        magma_uplo_const(*type), *m, *n,
        magma_ddevptr(dD), *lddd,
        magma_ddevptr(dA), *ldda, *queue,
        info );
}

#define magmablasf_dlaset FORTRAN_NAME( magmablasf_dlaset, MAGMABLASF_DLASET )
void magmablasf_dlaset(
    const char* uplo, magma_int_t *m, magma_int_t *n, double *offdiag, double *diag,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_dlaset(
        magma_uplo_const(*uplo), *m, *n, *offdiag, *diag,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmablasf_dlaset_band FORTRAN_NAME( magmablasf_dlaset_band, MAGMABLASF_DLASET_BAND )
void magmablasf_dlaset_band(
    const char* uplo, magma_int_t *m, magma_int_t *n, magma_int_t *k, double *offdiag, double *diag,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_dlaset_band(
        magma_uplo_const(*uplo), *m, *n, *k, *offdiag, *diag,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmablasf_dlaswp FORTRAN_NAME( magmablasf_dlaswp, MAGMABLASF_DLASWP )
void magmablasf_dlaswp(
    magma_int_t *n,
    devptr_t *dAT, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_dlaswp(
        *n,
        magma_ddevptr(dAT), *ldda, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_dlaswp2 FORTRAN_NAME( magmablasf_dlaswp2, MAGMABLASF_DLASWP2 )
void magmablasf_dlaswp2(
    magma_int_t *n,
    devptr_t *dAT, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    devptr_t *d_ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_dlaswp2(
        *n,
        magma_ddevptr(dAT), *ldda, *k1, *k2,
        magma_idevptr(d_ipiv), *inci, *queue );
}

#define magmablasf_dlaswp_sym FORTRAN_NAME( magmablasf_dlaswp_sym, MAGMABLASF_DLASWP_SYM )
void magmablasf_dlaswp_sym(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_dlaswp_sym(
        *n,
        magma_ddevptr(dA), *ldda, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_dlaswpx FORTRAN_NAME( magmablasf_dlaswpx, MAGMABLASF_DLASWPX )
void magmablasf_dlaswpx(
    magma_int_t *n,
    devptr_t *dA, magma_int_t *ldx, magma_int_t *ldy, magma_int_t *k1, magma_int_t *k2,
    magma_int_t *ipiv, magma_int_t *inci, magma_queue_t *queue )
{
    magmablas_dlaswpx(
        *n,
        magma_ddevptr(dA), *ldx, *ldy, *k1, *k2,
        ipiv, *inci, *queue );
}

#define magmablasf_dsymmetrize FORTRAN_NAME( magmablasf_dsymmetrize, MAGMABLASF_DSYMMETRIZE )
void magmablasf_dsymmetrize(
    const char* uplo, magma_int_t *m,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magmablas_dsymmetrize(
        magma_uplo_const(*uplo), *m,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmablasf_dsymmetrize_tiles FORTRAN_NAME( magmablasf_dsymmetrize_tiles, MAGMABLASF_DSYMMETRIZE_TILES )
void magmablasf_dsymmetrize_tiles(
    const char* uplo, magma_int_t *m,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *ntile, magma_int_t *mstride, magma_int_t *nstride, magma_queue_t *queue )
{
    magmablas_dsymmetrize_tiles(
        magma_uplo_const(*uplo), *m,
        magma_ddevptr(dA), *ldda, *ntile, *mstride, *nstride, *queue );
}

#define magmablasf_dtrtri_diag FORTRAN_NAME( magmablasf_dtrtri_diag, MAGMABLASF_DTRTRI_DIAG )
void magmablasf_dtrtri_diag(
    const char* uplo, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *d_dinvA, magma_queue_t *queue )
{
    magmablas_dtrtri_diag(
        magma_uplo_const(*uplo), magma_diag_const(*diag), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(d_dinvA), *queue );
}

#define magmaf_dlarfb_gpu FORTRAN_NAME( magmaf_dlarfb_gpu, MAGMAF_DLARFB_GPU )
magma_int_t magmaf_dlarfb_gpu(
    const char* side, const char* trans, const char* direct, const char* storev, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork, magma_queue_t *queue )
{
    return magma_dlarfb_gpu(
        magma_side_const(*side), magma_trans_const(*trans), magma_direct_const(*direct), magma_storev_const(*storev), *m, *n, *k,
        magma_ddevptr(dV), *lddv,
        magma_ddevptr(dT), *lddt,
        magma_ddevptr(dC), *lddc,
        magma_ddevptr(dwork), *ldwork, *queue );
}

#define magmaf_dlarfb_gpu_gemm FORTRAN_NAME( magmaf_dlarfb_gpu_gemm, MAGMAF_DLARFB_GPU_GEMM )
magma_int_t magmaf_dlarfb_gpu_gemm(
    const char* side, const char* trans, const char* direct, const char* storev, magma_int_t *m, magma_int_t *n, magma_int_t *k,
    devptr_t *dV, magma_int_t *lddv,
    devptr_t *dT, magma_int_t *lddt,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dwork, magma_int_t *ldwork,
    devptr_t *dworkvt, magma_int_t *ldworkvt, magma_queue_t *queue )
{
    return magma_dlarfb_gpu_gemm(
        magma_side_const(*side), magma_trans_const(*trans), magma_direct_const(*direct), magma_storev_const(*storev), *m, *n, *k,
        magma_ddevptr(dV), *lddv,
        magma_ddevptr(dT), *lddt,
        magma_ddevptr(dC), *lddc,
        magma_ddevptr(dwork), *ldwork,
        magma_ddevptr(dworkvt), *ldworkvt, *queue );
}

#define magmaf_dlarfbx_gpu FORTRAN_NAME( magmaf_dlarfbx_gpu, MAGMAF_DLARFBX_GPU )
void magmaf_dlarfbx_gpu(
    magma_int_t *m, magma_int_t *k,
    devptr_t *V, magma_int_t *ldv,
    devptr_t *dT, magma_int_t *ldt,
    devptr_t *c,
    devptr_t *dwork, magma_queue_t *queue )
{
    magma_dlarfbx_gpu(
        *m, *k,
        magma_ddevptr(V), *ldv,
        magma_ddevptr(dT), *ldt,
        magma_ddevptr(c),
        magma_ddevptr(dwork), *queue );
}

#define magmaf_dlarfgtx_gpu FORTRAN_NAME( magmaf_dlarfgtx_gpu, MAGMAF_DLARFGTX_GPU )
void magmaf_dlarfgtx_gpu(
    magma_int_t *n,
    devptr_t *dx0,
    devptr_t *dx,
    devptr_t *dtau,
    devptr_t *dxnorm,
    devptr_t *dA, magma_int_t *iter,
    devptr_t *V, magma_int_t *ldv,
    devptr_t *T, magma_int_t *ldt,
    devptr_t *dwork, magma_queue_t *queue )
{
    magma_dlarfgtx_gpu(
        *n,
        magma_ddevptr(dx0),
        magma_ddevptr(dx),
        magma_ddevptr(dtau),
        magma_ddevptr(dxnorm),
        magma_ddevptr(dA), *iter,
        magma_ddevptr(V), *ldv,
        magma_ddevptr(T), *ldt,
        magma_ddevptr(dwork), *queue );
}

#define magmaf_dlarfgx_gpu FORTRAN_NAME( magmaf_dlarfgx_gpu, MAGMAF_DLARFGX_GPU )
void magmaf_dlarfgx_gpu(
    magma_int_t *n,
    devptr_t *dx0,
    devptr_t *dx,
    devptr_t *dtau,
    devptr_t *dxnorm,
    devptr_t *dA, magma_int_t *iter, magma_queue_t *queue )
{
    magma_dlarfgx_gpu(
        *n,
        magma_ddevptr(dx0),
        magma_ddevptr(dx),
        magma_ddevptr(dtau),
        magma_ddevptr(dxnorm),
        magma_ddevptr(dA), *iter, *queue );
}

#define magmaf_dlarfx_gpu FORTRAN_NAME( magmaf_dlarfx_gpu, MAGMAF_DLARFX_GPU )
void magmaf_dlarfx_gpu(
    magma_int_t *m, magma_int_t *n,
    devptr_t *v,
    devptr_t *tau,
    devptr_t *C, magma_int_t *ldc,
    devptr_t *xnorm,
    devptr_t *dT, magma_int_t *iter,
    devptr_t *work, magma_queue_t *queue )
{
    magma_dlarfx_gpu(
        *m, *n,
        magma_ddevptr(v),
        magma_ddevptr(tau),
        magma_ddevptr(C), *ldc,
        magma_ddevptr(xnorm),
        magma_ddevptr(dT), *iter,
        magma_ddevptr(work), *queue );
}

#define magmablasf_daxpycp FORTRAN_NAME( magmablasf_daxpycp, MAGMABLASF_DAXPYCP )
void magmablasf_daxpycp(
    magma_int_t *m,
    devptr_t *dr,
    devptr_t *dx,
    devptr_t *db, magma_queue_t *queue )
{
    magmablas_daxpycp(
        *m,
        magma_ddevptr(dr),
        magma_ddevptr(dx),
        magma_ddevptr(db), *queue );
}

#define magmablasf_dswap FORTRAN_NAME( magmablasf_dswap, MAGMABLASF_DSWAP )
void magmablasf_dswap(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_dswap(
        *n,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmablasf_dswapblk FORTRAN_NAME( magmablasf_dswapblk, MAGMABLASF_DSWAPBLK )
void magmablasf_dswapblk(
    const char* order, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_int_t *i1, magma_int_t *i2,
    magma_int_t *ipiv, magma_int_t *inci, magma_int_t *offset, magma_queue_t *queue )
{
    magmablas_dswapblk(
        magma_order_const(*order), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *i1, *i2,
        ipiv, *inci, *offset, *queue );
}

#define magmablasf_dswapdblk FORTRAN_NAME( magmablasf_dswapdblk, MAGMABLASF_DSWAPDBLK )
void magmablasf_dswapdblk(
    magma_int_t *n, magma_int_t *nb,
    devptr_t *dA, magma_int_t *ldda, magma_int_t *inca,
    devptr_t *dB, magma_int_t *lddb, magma_int_t *incb, magma_queue_t *queue )
{
    magmablas_dswapdblk(
        *n, *nb,
        magma_ddevptr(dA), *ldda, *inca,
        magma_ddevptr(dB), *lddb, *incb, *queue );
}

#define magmablasf_dnrm2_adjust FORTRAN_NAME( magmablasf_dnrm2_adjust, MAGMABLASF_DNRM2_ADJUST )
void magmablasf_dnrm2_adjust(
    magma_int_t *k,
    devptr_t *dxnorm,
    devptr_t *dc, magma_queue_t *queue )
{
    magmablas_dnrm2_adjust(
        *k,
        magma_ddevptr(dxnorm),
        magma_ddevptr(dc), *queue );
}

#define magmablasf_dnrm2_check FORTRAN_NAME( magmablasf_dnrm2_check, MAGMABLASF_DNRM2_CHECK )
void magmablasf_dnrm2_check(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dxnorm,
    devptr_t *dlsticc, magma_queue_t *queue )
{
    magmablas_dnrm2_check(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dxnorm),
        magma_ddevptr(dlsticc), *queue );
}

#define magmablasf_dnrm2_cols FORTRAN_NAME( magmablasf_dnrm2_cols, MAGMABLASF_DNRM2_COLS )
void magmablasf_dnrm2_cols(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dxnorm, magma_queue_t *queue )
{
    magmablas_dnrm2_cols(
        *m, *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dxnorm), *queue );
}

#define magmablasf_dnrm2_row_check_adjust FORTRAN_NAME( magmablasf_dnrm2_row_check_adjust, MAGMABLASF_DNRM2_ROW_CHECK_ADJUST )
void magmablasf_dnrm2_row_check_adjust(
    magma_int_t *k, double *tol,
    devptr_t *dxnorm,
    devptr_t *dxnorm2,
    devptr_t *dC, magma_int_t *lddc,
    devptr_t *dlsticc, magma_queue_t *queue )
{
    magmablas_dnrm2_row_check_adjust(
        *k, *tol,
        magma_ddevptr(dxnorm),
        magma_ddevptr(dxnorm2),
        magma_ddevptr(dC), *lddc,
        magma_ddevptr(dlsticc), *queue );
}

#define magmablasf_dtrsv FORTRAN_NAME( magmablasf_dtrsv, MAGMABLASF_DTRSV )
void magmablasf_dtrsv(
    const char* uplo, const char* transA, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *db, magma_int_t *incb, magma_queue_t *queue )
{
    magmablas_dtrsv(
        magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(db), *incb, *queue );
}

#define magmablasf_dtrsv_outofplace FORTRAN_NAME( magmablasf_dtrsv_outofplace, MAGMABLASF_DTRSV_OUTOFPLACE )
void magmablasf_dtrsv_outofplace(
    const char* uplo, const char* transA, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *db, magma_int_t *incb,
    devptr_t *dx, magma_queue_t *queue, magma_int_t *flag )
{
    magmablas_dtrsv_outofplace(
        magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(db), *incb,
        magma_ddevptr(dx), *queue, *flag );
}

#define magmablasf_dgemv FORTRAN_NAME( magmablasf_dgemv, MAGMABLASF_DGEMV )
void magmablasf_dgemv(
    const char* trans, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, double *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_dgemv(
        magma_trans_const(*trans), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *beta,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmablasf_dgemv_conj FORTRAN_NAME( magmablasf_dgemv_conj, MAGMABLASF_DGEMV_CONJ )
void magmablasf_dgemv_conj(
    magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, double *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magmablas_dgemv_conj(
        *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *beta,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmablasf_dsymv FORTRAN_NAME( magmablasf_dsymv, MAGMABLASF_DSYMV )
magma_int_t magmablasf_dsymv(
    const char* uplo, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, double *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    return magmablas_dsymv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *beta,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmablasf_dsymv_work FORTRAN_NAME( magmablasf_dsymv_work, MAGMABLASF_DSYMV_WORK )
magma_int_t magmablasf_dsymv_work(
    const char* uplo, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, double *beta,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dwork, magma_int_t *lwork, magma_queue_t *queue )
{
    return magmablas_dsymv_work(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *beta,
        magma_ddevptr(dy), *incy,
        magma_ddevptr(dwork), *lwork, *queue );
}

#define magmablasf_dgemm FORTRAN_NAME( magmablasf_dgemm, MAGMABLASF_DGEMM )
void magmablasf_dgemm(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, magma_int_t *k, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_dgemm(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *k, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *beta,
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmablasf_dgemm_reduce FORTRAN_NAME( magmablasf_dgemm_reduce, MAGMABLASF_DGEMM_REDUCE )
void magmablasf_dgemm_reduce(
    magma_int_t *m, magma_int_t *n, magma_int_t *k, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magmablas_dgemm_reduce(
        *m, *n, *k, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *beta,
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmablasf_dtrsm FORTRAN_NAME( magmablasf_dtrsm, MAGMABLASF_DTRSM )
void magmablasf_dtrsm(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magmablas_dtrsm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmablasf_dtrsm_outofplace FORTRAN_NAME( magmablasf_dtrsm_outofplace, MAGMABLASF_DTRSM_OUTOFPLACE )
void magmablasf_dtrsm_outofplace(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx, magma_int_t *flag,
    devptr_t *d_dinvA, magma_int_t *dinvA_length, magma_queue_t *queue )
{
    magmablas_dtrsm_outofplace(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        magma_ddevptr(dX), *lddx, *flag,
        magma_ddevptr(d_dinvA), *dinvA_length, *queue );
}

#define magmablasf_dtrsm_work FORTRAN_NAME( magmablasf_dtrsm_work, MAGMABLASF_DTRSM_WORK )
void magmablasf_dtrsm_work(
    const char* side, const char* uplo, const char* transA, const char* diag, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb,
    devptr_t *dX, magma_int_t *lddx, magma_int_t *flag,
    devptr_t *d_dinvA, magma_int_t *dinvA_length, magma_queue_t *queue )
{
    magmablas_dtrsm_work(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*transA), magma_diag_const(*diag), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb,
        magma_ddevptr(dX), *lddx, *flag,
        magma_ddevptr(d_dinvA), *dinvA_length, *queue );
}

#define magmaf_dsetvector FORTRAN_NAME( magmaf_dsetvector, MAGMAF_DSETVECTOR )
void magmaf_dsetvector(
    magma_int_t *n,
    double *hx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dsetvector(
        *n,
        hx_src, *incx,
        magma_ddevptr(dy_dst), *incy, *queue );
}

#define magmaf_dgetvector FORTRAN_NAME( magmaf_dgetvector, MAGMAF_DGETVECTOR )
void magmaf_dgetvector(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    double *hy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dgetvector(
        *n,
        magma_ddevptr(dx_src), *incx,
        hy_dst, *incy, *queue );
}

#define magmaf_dcopyvector FORTRAN_NAME( magmaf_dcopyvector, MAGMAF_DCOPYVECTOR )
void magmaf_dcopyvector(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dcopyvector(
        *n,
        magma_ddevptr(dx_src), *incx,
        magma_ddevptr(dy_dst), *incy, *queue );
}

#define magmaf_dsetvector_async FORTRAN_NAME( magmaf_dsetvector_async, MAGMAF_DSETVECTOR_ASYNC )
void magmaf_dsetvector_async(
    magma_int_t *n,
    double *hx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dsetvector_async(
        *n,
        hx_src, *incx,
        magma_ddevptr(dy_dst), *incy, *queue );
}

#define magmaf_dgetvector_async FORTRAN_NAME( magmaf_dgetvector_async, MAGMAF_DGETVECTOR_ASYNC )
void magmaf_dgetvector_async(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    double *hy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dgetvector_async(
        *n,
        magma_ddevptr(dx_src), *incx,
        hy_dst, *incy, *queue );
}

#define magmaf_dcopyvector_async FORTRAN_NAME( magmaf_dcopyvector_async, MAGMAF_DCOPYVECTOR_ASYNC )
void magmaf_dcopyvector_async(
    magma_int_t *n,
    devptr_t *dx_src, magma_int_t *incx,
    devptr_t *dy_dst, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dcopyvector_async(
        *n,
        magma_ddevptr(dx_src), *incx,
        magma_ddevptr(dy_dst), *incy, *queue );
}

#define magmaf_dsetmatrix FORTRAN_NAME( magmaf_dsetmatrix, MAGMAF_DSETMATRIX )
void magmaf_dsetmatrix(
    magma_int_t *m, magma_int_t *n,
    double *hA_src, magma_int_t *lda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_dsetmatrix(
        *m, *n,
        hA_src, *lda,
        magma_ddevptr(dB_dst), *lddb, *queue );
}

#define magmaf_dgetmatrix FORTRAN_NAME( magmaf_dgetmatrix, MAGMAF_DGETMATRIX )
void magmaf_dgetmatrix(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    double *hB_dst, magma_int_t *ldb, magma_queue_t *queue )
{
    magma_dgetmatrix(
        *m, *n,
        magma_ddevptr(dA_src), *ldda,
        hB_dst, *ldb, *queue );
}

#define magmaf_dcopymatrix FORTRAN_NAME( magmaf_dcopymatrix, MAGMAF_DCOPYMATRIX )
void magmaf_dcopymatrix(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_dcopymatrix(
        *m, *n,
        magma_ddevptr(dA_src), *ldda,
        magma_ddevptr(dB_dst), *lddb, *queue );
}

#define magmaf_dsetmatrix_async FORTRAN_NAME( magmaf_dsetmatrix_async, MAGMAF_DSETMATRIX_ASYNC )
void magmaf_dsetmatrix_async(
    magma_int_t *m, magma_int_t *n,
    double *hA_src, magma_int_t *lda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_dsetmatrix_async(
        *m, *n,
        hA_src, *lda,
        magma_ddevptr(dB_dst), *lddb, *queue );
}

#define magmaf_dgetmatrix_async FORTRAN_NAME( magmaf_dgetmatrix_async, MAGMAF_DGETMATRIX_ASYNC )
void magmaf_dgetmatrix_async(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    double *hB_dst, magma_int_t *ldb, magma_queue_t *queue )
{
    magma_dgetmatrix_async(
        *m, *n,
        magma_ddevptr(dA_src), *ldda,
        hB_dst, *ldb, *queue );
}

#define magmaf_dcopymatrix_async FORTRAN_NAME( magmaf_dcopymatrix_async, MAGMAF_DCOPYMATRIX_ASYNC )
void magmaf_dcopymatrix_async(
    magma_int_t *m, magma_int_t *n,
    devptr_t *dA_src, magma_int_t *ldda,
    devptr_t *dB_dst, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_dcopymatrix_async(
        *m, *n,
        magma_ddevptr(dA_src), *ldda,
        magma_ddevptr(dB_dst), *lddb, *queue );
}

#define magmaf_idamax FORTRAN_NAME( magmaf_idamax, MAGMAF_IDAMAX )
magma_int_t magmaf_idamax(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_idamax(
        *n,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_idamin FORTRAN_NAME( magmaf_idamin, MAGMAF_IDAMIN )
magma_int_t magmaf_idamin(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_idamin(
        *n,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_dasum FORTRAN_NAME( magmaf_dasum, MAGMAF_DASUM )
double magmaf_dasum(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_dasum(
        *n,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_daxpy FORTRAN_NAME( magmaf_daxpy, MAGMAF_DAXPY )
void magmaf_daxpy(
    magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_daxpy(
        *n, *alpha,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmaf_dcopy FORTRAN_NAME( magmaf_dcopy, MAGMAF_DCOPY )
void magmaf_dcopy(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dcopy(
        *n,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmaf_ddot FORTRAN_NAME( magmaf_ddot, MAGMAF_DDOT )
double magmaf_ddot(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    return magma_ddot(
        *n,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmaf_dnrm2 FORTRAN_NAME( magmaf_dnrm2, MAGMAF_DNRM2 )
double magmaf_dnrm2(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    return magma_dnrm2(
        *n,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_drot FORTRAN_NAME( magmaf_drot, MAGMAF_DROT )
void magmaf_drot(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, double *dc, double *ds, magma_queue_t *queue )
{
    magma_drot(
        *n,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy, *dc, *ds, *queue );
}

#define magmaf_drotg FORTRAN_NAME( magmaf_drotg, MAGMAF_DROTG )
void magmaf_drotg(
    devptr_t *a,
    devptr_t *b,
    devptr_t *c,
    devptr_t *s, magma_queue_t *queue )
{
    magma_drotg(
        magma_ddevptr(a),
        magma_ddevptr(b),
        magma_ddevptr(c),
        magma_ddevptr(s), *queue );
}

#define magmaf_drotm FORTRAN_NAME( magmaf_drotm, MAGMAF_DROTM )
void magmaf_drotm(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *param, magma_queue_t *queue )
{
    magma_drotm(
        *n,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy,
        magma_ddevptr(param), *queue );
}

#define magmaf_drotmg FORTRAN_NAME( magmaf_drotmg, MAGMAF_DROTMG )
void magmaf_drotmg(
    devptr_t *d1,
    devptr_t *d2,
    devptr_t *x1,
    devptr_t *y1,
    devptr_t *param, magma_queue_t *queue )
{
    magma_drotmg(
        magma_ddevptr(d1),
        magma_ddevptr(d2),
        magma_ddevptr(x1),
        magma_ddevptr(y1),
        magma_ddevptr(param), *queue );
}

#define magmaf_dscal FORTRAN_NAME( magmaf_dscal, MAGMAF_DSCAL )
void magmaf_dscal(
    magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_dscal(
        *n, *alpha,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_dswap FORTRAN_NAME( magmaf_dswap, MAGMAF_DSWAP )
void magmaf_dswap(
    magma_int_t *n,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dswap(
        *n,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmaf_dgemv FORTRAN_NAME( magmaf_dgemv, MAGMAF_DGEMV )
void magmaf_dgemv(
    const char* transA, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, double *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dgemv(
        magma_trans_const(*transA), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *beta,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmaf_dger FORTRAN_NAME( magmaf_dger, MAGMAF_DGER )
void magmaf_dger(
    magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_dger(
        *m, *n, *alpha,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmaf_dsymv FORTRAN_NAME( magmaf_dsymv, MAGMAF_DSYMV )
void magmaf_dsymv(
    const char* uplo, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, double *beta,
    devptr_t *dy, magma_int_t *incy, magma_queue_t *queue )
{
    magma_dsymv(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *beta,
        magma_ddevptr(dy), *incy, *queue );
}

#define magmaf_dsyr FORTRAN_NAME( magmaf_dsyr, MAGMAF_DSYR )
void magmaf_dsyr(
    const char* uplo, magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_dsyr(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmaf_dsyr2 FORTRAN_NAME( magmaf_dsyr2, MAGMAF_DSYR2 )
void magmaf_dsyr2(
    const char* uplo, magma_int_t *n, double *alpha,
    devptr_t *dx, magma_int_t *incx,
    devptr_t *dy, magma_int_t *incy,
    devptr_t *dA, magma_int_t *ldda, magma_queue_t *queue )
{
    magma_dsyr2(
        magma_uplo_const(*uplo), *n, *alpha,
        magma_ddevptr(dx), *incx,
        magma_ddevptr(dy), *incy,
        magma_ddevptr(dA), *ldda, *queue );
}

#define magmaf_dtrmv FORTRAN_NAME( magmaf_dtrmv, MAGMAF_DTRMV )
void magmaf_dtrmv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_dtrmv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_dtrsv FORTRAN_NAME( magmaf_dtrsv, MAGMAF_DTRSV )
void magmaf_dtrsv(
    const char* uplo, const char* trans, const char* diag, magma_int_t *n,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dx, magma_int_t *incx, magma_queue_t *queue )
{
    magma_dtrsv(
        magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *n,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dx), *incx, *queue );
}

#define magmaf_dgemm FORTRAN_NAME( magmaf_dgemm, MAGMAF_DGEMM )
void magmaf_dgemm(
    const char* transA, const char* transB, magma_int_t *m, magma_int_t *n, magma_int_t *k, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_dgemm(
        magma_trans_const(*transA), magma_trans_const(*transB), *m, *n, *k, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *beta,
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmaf_dsymm FORTRAN_NAME( magmaf_dsymm, MAGMAF_DSYMM )
void magmaf_dsymm(
    const char* side, const char* uplo, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_dsymm(
        magma_side_const(*side), magma_uplo_const(*uplo), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *beta,
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmaf_dsyr2k FORTRAN_NAME( magmaf_dsyr2k, MAGMAF_DSYR2K )
void magmaf_dsyr2k(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_dsyr2k(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *beta,
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmaf_dsyrk FORTRAN_NAME( magmaf_dsyrk, MAGMAF_DSYRK )
void magmaf_dsyrk(
    const char* uplo, const char* trans, magma_int_t *n, magma_int_t *k, double *alpha,
    devptr_t *dA, magma_int_t *ldda, double *beta,
    devptr_t *dC, magma_int_t *lddc, magma_queue_t *queue )
{
    magma_dsyrk(
        magma_uplo_const(*uplo), magma_trans_const(*trans), *n, *k, *alpha,
        magma_ddevptr(dA), *ldda, *beta,
        magma_ddevptr(dC), *lddc, *queue );
}

#define magmaf_dtrmm FORTRAN_NAME( magmaf_dtrmm, MAGMAF_DTRMM )
void magmaf_dtrmm(
    const char* side, const char* uplo, const char* trans, const char* diag, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_dtrmm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmaf_dtrsm FORTRAN_NAME( magmaf_dtrsm, MAGMAF_DTRSM )
void magmaf_dtrsm(
    const char* side, const char* uplo, const char* trans, const char* diag, magma_int_t *m, magma_int_t *n, double *alpha,
    devptr_t *dA, magma_int_t *ldda,
    devptr_t *dB, magma_int_t *lddb, magma_queue_t *queue )
{
    magma_dtrsm(
        magma_side_const(*side), magma_uplo_const(*uplo), magma_trans_const(*trans), magma_diag_const(*diag), *m, *n, *alpha,
        magma_ddevptr(dA), *ldda,
        magma_ddevptr(dB), *lddb, *queue );
}

#define magmaf_dpotf2_lpout FORTRAN_NAME( magmaf_dpotf2_lpout, MAGMAF_DPOTF2_LPOUT )
magma_int_t magmaf_dpotf2_lpout(
    const char* uplo, magma_int_t *n,
    double *dA, magma_int_t *lda, magma_int_t *gbstep,
    magma_int_t *dinfo, magma_queue_t *queue )
{
    return magma_dpotf2_lpout(
        magma_uplo_const(*uplo), *n,
        dA, *lda, *gbstep,
        dinfo, *queue );
}

#define magmaf_dpotf2_lpin FORTRAN_NAME( magmaf_dpotf2_lpin, MAGMAF_DPOTF2_LPIN )
magma_int_t magmaf_dpotf2_lpin(
    const char* uplo, magma_int_t *n,
    double *dA, magma_int_t *lda, magma_int_t *gbstep,
    magma_int_t *dinfo, magma_queue_t *queue )
{
    return magma_dpotf2_lpin(
        magma_uplo_const(*uplo), *n,
        dA, *lda, *gbstep,
        dinfo, *queue );
}


#ifdef __cplusplus
}
#endif
